/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.objectstore;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.util.Log;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.Zeile;
import mausoleum.mail.Mail;
import mausoleum.mouse.Mouse;
import mausoleum.objectstore.CommandManagerCage;
import mausoleum.objectstore.CommandManagerMouse;
import mausoleum.objectstore.ObjectExtractor;
import mausoleum.rack.Rack;
import mausoleum.room.Room;

public class CommandManagerMail
extends CommandManagerExecutive {
    public static final String COM_MAI_NEW = "MAI_NEW";
    public static final String COM_MAI_DEL = "MAI_DEL";
    public static final String COM_MAI_CHREAD = "MAI_CHREAD";
    public static final String COM_MAI_EXTRACT = "MAI_EXTRACT";
    public static final String COM_IMPORT = "MAI_IMPORT";
    public static final String COM_IMPORT_WITH_ROOM = "MAI_IMPORT_WITH_ROOM";
    public static final String COM_CAGE_GROUP_TRANSFER_WITH_ROOM_OR_RACKPOS = "MAI_IMPORT_WITH_ROOM_OR_RACKPOS";
    public static final String COM_LEGACY_IMPORT = "LEGACY_IMPORT";
    static /* synthetic */ Class class$0;

    public CommandManagerMail() {
        super(11);
        this.addMeth(COM_MAI_NEW, "handleCOM_MAI_NEW", 8, false);
        this.addMeth(COM_MAI_DEL, "handleCOM_MAI_DEL", 2, true);
        this.addMeth(COM_MAI_CHREAD, "handleCOM_MAI_CHREAD", 2, true);
        this.addMeth(COM_MAI_EXTRACT, "handleCOM_MAI_EXTRACT", 3, true);
        this.addMeth(COM_IMPORT, "handleCOM_MAI_IMPORT", 3, false);
        this.addMeth(COM_IMPORT_WITH_ROOM, "handleCOM_MAI_IMPORT_WITH_ROOM", 4, false);
        this.addMeth(COM_CAGE_GROUP_TRANSFER_WITH_ROOM_OR_RACKPOS, "handleCOM_MAI_IMPORT_WITH_ROOM_OR_RACKPOS", 10, false);
        this.addMeth(COM_LEGACY_IMPORT, "handleCOM_LEGACY_IMPORT", 1, false);
    }

    public String getParsedCommandIfTouched(String command, Zeile z, String group, int typ, long id, String objectGroup) {
        if (command.equals(COM_MAI_NEW)) {
            if (typ == 0 && id == 0L) {
                return "Created new mail";
            }
            return null;
        }
        if (command.equals(COM_MAI_DEL)) {
            if (typ == 0 && id == 0L) {
                return "Removed mail";
            }
            if (typ == 11 && z.getLong(1, 0L) == id) {
                return "Removed mail";
            }
            return null;
        }
        if (command.equals(COM_MAI_CHREAD)) {
            if (typ == 0 && id == 0L) {
                return "Marked mail as read";
            }
            if (typ == 11 && z.getLong(1, 0L) == id) {
                return "Marked as read";
            }
            return null;
        }
        if (command.equals(COM_MAI_EXTRACT)) {
            if (typ == 0 && id == 0L) {
                return "Extracted mouse attachment";
            }
            if (typ == 11 && z.getLong(1, 0L) == id) {
                return "Extracted mouse attachment";
            }
            return null;
        }
        if (command.equals(COM_IMPORT)) {
            if (typ == 0 && id == 0L) {
                return "Imported mice";
            }
            return null;
        }
        if (command.equals(COM_IMPORT_WITH_ROOM)) {
            return null;
        }
        if (command.equals(COM_CAGE_GROUP_TRANSFER_WITH_ROOM_OR_RACKPOS)) {
            return null;
        }
        return "CME_NP";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleCOM_MAI_NEW() {
        try {
            Mail mailAnEmpfaenger;
            Zeile z = new Zeile(this.ivLine[1], '@');
            if (z.size() != 3) {
                Log.info("handleCOM_MAI_NEW sender wrong " + this.ivLine[1], this);
                return false;
            }
            String senderUser = Base64Manager.decodeIfMarked(z.getString(0, ""));
            String senderGroup = Base64Manager.decodeIfMarked(z.getString(1, ""));
            long senderUserID = z.getLong(2, -1L);
            z = new Zeile(this.ivLine[2], '@');
            if (z.size() != 3) {
                Log.info("handleCOM_MAI_NEW receiver wrong " + this.ivLine[2], this);
                return false;
            }
            String receiverUser = Base64Manager.decodeIfMarked(z.getString(0, ""));
            String receiverGroup = Base64Manager.decodeIfMarked(z.getString(1, ""));
            long receiverUserID = z.getLong(2, -1L);
            String subject = Base64Manager.getDecodedString(this.ivLine[3]);
            String text = Base64Manager.getDecodedString(this.ivLine[4]);
            String attach = Base64Manager.getDecodedString(this.ivLine[5]);
            String attachInf = this.ivLine[6];
            boolean wantsReceipt = this.ivLine[7].equals("1");
            if (!DataLayer.cvDataLayer.isGroupEnabled(receiverGroup)) {
                Log.info("handleCOM_MAI_NEW receiver Group disabled " + this.ivLine[2], this);
                return false;
            }
            Date jetzt = new Date();
            if (!Mail.isItSystem(senderUser, senderGroup)) {
                Mail belegFuerAbsender = new Mail();
                belegFuerAbsender.set("IDO_GROUP", this.ivGroupname);
                belegFuerAbsender.set("IDO_START_DATE", jetzt);
                belegFuerAbsender.set("MAI_OWNER", senderUser);
                belegFuerAbsender.set("MAI_OGROUP", senderGroup);
                belegFuerAbsender.set("MAI_SENDER", senderUser);
                belegFuerAbsender.set("MAI_SGROUP", senderGroup);
                belegFuerAbsender.set("MAI_RECEIVER", receiverUser);
                belegFuerAbsender.set("MAI_RGROUP", receiverGroup);
                if (senderUserID != -1L) {
                    belegFuerAbsender.set("MAI_SENDER_ID", new Long(senderUserID));
                    belegFuerAbsender.set("MAI_OWNER_ID", new Long(senderUserID));
                }
                if (receiverUserID != -1L) {
                    belegFuerAbsender.set("MAI_RECEIVER_ID", new Long(receiverUserID));
                }
                belegFuerAbsender.set("MAI_SUBJECT", subject);
                belegFuerAbsender.set("MAI_TEXT", text);
                belegFuerAbsender.set("MAI_ATTACHMENT", attach);
                belegFuerAbsender.set("MAI_ATTINFO", attachInf);
                belegFuerAbsender.setBoolean("MAI_READ", true);
                belegFuerAbsender.setBoolean("MAI_EXTRACTED", true);
                belegFuerAbsender.setBoolean("MAI_WANTSREC", false);
                if (!DataLayer.cvDataLayer.provideNewIDToIDObject(belegFuerAbsender)) {
                    Log.info("handleCOM_MAI_NEW keine neue ID fuer gesendetes Objekt vorhanden", this);
                    return false;
                }
                this.ivObjectBag.put(belegFuerAbsender.getIdentifierString(), belegFuerAbsender);
                this.ivNewObjectsTarget.addElement(belegFuerAbsender);
            }
            if (!senderGroup.equals(receiverGroup)) {
                mailAnEmpfaenger = new Mail();
                mailAnEmpfaenger.set("IDO_GROUP", receiverGroup);
                mailAnEmpfaenger.set("IDO_START_DATE", jetzt);
                mailAnEmpfaenger.set("MAI_OWNER", receiverUser);
                mailAnEmpfaenger.set("MAI_OGROUP", receiverGroup);
                mailAnEmpfaenger.set("MAI_SENDER", senderUser);
                mailAnEmpfaenger.set("MAI_SGROUP", senderGroup);
                mailAnEmpfaenger.set("MAI_RECEIVER", receiverUser);
                mailAnEmpfaenger.set("MAI_RGROUP", receiverGroup);
                if (senderUserID != -1L) {
                    mailAnEmpfaenger.set("MAI_SENDER_ID", new Long(senderUserID));
                }
                if (receiverUserID != -1L) {
                    mailAnEmpfaenger.set("MAI_RECEIVER_ID", new Long(receiverUserID));
                    mailAnEmpfaenger.set("MAI_OWNER_ID", new Long(receiverUserID));
                }
                mailAnEmpfaenger.set("MAI_SUBJECT", subject);
                mailAnEmpfaenger.set("MAI_TEXT", text);
                mailAnEmpfaenger.set("MAI_ATTACHMENT", attach);
                mailAnEmpfaenger.set("MAI_ATTINFO", attachInf);
                mailAnEmpfaenger.setBoolean("MAI_READ", false);
                mailAnEmpfaenger.setBoolean("MAI_EXTRACTED", false);
                mailAnEmpfaenger.setBoolean("MAI_WANTSREC", wantsReceipt);
                if (!DataLayer.cvDataLayer.provideNewIDToIDObject(mailAnEmpfaenger)) {
                    Log.info("handleCOM_MAI_NEW keine neue ID fuer empfaenger Objekt (fremde Gruppe) vorhanden", this);
                    return false;
                }
                mailAnEmpfaenger.commit(true);
                if (ObjectStoreServer.insertSingleMailObjectToForeignGroup(mailAnEmpfaenger)) return true;
                Log.info("handleCOM_MAI_NEW einfuegen fuer empfaenger Objekt (fremde Gruppe) misslungen", this);
                return false;
            } else {
                mailAnEmpfaenger = new Mail();
                mailAnEmpfaenger.set("IDO_GROUP", this.ivGroupname);
                mailAnEmpfaenger.set("IDO_START_DATE", jetzt);
                mailAnEmpfaenger.set("MAI_OWNER", receiverUser);
                mailAnEmpfaenger.set("MAI_OGROUP", receiverGroup);
                mailAnEmpfaenger.set("MAI_SENDER", senderUser);
                mailAnEmpfaenger.set("MAI_SGROUP", senderGroup);
                mailAnEmpfaenger.set("MAI_RECEIVER", receiverUser);
                mailAnEmpfaenger.set("MAI_RGROUP", receiverGroup);
                if (senderUserID != -1L) {
                    mailAnEmpfaenger.set("MAI_SENDER_ID", new Long(senderUserID));
                }
                if (receiverUserID != -1L) {
                    mailAnEmpfaenger.set("MAI_RECEIVER_ID", new Long(receiverUserID));
                    mailAnEmpfaenger.set("MAI_OWNER_ID", new Long(receiverUserID));
                }
                mailAnEmpfaenger.set("MAI_SUBJECT", subject);
                mailAnEmpfaenger.set("MAI_TEXT", text);
                mailAnEmpfaenger.set("MAI_ATTACHMENT", attach);
                mailAnEmpfaenger.set("MAI_ATTINFO", attachInf);
                mailAnEmpfaenger.setBoolean("MAI_READ", false);
                mailAnEmpfaenger.setBoolean("MAI_EXTRACTED", false);
                mailAnEmpfaenger.setBoolean("MAI_WANTSREC", wantsReceipt);
                if (!DataLayer.cvDataLayer.provideNewIDToIDObject(mailAnEmpfaenger)) {
                    Log.info("handleCOM_MAI_NEW keine neue ID fuer empfaenger Objekt (gleiche Gruppe) vorhanden", this);
                    return false;
                }
                this.ivObjectBag.put(mailAnEmpfaenger.getIdentifierString(), mailAnEmpfaenger);
                this.ivNewObjectsTarget.add(mailAnEmpfaenger);
            }
            return true;
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("mausoleum.objectstore.CommandManagerMail");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            Log.error("Error creating new mail", e, clazz);
            return false;
        }
    }

    public boolean handleCOM_MAI_DEL() {
        this.ivObjectForCommand.set("IDO_END_DATE", new Date());
        return true;
    }

    public boolean handleCOM_MAI_CHREAD() {
        Mail mail = (Mail)this.ivObjectForCommand;
        if (mail.getBoolean("MAI_READ", false)) {
            return true;
        }
        mail.setBoolean("MAI_READ", true);
        if (mail.getBoolean("MAI_WANTSREC", false)) {
            Date jetzt = new Date(System.currentTimeMillis());
            String rtext = "User: " + mail.getString("MAI_RECEIVER") + " of group: " + mail.getString("MAI_RGROUP") + " opened at " + DatumFormat.getDateTimeString(jetzt.getTime()) + " your mail containig the following text:" + "\n\n===================================\n\n" + mail.getString("MAI_TEXT");
            Mail retourMail = Mail.getSystemMail();
            retourMail.set("IDO_GROUP", mail.getString("MAI_SGROUP"));
            retourMail.set("IDO_START_DATE", jetzt);
            retourMail.set("MAI_OWNER", mail.getString("MAI_SENDER"));
            retourMail.set("MAI_OGROUP", mail.getString("MAI_SGROUP"));
            retourMail.set("MAI_OWNER_ID", mail.get("MAI_SENDER_ID"));
            retourMail.set("MAI_RECEIVER", mail.getString("MAI_SENDER"));
            retourMail.set("MAI_RGROUP", mail.getString("MAI_SGROUP"));
            retourMail.set("MAI_RECEIVER_ID", mail.get("MAI_SENDER_ID"));
            retourMail.set("MAI_SUBJECT", "Receipt of: " + mail.getString("MAI_SUBJECT"));
            retourMail.set("MAI_TEXT", rtext);
            retourMail.set("MAI_ATTACHMENT", "");
            retourMail.setBoolean("MAI_READ", false);
            retourMail.setBoolean("MAI_EXTRACTED", false);
            retourMail.setBoolean("MAI_WANTSREC", false);
            if (!DataLayer.cvDataLayer.provideNewIDToIDObject(retourMail)) {
                return false;
            }
            retourMail.commit(true);
            if (!ObjectStoreServer.insertSingleMailObjectToForeignGroup(retourMail)) {
                Log.info("handleCOM_MAI_NEW einfuegen fuer empfaenger Objekt (fremde Gruppe) misslungen", this);
                return false;
            }
        }
        return true;
    }

    public boolean handleCOM_MAI_EXTRACT() {
        Mail mail = (Mail)this.ivObjectForCommand;
        if (mail.getBoolean("MAI_EXTRACTED", false)) {
            return false;
        }
        String milliS = this.ivLine[2];
        String attach = mail.getString("MAI_ATTACHMENT");
        if (attach != null && milliS != null) {
            Vector mice = new Vector();
            ObjectExtractor.extractObjects(Base64Manager.getDecodedString(attach), this.ivGroupname, this.ivObjectBag, mail.getString("MAI_SGROUP"), mice, new Date(Long.parseLong(milliS)), 3, this.ivNewObjectsTarget);
            this.manageDestinationInSourceMouse(mice);
        }
        mail.setBoolean("MAI_EXTRACTED", true);
        return true;
    }

    public boolean handleCOM_MAI_IMPORT() {
        String attach = this.ivLine[1];
        String milliS = this.ivLine[2];
        if (attach != null && milliS != null) {
            Vector mice = new Vector();
            ObjectExtractor.extractObjects(Base64Manager.getDecodedString(attach), this.ivGroupname, this.ivObjectBag, null, mice, new Date(Long.parseLong(milliS)), 3, this.ivNewObjectsTarget);
            this.manageDestinationInSourceMouse(mice);
        }
        return true;
    }

    public boolean handleCOM_MAI_IMPORT_WITH_ROOM() {
        String attach;
        long roomID = Long.parseLong(this.ivLine[2]);
        if (roomID > 0L && ObjectStore.getObjectDeadOrAlive(10, roomID, this.ivGroupname, this.ivObjectBag, false) != null && (attach = this.ivLine[1]) != null) {
            Vector mice = new Vector();
            ObjectExtractor.extractObjects(Base64Manager.getDecodedString(attach), this.ivGroupname, this.ivObjectBag, null, mice, new Date(), 9, this.ivNewObjectsTarget);
            if (!mice.isEmpty()) {
                long[] ownerID = null;
                String owneridS = this.ivLine[3];
                if (owneridS != null) {
                    try {
                        long val = Long.parseLong(owneridS);
                        if (val > 0L) {
                            ownerID = new long[]{val};
                        }
                    }
                    catch (Exception val) {
                        // empty catch block
                    }
                }
                Iterator iter = mice.iterator();
                while (iter.hasNext()) {
                    Mouse mouse = (Mouse)iter.next();
                    mouse.setLong("MOS_ROOM", roomID);
                    this.manageDestinationInSourceMouse(mouse);
                    mouse.set("MOS_OWNER", ownerID);
                    this.markObjectForServiceRoom(mouse, roomID);
                }
                return true;
            }
        }
        return false;
    }

    public boolean handleCOM_MAI_IMPORT_WITH_ROOM_OR_RACKPOS() {
        String attach = this.ivLine[1];
        if (attach == null) {
            return false;
        }
        String sourceGroup = this.ivLine[8];
        Date transferDate = new Date();
        Vector mice = new Vector();
        ObjectExtractor.extractObjects(Base64Manager.getDecodedString(attach), this.ivGroupname, this.ivObjectBag, sourceGroup, mice, transferDate, 9, this.ivNewObjectsTarget);
        if (mice.isEmpty()) {
            return false;
        }
        long sourceCageID = Long.parseLong(this.ivLine[2]);
        Cage sourceCage = (Cage)ObjectStore.getObjectDeadOrAlive(2, sourceCageID, sourceGroup, this.ivObjectBag, false);
        if (sourceCage == null) {
            return false;
        }
        this.ivObjectBag.put(sourceCage.getIdentifierString(), sourceCage);
        String[] bruddel2 = new String[1];
        boolean res = CommandManagerCage.removeCage(sourceCage, this.ivObjectBag, transferDate.getTime(), bruddel2, this.ivServiceRoomOverride, true);
        if (!res && bruddel2[0] != null) {
            this.ivBugString = bruddel2[0];
            return false;
        }
        Cage targetCage = new Cage();
        this.finishNewObject(targetCage, Long.toString(transferDate.getTime()));
        targetCage.setInt("CAG_PSEUDOID", CommandManagerCage.findNextPseudoID(this.ivGroupname));
        targetCage.set("CAG_COMMENT", sourceCage.get("CAG_COMMENT"));
        targetCage.set("CAG_ANTAG", sourceCage.get("CAG_ANTAG"));
        targetCage.set("CAG_FLAG", sourceCage.get("CAG_FLAG"));
        targetCage.set("IDO_FKEY", sourceCage.get("IDO_FKEY"));
        long[] ownerID = null;
        String owneridS = this.ivLine[9];
        if (owneridS != null) {
            try {
                long val = Long.parseLong(owneridS);
                if (val > 0L) {
                    ownerID = new long[]{val};
                }
            }
            catch (Exception val) {
                // empty catch block
            }
        }
        Iterator iter = mice.iterator();
        while (iter.hasNext()) {
            Mouse mouse = (Mouse)iter.next();
            CommandManagerMouse.mouseEntersCage(mouse, targetCage, transferDate, 9, this.ivObjectBag);
            this.manageDestinationInSourceMouse(mouse);
            mouse.set("MOS_OWNER", ownerID);
        }
        long targetRoomID = Long.parseLong(this.ivLine[3]);
        long sourceRackID = Long.parseLong(this.ivLine[4]);
        if (targetRoomID > 0L) {
            Room room = (Room)ObjectStore.getObjectDeadOrAlive(10, targetRoomID, this.ivGroupname, this.ivObjectBag, false);
            if (room != null) {
                targetCage.set("CAG_ROOM", new Long(targetRoomID));
                Long serviceRoomID = room.getServiceRoomID();
                Vector<Cage> v = new Vector<Cage>(mice);
                v.add(targetCage);
                this.markObjectsForServiceRoom(v, serviceRoomID != null ? serviceRoomID : AllgUtils.NIX_ROOM);
                return true;
            }
        } else if (sourceRackID > 0L) {
            Rack sourceRack = (Rack)ObjectStore.getObjectDeadOrAlive(3, sourceRackID, sourceGroup, this.ivObjectBag, false);
            if (sourceRack == null) {
                return false;
            }
            this.ivObjectBag.put(sourceRack.getIdentifierString(), sourceRack);
            Rack targetRack = (Rack)sourceRack.getSharedObject(this.ivGroupname, this.ivObjectBag);
            if (targetRack == null) {
                return false;
            }
            this.ivObjectBag.put(targetRack.getIdentifierString(), targetRack);
            int seite = Integer.parseInt(this.ivLine[5]);
            int col = Integer.parseInt(this.ivLine[6]);
            int row = Integer.parseInt(this.ivLine[7]);
            res = CommandManagerCage.moveCageToRack(targetCage, targetRack, seite, col, row, this.ivObjectBag, bruddel2, this.ivServiceRoomOverride, this.ivGeneralSRId);
            this.ivBugString = bruddel2[0];
            Long serviceRoomID = targetRack.getServiceRoomID();
            Vector<Cage> v = new Vector<Cage>(mice);
            v.add(targetCage);
            this.markObjectsForServiceRoom(v, serviceRoomID != null ? serviceRoomID : AllgUtils.NIX_ROOM);
            return res;
        }
        return false;
    }

    private void manageDestinationInSourceMouse(Vector mice) {
        if (mice != null && !mice.isEmpty()) {
            Iterator iterator = mice.iterator();
            while (iterator.hasNext()) {
                Mouse mouse = (Mouse)iterator.next();
                this.manageDestinationInSourceMouse(mouse);
            }
        }
    }

    private void manageDestinationInSourceMouse(Mouse mouse) {
        String cameFrom = mouse.getString("MOS_CAME");
        if (cameFrom != null && cameFrom.startsWith("MGI:")) {
            try {
                IDObject.IDObjectIdentifier ident = new IDObject.IDObjectIdentifier(cameFrom.substring("MGI:".length(), cameFrom.length()));
                Mouse sourceMouse = (Mouse)ObjectStore.getObjectDeadOrAlive(ident.ivTyp, ident.ivID, ident.ivGroup, this.ivObjectBag, false);
                if (sourceMouse != null) {
                    sourceMouse.set("MOS_WENT", "MGI:" + mouse.getIdentifierString());
                } else {
                    Log.error("Problem while setting destination in source mouse. Source mouse cannot be found. IDENT " + ident + " cameFrom " + cameFrom + " Targetmouse " + mouse, null, this);
                }
            }
            catch (Throwable e) {
                Log.error("Problem while setting destination in source mouse. cameFrom " + cameFrom + " Targetmouse " + mouse, e, this);
            }
        }
    }

    public boolean handleCOM_LEGACY_IMPORT() {
        HashMap objectsByType = (HashMap)this.ivExtraObject;
        ObjectExtractor.extractObjectsFromLegacyExcel(objectsByType, this.ivGroupname, this.ivObjectBag, this.ivNewObjectsTarget);
        return true;
    }
}

