/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.objectstore;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.helper.Zeile;
import mausoleum.objectstore.CommandManagerCage;
import mausoleum.rack.Rack;
import mausoleum.result.rackhealthreport.RResHealthReport;
import mausoleum.room.Room;

public class CommandManagerRack
extends CommandManagerExecutive {
    public static final String COM_RCK_RM = "RKR";
    public static final String COM_RCK_NEWSRCN = "RKNSRCN";
    public static final String COM_RCK_NEWSRCN_ROOM = "RKNSRCN_ROOM";
    public static final String COM_RCK_MOV = "RKMOVE";
    public static final String COM_RCK_NAME = "RKNAME";
    public static final String COM_RCK_IMPORT_SERVICE = "RK_IMPORT_SERVICE";
    public static final String COM_RCK_CLEARPOS = "RKCLEARPOS";
    public static final String COM_RCK_HALTUNGSFORM = "RKHAFO";
    public static final String COM_RCK_ADDRES = "RADDRES";
    public static final String COM_RCK_DELRES = "RDELRES";
    static /* synthetic */ Class class$0;

    public CommandManagerRack() {
        super(3);
        this.addMeth(COM_RCK_NEWSRCN, "handleRCKNEWSRCN", 6, false);
        this.addMeth(COM_RCK_NEWSRCN_ROOM, "handleRCKNEWSRCNROOM", 7, false);
        this.addMeth(COM_RCK_RM, "handleRCKRM", 3, true);
        this.addMeth(COM_RCK_MOV, "handleRCKMOV", 3, true);
        this.addMeth(COM_RCK_NAME, "handleRCKNAME", 3, true);
        this.addMeth(COM_RCK_CLEARPOS, "handleRCKCLEARPOS", 5, true);
        this.addMeth("RKDISBAR", "handleRCKDISBAR", 3, true);
        this.addMeth(COM_RCK_IMPORT_SERVICE, "handleImportRackToService", 6, false);
        this.addMeth("RK_REMOVE_SERVICE", "handleRemoveRackFromService", 3, false);
        this.addMeth(COM_RCK_HALTUNGSFORM, "handleRCKHAFO", 3, true);
        this.addMeth(COM_RCK_ADDRES, "handleRES_NEW", 3, true);
        this.addMeth(COM_RCK_DELRES, "handleRES_REMOVE", 3, true);
    }

    public String getParsedCommandIfTouched(String command, Zeile z, String group, int typ, long id, String objectGroup) {
        if (command.equals(COM_RCK_RM)) {
            if (typ == 0 && id == 0L) {
                return "Removed rack " + this.getIDObjectRef(group, 3, z.getLong(1, 0L), objectGroup);
            }
            if (typ == 3 && z.getLong(1, 0L) == id) {
                return "Removed rack";
            }
            return null;
        }
        if (command.equals(COM_RCK_NEWSRCN) || command.equals(COM_RCK_NEWSRCN_ROOM)) {
            if (typ == 0 && id == 0L) {
                return "Created new rack";
            }
            return null;
        }
        if (command.equals(COM_RCK_MOV)) {
            Room room;
            if (typ == 0 && id == 0L) {
                String rackRef = this.getIDObjectRef(group, 3, z.getLong(1, 0L), objectGroup);
                String romRef = this.getIDObjectRef(group, 10, z.getLong(2, 0L), objectGroup);
                return "Moved rack  " + rackRef + " to room: " + romRef;
            }
            if (typ == 3 && z.getLong(1, 0L) == id && (room = (Room)this.getIDObject(group, 10, z.getLong(2, 0L))) != null) {
                return "Moved rack to room: " + room.getString("ROM_NAME", "");
            }
            return null;
        }
        if (command.equals(COM_RCK_NAME)) {
            if (typ == 0 && id == 0L) {
                String rackRef = this.getIDObjectRef(group, 3, z.getLong(1, 0L), objectGroup);
                return "Changed name of rack " + rackRef + " to: " + z.getString(2, "[???]");
            }
            if (typ == 3 && z.getLong(1, 0L) == id) {
                return "Changed name to: " + z.getString(2, "[???]");
            }
            return null;
        }
        if (command.equals(COM_RCK_HALTUNGSFORM)) {
            if (typ == 0 && id == 0L) {
                String rackRef = this.getIDObjectRef(group, 3, z.getLong(1, 0L), objectGroup);
                return "Changed keeping type of rack " + rackRef + " to: " + z.getString(2, "[???]");
            }
            if (typ == 3 && z.getLong(1, 0L) == id) {
                return "Changed keeping type to: " + z.getString(2, "[???]");
            }
            return null;
        }
        if (command.equals(COM_RCK_CLEARPOS)) {
            if (typ == 0 && id == 0L) {
                String rackRef = this.getIDObjectRef(group, 3, z.getLong(1, 0L), objectGroup);
                int side = z.getInt(2, 0);
                int row = z.getInt(3, 0);
                int col = z.getInt(4, 0);
                if (side == 0) {
                    return "Removed cage from front row: " + row + " column: " + col + " of rack " + rackRef;
                }
                return "Removed cage from rear row: " + row + " column: " + col + " of rack " + rackRef;
            }
            if (typ == 3 && z.getLong(1, 0L) == id) {
                int side = z.getInt(2, 0);
                int row = z.getInt(3, 0);
                int col = z.getInt(4, 0);
                if (side == 0) {
                    return "Removed cage from front row: " + row + " column: " + col;
                }
                return "Removed cage from rear row: " + row + " column: " + col;
            }
            return null;
        }
        if (command.equals("RKBAR")) {
            if (typ == 0 && id == 0L) {
                String rackRef = this.getIDObjectRef(group, 3, z.getLong(1, 0L), objectGroup);
                return "Opened access to rack  " + rackRef + " for group: " + z.getStringB64(2, "?");
            }
            if (typ == 3 && z.getLong(1, 0L) == id) {
                return "Opened access for group: " + z.getStringB64(2, "?");
            }
            return null;
        }
        if (command.equals("RKDISBAR")) {
            if (typ == 0 && id == 0L) {
                String rackRef = this.getIDObjectRef(group, 3, z.getLong(1, 0L), objectGroup);
                return "Closed access to rack  " + rackRef + " for group: " + z.getStringB64(2, "?");
            }
            if (typ == 3 && z.getLong(1, 0L) == id) {
                return "Closed access for group: " + z.getStringB64(2, "?");
            }
            return null;
        }
        if (command.equals(COM_RCK_IMPORT_SERVICE)) {
            if (typ == 0 && id == 0L) {
                String sourceGroup = z.getStringB64(1, "?");
                String groupRckRef = this.getIDObjectRef(sourceGroup, 3, z.getLong(2, 0L), objectGroup);
                long serviceRackID = z.getLong(3, -1L);
                if (serviceRackID <= 0L) {
                    String serviceRoomRef = this.getIDObjectRef("service", 10, z.getLong(4, 0L), objectGroup);
                    return "Imported Rack " + groupRckRef + " from group " + sourceGroup + " as Rack >" + z.getStringB64(5, "?") + "< into Room " + serviceRoomRef + " of the service group";
                }
                String serviceRckRef = this.getIDObjectRef("service", 3, serviceRackID, objectGroup);
                return "Imported Rack " + groupRckRef + " from group " + sourceGroup + " into Rack " + serviceRckRef + " of the service group";
            }
            return null;
        }
        if (command.equals("RK_REMOVE_SERVICE")) {
            if (typ == 0 && id == 0L) {
                String sourceGroup = z.getStringB64(1, "?");
                String groupRckRef = this.getIDObjectRef(sourceGroup, 3, z.getLong(2, 0L), objectGroup);
                return "Removed Rack " + groupRckRef + " of group " + sourceGroup + " from service";
            }
        } else if (command.equals("RK_DETACH_FROM_SERVICE")) {
            if (typ == 0 && id == 0L) {
                String sourceGroup = z.getStringB64(2, "?");
                String groupRckRef = this.getIDObjectRef(sourceGroup, 3, z.getLong(3, 0L), objectGroup);
                return "Removed Rack " + groupRckRef + " of group " + sourceGroup + " from service";
            }
        } else {
            if (command.equals(COM_RCK_ADDRES)) {
                if (typ == 0 && id == 0L) {
                    return "Added health report for rack " + this.getIDObjectRef(group, 3, z.getLong(1, 0L), objectGroup);
                }
                if (typ == 3 && z.getLong(1, 0L) == id) {
                    return "Added health report";
                }
                return null;
            }
            if (command.equals(COM_RCK_DELRES)) {
                if (typ == 0 && id == 0L) {
                    return "Removed health report from rack " + this.getIDObjectRef(group, 3, z.getLong(1, 0L), objectGroup);
                }
                if (typ == 3 && z.getLong(1, 0L) == id) {
                    return "Removed health report";
                }
                return null;
            }
        }
        return "CME_NP";
    }

    public boolean handleRCKNAME() {
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "RCK_NAME", Base64Manager.getDecodedString(this.ivLine[2]));
        return true;
    }

    public boolean handleRCKHAFO() {
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "RCK_HAFO", Base64Manager.getDecodedString(this.ivLine[2]));
        return true;
    }

    public boolean handleRCKRM() {
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "IDO_END_DATE", new Date(Long.parseLong(this.ivLine[2])));
        return true;
    }

    public boolean handleRCKMOV() {
        Rack rack;
        if (this.ivObjectForCommand != null && (rack = (Rack)this.ivObjectForCommand).mayAttributeBeChangedByCommand()) {
            HashMap hm;
            long roomID = Long.parseLong(this.ivLine[2]);
            rack.setLong("RCK_ROOM", roomID);
            if (rack.getString("IDO_GROUP", "").equals("service") && (hm = rack.getSubObjectsByGroupOnServer(this.ivObjectBag)) != null) {
                Room room = (Room)ObjectStore.getObjectDeadOrAlive(10, roomID, this.ivGroupname, this.ivObjectBag, false);
                HashMap roomHM = new HashMap();
                if (room != null) {
                    roomHM = room.getSubObjectsByGroupOnServer(this.ivObjectBag);
                }
                Iterator iter = hm.keySet().iterator();
                while (iter.hasNext()) {
                    String uGroup = (String)iter.next();
                    Rack uRack = (Rack)hm.get(uGroup);
                    if (room != null) {
                        String[] bugString = new String[1];
                        Room gruppenRaum = CommandManagerRack.createRoomCopyAndEnterIDIfNecessary(room, roomHM, uGroup, this.ivObjectBag, this.ivNewObjectsTarget, bugString);
                        if (gruppenRaum == null) {
                            if (bugString[0] != null) {
                                this.ivBugString = String.valueOf(this.ivBugString) + bugString[0];
                            }
                            return false;
                        }
                        uRack.set("RCK_ROOM", new Long(gruppenRaum.getID()));
                    } else {
                        uRack.set("RCK_ROOM", null);
                    }
                    this.ivObjectBag.put(uRack.getIdentifierString(), uRack);
                }
            }
            return true;
        }
        return false;
    }

    public static Room createRoomCopyAndEnterIDIfNecessary(Room serviceRaum, HashMap roomHM, String gruppe, Hashtable objectBag, Vector newObjectsTarget, String[] bugString) {
        Room gruppenRaum = (Room)roomHM.get(gruppe);
        if (gruppenRaum == null) {
            gruppenRaum = (Room)serviceRaum.createSharedCopyOfServiceObject(gruppe, objectBag, newObjectsTarget);
        }
        if (gruppenRaum == null) {
            String error = "Couldn'create shared room instance for group " + gruppe + " of Room " + serviceRaum;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.objectstore.CommandManagerRack");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(error, null, clazz);
            bugString[0] = error;
            return null;
        }
        return gruppenRaum;
    }

    public boolean handleRCKNEWSRCN() {
        Rack rack = new Rack();
        rack.setInt("RCK_SIDES", this.ivLine[1]);
        rack.setInt("RCK_ROWS", this.ivLine[2]);
        rack.setInt("RCK_COLUMNS", this.ivLine[3]);
        rack.set("RCK_NAME", Base64Manager.getDecodedString(this.ivLine[4]));
        rack.makeCageVector();
        return this.finishNewObject(rack, this.ivLine[5]);
    }

    public boolean handleRCKNEWSRCNROOM() {
        if (this.ivGroupname.equals("service")) {
            Rack rack = new Rack();
            rack.setInt("RCK_SIDES", this.ivLine[1]);
            rack.setInt("RCK_ROWS", this.ivLine[2]);
            rack.setInt("RCK_COLUMNS", this.ivLine[3]);
            rack.set("RCK_NAME", Base64Manager.getDecodedString(this.ivLine[4]));
            rack.makeCageVector();
            if (!this.finishNewObject(rack, this.ivLine[5])) {
                return false;
            }
            long roomID = Long.parseLong(this.ivLine[6]);
            rack.setLong("RCK_ROOM", roomID);
            return true;
        }
        return false;
    }

    public boolean handleRCKCLEARPOS() {
        Rack rack = (Rack)this.ivObjectForCommand;
        int side = Integer.parseInt(this.ivLine[2]);
        int row = Integer.parseInt(this.ivLine[3]);
        int col = Integer.parseInt(this.ivLine[4]);
        Log.log("Perform handleRCKCLEARPOS " + rack + " Side " + side + " Row " + row + " Column " + col, this);
        long[] rackCages = (long[])rack.get("RCK_CAGES");
        if (rackCages != null) {
            int pos = rack.calcPos(side, row, col);
            if (pos >= rackCages.length) {
                Log.warn("Problem at handleRCKCLEARPOS POS not possible " + pos + " Rack " + rack + " Side " + side + " Row " + row + " Column " + col, this);
                return true;
            }
            if (rackCages[pos] == 0L) {
                Log.warn("Problem at handleRCKCLEARPOS Rack at POS is already empty " + pos + " Rack " + rack + " Side " + side + " Row " + row + " Column " + col, this);
                return true;
            }
            Cage alterSack = (Cage)ObjectStore.getObjectDeadOrAlive(2, rackCages[pos], rack.getGroup(), this.ivObjectBag, false);
            if (alterSack != null) {
                if (alterSack.isAliveAndVisible()) {
                    Log.warn("Problem at handleRCKCLEARPOS Cage at POS is pumperlgsund " + pos + " Cage " + alterSack + " Rack " + rack + " Side " + side + " Row " + row + " Column " + col, this);
                    return true;
                }
                if (alterSack.get("CAG_POS") != null) {
                    alterSack.set("CAG_POS", null);
                    this.ivObjectBag.put(alterSack.getIdentifierString(), alterSack);
                }
            }
            long[] newRackCages = new long[rackCages.length];
            int i = 0;
            while (i < rackCages.length) {
                newRackCages[i] = rackCages[i];
                ++i;
            }
            newRackCages[rack.calcPos((int)side, (int)row, (int)col)] = 0L;
            rack.setAndPropagateCages(newRackCages, this.ivObjectBag, this.ivServiceRoomOverride);
        }
        return true;
    }

    public boolean handleImportRackToService() {
        boolean finished = false;
        if (this.isServiceGroup()) {
            String gruppe = Base64Manager.getDecodedString(this.ivLine[1]);
            long gruppenRackID = Long.parseLong(this.ivLine[2]);
            long serviceRackID = Long.parseLong(this.ivLine[3]);
            long serviceRoomID = Long.parseLong(this.ivLine[4]);
            String wantedRackName = Base64Manager.getDecodedString(this.ivLine[5]);
            Rack gruppenRack = (Rack)ObjectStoreServer.getObjectToUpdate(3, gruppenRackID, gruppe, this.ivObjectBag);
            if (gruppenRack != null && gruppenRack.get("IDO_SERVID") == null) {
                Rack serviceRack;
                if (serviceRoomID != -1L) {
                    Rack serviceRack2 = new Rack();
                    serviceRack2.set("RCK_SIDES", gruppenRack.get("RCK_SIDES"));
                    serviceRack2.set("RCK_ROWS", gruppenRack.get("RCK_ROWS"));
                    serviceRack2.set("RCK_COLUMNS", gruppenRack.get("RCK_COLUMNS"));
                    serviceRack2.set("RCK_NAME", wantedRackName);
                    serviceRack2.set("RCK_ROOM", new Long(serviceRoomID));
                    serviceRack2.makeCageVector();
                    if (this.finishNewObject(serviceRack2, Long.toString(System.currentTimeMillis()))) {
                        Room gruppenRaum;
                        serviceRack2.set("IDO_UGROUPS", new String[]{gruppe});
                        serviceRack2.set("IDO_UGROUPIDS", new long[]{gruppenRackID});
                        gruppenRack.set("IDO_SERVID", serviceRack2.get("IDO_ID"));
                        gruppenRack.set("RCK_NAME", wantedRackName);
                        boolean[] occArr = new boolean[gruppenRack.getArraySize()];
                        gruppenRack.addOccupation(occArr);
                        gruppenRack.set("RCK_OCC", occArr);
                        serviceRack2.set("RCK_OCC", occArr);
                        Room serviceRaum = (Room)ObjectStoreServer.getObjectToUpdate(10, serviceRoomID, this.ivGroupname, this.ivObjectBag);
                        if (serviceRaum != null && (gruppenRaum = this.giveAccessToRoom(serviceRaum, gruppe, gruppenRack)) == null) {
                            return false;
                        }
                        finished = true;
                    }
                } else if (serviceRackID != -1L && (serviceRack = (Rack)ObjectStoreServer.getObjectToUpdate(3, serviceRackID, this.ivGroupname, this.ivObjectBag)) != null) {
                    Room serviceRaum;
                    String[] gruppen = (String[])serviceRack.get("IDO_UGROUPS");
                    if (gruppen != null) {
                        int i = 0;
                        while (i < gruppen.length) {
                            if (gruppen[i].equals(gruppe)) {
                                this.ivBugString = "Rack is already in use by this group";
                                return false;
                            }
                            ++i;
                        }
                    }
                    if (gruppenRack.getInt("RCK_SIDES", -1) != serviceRack.getInt("RCK_SIDES", -1) || gruppenRack.getInt("RCK_ROWS", -1) != serviceRack.getInt("RCK_ROWS", -1) || gruppenRack.getInt("RCK_COLUMNS", -1) != serviceRack.getInt("RCK_COLUMNS", -1)) {
                        this.ivBugString = "Selected Rack does not match the dimensions";
                        return false;
                    }
                    Vector<Long> rausfliegIDs = new Vector<Long>();
                    boolean[] occupied = (boolean[])serviceRack.get("RCK_OCC");
                    long[] cageIDs = (long[])gruppenRack.get("RCK_CAGES");
                    if (occupied != null && cageIDs != null) {
                        if (occupied.length != cageIDs.length) {
                            return false;
                        }
                        int i = 0;
                        while (i < occupied.length) {
                            if (occupied[i] && cageIDs[i] != 0L) {
                                rausfliegIDs.add(new Long(cageIDs[i]));
                            }
                            ++i;
                        }
                    }
                    serviceRoomID = serviceRack.getLong("RCK_ROOM", -1L);
                    Room gruppenRaum = null;
                    if (serviceRoomID != -1L && (gruppenRaum = this.giveAccessToRoom(serviceRaum = (Room)ObjectStoreServer.getObjectToUpdate(10, serviceRoomID, this.ivGroupname, this.ivObjectBag), gruppe, gruppenRack)) == null) {
                        return false;
                    }
                    Iterator iter = rausfliegIDs.iterator();
                    while (iter.hasNext()) {
                        Long cageID = (Long)iter.next();
                        Cage cage = (Cage)ObjectStoreServer.getObjectToUpdate(2, cageID, gruppe, this.ivObjectBag);
                        if (cage == null) continue;
                        String bruddel = CommandManagerCage.removeCageFromRack(cage, this.ivObjectBag, this.ivServiceRoomOverride);
                        if (bruddel != null) {
                            this.ivBugString = bruddel;
                            return false;
                        }
                        if (gruppenRaum == null) continue;
                        cage.set("CAG_ROOM", gruppenRaum.get("IDO_ID"));
                    }
                    gruppenRack.set("RCK_NAME", serviceRack.get("RCK_NAME"));
                    gruppenRack.set("IDO_SERVID", serviceRack.get("IDO_ID"));
                    serviceRack.incUserGroupNamesAndUserGroupIDs(gruppe, gruppenRack);
                    Rack.propagateCageOccupation(serviceRack, this.ivObjectBag, this.ivServiceRoomOverride);
                    finished = true;
                }
            }
        }
        return finished;
    }

    private Room giveAccessToRoom(Room serviceRaum, String gruppe, Rack gruppenRack) {
        Room gruppenRaum = null;
        if (serviceRaum != null) {
            HashMap roomHM = serviceRaum.getSubObjectsByGroupOnServer(this.ivObjectBag);
            if (roomHM != null) {
                gruppenRaum = (Room)roomHM.get(gruppe);
            }
            if (gruppenRaum == null) {
                gruppenRaum = (Room)serviceRaum.createSharedCopyOfServiceObject(gruppe, this.ivObjectBag, this.ivNewObjectsTarget);
            }
            if (gruppenRaum != null) {
                gruppenRack.set("RCK_ROOM", new Long(gruppenRaum.getID()));
            }
        }
        return gruppenRaum;
    }

    public boolean handleRemoveRackFromService() {
        return false;
    }

    public boolean handleRCKDISBAR() {
        return false;
    }

    public boolean handleRES_NEW() {
        RResHealthReport mres = new RResHealthReport(Base64Manager.getDecodedString(this.ivLine[2]));
        mres.ivPseudoID = MilliSpender.getMillis();
        return RResHealthReport.performRackResAction(1, -1L, mres.getInitString());
    }

    public boolean handleRES_REMOVE() {
        return RResHealthReport.performRackResAction(2, Long.parseLong(this.ivLine[2]), null);
    }
}

