/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.objectstore;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.util.Log;
import java.awt.Color;
import mausoleum.helper.Zeile;
import mausoleum.objectstore.CommanManUtil;
import mausoleum.strain.Strain;

public class CommandManagerStrain
extends CommandManagerExecutive {
    private static final String PREFIX = "STR";
    public static final String COM_STR_NEW = "STRNEW";
    public static final String COM_STR_REVIT = "STRREVIT";
    public static final String COM_STR_RM = "STRRM";
    public static final String COM_STR_CHNAME = "STRCHNAME";
    public static final String COM_STR_CHCOMMENT = "STRCHCOMMENT";
    public static final String COM_STR_SETMATLIM = "STRSETMATLIM";
    public static final String COM_STR_CHCOLOR = "STRCHCOLOR";
    public static final String COM_STR_SET_PREFIX = "STRSETPREFIX";
    public static final String COM_STR_KILL_FINAL = "STR_KILL_FINAL";
    public static final String COM_STR_SET_COATCOLOR = "STRSTRSETCOATCOLOR";

    public CommandManagerStrain() {
        super(8);
        this.addMeth(COM_STR_NEW, "handleSTRNEW", 3, false);
        this.addMeth(COM_STR_REVIT, "setVisible", 2, true);
        this.addMeth(COM_STR_RM, "setInvisible", 2, true);
        this.addMeth(COM_STR_KILL_FINAL, "removeComObject", 2, true);
        this.addMeth(COM_STR_CHNAME, "handleSTRCHNAME", 3, true);
        this.addMeth(COM_STR_CHCOMMENT, "handleSTRCHCOMMENT", 3, true);
        this.addMeth(COM_STR_SETMATLIM, "handleSTRSETMATLIM", 3, true);
        this.addMeth(COM_STR_CHCOLOR, "handleSTRCHCOLOR", 3, true);
        this.addMeth(COM_STR_SET_PREFIX, "handleSTR_SET_PREFIX", 3, true);
        this.addMeth(COM_STR_SET_COATCOLOR, "handleSTR_SET_COAT_COLOR", 3, true);
    }

    public String getParsedCommandIfTouched(String command, Zeile z, String group, int typ, long id, String objectGroup) {
        if (command.equals(COM_STR_NEW)) {
            if (typ == 0 && id == 0L) {
                return "Created new strain";
            }
            return null;
        }
        if (command.equals(COM_STR_REVIT)) {
            if (typ == 0 && id == 0L) {
                return "Revitalized strain " + this.getIDObjectRef(group, 8, z.getLong(1, 0L), objectGroup);
            }
            if (typ == 8 && z.getLong(1, 0L) == id) {
                return "Revitalized Strain";
            }
            return null;
        }
        if (command.equals(COM_STR_RM)) {
            if (typ == 0 && id == 0L) {
                return "Removed strain " + this.getIDObjectRef(group, 8, z.getLong(1, 0L), objectGroup);
            }
            if (typ == 8 && z.getLong(1, 0L) == id) {
                return "Removed Strain";
            }
            return null;
        }
        if (command.equals(COM_STR_CHNAME)) {
            if (typ == 0 && id == 0L) {
                String strRef = this.getIDObjectRef(group, 8, z.getLong(1, 0L), objectGroup);
                return CommandManagerStrain.getPB64String("Changed name of strain " + strRef + " to: ", z, 2);
            }
            if (typ == 8 && z.getLong(1, 0L) == id) {
                return CommandManagerStrain.getPB64String("Changed name to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_STR_CHCOLOR)) {
            Color col;
            if (typ == 0 && id == 0L) {
                String linRef = this.getIDObjectRef(group, 8, z.getLong(1, 0L), objectGroup);
                Color col2 = CommandManagerStrain.convertToColor(z.getString(2, ""));
                if (col2 != null) {
                    return "Changed color of strain " + linRef + " to: (" + CommandManagerStrain.getDescr(col2) + ")";
                }
            } else if (typ == 8 && z.getLong(1, 0L) == id && (col = CommandManagerStrain.convertToColor(z.getString(2, ""))) != null) {
                return "Changed color to: (" + CommandManagerStrain.getDescr(col) + ")";
            }
            return null;
        }
        if (command.equals(COM_STR_SET_PREFIX)) {
            if (typ == 0 && id == 0L) {
                String linRef = this.getIDObjectRef(group, 8, z.getLong(1, 0L), objectGroup);
                return CommandManagerStrain.getPB64String("Set eartag prefix of strain " + linRef + " to: ", z, 2);
            }
            if (typ == 8 && z.getLong(1, 0L) == id) {
                return CommandManagerStrain.getPB64String("Set eartag prefix to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_STR_CHCOMMENT)) {
            if (typ == 0 && id == 0L) {
                String strRef = this.getIDObjectRef(group, 8, z.getLong(1, 0L), objectGroup);
                return CommandManagerStrain.getPB64String("Set comment of strain " + strRef + " to: ", z, 2);
            }
            if (typ == 8 && z.getLong(1, 0L) == id) {
                return CommandManagerStrain.getPB64String("Set comment to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_STR_SETMATLIM)) {
            if (typ == 0 && id == 0L) {
                String strRef = this.getIDObjectRef(group, 8, z.getLong(1, 0L), objectGroup);
                int matlim = z.getInt(2, -1);
                if (matlim == -1) {
                    return "Removed maturity limit of strain " + strRef;
                }
                return "Set maturity limit of strain " + strRef + " to " + matlim + " days";
            }
            if (typ == 8 && z.getLong(1, 0L) == id) {
                int matlim = z.getInt(2, -1);
                if (matlim == -1) {
                    return "Removed maturity limit";
                }
                return "Set maturity limit to " + matlim + " days";
            }
            return null;
        }
        if (command.equals(COM_STR_SET_COATCOLOR)) {
            if (typ == 0 && id == 0L) {
                String mosRef = this.getIDObjectRef(group, 8, z.getLong(1, 0L), objectGroup);
                if (z.getString(2, "").equals("0")) {
                    return "Defined coat colour of strain " + mosRef;
                }
                return "Cleared coat colour information of strain " + mosRef;
            }
            if (typ == 8 && z.getLong(1, 0L) == id) {
                if (z.getString(2, "").equals("0")) {
                    return "Defined coat colour";
                }
                return "Cleared coat colour information";
            }
            return null;
        }
        return "CME_NP";
    }

    public boolean handleSTRNEW() {
        Strain strain = new Strain();
        strain.set("STR_NAME", Base64Manager.getDecodedString(this.ivLine[1]));
        strain.setLong("STR_ENTERER", this.ivLine[2]);
        return this.finishNewObject(strain, null);
    }

    public boolean handleSTRCHNAME() {
        return this.setStringAndPropagate(2, "STR_NAME", true);
    }

    public boolean handleSTRCHCOMMENT() {
        return this.setStringAndPropagate(2, "STR_DESCRIPTION", true);
    }

    public boolean handleSTRSETMATLIM() {
        try {
            int matlim = Integer.parseInt(this.ivLine[2]);
            this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "STR_MATLIM", matlim == -1 ? null : new Integer(matlim));
            return true;
        }
        catch (Exception e) {
            Log.info("Problem bei handleSTRSETMATLIM " + this.ivLine[2], this);
            return false;
        }
    }

    public boolean handleSTRCHCOLOR() {
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "STR_COLOR", CommandManagerStrain.convertToColor(this.ivLine[2]));
        return true;
    }

    public boolean handleSTR_SET_PREFIX() {
        return this.setStringAndPropagate(2, "STR_ETPREFIX", true);
    }

    public boolean handleSTR_SET_COAT_COLOR() {
        return CommanManUtil.handleSetInt(this.ivObjectForCommand, "STR_CC", this.ivLine, 2, 0, "handleSTR_SET_COAT_COLOR", this.ivObjectBag);
    }
}

