/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.objectstore;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.helper.Zeile;

public class DocMoveManager {
    public static boolean moveDocsFromGroupObjectToService(IDObject groupObject, String groupObjectDocumentDefinitions, IDObject serviceObject) {
        boolean res = true;
        if (groupObjectDocumentDefinitions != null) {
            HashSet groupDokDefs = DocMoveManager.separateDokDefinitions(groupObjectDocumentDefinitions);
            HashSet serviceDokDefs = DocMoveManager.separateDokDefinitions(serviceObject.getString("IDO_DOK", null));
            Vector<String> dokDefsToAdd = new Vector<String>();
            Vector<String> filenamesToCopy = new Vector<String>();
            Iterator iterator = groupDokDefs.iterator();
            while (iterator.hasNext()) {
                int ind;
                String dokDef = (String)iterator.next();
                if (serviceDokDefs.contains(dokDef) || (ind = dokDef.indexOf("|")) == -1) continue;
                String filename = dokDef.substring(0, ind).trim();
                filenamesToCopy.add(filename);
                dokDefsToAdd.add(dokDef);
            }
            String gruppenDocsDirPath = GroupFileManager.getDocsPath(groupObject.getGroup());
            String serviceDocsDirPath = GroupFileManager.getDocsPath("service");
            if (!filenamesToCopy.isEmpty()) {
                res = DocMoveManager.copyDocs(filenamesToCopy, gruppenDocsDirPath, serviceDocsDirPath);
            }
            if (res) {
                if (!dokDefsToAdd.isEmpty()) {
                    serviceDokDefs.addAll(dokDefsToAdd);
                    StringBuilder msb = new StringBuilder();
                    Iterator iterator2 = serviceDokDefs.iterator();
                    while (iterator2.hasNext()) {
                        String dokDef = (String)iterator2.next();
                        if (msb.length() != 0) {
                            msb.append("|");
                        }
                        msb.append(Base64Manager.encodeBase64(dokDef));
                    }
                    serviceObject.set("IDO_DOK", msb.toString());
                }
                groupObject.set("IDO_DOK", serviceObject.get("IDO_DOK"));
            }
        }
        return res;
    }

    public static boolean copyDocsFromServiceObjectToGroup(IDObject serviceObject, IDObject groupObject) {
        boolean copyResultat = true;
        String serviceDocString = serviceObject.getString("IDO_DOK", null);
        HashSet serviceDokDefs = DocMoveManager.separateDokDefinitions(serviceDocString);
        if (!serviceDokDefs.isEmpty()) {
            Vector<String> filenames = new Vector<String>();
            Iterator iterator = serviceDokDefs.iterator();
            while (iterator.hasNext()) {
                String dokDef = (String)iterator.next();
                int ind = dokDef.indexOf("|");
                if (ind == -1) continue;
                filenames.add(dokDef.substring(0, ind).trim());
            }
            String gruppenDocsDirPath = GroupFileManager.getDocsPath(groupObject.getGroup());
            String serviceDocsDirPath = GroupFileManager.getDocsPath("service");
            copyResultat = DocMoveManager.copyDocs(filenames, serviceDocsDirPath, gruppenDocsDirPath);
        }
        if (copyResultat) {
            groupObject.set("IDO_DOK", serviceDocString);
        }
        return copyResultat;
    }

    private static HashSet separateDokDefinitions(String definitions) {
        HashSet<String> target = new HashSet<String>();
        if (definitions != null && definitions.length() != 0) {
            Zeile z = new Zeile(definitions, '|');
            int i = 0;
            while (i < z.size()) {
                target.add(z.getStringB64(i, ""));
                ++i;
            }
            target.remove("");
        }
        return target;
    }

    private static boolean copyDocs(Vector filenames, String sourceDocsPath, String targetDocsPath) {
        FileManager.prepareDirs(targetDocsPath);
        boolean copyResultat = true;
        Iterator iterator = filenames.iterator();
        while (iterator.hasNext() && copyResultat) {
            String filename = (String)iterator.next();
            String sourcePath = String.valueOf(sourceDocsPath) + "/" + filename;
            String targetPath = String.valueOf(targetDocsPath) + "/" + filename;
            if (!new File(sourcePath).exists() || new File(targetPath).exists() || FileManager.copy(sourcePath, targetPath)) continue;
            copyResultat = false;
        }
        return copyResultat;
    }
}

