/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.objectstore;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.dfa.IntermediaerHelfer;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.db.DBAssistant;
import mausoleum.helper.ZeileAbstr;
import mausoleum.line.Line;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.mouse.Mouse;
import mausoleum.objectstore.IndexChecker;

public class InterCrossHandler
implements Runnable,
IndexChecker {
    private static final HashMap RUNNING_JOBS = new HashMap(10);
    private static final int PARENTS_COL = IntermediaerHelfer.getParentsCol();
    private static final int LINE_COL = IntermediaerHelfer.getLineCol();
    private static final char INDEX_SEP_CHAR = IntermediaerHelfer.getIndexSeparator();
    private final String ivGroup;
    private String ivTicket = null;
    private String ivLineIDMom = null;
    private String ivLineIDDad = null;
    private CheckLaL[] ivLALMom = null;
    private CheckLaL[] ivLALDad = null;
    private boolean ivMomBreederAllowed = false;
    private boolean ivDadBreederAllowed = false;
    private boolean ivMomUnknownAllowed = false;
    private boolean ivDadUnknownAllowed = false;
    private HashMap ivBreederYNByLineID = new HashMap();
    private HashMap ivMatchByMouseID = new HashMap();
    private HashMap ivMouseIDsByGT = new HashMap(10);
    private HashMap ivMouseHT = new HashMap(2500);

    public static String startHandler(String group, long momLineID, LocusAndAlleles[] lalMom, boolean momBreederAllowed, boolean momUnknownAllowed, long dadLineID, LocusAndAlleles[] lalDad, boolean dadBreederAllowed, boolean dadUnknownAllowed) {
        InterCrossHandler ich = new InterCrossHandler(group, momLineID, lalMom, momBreederAllowed, momUnknownAllowed, dadLineID, lalDad, dadBreederAllowed, dadUnknownAllowed);
        new Thread(ich).start();
        return ich.ivTicket;
    }

    public static String getResForTicket(String ticket) {
        String res = (String)RUNNING_JOBS.get(ticket);
        if (res == null) {
            return "XXX";
        }
        if (res.equals("XXX")) {
            return res;
        }
        RUNNING_JOBS.remove(ticket);
        return res;
    }

    private static CheckLaL[] getParentGTArray(String parentLineID, LocusAndAlleles[] parentGenotype, Vector sammler) {
        int i;
        CheckLaL[] parentGTArray = null;
        sammler.clear();
        if (parentLineID != null && parentGenotype != null) {
            i = 0;
            while (i < parentGenotype.length) {
                if (parentGenotype[i].ivAllele != null && parentGenotype[i].ivAllele.length != 0) {
                    sammler.addElement(new CheckLaL(parentGenotype[i]));
                }
                ++i;
            }
        }
        if (!sammler.isEmpty()) {
            parentGTArray = new CheckLaL[sammler.size()];
            i = 0;
            while (i < sammler.size()) {
                parentGTArray[i] = (CheckLaL)sammler.elementAt(i);
                ++i;
            }
        }
        sammler.clear();
        return parentGTArray;
    }

    private static boolean checkAllels(LocusAndAlleles[] mlal, CheckLaL[] lal, boolean male) {
        if (lal == null || lal.length == 0) {
            return true;
        }
        if (mlal == null || mlal.length == 0) {
            return false;
        }
        int i = 0;
        while (i < lal.length) {
            LocusAndAlleles test = InterCrossHandler.findLaL(lal[i].ivLocusID, mlal);
            if (test == null) {
                return false;
            }
            if (!InterCrossHandler.compare(lal[i], test, male)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean compare(CheckLaL mussLaL, LocusAndAlleles mausLaL, boolean male) {
        if (mussLaL.ivAllele.length != mausLaL.ivAllele.length) {
            return male && mussLaL.ivAllele.length == 2 && mausLaL.ivAllele.length == 1 && (mussLaL.ivAllele[0].equals(mausLaL.ivAllele[0]) || mussLaL.ivAllele[1].equals(mausLaL.ivAllele[0]));
        }
        if (mussLaL.ivIsHomozygot) {
            int i = 0;
            while (i < mausLaL.ivAllele.length) {
                if (!mussLaL.ivAllele[0].equals(mausLaL.ivAllele[i])) {
                    return false;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < mussLaL.ivAllele.length) {
                if (!InterCrossHandler.allelDa(mussLaL.ivAllele[i], mausLaL.ivAllele)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static boolean allelDa(String allel, String[] arr) {
        int i = 0;
        while (i < arr.length) {
            if (allel.equals(arr[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static LocusAndAlleles findLaL(long locusID, LocusAndAlleles[] mlal) {
        int i = 0;
        while (i < mlal.length) {
            if (mlal[i].ivLocusID == locusID) {
                return mlal[i];
            }
            ++i;
        }
        return null;
    }

    private InterCrossHandler(String group, long momLineID, LocusAndAlleles[] lalMom, boolean momBreederAllowed, boolean momUnknownAllowed, long dadLineID, LocusAndAlleles[] lalDad, boolean dadBreederAllowed, boolean dadUnknownAllowed) {
        this.ivGroup = group;
        this.ivLineIDMom = momLineID == 0L ? null : Long.toString(momLineID);
        this.ivMomBreederAllowed = momBreederAllowed;
        this.ivMomUnknownAllowed = momUnknownAllowed;
        this.ivLineIDDad = dadLineID == 0L ? null : Long.toString(dadLineID);
        this.ivDadBreederAllowed = dadBreederAllowed;
        this.ivDadUnknownAllowed = dadUnknownAllowed;
        Vector sammler = new Vector();
        this.ivLALMom = InterCrossHandler.getParentGTArray(this.ivLineIDMom, lalMom, sammler);
        this.ivLALDad = InterCrossHandler.getParentGTArray(this.ivLineIDDad, lalDad, sammler);
        this.ivTicket = "ICH" + MilliSpender.getMillis();
        RUNNING_JOBS.put(this.ivTicket, "XXX");
    }

    private String getReport() {
        IntermediaerHelfer.giveIndicesToChecker(this, this.ivGroup);
        this.ivBreederYNByLineID.clear();
        this.ivBreederYNByLineID = null;
        this.ivMatchByMouseID.clear();
        this.ivMatchByMouseID = null;
        this.ivLineIDMom = null;
        this.ivLineIDDad = null;
        this.ivLALMom = null;
        this.ivLALDad = null;
        StringBuilder msb = new StringBuilder(5000);
        Iterator iterator = this.ivMouseIDsByGT.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (msb.length() != 0) {
                msb.append("@");
            }
            msb.append(Base64Manager.encodeBase64(key));
            Vector v = (Vector)this.ivMouseIDsByGT.get(key);
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                Long id = (Long)iter.next();
                msb.append("|").append(id);
            }
        }
        this.ivMouseIDsByGT.clear();
        this.ivMouseIDsByGT = null;
        this.ivMouseHT.clear();
        this.ivMouseHT = null;
        return msb.toString();
    }

    private boolean isBreederLine(String lineID) {
        if (lineID != null) {
            Boolean isBreeder = (Boolean)this.ivBreederYNByLineID.get(lineID);
            if (isBreeder == null) {
                Line line = (Line)ObjectStore.getObjectDeadOrAlive(7, Long.parseLong(lineID), this.ivGroup, null, false);
                isBreeder = line != null && line.isBreeder();
                this.ivBreederYNByLineID.put(lineID, isBreeder);
            }
            return isBreeder;
        }
        return false;
    }

    private Mouse getMouse(Number mouseID) {
        Mouse mouse = null;
        if (mouseID != null && (mouse = (Mouse)this.ivMouseHT.get(mouseID)) == null && (mouse = (Mouse)ObjectStore.getObjectDeadOrAlive(1, mouseID.longValue(), this.ivGroup, null, false)) != null) {
            this.ivMouseHT.put(mouseID, mouse);
        }
        return mouse;
    }

    private String getLineID(Long id, String defVal) {
        String index = IntermediaerHelfer.getIndex(this.ivGroup, id);
        return index != null ? ZeileAbstr.getStringNONEmpty(index, INDEX_SEP_CHAR, LINE_COL, null) : defVal;
    }

    private LocusAndAlleles[] determineMouseGT(Long id) {
        if (DataLayer.USE_DB) {
            return DBAssistant.determineMouseGT(this.ivGroup, id);
        }
        Mouse mouse = this.getMouse(id);
        if (mouse != null) {
            return (LocusAndAlleles[])mouse.get("MOS_LOCUSGENOTYPES");
        }
        return null;
    }

    public void checkIndex(Long id, String index) {
        int ind;
        String parents = ZeileAbstr.getStringNONEmpty(index, INDEX_SEP_CHAR, PARENTS_COL, null);
        if (parents != null && parents.length() > 1 && (ind = parents.indexOf(124)) != -1) {
            String mLineID;
            String fids = parents.substring(0, ind).trim();
            String mids = parents.substring(ind + 1, parents.length()).trim();
            if (fids.length() == 0 && mids.length() == 0) {
                return;
            }
            if (fids.length() == 0 ? !this.ivDadUnknownAllowed : mids.length() == 0 && !this.ivMomUnknownAllowed) {
                return;
            }
            Long fID = fids.length() == 0 ? null : new Long(fids);
            Long mID = fids.length() == 0 ? null : new Long(mids);
            String fLineID = fID != null ? this.getLineID(fID, null) : null;
            String string = mLineID = mID != null ? this.getLineID(mID, null) : null;
            if (fLineID != null || mLineID != null) {
                boolean mLineOK;
                boolean fLineOK = this.ivLineIDDad == null || fLineID == null && this.ivDadUnknownAllowed || this.ivLineIDDad.equals(fLineID) || this.isBreederLine(fLineID) && this.ivDadBreederAllowed;
                boolean bl = mLineOK = this.ivLineIDMom == null || mLineID == null && this.ivMomUnknownAllowed || this.ivLineIDMom.equals(mLineID) || this.isBreederLine(mLineID) && this.ivMomBreederAllowed;
                if (fLineOK && mLineOK && (!this.isBreederLine(fLineID) || !this.isBreederLine(mLineID)) && (this.ivLALDad == null || this.ivLineIDDad.equals(fLineID) && InterCrossHandler.checkAllels(this.determineMouseGT(fID), this.ivLALDad, true)) && (this.ivLALMom == null || this.ivLineIDMom.equals(mLineID) && InterCrossHandler.checkAllels(this.determineMouseGT(mID), this.ivLALMom, false))) {
                    LocusAndAlleles[] arr = this.determineMouseGT(id);
                    String key = String.valueOf(this.getLineID(id, "0")) + ":" + (arr == null ? "" : LocusAndAlleles.getTransportString(arr));
                    Vector<Long> v = (Vector<Long>)this.ivMouseIDsByGT.get(key);
                    if (v == null) {
                        v = new Vector<Long>();
                        this.ivMouseIDsByGT.put(key, v);
                    }
                    v.addElement(id);
                }
            }
        }
    }

    public void run() {
        try {
            RUNNING_JOBS.put(this.ivTicket, this.getReport());
        }
        catch (Exception e) {
            Log.warn("InterCrossHandler run Problem: ", e, this);
            RUNNING_JOBS.put(this.ivTicket, "NIX");
        }
        this.ivTicket = null;
    }

    static class CheckLaL
    extends LocusAndAlleles {
        private static final long serialVersionUID = 145875L;
        public boolean ivIsHomozygot = false;

        public CheckLaL(LocusAndAlleles lal) {
            this.ivLocusID = lal.ivLocusID;
            this.ivAllele = lal.ivAllele;
            this.ivIsHomozygot = lal.isHomozygous();
        }
    }
}

