/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.objectstore;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.network.server.ServerPortal;
import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.IndexObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.line.Line;
import mausoleum.locus.Locus;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.mouse.tierschutz.StressRule;
import mausoleum.objectstore.CommandManagerCage;
import mausoleum.objectstore.DocMoveManager;
import mausoleum.strain.Strain;
import mausoleum.visit.Visit;

public abstract class ObjectExtractor {
    public static final String FINGERPRINT_TAG = "<sfp ";
    static /* synthetic */ Class class$0;

    public static void extractObjects(String xmlString, String groupname, Hashtable objectbag, String senderGroupName, Vector mice, Date startDate, int startMode, Vector newObjectsTarget) {
        if (!ProcessDefinition.isServer()) {
            return;
        }
        boolean isSameServer = ObjectExtractor.isSameServer(xmlString);
        if (mice == null) {
            mice = new Vector();
        }
        Hashtable lociByOldID = new Hashtable();
        Hashtable linesByOldID = new Hashtable();
        Hashtable strainsByOldID = new Hashtable();
        ObjectExtractor.fillObjectsFromExportString(groupname, xmlString, mice, lociByOldID, linesByOldID, strainsByOldID, isSameServer);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.objectstore.ObjectExtractor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.debug("After extraction", clazz);
        ObjectExtractor.showInterestingObjects(lociByOldID, "LOCI", null);
        ObjectExtractor.showInterestingObjects(linesByOldID, "LINES", null);
        ObjectExtractor.findeIdentischeObjekte(strainsByOldID, groupname, 8, objectbag, newObjectsTarget);
        ObjectExtractor.findeIdentischeObjekte(lociByOldID, groupname, 14, objectbag, newObjectsTarget);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("mausoleum.objectstore.ObjectExtractor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.debug("Step 2", clazz2);
        ObjectExtractor.showInterestingObjects(lociByOldID, "LOCI", null);
        ObjectExtractor.showInterestingObjects(linesByOldID, "LINES", null);
        ObjectExtractor.adjustLineInformations(linesByOldID, lociByOldID);
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("mausoleum.objectstore.ObjectExtractor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.debug("Step 3", clazz3);
        ObjectExtractor.showInterestingObjects(lociByOldID, "LOCI", null);
        ObjectExtractor.showInterestingObjects(linesByOldID, "LINES", null);
        ObjectExtractor.findeIdentischeObjekte(linesByOldID, groupname, 7, objectbag, newObjectsTarget);
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("mausoleum.objectstore.ObjectExtractor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.debug("Step 4", clazz4);
        ObjectExtractor.showInterestingObjects(lociByOldID, "LOCI", null);
        ObjectExtractor.showInterestingObjects(linesByOldID, "LINES", null);
        long[] owners = null;
        if (senderGroupName != null) {
            User primaryUser = null;
            Hashtable allUsers = DataLayer.cvDataLayer.getAllActualObjects(groupname, 6);
            Enumeration objs = allUsers.elements();
            while (objs.hasMoreElements()) {
                User usi = (User)objs.nextElement();
                if (!senderGroupName.equalsIgnoreCase(usi.getString("USR_NAME"))) continue;
                primaryUser = usi;
            }
            if (primaryUser != null) {
                Vector<User> ownerVec = new Vector<User>();
                ownerVec.addElement(primaryUser);
                objs = allUsers.elements();
                while (objs.hasMoreElements()) {
                    User usi = (User)objs.nextElement();
                    if (usi == primaryUser || usi.getInt("USR_MODE") < 2) continue;
                    ownerVec.addElement(usi);
                }
                owners = new long[ownerVec.size()];
                int i = 0;
                while (i < ownerVec.size()) {
                    User usi = (User)ownerVec.elementAt(i);
                    owners[i] = usi.getID();
                    ++i;
                }
            }
        }
        int i = 0;
        while (i < mice.size()) {
            Mouse mouse = (Mouse)mice.elementAt(i);
            if (owners != null) {
                mouse.set("MOS_OWNER", owners);
            } else {
                mouse.set("MOS_OWNER", null);
            }
            mouse.setInt("MOS_STARTMODE", startMode);
            if (startDate != null) {
                mouse.set("IDO_START_DATE", startDate);
            }
            ObjectExtractor.showInterestingObjects(null, "Mouse before", mouse);
            ObjectExtractor.adjustLineAndGenotype(mouse, linesByOldID, lociByOldID);
            ObjectExtractor.adjustStrains(mouse, strainsByOldID);
            ObjectExtractor.showInterestingObjects(null, "Mouse after 1", mouse);
            if (!DataLayer.cvDataLayer.provideNewIDToIDObject(mouse)) {
                String string = "ExtractHelper [4]: Problem bei provideNewIDToIDObject " + mouse;
                Class<?> clazz5 = class$0;
                if (clazz5 == null) {
                    try {
                        clazz5 = Class.forName("mausoleum.objectstore.ObjectExtractor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.warn(string, null, clazz5);
            } else {
                ObjectExtractor.showInterestingObjects(null, "Mouse after 2", mouse);
                newObjectsTarget.addElement(mouse);
                objectbag.put(mouse.getIdentifierString(), mouse);
                TaskExtended.polishMouseTasksDuringImport(mouse);
            }
            ++i;
        }
        ObjectExtractor.finalizeObjectBag(objectbag, groupname, newObjectsTarget);
    }

    public static void extractObjectsFromLegacyExcel(HashMap objectHashtablesByObjectType, String groupname, Hashtable objectbag, Vector newObjectsTarget) {
        Mouse mouse;
        Hashtable cagesByOldID;
        Hashtable miceByOldID;
        Hashtable usersByOldID;
        Hashtable strainsByOldID;
        Hashtable linesByOldID;
        Hashtable lociByOldID = (Hashtable)objectHashtablesByObjectType.get(new Integer(14));
        if (lociByOldID == null) {
            lociByOldID = new Hashtable();
        }
        if ((linesByOldID = (Hashtable)objectHashtablesByObjectType.get(new Integer(7))) == null) {
            linesByOldID = new Hashtable();
        }
        if ((strainsByOldID = (Hashtable)objectHashtablesByObjectType.get(new Integer(8))) == null) {
            strainsByOldID = new Hashtable();
        }
        if ((usersByOldID = (Hashtable)objectHashtablesByObjectType.get(new Integer(6))) == null) {
            usersByOldID = new Hashtable();
        }
        if ((miceByOldID = (Hashtable)objectHashtablesByObjectType.get(new Integer(1))) == null) {
            miceByOldID = new Hashtable();
        }
        if ((cagesByOldID = (Hashtable)objectHashtablesByObjectType.get(new Integer(2))) == null) {
            cagesByOldID = new Hashtable();
        }
        ObjectExtractor.findeIdentischeObjekte(strainsByOldID, groupname, 8, objectbag, newObjectsTarget);
        ObjectExtractor.findeIdentischeObjekte(lociByOldID, groupname, 14, objectbag, newObjectsTarget);
        ObjectExtractor.adjustLineInformations(linesByOldID, lociByOldID);
        ObjectExtractor.findeIdentischeObjekte(linesByOldID, groupname, 7, objectbag, newObjectsTarget);
        ObjectExtractor.findeIdentischeObjekte(usersByOldID, groupname, 6, objectbag, newObjectsTarget);
        Iterator iter = miceByOldID.values().iterator();
        while (iter.hasNext()) {
            Mouse mouse2 = (Mouse)iter.next();
            mouse2.set("IDO_GROUP", groupname);
            ObjectExtractor.adjustOwners(mouse2, usersByOldID);
            ObjectExtractor.adjustLineAndGenotype(mouse2, linesByOldID, lociByOldID);
            ObjectExtractor.adjustStrains(mouse2, strainsByOldID);
            if (!DataLayer.cvDataLayer.provideNewIDToIDObject(mouse2)) {
                String string = "ExtractHelper [4]: Problem bei provideNewIDToIDObject " + mouse2;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("mausoleum.objectstore.ObjectExtractor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.warn(string, null, clazz);
                continue;
            }
            newObjectsTarget.addElement(mouse2);
            objectbag.put(mouse2.getIdentifierString(), mouse2);
        }
        int pseudoIDstart = -1;
        pseudoIDstart = CommandManagerCage.findNextPseudoIDRange(groupname, cagesByOldID.size());
        Iterator iter2 = cagesByOldID.values().iterator();
        while (iter2.hasNext()) {
            Cage cage = (Cage)iter2.next();
            cage.set("IDO_GROUP", groupname);
            if (pseudoIDstart != -1) {
                cage.setInt("CAG_PSEUDOID", pseudoIDstart);
                ++pseudoIDstart;
            }
            if (!DataLayer.cvDataLayer.provideNewIDToIDObject(cage)) {
                String string = "ExtractHelper [5]: Problem bei provideNewIDToIDObject " + cage;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("mausoleum.objectstore.ObjectExtractor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.warn(string, null, clazz);
                continue;
            }
            newObjectsTarget.addElement(cage);
            objectbag.put(cage.getIdentifierString(), cage);
        }
        iter2 = miceByOldID.values().iterator();
        while (iter2.hasNext()) {
            mouse = (Mouse)iter2.next();
            ObjectExtractor.adjustParents(mouse, miceByOldID, "MOS_MOTHER");
            ObjectExtractor.adjustParents(mouse, miceByOldID, "MOS_FATHER");
        }
        iter2 = miceByOldID.values().iterator();
        while (iter2.hasNext()) {
            mouse = (Mouse)iter2.next();
            ObjectExtractor.adjustKids(mouse, miceByOldID);
        }
        ObjectExtractor.adjustVisits(miceByOldID, cagesByOldID);
        ObjectExtractor.finalizeObjectBag(objectbag, groupname, newObjectsTarget);
    }

    public static void adjustKidInfos(Mouse mouse, Mouse[] kids) {
        int[] bdarr = new int[kids.length];
        int[] sxarr = new int[kids.length];
        long[] oparr = new long[kids.length];
        int i = 0;
        while (i < kids.length) {
            Mouse kid = kids[i];
            if (kid != null) {
                Date birthDate = kid.getDate("MOS_BIRTHDAY");
                if (birthDate == null) {
                    birthDate = kid.getDate("IDO_START_DATE");
                }
                bdarr[i] = birthDate != null ? MyDate.getTage(birthDate.getTime()) : Integer.MIN_VALUE;
                sxarr[i] = kid.getSex();
                long opVal = -3L;
                long kfid = kid.getLong("MOS_FATHER", -3L);
                long kmid = kid.getLong("MOS_MOTHER", -3L);
                long amid = mouse.getID();
                if (amid == kfid) {
                    opVal = kmid;
                } else if (amid == kmid) {
                    opVal = kfid;
                }
                oparr[i] = opVal;
            } else {
                bdarr[i] = Integer.MIN_VALUE;
                sxarr[i] = 0;
                oparr[i] = -3L;
            }
            ++i;
        }
        mouse.set("MOS_KID_BD", bdarr);
        mouse.set("MOS_KID_SX", sxarr);
        mouse.set("MOS_KID_OP", oparr);
    }

    public static IDObject manageImportTOServiceGroup(IDObject gruppenObject, Hashtable objectBag, Vector newObjectsTarget, CommandManagerExecutive cme) {
        IDObject serviceObject;
        block9: {
            serviceObject = null;
            if (gruppenObject != null && !gruppenObject.isSharedWithOtherGroups() && !"service".equals(gruppenObject.getGroup())) {
                try {
                    boolean docsMovedToService;
                    serviceObject = gruppenObject instanceof Line ? ObjectExtractor.manageImportTOServiceGroupLine((Line)gruppenObject, objectBag, newObjectsTarget, cme) : ObjectExtractor.manageImportTOServiceGroupNONLine(gruppenObject, objectBag, newObjectsTarget, cme);
                    if (serviceObject == null || (docsMovedToService = DocMoveManager.moveDocsFromGroupObjectToService(gruppenObject, (String)gruppenObject.get("IDO_DOK"), serviceObject))) break block9;
                    String string = "Problem while copying docs to Service from Object " + serviceObject;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("mausoleum.objectstore.ObjectExtractor");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error(string, null, clazz);
                    return null;
                }
                catch (Exception e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("mausoleum.objectstore.ObjectExtractor");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error("Problem while importing to service group", e, clazz);
                }
            }
        }
        return serviceObject;
    }

    public static IDObject manageExportFROMServiceGroup(IDObject serviceGroupObject, String targetGroup, Hashtable objectBag, Vector newObjectsTarget) {
        IDObject newObject = null;
        try {
            newObject = serviceGroupObject instanceof Line ? ObjectExtractor.manageExportFROMServiceGroupLine((Line)serviceGroupObject, targetGroup, objectBag, newObjectsTarget) : ObjectExtractor.manageExportFROMServiceGroupNONLine(serviceGroupObject, targetGroup, objectBag, newObjectsTarget);
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.objectstore.ObjectExtractor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Problem while exporting from service group", e, clazz);
        }
        return newObject;
    }

    private static IDObject manageImportTOServiceGroupNONLine(IDObject groupObject, Hashtable objectBag, Vector newObjectsTarget, CommandManagerExecutive cme) {
        IDObject serviceObject = null;
        Vector allObjectsInServiceGroup = ObjectStore.getActualObjects(groupObject.getTyp(), "service");
        if (allObjectsInServiceGroup != null) {
            Iterator iterator = allObjectsInServiceGroup.iterator();
            while (iterator.hasNext() && serviceObject == null) {
                IDObject tempServiceIDObject = (IDObject)iterator.next();
                if (!groupObject.isObjectIdenticalForGroupTransfer(tempServiceIDObject)) continue;
                IDObject alreadyConnectedGroupObject = tempServiceIDObject.getSubObjectForGroup(groupObject.getGroup(), objectBag);
                if (alreadyConnectedGroupObject != null && groupObject.getID() != alreadyConnectedGroupObject.getID()) {
                    cme.ivBugString = "There is already an identical " + (groupObject.isVisible() ? "" : "- inactivated - ") + "service object (" + groupObject.getName() + ") connected to the group. A sceond import is not possible!";
                    return null;
                }
                serviceObject = tempServiceIDObject;
                groupObject.mergeNecessAtrrsToServiceObject(serviceObject, objectBag);
            }
        }
        if (serviceObject == null) {
            serviceObject = groupObject.createServiceCopyOfGroupObject(objectBag, newObjectsTarget);
        } else {
            ObjectExtractor.mergeAttrsFromServiceToGroupObject(serviceObject, groupObject);
        }
        serviceObject.finalizeSubObject(groupObject, groupObject.getGroup());
        objectBag.put(groupObject.getIdentifierString(), groupObject);
        objectBag.put(serviceObject.getIdentifierString(), serviceObject);
        return serviceObject;
    }

    private static IDObject manageImportTOServiceGroupLine(Line groupLine, Hashtable objectBag, Vector newObjectsTarget, CommandManagerExecutive cme) {
        Hashtable groupLociByGroupID = ObjectExtractor.getSourceLoci(groupLine, objectBag);
        Hashtable<Long, Locus> serviceLociByGroupID = new Hashtable<Long, Locus>(groupLociByGroupID.size() * 2);
        Iterator iterator = groupLociByGroupID.keySet().iterator();
        while (iterator.hasNext()) {
            Long groupLocusID = (Long)iterator.next();
            Locus groupLocus = (Locus)groupLociByGroupID.get(groupLocusID);
            Locus serviceLocus = null;
            serviceLocus = groupLocus.isSharedWithOtherGroups() ? (Locus)groupLocus.getServiceGroupObject(objectBag) : (Locus)ObjectExtractor.manageImportTOServiceGroupNONLine(groupLocus, objectBag, newObjectsTarget, cme);
            if (serviceLocus == null) {
                String s = cme.ivBugString == null ? "" : String.valueOf(cme.ivBugString) + "\r\n";
                cme.ivBugString = s = String.valueOf(s) + "Locus " + groupLocus.getName() + " could not be transferred. Therefore the line transfer was cancelled!";
                return null;
            }
            serviceLociByGroupID.put(groupLocusID, serviceLocus);
        }
        Hashtable neededAllelesByTargetLocusID = ObjectExtractor.getNeededAllelesByTargetLocusID(groupLine, serviceLociByGroupID);
        Line alreadyPresentTargetLine = ObjectExtractor.getAlreadyPresentMatchingTargetLine(groupLine, "service", neededAllelesByTargetLocusID);
        Line alreadyConnectedGroupObject = (Line)alreadyPresentTargetLine.getSubObjectForGroup(groupLine.getGroup(), objectBag);
        if (alreadyConnectedGroupObject != null && groupLine.getID() != alreadyConnectedGroupObject.getID()) {
            cme.ivBugString = "There is already an identical " + (alreadyPresentTargetLine.isVisible() ? "" : "- inactivated - ") + "service object (" + alreadyPresentTargetLine.getName() + ") connected to the group. A sceond import is not possible!";
            return null;
        }
        Line serviceLine = ObjectExtractor.getTargetLineWhileConnectingToOrFromServiceGroup(groupLine, alreadyPresentTargetLine, "service", serviceLociByGroupID, objectBag, newObjectsTarget);
        groupLociByGroupID.clear();
        groupLociByGroupID = null;
        serviceLociByGroupID.clear();
        serviceLociByGroupID = null;
        neededAllelesByTargetLocusID.clear();
        neededAllelesByTargetLocusID = null;
        return serviceLine;
    }

    private static Hashtable getNeededAllelesByTargetLocusID(Line sourceLine, Hashtable targetLociBySourceID) {
        Hashtable neededAllelesBySourceLocusID = new Hashtable();
        sourceLine.collectYourData(neededAllelesBySourceLocusID);
        Hashtable neededAllelesByTargetLocusID = new Hashtable(neededAllelesBySourceLocusID.size());
        Iterator iterator = neededAllelesBySourceLocusID.keySet().iterator();
        while (iterator.hasNext()) {
            Long sourceID = (Long)iterator.next();
            Locus targetLocus = (Locus)targetLociBySourceID.get(sourceID);
            if (targetLocus == null) continue;
            neededAllelesByTargetLocusID.put(targetLocus.getLongID(), neededAllelesBySourceLocusID.get(sourceID));
        }
        neededAllelesBySourceLocusID.clear();
        neededAllelesBySourceLocusID = null;
        return neededAllelesByTargetLocusID;
    }

    private static Line getAlreadyPresentMatchingTargetLine(Line sourceLine, String targetGroup, Hashtable neededAllelesByTargetLocusID) {
        String sourceLineName = sourceLine.getString("LIN_NAME", "");
        Line targetLine = null;
        Vector allObjectsInTargetGroup = ObjectStore.getActualObjects(7, targetGroup);
        if (allObjectsInTargetGroup != null) {
            Iterator iterator = allObjectsInTargetGroup.iterator();
            while (iterator.hasNext() && targetLine == null) {
                Line lineInTargetGroup = (Line)iterator.next();
                if (!sourceLineName.equals(lineInTargetGroup.getString("LIN_NAME", "")) || !lineInTargetGroup.doYouMatch(neededAllelesByTargetLocusID)) continue;
                targetLine = lineInTargetGroup;
            }
        }
        return targetLine;
    }

    private static Line getTargetLineWhileConnectingToOrFromServiceGroup(Line sourceLine, Line alreadyPresentTargetLine, String targetGroup, Hashtable targetLociBySourceID, Hashtable objectBag, Vector newObjectsTarget) {
        Line targetLine = alreadyPresentTargetLine;
        if (targetLine == null) {
            targetLine = "service".equals(targetGroup) ? (Line)sourceLine.createServiceCopyOfGroupObject(objectBag, newObjectsTarget) : (Line)sourceLine.createSharedCopyOfServiceObject(targetGroup, objectBag, newObjectsTarget);
            ObjectExtractor.adjustLineInformations(targetLine, targetLociBySourceID);
        } else {
            ObjectExtractor.mergeAttrsFromServiceToGroupObject(sourceLine, targetLine);
        }
        if ("service".equals(targetGroup)) {
            targetLine.finalizeSubObject(sourceLine, sourceLine.getGroup());
        } else {
            sourceLine.finalizeSubObject(targetLine, targetLine.getGroup());
        }
        objectBag.put(sourceLine.getIdentifierString(), sourceLine);
        objectBag.put(targetLine.getIdentifierString(), targetLine);
        return targetLine;
    }

    private static Hashtable getSourceLoci(Line sourceLine, Hashtable objectBag) {
        Hashtable<Long, Locus> lociByOldID = new Hashtable<Long, Locus>(10);
        LocusAndAlleles[] lalarr = (LocusAndAlleles[])sourceLine.get("LIN_LOCIALLELES");
        if (lalarr != null) {
            int i = 0;
            while (i < lalarr.length) {
                Locus locus = (Locus)ObjectStore.getObjectDeadOrAlive(14, lalarr[i].ivLocusID, sourceLine.getGroup(), objectBag, false);
                if (locus != null) {
                    lociByOldID.put(locus.getLongID(), locus);
                }
                ++i;
            }
        }
        return lociByOldID;
    }

    private static void mergeAttrsFromServiceToGroupObject(IDObject ido1, IDObject ido2) {
        if (ido1 != null && ido2 != null) {
            String[] attrs;
            IDObject serviceObject = null;
            IDObject groupObject = null;
            String group1 = ido1.getGroup();
            String group2 = ido2.getGroup();
            if (group1 != null && group2 != null && !group1.equals(group2)) {
                if (group1.equals("service")) {
                    serviceObject = ido1;
                    groupObject = ido2;
                } else if (group2.equals("service")) {
                    serviceObject = ido2;
                    groupObject = ido1;
                }
            }
            if (serviceObject != null && groupObject != null && (attrs = serviceObject.getMergeAttributesFromServiceToExistingGroupObject()) != null) {
                int i = 0;
                while (i < attrs.length) {
                    groupObject.set(attrs[i], serviceObject.get(attrs[i]));
                    ++i;
                }
            }
        }
    }

    private static IDObject manageExportFROMServiceGroupLine(Line serviceLine, String targetGroup, Hashtable objectBag, Vector newObjectsTarget) {
        Hashtable serviceLociByServiceID = ObjectExtractor.getSourceLoci(serviceLine, objectBag);
        Hashtable<Long, IDObject> groupLociByServiceID = new Hashtable<Long, IDObject>(serviceLociByServiceID.size() * 2);
        Iterator iterator = serviceLociByServiceID.keySet().iterator();
        while (iterator.hasNext()) {
            Long locusServideID = (Long)iterator.next();
            Locus serviceLocus = (Locus)serviceLociByServiceID.get(locusServideID);
            groupLociByServiceID.put(locusServideID, ObjectExtractor.manageExportFROMServiceGroupNONLine(serviceLocus, targetGroup, objectBag, newObjectsTarget));
        }
        Hashtable neededAllelesByTargetLocusID = ObjectExtractor.getNeededAllelesByTargetLocusID(serviceLine, groupLociByServiceID);
        Line alreadyPresentTargetLine = ObjectExtractor.getAlreadyPresentMatchingTargetLine(serviceLine, targetGroup, neededAllelesByTargetLocusID);
        Line groupLine = ObjectExtractor.getTargetLineWhileConnectingToOrFromServiceGroup(serviceLine, alreadyPresentTargetLine, targetGroup, groupLociByServiceID, objectBag, newObjectsTarget);
        serviceLociByServiceID.clear();
        serviceLociByServiceID = null;
        groupLociByServiceID.clear();
        groupLociByServiceID = null;
        neededAllelesByTargetLocusID.clear();
        neededAllelesByTargetLocusID = null;
        return groupLine;
    }

    private static IDObject manageExportFROMServiceGroupNONLine(IDObject serviceObject, String targetGroup, Hashtable objectBag, Vector newObjectsTarget) {
        IDObject groupObject = null;
        Vector allObjectsInTargetGroup = ObjectStore.getActualObjects(serviceObject.getTyp(), targetGroup);
        if (allObjectsInTargetGroup != null) {
            IDObject ido;
            Long serviceObjectID = serviceObject.getLongID();
            Iterator iterator = allObjectsInTargetGroup.iterator();
            while (iterator.hasNext() && groupObject == null) {
                ido = (IDObject)iterator.next();
                if (!serviceObjectID.equals(ido.get("IDO_SERVID"))) continue;
                return ido;
            }
            iterator = allObjectsInTargetGroup.iterator();
            while (iterator.hasNext() && groupObject == null) {
                ido = (IDObject)iterator.next();
                if (ido.isSharedWithOtherGroups() || !serviceObject.isObjectIdenticalForGroupTransfer(ido)) continue;
                groupObject = ido;
                DocMoveManager.moveDocsFromGroupObjectToService(groupObject, groupObject.getString("IDO_DOK", null), serviceObject);
                groupObject.mergeNecessAtrrsToServiceObject(serviceObject, objectBag);
            }
        }
        if (groupObject != null) {
            serviceObject.finalizeSubObject(groupObject, targetGroup);
            ObjectExtractor.mergeAttrsFromServiceToGroupObject(serviceObject, groupObject);
        } else {
            groupObject = serviceObject.createSharedCopyOfServiceObject(targetGroup, objectBag, newObjectsTarget);
            groupObject.set("IDO_DOK", serviceObject.get("IDO_DOK"));
        }
        objectBag.put(groupObject.getIdentifierString(), groupObject);
        return groupObject;
    }

    private static void finalizeObjectBag(Hashtable objectbag, String targetGroupname, Vector newObjects) {
        Enumeration en = objectbag.elements();
        while (en.hasMoreElements()) {
            IDObject idobject = (IDObject)en.nextElement();
            if (newObjects != null && !newObjects.contains(idobject)) continue;
            if (idobject.get("IDO_GROUP") == null) {
                idobject.set("IDO_GROUP", targetGroupname);
            }
            idobject.commit(true);
            Enumeration pen = idobject.ivProperties.keys();
            while (pen.hasMoreElements()) {
                String key = (String)pen.nextElement();
                idobject.set(key, idobject.get(key));
            }
            idobject.set("IDO_GROUP", idobject.getGroup());
        }
    }

    private static boolean isSameServer(String xmlString) {
        int ind;
        String myFingerprint;
        if (xmlString != null && (myFingerprint = ServerPortal.getFingerprint()) != null && (ind = xmlString.indexOf(FINGERPRINT_TAG)) != -1) {
            ind += FINGERPRINT_TAG.length();
            int ind2 = xmlString.indexOf("/>");
            if (ind2 != -1) {
                String anderer = xmlString.substring(ind, ind2).trim();
                return myFingerprint.equals(anderer);
            }
        }
        return false;
    }

    private static void adjustLineAndGenotype(Mouse mouse, Hashtable linesByOldID, Hashtable lociByOldID) {
        Long oldLineID = (Long)mouse.get("MOS_LINEID");
        if (oldLineID == null) {
            mouse.set("MOS_LOCUSGENOTYPES", null);
        } else if (oldLineID < 0L) {
            mouse.set("MOS_LINEID", new Long(-oldLineID.longValue()));
            mouse.set("MOS_LOCUSGENOTYPES", null);
        } else {
            Line line = (Line)linesByOldID.get(oldLineID);
            if (line == null) {
                mouse.set("MOS_LINEID", null);
                mouse.set("MOS_LOCUSGENOTYPES", null);
            } else {
                LocusAndAlleles[] genotypes;
                mouse.set("MOS_LINEID", line.getLongID());
                if (line != null) {
                    mouse.set("MOS_LINLICID", line.get("LIN_LIC"));
                }
                if ((genotypes = (LocusAndAlleles[])mouse.get("MOS_LOCUSGENOTYPES")) != null) {
                    LocusAndAlleles[] newGenotypes = new LocusAndAlleles[genotypes.length];
                    int gt = 0;
                    while (gt < genotypes.length) {
                        LocusAndAlleles genotype = genotypes[gt];
                        Locus locus = (Locus)lociByOldID.get(new Long(genotype.ivLocusID));
                        genotype.ivLocusID = locus.getID();
                        newGenotypes[gt] = genotype;
                        ++gt;
                    }
                    mouse.set("MOS_LOCUSGENOTYPES", newGenotypes);
                }
            }
        }
    }

    private static void adjustStrains(Mouse mouse, Hashtable strainsByOldID) {
        IndexObject[] strains = (IndexObject[])mouse.get("MOS_STRAIN");
        if (strains != null) {
            Vector<IndexObject> foundStrains = new Vector<IndexObject>();
            int li = 0;
            while (li < strains.length) {
                long oid = strains[li].ivObjectID;
                Strain tns = (Strain)strainsByOldID.get(new Long(oid));
                if (tns != null) {
                    strains[li].ivObjectID = tns.getID();
                    foundStrains.addElement(strains[li]);
                } else {
                    String string = "ExtractHelper [3] Strain fehlt " + oid + "  " + strainsByOldID;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("mausoleum.objectstore.ObjectExtractor");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error(string, null, clazz);
                }
                ++li;
            }
            if (foundStrains.isEmpty()) {
                mouse.set("MOS_STRAIN", null);
            } else {
                IndexObject[] newstrains = new IndexObject[foundStrains.size()];
                int li2 = 0;
                while (li2 < foundStrains.size()) {
                    newstrains[li2] = (IndexObject)foundStrains.elementAt(li2);
                    ++li2;
                }
                mouse.set("MOS_STRAIN", newstrains);
            }
        }
    }

    private static void adjustOwners(Mouse mouse, Hashtable usersByOldID) {
        long[] owners = (long[])mouse.get("MOS_OWNER");
        if (owners != null) {
            Vector<User> foundOwners = new Vector<User>();
            int li = 0;
            while (li < owners.length) {
                long oid = owners[li];
                User tns = (User)usersByOldID.get(new Long(oid));
                if (tns != null) {
                    foundOwners.addElement(tns);
                } else {
                    String string = "ExtractHelper [3] User fehlt " + oid + "  " + usersByOldID;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("mausoleum.objectstore.ObjectExtractor");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error(string, null, clazz);
                }
                ++li;
            }
            if (foundOwners.isEmpty()) {
                mouse.set("MOS_OWNER", null);
            } else {
                long[] newOwners = new long[foundOwners.size()];
                int li2 = 0;
                while (li2 < foundOwners.size()) {
                    User tuser = (User)foundOwners.elementAt(li2);
                    newOwners[li2] = tuser.getID();
                    ++li2;
                }
                mouse.set("MOS_OWNER", newOwners);
            }
        }
    }

    private static void adjustParents(Mouse mouse, Hashtable miceByOldID, String tag) {
        Long motherID = (Long)mouse.get(tag);
        if (motherID != null) {
            Mouse mother = (Mouse)miceByOldID.get(motherID);
            if (mother != null) {
                mouse.set(tag, mother.get("IDO_ID"));
                mother.set("MOS_KID", ArrayHelper.addLongToArraySingulaer((long[])mother.get("MOS_KID"), mouse.getID()));
            } else {
                mouse.set(tag, null);
            }
        }
    }

    private static void adjustKids(Mouse mouse, Hashtable miceByOldID) {
        long[] kidIDs = (long[])mouse.get("MOS_KID");
        if (kidIDs != null) {
            Mouse[] kids = new Mouse[kidIDs.length];
            int i = 0;
            while (i < kidIDs.length) {
                kids[i] = (Mouse)miceByOldID.get(new Long(kidIDs[i]));
                ++i;
            }
            ObjectExtractor.adjustKidInfos(mouse, kids);
        }
    }

    private static void adjustVisits(Hashtable miceByOldID, Hashtable cagesByOldID) {
        int i;
        Visit[] arr;
        Iterator iter = miceByOldID.values().iterator();
        while (iter.hasNext()) {
            Mouse mouse = (Mouse)iter.next();
            arr = (Visit[])mouse.get("MOS_VISIT");
            if (arr == null) continue;
            i = 0;
            while (i < arr.length) {
                arr[i].ivMouseID = mouse.getID();
                Cage cage = (Cage)cagesByOldID.get(new Long(arr[i].ivCageID));
                if (cage != null) {
                    arr[i].ivCageID = cage.getID();
                }
                ++i;
            }
        }
        iter = cagesByOldID.values().iterator();
        while (iter.hasNext()) {
            Cage cage = (Cage)iter.next();
            arr = (Visit[])cage.get("CAG_VISIT");
            if (arr == null) continue;
            i = 0;
            while (i < arr.length) {
                arr[i].ivCageID = cage.getID();
                Mouse mouse = (Mouse)miceByOldID.get(new Long(arr[i].ivMouseID));
                if (mouse != null) {
                    arr[i].ivMouseID = mouse.getID();
                }
                ++i;
            }
        }
    }

    private static void findeIdentischeObjekte(Hashtable objectsByOldID, String targetGroupName, int objectType, Hashtable objectBag, Vector newObjectsTarget) {
        if (!objectsByOldID.isEmpty()) {
            Long oldID;
            Vector allObjects = ObjectStore.getActualObjects(objectType, targetGroupName);
            HashMap<Long, IDObject> identicalsByID = new HashMap<Long, IDObject>(objectsByOldID);
            Iterator iterator = objectsByOldID.keySet().iterator();
            while (iterator.hasNext()) {
                oldID = (Long)iterator.next();
                IDObject extractedObject = (IDObject)objectsByOldID.get(oldID);
                IDObject existingIdenticalObject = ObjectExtractor.findAnIdenticalObjectForGroupTransfer(extractedObject, allObjects, objectBag);
                if (existingIdenticalObject != null) {
                    identicalsByID.put(oldID, existingIdenticalObject);
                    objectBag.put(existingIdenticalObject.getIdentifierString(), existingIdenticalObject);
                    continue;
                }
                extractedObject.set("IDO_GROUP", targetGroupName);
                if (!DataLayer.cvDataLayer.provideNewIDToIDObject(extractedObject)) {
                    String string = "ExtractHelper 1 : Problem bei ExtractHelper provideNewIDToIDObject " + extractedObject;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("mausoleum.objectstore.ObjectExtractor");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.warn(string, null, clazz);
                    continue;
                }
                Long extServiceID = (Long)extractedObject.get("IDO_SERVID");
                if (extServiceID != null) {
                    if (extractedObject instanceof Line) {
                        ObjectExtractor.transmitFromServiceObjectLineSpecial((Line)extractedObject, extServiceID, objectBag);
                    } else {
                        ObjectExtractor.transmitFromServiceObject(objectType, extServiceID, extractedObject, objectBag);
                    }
                }
                extractedObject.commit(true);
                newObjectsTarget.addElement(extractedObject);
                objectBag.put(extractedObject.getIdentifierString(), extractedObject);
            }
            if (!identicalsByID.isEmpty()) {
                iterator = identicalsByID.keySet().iterator();
                while (iterator.hasNext()) {
                    oldID = (Long)iterator.next();
                    objectsByOldID.put(oldID, identicalsByID.get(oldID));
                }
            }
        }
    }

    private static IDObject findAnIdenticalObjectForGroupTransfer(IDObject externalObject, Vector objectsInTargetGroup, Hashtable objectBag) {
        Long extServiceID = (Long)externalObject.get("IDO_SERVID");
        if (extServiceID != null) {
            Iterator iterator = objectsInTargetGroup.iterator();
            while (iterator.hasNext()) {
                IDObject idObject = (IDObject)iterator.next();
                if (!extServiceID.equals(idObject.get("IDO_SERVID"))) continue;
                return idObject;
            }
            IDObject foundObject = ObjectExtractor.findIdenticalObject(externalObject, objectsInTargetGroup, false);
            if (foundObject != null) {
                if (foundObject instanceof Line) {
                    ObjectExtractor.transmitFromServiceObjectLineSpecial((Line)foundObject, extServiceID, objectBag);
                } else {
                    ObjectExtractor.transmitFromServiceObject(foundObject.getTyp(), extServiceID, foundObject, objectBag);
                }
            }
            return foundObject;
        }
        return ObjectExtractor.findIdenticalObject(externalObject, objectsInTargetGroup, true);
    }

    private static IDObject findIdenticalObject(IDObject externalObject, Vector objectsInTargetGroup, boolean serviceIDcanBeSet) {
        IDObject foundObject = null;
        if (externalObject instanceof Line) {
            long lowestID = Long.MAX_VALUE;
            Line extLine = (Line)externalObject;
            if (extLine.isBreeder()) {
                Iterator iterator = objectsInTargetGroup.iterator();
                while (iterator.hasNext()) {
                    long id;
                    Line tline;
                    IDObject ido = (IDObject)iterator.next();
                    if (!(ido instanceof Line) || !(tline = (Line)ido).isBreeder() || (id = tline.getID()) >= lowestID) continue;
                    lowestID = id;
                    foundObject = tline;
                }
                if (foundObject != null) {
                    return foundObject;
                }
            }
        }
        Vector<IDObject> sammler = new Vector<IDObject>();
        Iterator iterator = objectsInTargetGroup.iterator();
        while (iterator.hasNext() && foundObject == null) {
            IDObject ido = (IDObject)iterator.next();
            if (!serviceIDcanBeSet && ido.get("IDO_SERVID") != null || !externalObject.isObjectIdenticalForGroupTransfer(ido)) continue;
            sammler.add(ido);
        }
        if (!sammler.isEmpty()) {
            if (sammler.size() != 1) {
                String extName = externalObject.getBrowseNameWITHOUTServicePrefix();
                Iterator iterator2 = sammler.iterator();
                while (iterator2.hasNext() && foundObject == null) {
                    IDObject ido = (IDObject)iterator2.next();
                    if (!extName.equalsIgnoreCase(ido.getBrowseNameWITHOUTServicePrefix())) continue;
                    foundObject = ido;
                }
            }
            if (foundObject == null) {
                foundObject = (IDObject)sammler.firstElement();
            }
        }
        sammler.clear();
        sammler = null;
        return foundObject;
    }

    private static void transmitFromServiceObjectLineSpecial(Line extractedObject, Long extServiceID, Hashtable objectbag) {
        Object merkLociAlleles = extractedObject.get("LIN_LOCIALLELES");
        Object merkStressRules = extractedObject.get("LIN_STRRUL");
        ObjectExtractor.transmitFromServiceObject(7, extServiceID, extractedObject, objectbag);
        extractedObject.set("LIN_LOCIALLELES", merkLociAlleles);
        extractedObject.set("LIN_STRRUL", merkStressRules);
    }

    private static void transmitFromServiceObject(int typ, long serviceID, IDObject groupObject, Hashtable objectbag) {
        IDObject serviceObject = ObjectStore.getObjectDeadOrAlive(typ, serviceID, "service", objectbag, false);
        if (serviceObject != null) {
            serviceObject.copyAttributesForSubObject(groupObject);
            serviceObject.finalizeSubObject(groupObject, groupObject.getGroup());
            objectbag.put(serviceObject.getIdentifierString(), serviceObject);
            objectbag.put(groupObject.getIdentifierString(), groupObject);
        }
    }

    private static void adjustLineInformations(Hashtable linesByOldID, Hashtable lociByOldID) {
        if (!linesByOldID.isEmpty()) {
            Enumeration lineEN = linesByOldID.elements();
            while (lineEN.hasMoreElements()) {
                ObjectExtractor.adjustLineInformations((Line)lineEN.nextElement(), lociByOldID);
            }
        }
    }

    private static void adjustLineInformations(Line line, Hashtable targetLociBySourceLocusID) {
        if (line != null) {
            StressRule[] sourceStressRuleArray;
            LocusAndAlleles[] sourceLALArr = (LocusAndAlleles[])line.get("LIN_LOCIALLELES");
            if (sourceLALArr != null) {
                LocusAndAlleles[] targetLALArr = new LocusAndAlleles[sourceLALArr.length];
                int i = 0;
                while (i < sourceLALArr.length) {
                    LocusAndAlleles sourceLaL = sourceLALArr[i];
                    LocusAndAlleles targetLaL = new LocusAndAlleles();
                    Long oldID = new Long(sourceLaL.ivLocusID);
                    Locus targetLocus = (Locus)targetLociBySourceLocusID.get(oldID);
                    targetLaL.ivLocusID = targetLocus.getID();
                    targetLaL.ivAllele = ArrayHelper.getCopy(sourceLaL.ivAllele);
                    targetLALArr[i] = targetLaL;
                    ++i;
                }
                line.set("LIN_LOCIALLELES", targetLALArr);
            }
            if ((sourceStressRuleArray = (StressRule[])line.get("LIN_STRRUL")) != null) {
                HashMap<Long, Long> targetLocusIDsBySourceLocusID = new HashMap<Long, Long>();
                Iterator iterator = targetLociBySourceLocusID.keySet().iterator();
                while (iterator.hasNext()) {
                    Long sourceLocusID = (Long)iterator.next();
                    Locus targetLocus = (Locus)targetLociBySourceLocusID.get(sourceLocusID);
                    targetLocusIDsBySourceLocusID.put(sourceLocusID, targetLocus.getLongID());
                }
                StressRule[] targetStressRuleArray = new StressRule[sourceStressRuleArray.length];
                int i = 0;
                while (i < sourceStressRuleArray.length) {
                    StressRule sourceSR = sourceStressRuleArray[i];
                    targetStressRuleArray[i] = StressRule.getCopyFromOtherGroup(sourceSR, targetLocusIDsBySourceLocusID, line.getGroup());
                    ++i;
                }
                line.set("LIN_STRRUL", targetStressRuleArray);
                targetLocusIDsBySourceLocusID.clear();
                targetLocusIDsBySourceLocusID = null;
            }
        }
    }

    private static void fillObjectsFromExportString(String groupname, String xmlString, Vector mice, Hashtable lociByOldID, Hashtable linesByOldID, Hashtable strainsByOldID, boolean isSameServer) {
        Vector<String> objectXMLs = new Vector<String>();
        int lastFound = 0;
        int ind = xmlString.indexOf("<I", lastFound);
        while (ind != -1) {
            String objectXML = xmlString.substring(lastFound, ind).trim();
            if (objectXML.length() != 0 && objectXML.startsWith("<I")) {
                objectXMLs.addElement(objectXML);
            }
            lastFound = ind;
            ind = xmlString.indexOf("<I", lastFound + 1);
        }
        objectXMLs.addElement(xmlString.substring(lastFound, xmlString.length()));
        Iterator iterator = objectXMLs.iterator();
        while (iterator.hasNext()) {
            String objXML = (String)iterator.next();
            try {
                IDObject idObject = IDObjectXMLHandler.initSimpleObjectFromXMLString(objXML, groupname, true);
                if (idObject == null) continue;
                if (!isSameServer) {
                    idObject.set("IDO_SERVID", null);
                }
                idObject.set("IDO_GROUP", groupname);
                idObject.commit(true);
                if (idObject instanceof Mouse) {
                    mice.addElement(idObject);
                    continue;
                }
                if (idObject instanceof Locus) {
                    lociByOldID.put(idObject.get("IDO_ID"), idObject);
                    continue;
                }
                if (idObject instanceof Line) {
                    linesByOldID.put(idObject.get("IDO_ID"), idObject);
                    continue;
                }
                if (!(idObject instanceof Strain)) continue;
                strainsByOldID.put(idObject.get("IDO_ID"), idObject);
            }
            catch (Throwable e) {
                String string = "Could not extract IDObject from XML: " + objXML;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("mausoleum.objectstore.ObjectExtractor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
    }

    private static void showInterestingObjects(Hashtable objectsByID, String prefix, IDObject interestingObject) {
        StringBuilder msb = new StringBuilder();
        msb.append(prefix).append("\n");
        if (objectsByID != null) {
            Iterator iterator = objectsByID.keySet().iterator();
            while (iterator.hasNext()) {
                Long id = (Long)iterator.next();
                ObjectExtractor.showInterestingObject((IDObject)objectsByID.get(id), id, msb);
            }
        }
        if (interestingObject != null) {
            ObjectExtractor.showInterestingObject(interestingObject, interestingObject.getLongID(), msb);
        }
        String string = msb.toString();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.objectstore.ObjectExtractor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.debug(string, clazz);
    }

    private static void showInterestingObject(IDObject ido, Long id, StringBuilder msb) {
        if (ido != null) {
            msb.append("KEY-ID: ").append(id).append(" ObjectID: ").append(ido.getID()).append(" Service ID: ").append(ido.get("IDO_SERVID")).append("\n");
            msb.append("    group: ").append(ido.getGroup()).append("\n");
            if (ido instanceof Line) {
                Line line = (Line)ido;
                msb.append("    Allele: ").append(LocusAndAlleles.toString((LocusAndAlleles[])line.get("LIN_LOCIALLELES"))).append("\n");
                msb.append("    StressRules: ").append(StressRule.toString((StressRule[])line.get("LIN_STRRUL"))).append("\n");
            } else if (ido instanceof Locus) {
                Locus locus = (Locus)ido;
                String[] allele = (String[])locus.get("LOC_ALLELES");
                if (allele != null && allele.length != 0) {
                    msb.append("    Allele: ").append(ArrayHelper.createVector(allele)).append("\n");
                }
            } else if (ido instanceof Mouse) {
                Mouse mouse = (Mouse)ido;
                msb.append("    Line ID: ").append(mouse.get("MOS_LINEID")).append("\n");
                msb.append("    Genotype: ").append(LocusAndAlleles.toString((LocusAndAlleles[])mouse.get("MOS_LOCUSGENOTYPES"))).append("\n");
            }
        }
    }
}

