/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.print.PageFormat;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import mausoleum.gui.MGButton;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.FontManager;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.inspector.InspectorMainPanel;
import mausoleum.printing.MausoleumPrinter;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.ui.UIDef;

public class PreviewFrame
extends JFrame {
    private static final long serialVersionUID = 11681351353L;
    private static final Vector OPEN_FRAMES = new Vector();
    private static final Vector FRAMES_TO_SHOW = new Vector();
    static /* synthetic */ Class class$0;

    public static void closeOpenFrames() {
        Vector v = new Vector(OPEN_FRAMES);
        Iterator iterator = v.iterator();
        while (iterator.hasNext()) {
            PreviewFrame mdf = (PreviewFrame)iterator.next();
            if (mdf.isVisible()) {
                mdf.setVisible(false);
            }
            mdf.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showPreviewFrame(MausoleumPrinter mp) {
        MausoleumPrinterPreviewPanel mppp = new MausoleumPrinterPreviewPanel(mp);
        PreviewFrame pf = new PreviewFrame(mppp);
        Vector vector = FRAMES_TO_SHOW;
        synchronized (vector) {
            FRAMES_TO_SHOW.add(mppp);
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (!FRAMES_TO_SHOW.isEmpty()) {
                    MausoleumPrinterPreviewPanel mppp = null;
                    Vector vector = FRAMES_TO_SHOW;
                    synchronized (vector) {
                        mppp = (MausoleumPrinterPreviewPanel)FRAMES_TO_SHOW.firstElement();
                        FRAMES_TO_SHOW.remove(0);
                    }
                    if (mppp != null) {
                        JFrame jf = WindowUtils.getJFrame(mppp);
                        int ww = 0;
                        int wh = 0;
                        jf.pack();
                        Insets inni = jf.getInsets();
                        MausoleumPrinter tp = mppp.ivPrinter;
                        PageFormat pform = tp.ivPageFormat;
                        if (tp.isRotated()) {
                            ww = inni.left + inni.right + (int)pform.getHeight() + 2 * UIDef.RAND + UIDef.RAND;
                            wh = inni.top + inni.bottom + (int)pform.getWidth() + 3 * UIDef.RAND + UIDef.BUT_HEIGHT + UIDef.RAND;
                        } else {
                            ww = inni.left + inni.right + (int)pform.getWidth() + 2 * UIDef.RAND + UIDef.RAND;
                            wh = inni.top + inni.bottom + (int)pform.getHeight() + 3 * UIDef.RAND + UIDef.BUT_HEIGHT + UIDef.RAND;
                        }
                        OPEN_FRAMES.add(jf);
                        WindowUtils.setSizeAndCenterOnScreen(jf, ww, wh);
                        WindowUtils.bringUpFrame(jf);
                    }
                }
            }
        });
    }

    private PreviewFrame(MausoleumPrinterPreviewPanel mppp) {
        this.setIconImage(MausoleumImageStore.getLogo());
        this.getContentPane().add(mppp);
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            OPEN_FRAMES.remove(this);
        }
        super.setVisible(visible);
    }

    public static class MausoleumPrinterPreviewPanel
    extends InspectorMainPanel
    implements ActionListener {
        private static final long serialVersionUID = 1123234235L;
        private final JComponent ivComponent;
        private final JScrollPane ivScrollpane;
        private final MGButton ivFirstButton;
        private final MGButton ivPrevButton;
        private final MGButton ivNextButton;
        private final MGButton ivLastButton;
        private final MGButton ivPrintButton;
        private MausoleumPrinter ivPrinter;
        private int ivAnzPages;
        private int ivAktPage = 0;
        private double ivFaktor = 1.0;
        private boolean ivFullMatch = false;
        private boolean ivDrawFrame = false;

        public MausoleumPrinterPreviewPanel(MausoleumPrinter tp) {
            super.setLayout(new SimpleLayoutManager(this){
                final /* synthetic */ MausoleumPrinterPreviewPanel this$1;
                {
                    this.this$1 = mausoleumPrinterPreviewPanel;
                }

                public void layoutContainer(Container c) {
                    Dimension d = c.getSize();
                    int width = d.width;
                    int height = d.height;
                    int innerwidth = width - 2 * UIDef.RAND;
                    int innerheight = height - 2 * UIDef.RAND;
                    int obenheight = innerheight - UIDef.RAND - UIDef.BUT_HEIGHT;
                    MausoleumPrinterPreviewPanel.access$0(this.this$1).setBounds(UIDef.RAND, UIDef.RAND, innerwidth, obenheight);
                    int uy = 2 * UIDef.RAND + obenheight;
                    if (MausoleumPrinterPreviewPanel.access$1(this.this$1) > 1) {
                        int butw = (innerwidth - 4 * UIDef.INNER_RAND) / 5;
                        int lbutw = innerwidth - 4 * UIDef.INNER_RAND - 4 * butw;
                        int ux = UIDef.RAND;
                        MausoleumPrinterPreviewPanel.access$2(this.this$1).setBounds(ux, uy, butw, UIDef.BUT_HEIGHT);
                        MausoleumPrinterPreviewPanel.access$3(this.this$1).setBounds(ux += butw + UIDef.INNER_RAND, uy, butw, UIDef.BUT_HEIGHT);
                        MausoleumPrinterPreviewPanel.access$4(this.this$1).setBounds(ux += butw + UIDef.INNER_RAND, uy, butw, UIDef.BUT_HEIGHT);
                        MausoleumPrinterPreviewPanel.access$5(this.this$1).setBounds(ux += butw + UIDef.INNER_RAND, uy, butw, UIDef.BUT_HEIGHT);
                        MausoleumPrinterPreviewPanel.access$6(this.this$1).setBounds(ux += butw + UIDef.INNER_RAND, uy, lbutw, UIDef.BUT_HEIGHT);
                        ux += butw + UIDef.INNER_RAND;
                    } else {
                        MausoleumPrinterPreviewPanel.access$6(this.this$1).setBounds(UIDef.RAND, uy, innerwidth, UIDef.BUT_HEIGHT);
                        if (MausoleumPrinterPreviewPanel.access$2(this.this$1) != null) {
                            MausoleumPrinterPreviewPanel.access$2(this.this$1).setBounds(0, 0, 0, 0);
                            MausoleumPrinterPreviewPanel.access$3(this.this$1).setBounds(0, 0, 0, 0);
                            MausoleumPrinterPreviewPanel.access$4(this.this$1).setBounds(0, 0, 0, 0);
                            MausoleumPrinterPreviewPanel.access$5(this.this$1).setBounds(0, 0, 0, 0);
                        }
                    }
                }
            });
            this.ivPrinter = tp;
            this.ivAnzPages = tp != null ? tp.getNumberOfPages() : -1;
            this.ivComponent = new JComponent(this){
                private static final long serialVersionUID = 145L;
                final /* synthetic */ MausoleumPrinterPreviewPanel this$1;
                {
                    this.this$1 = mausoleumPrinterPreviewPanel;
                }

                public Dimension getPreferredSize() {
                    if (MausoleumPrinterPreviewPanel.access$7(this.this$1) == null) {
                        return UIDef.MINI_DIM;
                    }
                    PageFormat pf = MausoleumPrinterPreviewPanel.access$7((MausoleumPrinterPreviewPanel)this.this$1).ivPageFormat;
                    if (MausoleumPrinterPreviewPanel.access$7(this.this$1).isRotated()) {
                        return new Dimension((int)(pf.getHeight() * MausoleumPrinterPreviewPanel.access$8(this.this$1)), (int)(pf.getWidth() * MausoleumPrinterPreviewPanel.access$8(this.this$1)));
                    }
                    return new Dimension((int)(pf.getWidth() * MausoleumPrinterPreviewPanel.access$8(this.this$1)), (int)(pf.getHeight() * MausoleumPrinterPreviewPanel.access$8(this.this$1)));
                }

                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }

                public void paint(Graphics g) {
                    if (MausoleumPrinterPreviewPanel.access$7(this.this$1) == null) {
                        return;
                    }
                    Graphics2D g2d = (Graphics2D)g;
                    if (MausoleumPrinterPreviewPanel.access$8(this.this$1) != 1.0) {
                        g2d.scale(MausoleumPrinterPreviewPanel.access$8(this.this$1), MausoleumPrinterPreviewPanel.access$8(this.this$1));
                    }
                    PageFormat pf = MausoleumPrinterPreviewPanel.access$7((MausoleumPrinterPreviewPanel)this.this$1).ivPageFormat;
                    int dw = MausoleumPrinterPreviewPanel.access$7(this.this$1).isRotated() ? (int)pf.getHeight() : (int)pf.getWidth();
                    int dh = MausoleumPrinterPreviewPanel.access$7(this.this$1).isRotated() ? (int)pf.getWidth() : (int)pf.getHeight();
                    int ox = 0;
                    int oy = 0;
                    if (MausoleumPrinterPreviewPanel.access$9(this.this$1)) {
                        Dimension d = this.getSize();
                        ox = ((int)((double)d.width / MausoleumPrinterPreviewPanel.access$8(this.this$1)) - dw) / 2;
                        oy = ((int)((double)d.height / MausoleumPrinterPreviewPanel.access$8(this.this$1)) - dh) / 2;
                    }
                    if (ox != 0 || oy != 0) {
                        g.translate(ox, oy);
                    }
                    g.setColor(Color.white);
                    g.fillRect(0, 0, dw, dh);
                    if (MausoleumPrinterPreviewPanel.access$7(this.this$1).isRotated()) {
                        if (MausoleumPrinterPreviewPanel.access$7(this.this$1) instanceof LabelPrinter) {
                            LabelPrinter lp = (LabelPrinter)MausoleumPrinterPreviewPanel.access$7(this.this$1);
                            lp.rotateBack(g2d);
                            lp.print(g, pf, MausoleumPrinterPreviewPanel.access$10(this.this$1));
                            lp.rotate(g2d);
                        } else {
                            g2d.translate(0, (int)pf.getWidth());
                            g2d.rotate(-1.5707963267948966);
                            MausoleumPrinterPreviewPanel.access$7(this.this$1).print(g, pf, MausoleumPrinterPreviewPanel.access$10(this.this$1));
                            g2d.rotate(1.5707963267948966);
                            g2d.translate(0, -((int)pf.getWidth()));
                        }
                    } else {
                        MausoleumPrinterPreviewPanel.access$7(this.this$1).print(g, pf, MausoleumPrinterPreviewPanel.access$10(this.this$1));
                    }
                    if (MausoleumPrinterPreviewPanel.access$11(this.this$1)) {
                        g.setColor(Color.black);
                        g.drawRect(0, 0, dw, dh);
                    }
                    if (ox != 0 || oy != 0) {
                        g.translate(-ox, -oy);
                    }
                    if (MausoleumPrinterPreviewPanel.access$8(this.this$1) != 1.0) {
                        g2d.scale(1.0 / MausoleumPrinterPreviewPanel.access$8(this.this$1), 1.0 / MausoleumPrinterPreviewPanel.access$8(this.this$1));
                    }
                }
            };
            this.ivScrollpane = new JScrollPane(this.ivComponent);
            this.ivScrollpane.addComponentListener(new ComponentAdapter(this){
                final /* synthetic */ MausoleumPrinterPreviewPanel this$1;
                {
                    this.this$1 = mausoleumPrinterPreviewPanel;
                }

                public void componentResized(ComponentEvent e) {
                    MausoleumPrinterPreviewPanel.access$12(this.this$1);
                }
            });
            this.add(this.ivScrollpane);
            boolean wantAllButts = this.ivAnzPages <= -1 || this.ivAnzPages > 1;
            this.ivFirstButton = !wantAllButts ? null : this.createButton("PRINT_FIRST", "FIRST", false);
            this.ivPrevButton = !wantAllButts ? null : this.createButton("PRINT_PREVIOUS", "PREV", false);
            this.ivNextButton = !wantAllButts ? null : this.createButton("PRINT_NEXT", "NEXT", false);
            this.ivLastButton = !wantAllButts ? null : this.createButton("PRINT_LAST", "LAST", false);
            this.ivPrintButton = this.createButton("PRINT", "PRINT", true);
            this.adjustButtons();
        }

        public void setPrinter(MausoleumPrinter tp) {
            this.ivPrinter = tp;
            this.ivAnzPages = tp != null ? tp.getNumberOfPages() : -1;
            this.ivAktPage = 0;
            this.manageFaktor();
            this.getLayout().layoutContainer(this);
            this.adjustButtons();
        }

        public MausoleumPrinter getPrinter() {
            return this.ivPrinter;
        }

        public void setFullMatch(boolean b) {
            this.ivFullMatch = b;
        }

        public void setDrawFrame(boolean b) {
            this.ivDrawFrame = b;
        }

        private void setPage(int page) {
            this.ivAktPage = page;
            this.ivComponent.repaint();
            this.adjustButtons();
        }

        private void adjustButtons() {
            PreviewFrame pf;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.printing.PreviewFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((pf = (PreviewFrame)WindowUtils.getParent(this, clazz)) != null) {
                pf.setTitle("Print Preview Page " + (this.ivAktPage + 1));
            }
            if (this.ivAnzPages > 1) {
                this.ivFirstButton.setEnabled(this.ivAktPage != 0);
                this.ivPrevButton.setEnabled(this.ivAktPage != 0);
                this.ivNextButton.setEnabled(this.ivAktPage < this.ivAnzPages - 1);
                this.ivLastButton.setEnabled(this.ivAktPage < this.ivAnzPages - 1);
            } else if (this.ivFirstButton != null) {
                this.ivFirstButton.setEnabled(false);
                this.ivPrevButton.setEnabled(false);
                this.ivNextButton.setEnabled(false);
                this.ivLastButton.setEnabled(false);
            }
        }

        private MGButton createButton(String babel, String ac, boolean enabled) {
            MGButton but = new MGButton(Babel.get(babel));
            but.setActionCommand(ac);
            but.addActionListener(this);
            but.setFont(FontManager.getFont("SSB12"));
            but.setEnabled(enabled);
            this.add(but);
            return but;
        }

        private void manageFaktor() {
            if (this.ivPrinter != null) {
                Dimension d = this.ivScrollpane.getViewport().getSize();
                if (this.ivFullMatch) {
                    double wwidth = this.ivPrinter.isRotated() ? this.ivPrinter.ivPageFormat.getHeight() : this.ivPrinter.ivPageFormat.getWidth();
                    double wheight = this.ivPrinter.isRotated() ? this.ivPrinter.ivPageFormat.getWidth() : this.ivPrinter.ivPageFormat.getHeight();
                    double faktorw = (double)d.width / wwidth;
                    double faktorh = (double)d.height / wheight;
                    this.ivFaktor = faktorw < faktorh ? faktorw : faktorh;
                } else {
                    double wwidth = this.ivPrinter.isRotated() ? this.ivPrinter.ivPageFormat.getHeight() : this.ivPrinter.ivPageFormat.getWidth();
                    this.ivFaktor = (double)d.width / wwidth;
                }
            } else {
                this.ivFaktor = 1.0;
            }
            this.ivScrollpane.repaint();
        }

        public void actionPerformed(ActionEvent e) {
            String comm = e.getActionCommand();
            if (comm.equals("FIRST")) {
                this.setPage(0);
            } else if (comm.equals("PREV")) {
                this.setPage(this.ivAktPage - 1);
            } else if (comm.equals("NEXT")) {
                this.setPage(this.ivAktPage + 1);
            } else if (comm.equals("LAST")) {
                this.setPage(this.ivPrinter.getNumberOfPages() - 1);
            } else if (comm.equals("PRINT")) {
                this.ivPrinter.printIt();
            }
        }

        static /* synthetic */ JScrollPane access$0(MausoleumPrinterPreviewPanel mausoleumPrinterPreviewPanel) {
            return mausoleumPrinterPreviewPanel.ivScrollpane;
        }

        static /* synthetic */ int access$1(MausoleumPrinterPreviewPanel mausoleumPrinterPreviewPanel) {
            return mausoleumPrinterPreviewPanel.ivAnzPages;
        }

        static /* synthetic */ MGButton access$2(MausoleumPrinterPreviewPanel mausoleumPrinterPreviewPanel) {
            return mausoleumPrinterPreviewPanel.ivFirstButton;
        }

        static /* synthetic */ MGButton access$3(MausoleumPrinterPreviewPanel mausoleumPrinterPreviewPanel) {
            return mausoleumPrinterPreviewPanel.ivPrevButton;
        }

        static /* synthetic */ MGButton access$4(MausoleumPrinterPreviewPanel mausoleumPrinterPreviewPanel) {
            return mausoleumPrinterPreviewPanel.ivNextButton;
        }

        static /* synthetic */ MGButton access$5(MausoleumPrinterPreviewPanel mausoleumPrinterPreviewPanel) {
            return mausoleumPrinterPreviewPanel.ivLastButton;
        }

        static /* synthetic */ MGButton access$6(MausoleumPrinterPreviewPanel mausoleumPrinterPreviewPanel) {
            return mausoleumPrinterPreviewPanel.ivPrintButton;
        }

        static /* synthetic */ double access$8(MausoleumPrinterPreviewPanel mausoleumPrinterPreviewPanel) {
            return mausoleumPrinterPreviewPanel.ivFaktor;
        }

        static /* synthetic */ boolean access$9(MausoleumPrinterPreviewPanel mausoleumPrinterPreviewPanel) {
            return mausoleumPrinterPreviewPanel.ivFullMatch;
        }

        static /* synthetic */ int access$10(MausoleumPrinterPreviewPanel mausoleumPrinterPreviewPanel) {
            return mausoleumPrinterPreviewPanel.ivAktPage;
        }

        static /* synthetic */ boolean access$11(MausoleumPrinterPreviewPanel mausoleumPrinterPreviewPanel) {
            return mausoleumPrinterPreviewPanel.ivDrawFrame;
        }

        static /* synthetic */ void access$12(MausoleumPrinterPreviewPanel mausoleumPrinterPreviewPanel) {
            mausoleumPrinterPreviewPanel.manageFaktor();
        }
    }
}

