/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.labelprinters;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.XMLNode;
import de.hannse.netobjects.util.XMLParser;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.helper.FontManager;
import mausoleum.helper.FontManagerUS;
import mausoleum.helper.LitterHelper;
import mausoleum.helper.LongPunkt;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.printing.PrintElement;
import mausoleum.printing.labelprinters.KoelnPrinter;
import mausoleum.printing.labelprinters.LabelPrinter;

public class CECADStockPrinter
extends KoelnPrinter {
    private static final String XML = "\t<LabelPrinter name=\"CECAD ivRF Stock\" weddingsred=\"true\" rotated=\"1\" onecardperpage=\"1\" width=\"131\" height=\"75\" top=\"5\" left=\"5\" right=\"10\">\n\t\t<lines>\n\t\t\t<line typ=\"LicenseWithOwnersNamePreferred\" font=\"4\"></line>\n\t\t\t<line typ=\"Empty\" font=\"4\"></line>\n\t\t\t<line typ=\"PolygonOhneCECAD\" font=\"5\" orientation=\"center\" ovrCageColorMode=\"18\"></line>\n\t\t\t<line typ=\"Line\" font=\"4\"></line>\n\t\t\t<line typ=\"Strain\" font=\"4\"></line>\n\t\t\t<line typ=\"Comment\" font=\"3\"></line>\n\t\t</lines>\n\t\t<mice>\n\t\t\t<col typ=\"eartagwp\" font=\"3\"></col>\n\t\t\t<col typ=\"Sex\" font=\"3\"></col>\n\t\t\t<col typ=\"Genotype\" font=\"3\"></col>\n\t\t\t<col typ=\"Birthday\" font=\"3\"></col>\n\t\t</mice>\n\t</LabelPrinter>\n";
    private static final String XML_BACKCROSS = "\t<LabelPrinter name=\"DZNE backcrossing\" weddingsred=\"true\" rotated=\"1\" onecardperpage=\"1\" width=\"131\" height=\"75\" top=\"5\" left=\"5\" right=\"10\">\n\t\t<lines>\n\t\t\t<line typ=\"Text\" font=\"3\" contents=\"BACKCROSSING\" orientation=\"center\"></line>\n\t\t\t<line typ=\"LicenseWithOwnersNamePreferred\" font=\"4\"></line>\n\t\t\t<line typ=\"Empty\" font=\"4\"></line>\n\t\t\t<line typ=\"PolygonOhneCECAD\" font=\"5\" orientation=\"center\" ovrCageColorMode=\"18\"></line>\n\t\t\t<line typ=\"Line\" font=\"4\"></line>\n\t\t\t<line typ=\"Strain\" font=\"4\"></line>\n\t\t\t<line typ=\"Comment\" font=\"3\"></line>\n\t\t</lines>\n\t\t<mice>\n\t\t\t<col typ=\"eartagwp\" font=\"3\"></col>\n\t\t\t<col typ=\"Sex\" font=\"3\"></col>\n\t\t\t<col typ=\"Genotype\" font=\"3\"></col>\n\t\t\t<col typ=\"Birthday\" font=\"3\"></col>\n\t\t</mice>\n\t</LabelPrinter>\n";
    private boolean ivBackcrossMode = false;
    private boolean ivWithS2 = false;

    public static CECADStockPrinter createNormalPrinter(boolean withS2) {
        CECADStockPrinter pr = new CECADStockPrinter(XMLParser.parseXMLString(XML));
        pr.ivName = "CECAD ivRF Stock";
        pr.ivWithS2 = withS2;
        if (pr.ivWithS2) {
            pr.ivName = String.valueOf(pr.ivName) + " S2";
        }
        pr.ivBackcrossMode = false;
        pr.ivGenotypePralineMode = true;
        return pr;
    }

    public static CECADStockPrinter createBackcrossPrinter() {
        CECADStockPrinter pr = new CECADStockPrinter(XMLParser.parseXMLString(XML_BACKCROSS));
        pr.ivName = "DZNE backcrossing";
        pr.ivBackcrossMode = true;
        return pr;
    }

    private CECADStockPrinter(XMLNode xn) {
        super(xn);
        this.setVals();
    }

    private CECADStockPrinter() {
        this.setVals();
    }

    private void setVals() {
        this.ivGroupMiceByParents = true;
        this.ivGroupMiceByParentsNotIfTooBig = true;
        this.ivUseVeryShortDate = true;
        this.ivName = "CECAD ivRF Stock";
        this.ivGVOWatermark = "GVO";
        this.ivWatermarkExtraY = 30;
        this.ivWeddingsRed = true;
    }

    public LabelPrinter getClone() {
        CECADStockPrinter clone = new CECADStockPrinter();
        this.copyValues(clone);
        clone.ivBackcrossMode = this.ivBackcrossMode;
        clone.ivWithS2 = this.ivWithS2;
        return clone;
    }

    public String getCageTitelExtra(Cage c) {
        return this.ivWithS2 ? "S2" : null;
    }

    public Color getCageTitelExtraColor() {
        return this.ivWithS2 ? Color.red : null;
    }

    public Color[] getCageColor(Cage cage) {
        return cage.getColor(18);
    }

    public Font getParentFont(Font model) {
        return FontManager.getFont(model.getName(), 0, model.getSize() - 1);
    }

    public String getParentString(Cage cage, LongPunkt lp) {
        StringBuffer msb = new StringBuffer();
        String group = cage.getString("IDO_GROUP", null);
        if (group != null) {
            Mouse vater = null;
            if (lp.ivX > 0L) {
                vater = (Mouse)ObjectStore.getObjectDeadOrAlive(1, lp.ivX, group, null, false);
            }
            msb.append(String.valueOf(DefaultManager.getMale()) + " ").append(CECADStockPrinter.getParentString(vater)).append(" ");
            Mouse mutter = null;
            if (lp.ivY > 0L) {
                mutter = (Mouse)ObjectStore.getObjectDeadOrAlive(1, lp.ivY, group, null, false);
            }
            msb.append(" " + DefaultManager.getFemale() + " ").append(CECADStockPrinter.getParentString(mutter));
            if (this.ivBackcrossMode) {
                msb.append("\n").append(Babel.get("STRAIN")).append(": ");
                msb.append(Mouse.getStrainInfo(LitterHelper.getPupStrain(vater, mutter), Babel.get("NOSTRAIN"), group));
            }
            return msb.toString();
        }
        return null;
    }

    private static String getParentString(Mouse parent) {
        if (parent != null) {
            StringBuffer msb = new StringBuffer();
            msb.append(parent.getCLLWEartagString());
            return msb.toString();
        }
        return "[?]";
    }

    public Vector handleCage(Cage c) {
        if (c.isMatingCage()) {
            Font f = FontManagerUS.SSB24;
            FontMetrics fm = FontManager.getFontMetrics(f);
            int ascent = fm.getAscent();
            int descent = fm.getDescent();
            int rfh = ascent + descent;
            PrintElement pe = PrintElement.getTextElement((int)this.ivWidth / 2, ((int)this.ivHeight - rfh) / 2 + ascent, "Not applicable", f, Color.DARK_GRAY);
            pe.ivOrientation = 2;
            Vector<PrintElement> page = new Vector<PrintElement>();
            page.addElement(pe);
            return page;
        }
        return super.handleCage(c);
    }
}

