/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.labelprinters;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.XMLNode;
import de.hannse.netobjects.util.XMLParser;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.factsheets.TextWrapComponentNeu;
import mausoleum.factsheets.TextWrapElementNeu;
import mausoleum.helper.FontManagerUS;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.printing.PrintElement;
import mausoleum.printing.labelprinters.LabelLine;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.printing.util.LabelMaker;
import mausoleum.printing.util.Wurf;

public class CIBIRPrinter
extends LabelPrinter {
    private static final String DEFAULT_PRINTER = "\t<LabelPrinter name=\"CIBIR\" weddingsred=\"true\" rotated=\"1\" onecardperpage=\"1\" width=\"104\" height=\"72\" top=\"5\" left=\"5\" right=\"10\">\n\t\t<lines>\n\t\t\t<line typ=\"LicenseWithOwners\" font=\"4\" />\n\t\t\t<line typ=\"Empty\" font=\"4\" />\n\t\t\t<line typ=\"PolygonOhneOwner\" font=\"5\" orientation=\"center\" />\n\t\t\t<line typ=\"Line\" font=\"4\" />\n\t\t\t<line typ=\"Strain\" font=\"4\" />\n\t\t\t<line typ=\"Comment\" font=\"3\" />\n\t\t</lines>\n\t\t<mice>\n\t\t\t<col typ=\"Tag\" font=\"1\" />\n\t\t\t<col typ=\"EarTagWP\" font=\"1\" />\n\t\t\t<col typ=\"Sex\" font=\"1\" />\n\t\t\t<col typ=\"Genotype\" font=\"1\" />\n\t\t\t<col typ=\"Birthday\" font=\"1\" />\n\t\t\t<col typ=\"Parents\" font=\"1\" />\n\t\t</mice>\n\t</LabelPrinter>\n";
    private boolean ivShowMatingGTs = false;
    private TextWrapComponentNeu ivTWC = new TextWrapComponentNeu("", FontManagerUS.SSB09);

    public static CIBIRPrinter createPrinter(boolean showMatingGTs) {
        XMLNode xn = XMLParser.parseXMLString(DEFAULT_PRINTER);
        return new CIBIRPrinter(xn, showMatingGTs);
    }

    private CIBIRPrinter(XMLNode xn, boolean showMatingGTs) {
        super(xn);
        this.ivShowMatingGTs = showMatingGTs;
        if (this.ivShowMatingGTs) {
            this.ivName = String.valueOf(this.ivName) + " GT";
        }
        this.ivUseVeryShortDate = true;
        this.ivGroupMiceByParents = true;
    }

    private CIBIRPrinter() {
        this.ivUseVeryShortDate = true;
        this.ivGroupMiceByParents = true;
    }

    public LabelPrinter getClone() {
        CIBIRPrinter clone = new CIBIRPrinter();
        this.copyValues(clone);
        clone.ivShowMatingGTs = this.ivShowMatingGTs;
        return clone;
    }

    public Vector handleCage(Cage c) {
        if (c.isMatingCage()) {
            return this.handleMatingCage(c);
        }
        return super.handleCage(c);
    }

    public Vector handleMatingCage(Cage c) {
        Vector page = new Vector(100);
        Vector males = new Vector();
        Vector females = new Vector();
        Vector wuerfe = Wurf.collectWuerfeForPrinters(c, males, females, false, 20, 20, null, false, false, false, false, true, false, true, false, false, false);
        if (wuerfe == null) {
            return super.handleCage(c);
        }
        int anzAdults = males.size() + females.size();
        String mouseCount = "(" + anzAdults + " adults)";
        if (anzAdults == 1) {
            mouseCount = "(" + anzAdults + " adult)";
        }
        int ax = (int)this.ivLeft;
        int ay = (int)this.ivTop;
        int i = 0;
        while (i < this.ivLines.size()) {
            LabelLine ll = (LabelLine)this.ivLines.elementAt(i);
            String ltyp = ll.getType();
            if (!(ltyp.equalsIgnoreCase("Line") || ltyp.equalsIgnoreCase("Strain") || ltyp.equalsIgnoreCase("Comment"))) {
                ay += ll.generateOutput(c, page, ax, ay, this.ivWeddingsRed, mouseCount, this);
            }
            ++i;
        }
        ay = this.showParentMice(males, ax, ay, Wurf.FATHER_COLORS, DefaultManager.getMale(), page, c);
        ay += 3;
        ay = this.showParentMice(females, ax, ay, Wurf.MOTHER_COLORS, DefaultManager.getFemale(), page, c);
        ay += 5;
        ay = this.showWuerfe(wuerfe, ax, ay, page, males, females, IDObject.combineIDObjectCollections(new Vector[]{males, females}));
        return page;
    }

    private int showParentMice(Vector mice, int ax, int ay, Color[] colarr, String sign, Vector sammler, Cage c) {
        Font f = FontManagerUS.SSB09;
        int i = 0;
        while (i < mice.size()) {
            int normWidth;
            int tx = ax;
            Mouse mausi = (Mouse)mice.elementAt(i);
            sammler.addElement(PrintElement.getTextElement(tx, ay, sign, f));
            tx += 14;
            int etBreite = normWidth = 35;
            String et = mausi.getCLLWEartagString("?", true, true);
            int w = StringHelper.getStringWidth(et, f, 10) + 8;
            if (w > etBreite) {
                etBreite = w;
            }
            PrintElement tpe = null;
            tpe = i < colarr.length ? PrintElement.getFilledTextBox(tx, ay, etBreite, 12, mausi.getCLLWEartagString("?", true, true), f, colarr[i]) : PrintElement.getFilledTextBox(tx, ay, etBreite, 12, mausi.getCLLWEartagString("?", true, true), f, null);
            sammler.addElement(tpe);
            tpe.ivOrientation = 2;
            tx += etBreite;
            StringBuffer msb = new StringBuffer();
            msb.append("I ").append(LabelMaker.getVeryShortDateString(Cage.getInDate(mausi, c))).append(" ");
            msb.append("B ").append(LabelMaker.getVeryShortDateString(mausi.getDate("MOS_BIRTHDAY"))).append(" ");
            msb.append(mausi.getString("MOS_ANTAG", "")).append(" ");
            if (this.ivShowMatingGTs) {
                msb.append(mausi.getGenotype()).append(" ");
            } else {
                msb.append(mausi.getCLLWLineString()).append(" ");
            }
            int restWidth = (int)(this.ivWidth - (double)tx - this.ivRight);
            this.ivTWC.setFont(f);
            this.ivTWC.ivString = msb.toString().trim();
            this.ivTWC.setBounds(0, 0, restWidth, 2000);
            this.ivTWC.generateElements();
            Vector v = this.ivTWC.getElements();
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                TextWrapElementNeu element = (TextWrapElementNeu)iter.next();
                sammler.addElement(PrintElement.getFilledTextBox(tx, ay, restWidth, 12, element.ivText, f, null));
                ay += 11;
            }
            ++i;
        }
        return ay;
    }

    private int showWuerfe(Vector wuerfe, int ax, int ay, Vector page, Vector males, Vector females, HashMap parents) {
        int origay = ay;
        Font f = FontManagerUS.SSB09;
        int i = wuerfe.size() - 1;
        while (i >= 0) {
            Wurf w = (Wurf)wuerfe.elementAt(i);
            int tx = ax;
            if (w.areAllLeft()) {
                page.addElement(PrintElement.getFilledTextBox(tx, ay, 8, 12, "*", f, null));
            }
            page.addElement(PrintElement.getFilledTextBox(tx += 8, ay, 38, 12, LabelMaker.getVeryShortDateString(w.ivDay), f, null));
            page.addElement(PrintElement.getFilledTextBox(tx += 50, ay, 22, 12, w.getMaleNumberString(), f, null));
            page.addElement(PrintElement.getFilledTextBox(tx += 22, ay, 22, 12, w.getFemaleNumberString(), f, null));
            page.addElement(PrintElement.getFilledTextBox(tx += 22, ay, 22, 12, "T " + w.ivNumBornTotal, f, null));
            tx += 22;
            tx += 2;
            Mouse father = (Mouse)parents.get(new Long(w.ivFatherID));
            if (father != null) {
                int pos = males.indexOf(father);
                PrintElement tpe = null;
                tpe = pos < Wurf.FATHER_COLORS.length && pos != -1 ? PrintElement.getFilledTextBox(tx, ay, 30, 12, father.getCLLWEartagString("?", true, true), f, Wurf.FATHER_COLORS[pos]) : PrintElement.getFilledTextBox(tx, ay, 30, 12, father.getCLLWEartagString("?", true, true), f, null);
                page.addElement(tpe);
                tpe.ivOrientation = 2;
            }
            tx += 30;
            Mouse mother = (Mouse)parents.get(new Long(w.ivMotherID));
            if (mother != null) {
                int pos = females.indexOf(mother);
                PrintElement tpe = null;
                tpe = pos < Wurf.MOTHER_COLORS.length && pos != -1 ? PrintElement.getFilledTextBox(tx, ay, 30, 12, mother.getCLLWEartagString("?", true, true), f, Wurf.MOTHER_COLORS[pos]) : PrintElement.getFilledTextBox(tx, ay, 30, 12, mother.getCLLWEartagString("?", true, true), f, null);
                page.addElement(tpe);
                tpe.ivOrientation = 2;
            }
            tx += 30;
            if ((ay += 10) > 205) {
                ay = origay;
                ax += 180;
            }
            --i;
        }
        return ay;
    }
}

