/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.labelprinters;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.gui.MusterColor;
import mausoleum.gui.TextWrapComponent;
import mausoleum.gui.TextWrapElement;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.FontManagerUS;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.printing.PageFormatGenerator;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.printing.util.LabelMaker;
import mausoleum.printing.util.Wurf;
import mausoleum.rack.frame.CageDisplayManager;

public class DMBRDymoPrinter
extends LabelPrinter {
    private static final int EARTAG_WIDTH = 42;
    private static final int EARTAG_WIDTH_2 = 39;
    private static final int LINE_HEIGHT = 13;
    private static final int LINE_HEIGHT_STOCK = 13;
    private static final int CAGE_NUMBER_FIELD_WIDTH = DMBRDymoPrinter.mm(17.0);
    private static final int CAGE_NUMBER_FIELD_HEIGHT = DMBRDymoPrinter.mm(10.0);
    private static final int MIN_RAND = DMBRDymoPrinter.mm(2.0);
    private static final double RAND = 1.5;
    private int ivLinks = 0;
    private int ivRechts = 0;
    private int ivOben = 0;
    private int ivUnten = 0;

    public DMBRDymoPrinter() {
        this.ivLatePageGeneration = true;
        this.ivName = "DRBM Dymo";
        this.ivWidth = 161.5748031496063;
        this.ivHeight = 269.2913385826772;
        this.ivTop = 0.0;
        this.ivLeft = 0.0;
        this.ivBottom = 0.0;
        this.ivRight = 0.0;
        this.ivBackground = false;
        this.ivRotated = true;
        PageFormatGenerator.createPageformatForLabelPrinter(this);
        this.ivLinks = 4;
        this.ivRechts = (int)(this.ivWidth - 4.251968503937008);
        this.ivOben = 4;
        this.ivUnten = (int)(this.ivHeight - 4.251968503937008);
    }

    public LabelPrinter getClone() {
        DMBRDymoPrinter clone = new DMBRDymoPrinter();
        this.copyValues(clone);
        return clone;
    }

    public boolean isRotated() {
        return true;
    }

    public void simplePrint(Cage cage, Graphics graphics) {
        if (cage.isMatingCage()) {
            this.printMatingCage((Graphics2D)graphics, cage);
        } else {
            this.printStockCage((Graphics2D)graphics, cage);
        }
    }

    private void printMatingCage(Graphics2D g, Cage c) {
        Vector males = new Vector();
        Vector females = new Vector();
        Vector wuerfe = Wurf.collectWuerfeForPrinters(c, males, females, false, 1, 2, null, false, false, false, true, true, false, true, false, false, false);
        if (wuerfe == null) {
            this.printStockCage(g, c);
            return;
        }
        int orLineHeight = DMBRDymoPrinter.mm(3.5);
        int platzFuerLines = 0;
        TextWrapComponent twc = null;
        String typs = AllgUtils.getTypeString(c, c.getActualMice(), 0, true);
        if (typs.trim().length() != 0) {
            twc = new TextWrapComponent(typs, FontManagerUS.SSB09);
            twc.setSize(this.ivRechts - this.ivLinks - 2 * MIN_RAND, 100);
            twc.generateElements();
            platzFuerLines = twc.getAnzElements() * orLineHeight + 2 * MIN_RAND;
        }
        int yObenNormal = this.ivLinks + CAGE_NUMBER_FIELD_HEIGHT + 2 * MIN_RAND;
        int you = yObenNormal + platzFuerLines;
        DMBRDymoPrinter.makeFill(c, g, this.ivLinks, this.ivOben, this.ivRechts, you);
        DMBRDymoPrinter.drawRect(g, this.ivLinks, this.ivOben, this.ivRechts, you, DMBRDymoPrinter.mm(0.8));
        LabelMaker.make(g, c.getNumberString(), FontManagerUS.SSB12, this.ivLinks + MIN_RAND, this.ivOben + MIN_RAND, CAGE_NUMBER_FIELD_WIDTH, CAGE_NUMBER_FIELD_HEIGHT, DMBRDymoPrinter.mm(0.8), 0, Color.white);
        int orXStart = this.ivLinks + MIN_RAND + CAGE_NUMBER_FIELD_WIDTH + MIN_RAND;
        int orBreite = (int)(this.ivWidth - 4.251968503937008) - orXStart;
        int ay = this.ivOben + MIN_RAND;
        String permission = c.getLicenseString("permiss.: ");
        if (permission != null) {
            LabelMaker.makeMitRandDrumrum(g, permission, FontManagerUS.SSB09, orXStart, ay - 1, orBreite, orLineHeight, 0, 0, null);
        }
        ay += orLineHeight + DMBRDymoPrinter.mm(0.2);
        int anzLineHeight = DMBRDymoPrinter.mm(4.2);
        String css = String.valueOf(c.getNumberOfMice()) + " M / " + c.getOwnerStringOnlySingleEmailPreferred();
        if (css != null && css.length() != 0) {
            LabelMaker.makeMitRandDrumrum(g, css, FontManagerUS.SSB12, orXStart, ay, orBreite, orLineHeight, 0, 0, null);
        }
        ay += anzLineHeight + DMBRDymoPrinter.mm(0.2);
        String rackname = c.getRackName();
        if (rackname != null) {
            LabelMaker.makeMitRandDrumrum(g, rackname, FontManagerUS.SSB09, orXStart, ay + 1, orBreite, orLineHeight, 0, 0, null);
        }
        ay += orLineHeight;
        ay = yObenNormal;
        if (twc != null) {
            Enumeration en = twc.getElements();
            while (en.hasMoreElements()) {
                TextWrapElement twe = (TextWrapElement)en.nextElement();
                LabelMaker.makeMitRandDrumrum(g, twe.ivText, FontManagerUS.SSB09, this.ivLinks + MIN_RAND, ay + 1, this.ivRechts - this.ivLinks - 2 * MIN_RAND, orLineHeight, 0, 0, null);
                ay += orLineHeight;
            }
        }
        int akty = you;
        int signWith = 42;
        int restWidth = this.ivRechts - this.ivLinks - signWith;
        int restStart = this.ivLinks + 42;
        Mouse father = null;
        if (males.size() == 1) {
            father = (Mouse)males.elementAt(0);
            LabelMaker.make(g, DefaultManager.getMale(), FontManagerUS.SSB11, this.ivLinks, akty, 42, 13, 0, 0, null);
            LabelMaker.make(g, DMBRDymoPrinter.getEartag(father), FontManagerUS.SSB09, this.ivLinks, akty + 13, 42, 13, 0, 0, Wurf.FATHER_COLORS[0]);
            DMBRDymoPrinter.drawRect(g, this.ivLinks, akty, this.ivLinks + 42, akty + 13, DMBRDymoPrinter.mm(0.1));
            DMBRDymoPrinter.drawRect(g, this.ivLinks, akty, this.ivLinks + 42, akty + 26, DMBRDymoPrinter.mm(0.1));
            DMBRDymoPrinter.drawRect(g, this.ivLinks, akty, this.ivRechts, akty + 26, DMBRDymoPrinter.mm(0.8));
            int iay = akty;
            LabelMaker.make(g, " " + DMBRDymoPrinter.getGenotype(father) + " ", FontManagerUS.SSB09, restStart, iay, restWidth, 13, 0, 2, null);
            DMBRDymoPrinter.drawRect(g, restStart, iay, restStart + restWidth, iay + 13, DMBRDymoPrinter.mm(0.1));
            LabelMaker.make(g, " " + father.getCLLWLineString() + " ", FontManagerUS.SSB09, restStart, iay += 13, restWidth, 13, 0, 2, null);
            DMBRDymoPrinter.drawRect(g, restStart, iay, restStart + restWidth, iay + 13, DMBRDymoPrinter.mm(0.1));
            akty += 26;
        }
        int i = 0;
        while (i < females.size()) {
            Mouse mother = (Mouse)females.elementAt(i);
            LabelMaker.make(g, DefaultManager.getFemale(), FontManagerUS.SSB11, this.ivLinks, akty, 42, 13, 0, 0, null);
            LabelMaker.make(g, DMBRDymoPrinter.getEartag(mother), FontManagerUS.SSB09, this.ivLinks, akty + 13, 42, 13, 0, 0, Wurf.MOTHER_COLORS[i % Wurf.MOTHER_COLORS.length]);
            DMBRDymoPrinter.drawRect(g, this.ivLinks, akty, this.ivLinks + 42, akty + 13, DMBRDymoPrinter.mm(0.1));
            DMBRDymoPrinter.drawRect(g, this.ivLinks, akty, this.ivLinks + 42, akty + 26, DMBRDymoPrinter.mm(0.1));
            DMBRDymoPrinter.drawRect(g, this.ivLinks, akty, this.ivRechts, akty + 26, DMBRDymoPrinter.mm(0.8));
            int iay = akty;
            LabelMaker.make(g, " " + DMBRDymoPrinter.getGenotype(mother) + " ", FontManagerUS.SSB09, restStart, iay, restWidth, 13, 0, 2, null);
            DMBRDymoPrinter.drawRect(g, restStart, iay, restStart + restWidth, iay + 13, DMBRDymoPrinter.mm(0.1));
            LabelMaker.make(g, " " + mother.getCLLWLineString() + " ", FontManagerUS.SSB09, restStart, iay += 13, restWidth / 2, 13, 0, 2, null);
            DMBRDymoPrinter.drawRect(g, restStart, iay, restStart + restWidth / 2, iay + 13, DMBRDymoPrinter.mm(0.1));
            Date pd = DMBRDymoPrinter.getPlugday(mother);
            if (pd != null) {
                LabelMaker.make(g, "PD: " + LabelMaker.getDateString(pd), FontManagerUS.SSB09, restStart + restWidth / 2, iay, restWidth - restWidth / 2, 13, 0, 0, null);
            }
            DMBRDymoPrinter.drawRect(g, restStart + restWidth / 2, iay, restStart + restWidth, iay + 13, DMBRDymoPrinter.mm(0.1));
            akty += 26;
            ++i;
        }
        int yStartWurfTabelleHeader = akty;
        int yStartWurfZeilen = yStartWurfTabelleHeader + 28;
        int y8 = yStartWurfTabelleHeader + 14;
        int datw = 42;
        int totwidth = this.ivRechts - this.ivLinks;
        int nbw1 = (totwidth - datw - 78) / 2;
        int nbw2 = totwidth - datw - 78 - nbw1;
        int x3 = this.ivLinks + datw;
        int x5 = x3 + nbw1 + nbw2;
        int x5a = x5 + 39;
        int x6 = this.ivRechts;
        LabelMaker.make(g, "DOB", FontManagerUS.SSB09, this.ivLinks, yStartWurfTabelleHeader, datw, yStartWurfZeilen - yStartWurfTabelleHeader, 0, 0, null);
        LabelMaker.make(g, "Born", FontManagerUS.SSB09, x3, yStartWurfTabelleHeader, nbw1 + nbw2, yStartWurfZeilen - yStartWurfTabelleHeader, 0, 0, null);
        LabelMaker.make(g, "Parents", FontManagerUS.SSB09, x5, yStartWurfTabelleHeader, 78, y8 - yStartWurfTabelleHeader, 0, 0, null);
        LabelMaker.make(g, DefaultManager.getMale(), FontManagerUS.SSB09, x5, y8, 39, yStartWurfZeilen - y8, 0, 0, null);
        LabelMaker.make(g, DefaultManager.getFemale(), FontManagerUS.SSB09, x5a, y8, 39, yStartWurfZeilen - y8, 0, 0, null);
        int y = yStartWurfZeilen;
        int i2 = 0;
        while (i2 < wuerfe.size()) {
            Wurf wurf = (Wurf)wuerfe.elementAt(i2);
            LabelMaker.makeWithDate(g, wurf.ivDay, FontManagerUS.SSP9, this.ivLinks, y, x3 - this.ivLinks, 14, 0, 0, null);
            LabelMaker.make(g, wurf.ivNumBornTotal, FontManagerUS.SSP9, x3, y, x5 - x3, 14, 0, 0, null);
            Color back = null;
            if (father != null && wurf.ivFatherID == father.getID()) {
                back = Wurf.FATHER_COLORS[0];
            }
            LabelMaker.make(g, DMBRDymoPrinter.getJustEartag(wurf.ivFatherID, c.getGroup()), FontManagerUS.SSP9, x5, y, x5a - x5, 14, 0, 0, back);
            back = null;
            if (females.size() > 0 && wurf.ivMotherID == ((Mouse)females.elementAt(0)).getID()) {
                back = Wurf.MOTHER_COLORS[0];
            } else if (females.size() > 1 && wurf.ivMotherID == ((Mouse)females.elementAt(1)).getID()) {
                back = Wurf.MOTHER_COLORS[1];
            }
            LabelMaker.make(g, DMBRDymoPrinter.getJustEartag(wurf.ivMotherID, c.getGroup()), FontManagerUS.SSP9, x5a, y, x6 - x5a, 14, 0, 0, back);
            y += 14;
            ++i2;
        }
        g.setStroke(new BasicStroke(1.0f));
        g.drawLine(x3, this.ivUnten, x3, yStartWurfZeilen);
        g.drawLine(x5, this.ivUnten, x5, yStartWurfZeilen);
        g.drawLine(x5a, this.ivUnten, x5a, yStartWurfZeilen);
        g.drawLine(x6, this.ivUnten, x6, yStartWurfZeilen);
        int ly = yStartWurfZeilen;
        while (ly <= this.ivUnten) {
            g.drawLine(this.ivLinks, ly, this.ivRechts, ly);
            ly += 14;
        }
        DMBRDymoPrinter.drawRect(g, this.ivLinks, yStartWurfTabelleHeader, x3, yStartWurfZeilen, DMBRDymoPrinter.mm(0.8));
        DMBRDymoPrinter.drawRect(g, x3, yStartWurfTabelleHeader, x5, yStartWurfZeilen, DMBRDymoPrinter.mm(0.8));
        DMBRDymoPrinter.drawRect(g, x5, yStartWurfTabelleHeader, x6, yStartWurfZeilen, DMBRDymoPrinter.mm(0.8));
        DMBRDymoPrinter.drawRect(g, x6, yStartWurfTabelleHeader, this.ivRechts, yStartWurfZeilen, DMBRDymoPrinter.mm(0.8));
        DMBRDymoPrinter.drawRect(g, this.ivLinks, this.ivOben, this.ivRechts, this.ivUnten, DMBRDymoPrinter.mm(0.8));
    }

    private static void drawRect(Graphics2D g, int ulx, int uly, int lrx, int lry, float width) {
        g.setColor(Color.black);
        g.setStroke(new BasicStroke(width));
        g.drawRect(ulx, uly, lrx - ulx, lry - uly);
    }

    private static void fillRect(Graphics2D g, int ulx, int uly, int lrx, int lry, Color col) {
        g.setColor(col);
        g.fillRect(ulx, uly, lrx - ulx, lry - uly);
    }

    private void printStockCage(Graphics2D g, Cage c) {
        int orLineHeight = DMBRDymoPrinter.mm(3.5);
        int platzFuerLines = 0;
        TextWrapComponent twc = null;
        String typs = AllgUtils.getTypeString(c, c.getActualMice(), 0, true);
        if (typs.trim().length() != 0) {
            twc = new TextWrapComponent(typs, FontManagerUS.SSB09);
            twc.setSize(this.ivRechts - this.ivLinks - 2 * MIN_RAND, 100);
            twc.generateElements();
            platzFuerLines = twc.getAnzElements() * orLineHeight + 2 * MIN_RAND;
        }
        int yObenNormal = this.ivLinks + CAGE_NUMBER_FIELD_HEIGHT + 2 * MIN_RAND;
        int you = yObenNormal + platzFuerLines;
        DMBRDymoPrinter.makeFill(c, g, this.ivLinks, this.ivOben, this.ivRechts, you);
        DMBRDymoPrinter.drawRect(g, this.ivLinks, this.ivOben, this.ivRechts, you, DMBRDymoPrinter.mm(0.8));
        LabelMaker.make(g, c.getNumberString(), FontManagerUS.SSB12, this.ivLinks + MIN_RAND, this.ivOben + MIN_RAND, CAGE_NUMBER_FIELD_WIDTH, CAGE_NUMBER_FIELD_HEIGHT, DMBRDymoPrinter.mm(0.8), 0, Color.white);
        int orXStart = this.ivLinks + MIN_RAND + CAGE_NUMBER_FIELD_WIDTH + MIN_RAND;
        int orBreite = (int)(this.ivWidth - 4.251968503937008) - orXStart;
        int ay = this.ivOben + MIN_RAND;
        String permission = c.getLicenseString("permiss.: ");
        if (permission != null) {
            LabelMaker.makeMitRandDrumrum(g, permission, FontManagerUS.SSB09, orXStart, ay - 1, orBreite, orLineHeight, 0, 0, null);
        }
        ay += orLineHeight + DMBRDymoPrinter.mm(0.2);
        int anzLineHeight = DMBRDymoPrinter.mm(4.2);
        String css = String.valueOf(c.getNumberOfMice()) + " M / " + c.getOwnerStringOnlySingleEmailPreferred();
        if (css != null && css.length() != 0) {
            LabelMaker.makeMitRandDrumrum(g, css, FontManagerUS.SSB12, orXStart, ay, orBreite, orLineHeight, 0, 0, null);
        }
        ay += anzLineHeight + DMBRDymoPrinter.mm(0.2);
        String rackname = c.getRackName();
        if (rackname != null) {
            LabelMaker.makeMitRandDrumrum(g, rackname, FontManagerUS.SSB09, orXStart, ay + 1, orBreite, orLineHeight, 0, 0, null);
        }
        ay += orLineHeight;
        ay = yObenNormal;
        if (twc != null) {
            Enumeration en = twc.getElements();
            while (en.hasMoreElements()) {
                TextWrapElement twe = (TextWrapElement)en.nextElement();
                LabelMaker.makeMitRandDrumrum(g, twe.ivText, FontManagerUS.SSB09, this.ivLinks + MIN_RAND, ay + 1, this.ivRechts - this.ivLinks - 2 * MIN_RAND, orLineHeight, 0, 0, null);
                ay += orLineHeight;
            }
        }
        int akty = you;
        int hlh = DMBRDymoPrinter.mm(6.0);
        int signWidth = DMBRDymoPrinter.mm(4.0);
        int datw = 51;
        int totwidth = this.ivRechts - this.ivLinks;
        int gtWidth = totwidth - signWidth - datw - 39;
        int pos1 = this.ivLinks;
        int pos2 = pos1 + signWidth;
        int pos3 = pos2 + 39;
        int pos4 = pos3 + datw;
        LabelMaker.make(g, "", FontManagerUS.SSB10, pos1, akty, signWidth, hlh, 0, 0, null);
        LabelMaker.make(g, "ID", FontManagerUS.SSB10, pos2, akty, 39, hlh, 0, 0, null);
        LabelMaker.make(g, "Born", FontManagerUS.SSB10, pos3, akty, datw, hlh, 0, 0, null);
        LabelMaker.make(g, "Genotype", FontManagerUS.SSB10, pos4, akty, gtWidth, hlh, 0, 0, null);
        DMBRDymoPrinter.drawRect(g, this.ivLinks, akty, pos1, akty + hlh, DMBRDymoPrinter.mm(0.8));
        DMBRDymoPrinter.drawRect(g, pos1, akty, pos2, akty + hlh, DMBRDymoPrinter.mm(0.8));
        DMBRDymoPrinter.drawRect(g, pos2, akty, pos3, akty + hlh, DMBRDymoPrinter.mm(0.8));
        DMBRDymoPrinter.drawRect(g, pos3, akty, pos4, akty + hlh, DMBRDymoPrinter.mm(0.8));
        DMBRDymoPrinter.drawRect(g, pos4, akty, this.ivRechts, akty + hlh, DMBRDymoPrinter.mm(0.8));
        int yVorMaeusen = akty += hlh;
        int yd = akty;
        Vector v = c.getActualMice();
        int i = 0;
        while (i < v.size()) {
            Mouse mausi = (Mouse)v.elementAt(i);
            String gts = mausi.getGenotype();
            gts = gts != null && !gts.equals("?") ? " " + gts + " " : "";
            String ets = mausi.getCLLWEartagString("?", true, true);
            Date bds = DMBRDymoPrinter.getBirthday(mausi);
            int sex = mausi.getSex();
            if (sex == 1) {
                LabelMaker.make(g, DefaultManager.getMale(), FontManagerUS.SSP9, pos1, yd, signWidth, 13, 0, 0, null);
            } else if (sex == 2) {
                LabelMaker.make(g, DefaultManager.getFemale(), FontManagerUS.SSP9, pos1, yd, signWidth, 13, 0, 0, null);
            }
            LabelMaker.make(g, ets, FontManagerUS.SSP9, pos2, yd, 39, 13, 0, 0, null);
            LabelMaker.makeWithDate(g, bds, FontManagerUS.SSP9, pos3, yd, datw, 13, 0, 0, null);
            LabelMaker.make(g, gts, FontManagerUS.SSP9, pos4, yd, gtWidth, 13, 0, 2, null);
            yd += 13;
            ++i;
        }
        g.setStroke(new BasicStroke(1.0f));
        g.drawLine(this.ivLinks, yd, this.ivRechts, yd);
        g.drawLine(pos1, yd, pos1, yVorMaeusen);
        g.drawLine(pos2, yd, pos2, yVorMaeusen);
        g.drawLine(pos3, yd, pos3, yVorMaeusen);
        g.drawLine(pos4, yd, pos4, yVorMaeusen);
        DMBRDymoPrinter.drawRect(g, this.ivLinks, this.ivOben, this.ivRechts, this.ivUnten, DMBRDymoPrinter.mm(0.8));
    }

    private static String getGenotype(Mouse mausi) {
        if (mausi != null) {
            return mausi.getGenotype();
        }
        return "";
    }

    private static String getEartag(Mouse mausi) {
        if (mausi != null) {
            return mausi.getCLLWEartagString("?", true, true);
        }
        return "";
    }

    private static String getJustEartag(long mausid, String group) {
        int et;
        Mouse mausi;
        if (mausid != 0L && (mausi = MouseManager.getMouse(mausid, group)) != null && (et = mausi.getInt("MOS_EARTAG", -1)) > 0) {
            return Integer.toString(et);
        }
        return "";
    }

    private static Date getBirthday(Mouse mausi) {
        if (mausi != null) {
            return mausi.getDate("MOS_BIRTHDAY");
        }
        return null;
    }

    private static Date getPlugday(Mouse mausi) {
        if (mausi != null) {
            return mausi.getDate("MOS_PLUGDATE");
        }
        return null;
    }

    private static void makeFill(Cage c, Graphics2D g, int links, int oben, int rechts, int unten) {
        Color[] ccol = c.getColor(0);
        if (ccol != null && ccol.length != 0) {
            if (ccol.length == 1 && ccol[0] != CageColorManager.NULL_COLOR && !(ccol[0] instanceof MusterColor)) {
                DMBRDymoPrinter.fillRect(g, links, oben, rechts, unten, ccol[0]);
            } else {
                Graphics2D g2d = g;
                g2d.setPaint(CageDisplayManager.getTexture(links, 0, ccol, rechts - links, true));
                DMBRDymoPrinter.fillRect(g, links, oben, rechts, unten, null);
            }
        }
    }
}

