/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.labelprinters;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.FontManagerUS;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.printing.PageFormatGenerator;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.printing.util.LabelMaker;
import mausoleum.printing.util.Wurf;

public class DZNEMagdeburg
extends LabelPrinter {
    private static final int LINE_HEIGHT = 14;
    private static final double RAND = 6.0;
    private static final String[] ORDER = new String[]{"oo", "ol", "lo", "ll", "oll", "llo"};
    private static final Comparator MOUSE_TAG_SORTER = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Mouse && o2 instanceof Mouse) {
                Mouse m1 = (Mouse)o1;
                Mouse m2 = (Mouse)o2;
                String s1 = m1.getString("MOS_ANTAG", "").toLowerCase().trim();
                String s2 = m2.getString("MOS_ANTAG", "").toLowerCase().trim();
                int i1 = 9999;
                int i2 = 9999;
                int i = 0;
                while (i < ORDER.length && i1 == 9999) {
                    if (ORDER[i].equalsIgnoreCase(s1)) {
                        i1 = i;
                    }
                    ++i;
                }
                i = 0;
                while (i < ORDER.length && i2 == 9999) {
                    if (ORDER[i].equalsIgnoreCase(s2)) {
                        i2 = i;
                    }
                    ++i;
                }
                if (i1 < i2) {
                    return -1;
                }
                if (i1 > i2) {
                    return 1;
                }
            }
            return 0;
        }
    };
    private int ivLinks = 0;
    private int ivRechts = 0;
    private int ivOben = 0;
    private int ivUnten = 0;

    public DZNEMagdeburg() {
        super("DZNE Magdeburg", 212.59842519685043, 255.1181102362205);
        PageFormatGenerator.createPageformatForLabelPrinter(this);
        this.ivLinks = 17;
        this.ivRechts = (int)(this.ivWidth - 17.007874015748033);
        this.ivOben = 17;
        this.ivUnten = (int)(this.ivHeight - 17.007874015748033);
    }

    public LabelPrinter getClone() {
        DZNEMagdeburg clone = new DZNEMagdeburg();
        this.copyValues(clone);
        return clone;
    }

    public void simplePrint(Cage cage, Graphics graphics) {
        if (cage.isMatingCage()) {
            this.printMatingCage((Graphics2D)graphics, cage);
        } else {
            this.printStockCage((Graphics2D)graphics, cage);
        }
    }

    private void printMatingCage(Graphics2D g, Cage c) {
        int earTagWidth;
        Vector males = new Vector();
        Vector females = new Vector();
        Wurf.findSexActiveMice(c, null, males, females, null);
        int akty = this.ivOben;
        LabelMaker.make(g, c.getNumberString(), FontManagerUS.SSB10, this.ivLinks, akty, 100, 14, 0, 2, null);
        akty += 16;
        int signWith = earTagWidth = 51;
        int restWidth = this.ivRechts - this.ivLinks - signWith;
        int restStart = this.ivLinks + earTagWidth;
        Mouse father = null;
        if (males.size() == 1) {
            father = (Mouse)males.elementAt(0);
            if (!c.isMouseInside(father.getLong("IDO_ID"))) {
                DZNEMagdeburg.fillRect(g, this.ivLinks, akty, this.ivRechts, akty + 42, Color.lightGray);
            }
            LabelMaker.make(g, DefaultManager.getMale(), FontManagerUS.SSB14, this.ivLinks, akty, earTagWidth, 28, 0, 0, null);
            LabelMaker.make(g, Long.toString(father.getID()), FontManagerUS.SSB10, this.ivLinks, akty + 28, earTagWidth, 14, 0, 0, Wurf.FATHER_COLORS[0]);
            DZNEMagdeburg.drawRect(g, this.ivLinks, akty, this.ivLinks + earTagWidth, akty + 28, DZNEMagdeburg.mm(0.1));
            DZNEMagdeburg.drawRect(g, this.ivLinks, akty, this.ivLinks + earTagWidth, akty + 42, DZNEMagdeburg.mm(0.1));
            DZNEMagdeburg.drawRect(g, this.ivLinks, akty, this.ivRechts, akty + 42, DZNEMagdeburg.mm(0.8));
            int iay = akty;
            LabelMaker.make(g, " " + father.getCLLWLineString() + " ", FontManagerUS.SSB10, restStart, iay, restWidth, 14, 0, 2, null);
            DZNEMagdeburg.drawRect(g, restStart, iay, restStart + restWidth, iay + 14, DZNEMagdeburg.mm(0.1));
            LabelMaker.make(g, " " + LabelMaker.getVeryShortDateString(DZNEMagdeburg.getBirthday(father)) + " ", FontManagerUS.SSB10, restStart, iay += 14, restWidth / 2, 14, 0, 0, null);
            DZNEMagdeburg.drawRect(g, restStart, iay, restStart + restWidth / 2, iay + 14, DZNEMagdeburg.mm(0.1));
            LabelMaker.make(g, " " + father.getString("MOS_ANTAG", "") + " ", FontManagerUS.SSB10, restStart + restWidth / 2, iay, restWidth - restWidth / 2, 14, 0, 0, null);
            DZNEMagdeburg.drawRect(g, restStart + restWidth / 2, iay, restStart + restWidth, iay + 14, DZNEMagdeburg.mm(0.1));
            LabelMaker.make(g, " " + father.getGenerationString(true) + " ", FontManagerUS.SSB10, restStart, iay += 14, restWidth, 14, 0, 2, null);
            DZNEMagdeburg.drawRect(g, restStart, iay, restStart + restWidth, iay + 14, DZNEMagdeburg.mm(0.1));
            akty += 42;
        }
        int i = 0;
        while (i < females.size()) {
            Mouse mother = (Mouse)females.elementAt(i);
            if (!c.isMouseInside(mother.getLong("IDO_ID"))) {
                DZNEMagdeburg.fillRect(g, this.ivLinks, akty, this.ivRechts, akty + 42, Color.lightGray);
            }
            LabelMaker.make(g, DefaultManager.getFemale(), FontManagerUS.SSB14, this.ivLinks, akty, earTagWidth, 28, 0, 0, null);
            LabelMaker.make(g, Long.toString(mother.getID()), FontManagerUS.SSB10, this.ivLinks, akty + 28, earTagWidth, 14, 0, 0, Wurf.MOTHER_COLORS[i % Wurf.MOTHER_COLORS.length]);
            DZNEMagdeburg.drawRect(g, this.ivLinks, akty, this.ivLinks + earTagWidth, akty + 28, DZNEMagdeburg.mm(0.1));
            DZNEMagdeburg.drawRect(g, this.ivLinks, akty, this.ivLinks + earTagWidth, akty + 42, DZNEMagdeburg.mm(0.1));
            DZNEMagdeburg.drawRect(g, this.ivLinks, akty, this.ivRechts, akty + 42, DZNEMagdeburg.mm(0.8));
            int iay = akty;
            LabelMaker.make(g, " " + mother.getCLLWLineString() + " ", FontManagerUS.SSB10, restStart, iay, restWidth, 14, 0, 2, null);
            DZNEMagdeburg.drawRect(g, restStart, iay, restStart + restWidth, iay + 14, DZNEMagdeburg.mm(0.1));
            LabelMaker.make(g, " " + LabelMaker.getVeryShortDateString(DZNEMagdeburg.getBirthday(mother)) + " ", FontManagerUS.SSB10, restStart, iay += 14, restWidth / 2, 14, 0, 0, null);
            DZNEMagdeburg.drawRect(g, restStart, iay, restStart + restWidth / 2, iay + 14, DZNEMagdeburg.mm(0.1));
            LabelMaker.make(g, " " + mother.getString("MOS_ANTAG", "") + " ", FontManagerUS.SSB10, restStart + restWidth / 2, iay, restWidth - restWidth / 2, 14, 0, 0, null);
            DZNEMagdeburg.drawRect(g, restStart + restWidth / 2, iay, restStart + restWidth, iay + 14, DZNEMagdeburg.mm(0.1));
            LabelMaker.make(g, " " + mother.getGenerationString(true) + " ", FontManagerUS.SSB10, restStart, iay += 14, restWidth / 2, 14, 0, 2, null);
            DZNEMagdeburg.drawRect(g, restStart, iay, restStart + restWidth, iay + 14, DZNEMagdeburg.mm(0.1));
            akty += 42;
            ++i;
        }
        int yStartWurfTabelleHeader = akty;
        int totwidth = this.ivRechts - this.ivLinks;
        int datw = 68;
        int nbw1 = totwidth - 2 * datw;
        int x3 = this.ivLinks + datw;
        int x4 = x3 + nbw1;
        int yStartWurfZeilen = yStartWurfTabelleHeader + 14;
        LabelMaker.make(g, "Wurfdatum", FontManagerUS.SSB10, this.ivLinks, yStartWurfTabelleHeader, datw, yStartWurfZeilen - yStartWurfTabelleHeader, 0, 0, null);
        LabelMaker.make(g, "Anzahl", FontManagerUS.SSB10, x3, yStartWurfTabelleHeader, nbw1, yStartWurfZeilen - yStartWurfTabelleHeader, 0, 0, null);
        LabelMaker.make(g, "Absetzdatum", FontManagerUS.SSB10, x4, yStartWurfTabelleHeader, datw, yStartWurfZeilen - yStartWurfTabelleHeader, 0, 0, null);
        g.setStroke(new BasicStroke(1.0f));
        g.drawLine(x3, this.ivUnten, x3, yStartWurfTabelleHeader);
        g.drawLine(x4, this.ivUnten, x4, yStartWurfTabelleHeader);
        int ly = yStartWurfZeilen;
        while (ly <= this.ivUnten) {
            g.drawLine(this.ivLinks, ly, this.ivRechts, ly);
            ly += 14;
        }
        DZNEMagdeburg.drawRect(g, this.ivLinks, this.ivOben, this.ivRechts, this.ivUnten, DZNEMagdeburg.mm(0.8));
    }

    private static void drawRect(Graphics2D g, int ulx, int uly, int lrx, int lry, float width) {
        g.setColor(Color.black);
        g.setStroke(new BasicStroke(width));
        g.drawRect(ulx, uly, lrx - ulx, lry - uly);
    }

    private static void fillRect(Graphics2D g, int ulx, int uly, int lrx, int lry, Color col) {
        g.setColor(col);
        g.fillRect(ulx, uly, lrx - ulx, lry - uly);
    }

    private void printStockCage(Graphics2D g, Cage c) {
        Mouse mouse;
        Long id;
        int akty = this.ivOben;
        int totwidth = this.ivRechts - this.ivLinks;
        Vector mice = c.getActualMice();
        LabelMaker.make(g, String.valueOf(c.getNumberString()) + " " + AllgUtils.getTypeString(c, mice, 7, true), FontManagerUS.SSB10, this.ivLinks, akty, totwidth, 14, 0, 2, null);
        g.drawLine(this.ivLinks, akty += 14, this.ivRechts, akty);
        akty += 2;
        HashSet<Long> motherIDS = new HashSet<Long>();
        HashSet<Long> fatherIDS = new HashSet<Long>();
        Iterator iter = mice.iterator();
        while (iter.hasNext()) {
            Mouse mouse2 = (Mouse)iter.next();
            Long l = (Long)mouse2.get("MOS_MOTHER");
            if (l != null) {
                motherIDS.add(l);
            }
            if ((l = (Long)mouse2.get("MOS_FATHER")) == null) continue;
            fatherIDS.add(l);
        }
        int sw = 17;
        int idwp = 39;
        int lw = totwidth - sw - idwp;
        int ppos1 = this.ivLinks;
        int ppos2 = ppos1 + sw;
        int ppos3 = ppos2 + idwp;
        int plineHeight = 13;
        Iterator iter2 = motherIDS.iterator();
        while (iter2.hasNext()) {
            id = (Long)iter2.next();
            mouse = MouseManager.getMouse(id, c.getGroup());
            if (mouse == null) continue;
            LabelMaker.make(g, " " + DefaultManager.getFemale() + " ", FontManagerUS.SSP10, ppos1, akty, sw, plineHeight, 0, 0, null);
            LabelMaker.make(g, " " + Long.toString(mouse.getID()) + " ", FontManagerUS.SSP10, ppos2, akty, idwp, plineHeight, 0, 0, null);
            LabelMaker.make(g, " " + mouse.getCLLWLineString() + " ", FontManagerUS.SSP10, ppos3, akty, lw, plineHeight, 0, 2, null);
            akty += plineHeight;
        }
        iter2 = fatherIDS.iterator();
        while (iter2.hasNext()) {
            id = (Long)iter2.next();
            mouse = MouseManager.getMouse(id, c.getGroup());
            if (mouse == null) continue;
            LabelMaker.make(g, " " + DefaultManager.getMale() + " ", FontManagerUS.SSP10, ppos1, akty, sw, plineHeight, 0, 0, null);
            LabelMaker.make(g, " " + Long.toString(mouse.getID()) + " ", FontManagerUS.SSP10, ppos2, akty, idwp, plineHeight, 0, 0, null);
            LabelMaker.make(g, " " + mouse.getCLLWLineString() + " ", FontManagerUS.SSP10, ppos3, akty, lw, plineHeight, 0, 2, null);
            akty += plineHeight;
        }
        if (!motherIDS.isEmpty() || !fatherIDS.isEmpty()) {
            g.drawLine(this.ivLinks, akty, this.ivRechts, akty);
            akty += 2;
        }
        String alles = String.valueOf(mice.size()) + " / " + AllgUtils.getTypeString(c, mice, 4, true) + " / " + AllgUtils.getTypeString(c, mice, 5, true) + " / " + AllgUtils.getTypeString(c, mice, 6, true);
        LabelMaker.make(g, " " + alles + " ", FontManagerUS.SSB10, this.ivLinks, akty, totwidth, 12, 0, 2, null);
        akty += 14;
        int hlh = DZNEMagdeburg.mm(6.0);
        int idw = 39;
        int codew = 34;
        int gtWidth = totwidth - idw - codew;
        int pos1 = this.ivLinks;
        int pos2 = pos1 + idw;
        int pos3 = pos2 + codew;
        LabelMaker.make(g, "ID", FontManagerUS.SSB11, pos1, akty, idw, hlh, 0, 0, null);
        LabelMaker.make(g, "Code", FontManagerUS.SSB11, pos2, akty, codew, hlh, 0, 0, null);
        LabelMaker.make(g, "Genotype", FontManagerUS.SSB11, pos3, akty, gtWidth, hlh, 0, 0, null);
        DZNEMagdeburg.drawRect(g, this.ivLinks, akty, pos1, akty + hlh, DZNEMagdeburg.mm(0.8));
        DZNEMagdeburg.drawRect(g, pos1, akty, pos2, akty + hlh, DZNEMagdeburg.mm(0.8));
        DZNEMagdeburg.drawRect(g, pos2, akty, pos3, akty + hlh, DZNEMagdeburg.mm(0.8));
        DZNEMagdeburg.drawRect(g, pos3, akty, this.ivRechts, akty + hlh, DZNEMagdeburg.mm(0.8));
        int lineHeight = 15;
        int yVorMaeusen = akty += hlh;
        int yd = akty;
        Vector v = c.getActualMice();
        Collections.sort(v, MOUSE_TAG_SORTER);
        int i = 0;
        while (i < v.size()) {
            Mouse mausi = (Mouse)v.elementAt(i);
            String gts = mausi.getGenotype();
            gts = gts != null && !gts.equals("?") ? " " + gts + " " : "";
            LabelMaker.make(g, Long.toString(mausi.getID()), FontManagerUS.SSP10, pos1, yd, idw, lineHeight, 0, 0, null);
            LabelMaker.make(g, mausi.getString("MOS_ANTAG", ""), FontManagerUS.SSP10, pos2, yd, codew, lineHeight, 0, 0, null);
            LabelMaker.make(g, gts, FontManagerUS.SSP10, pos3, yd, gtWidth, lineHeight, 0, 2, null);
            yd += lineHeight;
            ++i;
        }
        g.setStroke(new BasicStroke(1.0f));
        g.drawLine(this.ivLinks, yd, this.ivRechts, yd);
        g.drawLine(pos1, yd, pos1, yVorMaeusen);
        g.drawLine(pos2, yd, pos2, yVorMaeusen);
        g.drawLine(pos3, yd, pos3, yVorMaeusen);
        DZNEMagdeburg.drawRect(g, this.ivLinks, this.ivOben, this.ivRechts, this.ivUnten, DZNEMagdeburg.mm(0.8));
    }

    private static Date getBirthday(Mouse mausi) {
        if (mausi != null) {
            return mausi.getDate("MOS_BIRTHDAY");
        }
        return null;
    }
}

