/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.labelprinters;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.XMLNode;
import de.hannse.netobjects.util.XMLParser;
import java.awt.Color;
import java.awt.Font;
import mausoleum.cage.Cage;
import mausoleum.helper.FontManager;
import mausoleum.helper.LitterHelper;
import mausoleum.helper.LongPunkt;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.printing.labelprinters.KoelnPrinter;
import mausoleum.printing.labelprinters.LabelPrinter;

public class DZNEStockPrinter
extends KoelnPrinter {
    private static final String XML = "\t<LabelPrinter name=\"DZNE_Stock\" weddingsred=\"true\" rotated=\"1\" onecardperpage=\"1\" width=\"131\" height=\"75\" top=\"5\" left=\"5\" right=\"10\">\n\t\t<lines>\n\t\t\t<line typ=\"LicenseWithOwnersNamePreferred\" font=\"4\"></line>\n\t\t\t<line typ=\"Empty\" font=\"4\"></line>\n\t\t\t<line typ=\"PolygonOhneOwner\" font=\"5\" orientation=\"center\" ovrCageColorMode=\"18\"></line>\n\t\t\t<line typ=\"Line\" font=\"4\"></line>\n\t\t\t<line typ=\"Strain\" font=\"4\"></line>\n\t\t\t<line typ=\"Comment\" font=\"3\"></line>\n\t\t</lines>\n\t\t<mice>\n\t\t\t<col typ=\"EarTag\" font=\"3\"></col>\n\t\t\t<col typ=\"Sex\" font=\"3\"></col>\n\t\t\t<col typ=\"Genotype\" font=\"3\"></col>\n\t\t\t<col typ=\"Birthday\" font=\"3\"></col>\n\t\t\t<col typ=\"Entryday\" font=\"3\"></col>\n\t\t\t<col typ=\"Plugday\" font=\"3\"></col>\n\t\t</mice>\n\t</LabelPrinter>\n";
    private static final String XML_BACKCROSS = "\t<LabelPrinter name=\"DZNE backcrossing\" weddingsred=\"true\" rotated=\"1\" onecardperpage=\"1\" width=\"131\" height=\"75\" top=\"5\" left=\"5\" right=\"10\">\n\t\t<lines>\n\t\t\t<line typ=\"Text\" font=\"3\" contents=\"BACKCROSSING\" orientation=\"center\"></line>\n\t\t\t<line typ=\"LicenseWithOwnersNamePreferred\" font=\"4\"></line>\n\t\t\t<line typ=\"Empty\" font=\"4\"></line>\n\t\t\t<line typ=\"PolygonOhneOwner\" font=\"5\" orientation=\"center\" ovrCageColorMode=\"18\"></line>\n\t\t\t<line typ=\"Line\" font=\"4\"></line>\n\t\t\t<line typ=\"Strain\" font=\"4\"></line>\n\t\t\t<line typ=\"Comment\" font=\"3\"></line>\n\t\t</lines>\n\t\t<mice>\n\t\t\t<col typ=\"EarTag\" font=\"3\"></col>\n\t\t\t<col typ=\"Sex\" font=\"3\"></col>\n\t\t\t<col typ=\"Genotype\" font=\"3\"></col>\n\t\t\t<col typ=\"Birthday\" font=\"3\"></col>\n\t\t\t<col typ=\"Entryday\" font=\"3\"></col>\n\t\t\t<col typ=\"Plugday\" font=\"3\"></col>\n\t\t</mice>\n\t</LabelPrinter>\n";
    private boolean ivBackcrossMode = false;
    private boolean ivWithS2 = false;

    public static DZNEStockPrinter createNormalPrinter(boolean withS2) {
        DZNEStockPrinter pr = new DZNEStockPrinter(XMLParser.parseXMLString(XML));
        pr.ivName = "DZNE Stock";
        pr.ivWithS2 = withS2;
        if (pr.ivWithS2) {
            pr.ivName = String.valueOf(pr.ivName) + " S2";
        }
        pr.ivBackcrossMode = false;
        pr.ivGenotypePralineMode = true;
        return pr;
    }

    public static DZNEStockPrinter createBackcrossPrinter() {
        DZNEStockPrinter pr = new DZNEStockPrinter(XMLParser.parseXMLString(XML_BACKCROSS));
        pr.ivName = "DZNE backcrossing";
        pr.ivBackcrossMode = true;
        return pr;
    }

    private DZNEStockPrinter(XMLNode xn) {
        super(xn);
        this.ivGroupMiceByParents = true;
        this.ivUseVeryShortDate = true;
        this.ivName = "DZNE Stock";
    }

    private DZNEStockPrinter() {
        this.ivGroupMiceByParents = true;
        this.ivUseVeryShortDate = true;
        this.ivName = "DZNE Stock";
    }

    public LabelPrinter getClone() {
        DZNEStockPrinter clone = new DZNEStockPrinter();
        this.copyValues(clone);
        clone.ivBackcrossMode = this.ivBackcrossMode;
        clone.ivWithS2 = this.ivWithS2;
        return clone;
    }

    public String getCageTitelExtra(Cage c) {
        return this.ivWithS2 ? "S2" : null;
    }

    public Color getCageTitelExtraColor() {
        return this.ivWithS2 ? Color.red : null;
    }

    public Color[] getCageColor(Cage cage) {
        return cage.getColor(18);
    }

    public Font getParentFont(Font model) {
        return FontManager.getFont(model.getName(), 0, model.getSize() - 1);
    }

    public String getParentString(Cage cage, LongPunkt lp) {
        StringBuffer msb = new StringBuffer();
        String group = cage.getString("IDO_GROUP", null);
        if (group != null) {
            Mouse vater = null;
            if (lp.ivX > 0L) {
                vater = (Mouse)ObjectStore.getObjectDeadOrAlive(1, lp.ivX, group, null, false);
            }
            msb.append(String.valueOf(DefaultManager.getMale()) + " ").append(DZNEStockPrinter.getParentString(vater)).append(" ");
            Mouse mutter = null;
            if (lp.ivY > 0L) {
                mutter = (Mouse)ObjectStore.getObjectDeadOrAlive(1, lp.ivY, group, null, false);
            }
            msb.append(" " + DefaultManager.getFemale() + " ").append(DZNEStockPrinter.getParentString(mutter));
            if (this.ivBackcrossMode) {
                msb.append("\n").append(Babel.get("STRAIN")).append(": ");
                msb.append(Mouse.getStrainInfo(LitterHelper.getPupStrain(vater, mutter), Babel.get("NOSTRAIN"), group));
            }
            return msb.toString();
        }
        return null;
    }

    private static String getParentString(Mouse parent) {
        if (parent != null) {
            StringBuffer msb = new StringBuffer();
            msb.append(parent.getCLLWEartagString());
            msb.append(" ").append(parent.getCLLWLineString());
            msb.append(" ").append(parent.getCLLWStrainString());
            msb.append(" ").append(parent.getCLLWBirthDayString(true));
            return msb.toString();
        }
        return "[?]";
    }
}

