/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.labelprinters;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Date;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.helper.FontManagerUS;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.printing.PageFormatGenerator;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.printing.util.LabelMaker;
import mausoleum.printing.util.Wurf;
import mausoleum.visit.Visit;

public class HeidelbergPrinter
extends LabelPrinter {
    public HeidelbergPrinter() {
        super("EMBL-Heidelberg", 297.6377952755906, 419.52755905511816);
        PageFormatGenerator.createPageformatForLabelPrinter(this);
    }

    public LabelPrinter getClone() {
        HeidelbergPrinter clone = new HeidelbergPrinter();
        this.copyValues(clone);
        return clone;
    }

    public void simplePrint(Cage cage, Graphics graphics) {
        if (cage.isMatingCage()) {
            this.printMatingCage((Graphics2D)graphics, cage);
        } else {
            this.printStockCage((Graphics2D)graphics, cage);
        }
    }

    private void printMatingCage(Graphics2D g, Cage c) {
        String ownerName;
        Vector males = new Vector();
        Vector females = new Vector();
        Vector wuerfe = Wurf.collectWuerfeForPrinters(c, males, females, false, 1, 2, null, false, false, false, true, true, false, true, false, false, false);
        if (wuerfe == null) {
            this.printStockCage(g, c);
            return;
        }
        int x0 = 19;
        int x1 = 121;
        int x2 = 280;
        int x3 = 73;
        int x4 = 99;
        int x5 = 124;
        int x5a = 164;
        int x6 = 204;
        int x7 = 229;
        int x8 = 255;
        int y0 = 19;
        int y1 = 59;
        int y2 = 127;
        int y3 = 195;
        int y4 = 204;
        int y5 = 243;
        int y6 = 277;
        int y7 = 408;
        int y8 = 260;
        this.drawRect(g, x0, y0, x2, y3, HeidelbergPrinter.mm(0.8));
        this.fillRect(g, x0, y0, x2, y1, Color.lightGray);
        this.drawRect(g, x0, y0, x2, y1, HeidelbergPrinter.mm(0.8));
        LabelMaker.make(g, c.getNumberString(), FontManagerUS.SSB16, HeidelbergPrinter.mm(9.0), y0 + HeidelbergPrinter.mm(2.0), HeidelbergPrinter.mm(23.0), HeidelbergPrinter.mm(10.0), HeidelbergPrinter.mm(0.8), 0, Color.white);
        String roomname = c.getRoomName();
        if (roomname != null && roomname.length() != 0) {
            LabelMaker.make(g, roomname, FontManagerUS.SSB12, HeidelbergPrinter.mm(35.0), HeidelbergPrinter.mm(9.0), HeidelbergPrinter.mm(55.0), HeidelbergPrinter.mm(4.0), 0, 0, null);
        }
        if ((ownerName = c.getLabelOwnerString(false)) != null) {
            LabelMaker.make(g, ownerName, FontManagerUS.SSB11, HeidelbergPrinter.mm(35.0), HeidelbergPrinter.mm(15.0), HeidelbergPrinter.mm(55.0), HeidelbergPrinter.mm(4.0), 0, 0, null);
        }
        Mouse father = null;
        if (males.size() == 1) {
            father = (Mouse)males.elementAt(0);
            LabelMaker.make(g, DefaultManager.getMale(), FontManagerUS.SSB16, HeidelbergPrinter.mm(9.0), HeidelbergPrinter.mm(22.0), HeidelbergPrinter.mm(8.0), HeidelbergPrinter.mm(8.0), 0, 0, null);
            LabelMaker.make(g, "Strain/Line", FontManagerUS.SSP10, HeidelbergPrinter.mm(18.0), HeidelbergPrinter.mm(22.0), HeidelbergPrinter.mm(22.0), HeidelbergPrinter.mm(4.0), 0, 2, null);
            if (father != null) {
                StringBuffer msb = new StringBuffer();
                msb.append(father.getCLLWStrainString()).append("/").append(father.getCLLWLineString());
                LabelMaker.make(g, msb.toString(), FontManagerUS.SSB10, HeidelbergPrinter.mm(18.0), HeidelbergPrinter.mm(27.0), HeidelbergPrinter.mm(22.0), HeidelbergPrinter.mm(4.0), 0, 2, null);
            }
            int yn = 96;
            int w1 = 42;
            int w2 = 53;
            int tx1 = 25;
            int tx2 = tx1 + w1;
            int lh = 12;
            LabelMaker.make(g, "Date in", FontManagerUS.SSP10, tx1, yn, w1, lh, 0, 2, null);
            LabelMaker.makeWithDate(g, this.getInDate(father, c), FontManagerUS.SSB10, tx2, yn, w2, lh, 0, 0, null);
            this.drawRect(g, tx2, yn, tx2 + w2, yn + lh, 1.0f);
            LabelMaker.make(g, "ID", FontManagerUS.SSP10, tx1, yn += lh, w1, lh, 0, 2, null);
            LabelMaker.make(g, this.getEartag(father), FontManagerUS.SSB10, tx2, yn, w2, lh, 0, 0, Wurf.FATHER_COLORS[0]);
            this.drawRect(g, tx2, yn, tx2 + w2, yn + lh, 1.0f);
            LabelMaker.make(g, "Born", FontManagerUS.SSP10, tx1, yn += lh, w1, lh, 0, 2, null);
            LabelMaker.makeWithDate(g, this.getBirthday(father), FontManagerUS.SSB10, tx2, yn, w2, lh, 0, 0, null);
            this.drawRect(g, tx2, yn, tx2 + w2, yn + lh, 1.0f);
            yn += lh;
        }
        this.drawRect(g, x0, y1, x1, y3, HeidelbergPrinter.mm(0.8));
        this.drawRect(g, x1, y1, x2, y2, HeidelbergPrinter.mm(0.8));
        if (females.size() > 0) {
            this.makeMotherBox((Mouse)females.elementAt(0), c, 21, g, Wurf.MOTHER_COLORS[0]);
        }
        if (females.size() > 1) {
            this.makeMotherBox((Mouse)females.elementAt(1), c, 46, g, Wurf.MOTHER_COLORS[1]);
        }
        this.drawRect(g, x0, y4, x2, y7, HeidelbergPrinter.mm(0.8));
        this.fillRect(g, x0, y4, x2, y5, Color.lightGray);
        this.drawRect(g, x0, y4, x2, y5, HeidelbergPrinter.mm(0.8));
        LabelMaker.make(g, c.getNumberString(), FontManagerUS.SSB16, HeidelbergPrinter.mm(9.0), y4 + HeidelbergPrinter.mm(2.0), HeidelbergPrinter.mm(23.0), HeidelbergPrinter.mm(10.0), HeidelbergPrinter.mm(0.8), 0, Color.white);
        LabelMaker.make(g, "DOB", FontManagerUS.SSB11, x0, y5, x3 - x0, y6 - y5, 0, 0, null);
        LabelMaker.make(g, "Born", FontManagerUS.SSB11, x3, y5, x5 - x3, y8 - y5, 0, 0, null);
        LabelMaker.make(g, DefaultManager.getMale(), FontManagerUS.SSB11, x3, y8, x4 - x3, y6 - y8, 0, 0, null);
        LabelMaker.make(g, DefaultManager.getFemale(), FontManagerUS.SSB11, x4, y8, x5 - x4, y6 - y8, 0, 0, null);
        LabelMaker.make(g, "Parents", FontManagerUS.SSB11, x5, y5, x6 - x5, y8 - y5, 0, 0, null);
        LabelMaker.make(g, DefaultManager.getMale(), FontManagerUS.SSB11, x5, y8, x5a - x5, y6 - y8, 0, 0, null);
        LabelMaker.make(g, DefaultManager.getFemale(), FontManagerUS.SSB11, x5a, y8, x6 - x5a, y6 - y8, 0, 0, null);
        LabelMaker.make(g, "Left", FontManagerUS.SSB11, x6, y5, x2 - x6, y8 - y5, 0, 0, null);
        LabelMaker.make(g, DefaultManager.getMale(), FontManagerUS.SSB11, x6, y8, x7 - x6, y6 - y8, 0, 0, null);
        LabelMaker.make(g, DefaultManager.getFemale(), FontManagerUS.SSB11, x7, y8, x8 - x7, y6 - y8, 0, 0, null);
        LabelMaker.make(g, "tot", FontManagerUS.SSB11, x8, y8, x2 - x8, y6 - y8, 0, 0, null);
        int y = y6;
        int i = 0;
        while (i < wuerfe.size()) {
            Wurf wurf = (Wurf)wuerfe.elementAt(i);
            LabelMaker.makeWithDate(g, wurf.ivDay, FontManagerUS.SSP10, x0, y, x3 - x0, 14, 0, 0, null);
            LabelMaker.make(g, wurf.ivNumMaleBorn, FontManagerUS.SSP10, x3, y, x4 - x3, 14, 0, 0, null);
            LabelMaker.make(g, wurf.ivNumFemaleBorn, FontManagerUS.SSP10, x4, y, x5 - x4, 14, 0, 0, null);
            Color back = null;
            if (father != null && wurf.ivFatherID == father.getID()) {
                back = Wurf.FATHER_COLORS[0];
            }
            LabelMaker.make(g, this.getJustEartag(wurf.ivFatherID, c.getGroup()), FontManagerUS.SSP10, x5, y, x5a - x5, 14, 0, 0, back);
            back = null;
            if (females.size() > 0 && wurf.ivMotherID == ((Mouse)females.elementAt(0)).getID()) {
                back = Wurf.MOTHER_COLORS[0];
            } else if (females.size() > 1 && wurf.ivMotherID == ((Mouse)females.elementAt(1)).getID()) {
                back = Wurf.MOTHER_COLORS[1];
            }
            LabelMaker.make(g, this.getJustEartag(wurf.ivMotherID, c.getGroup()), FontManagerUS.SSP10, x5a, y, x6 - x5a, 14, 0, 0, back);
            LabelMaker.make(g, wurf.ivNumMaleLeft, FontManagerUS.SSP10, x6, y, x7 - x6, 14, 0, 0, null);
            LabelMaker.make(g, wurf.ivNumFemaleLeft, FontManagerUS.SSP10, x7, y, x8 - x7, 14, 0, 0, null);
            LabelMaker.make(g, wurf.ivNumBornTotal, FontManagerUS.SSP10, x8, y, x2 - x8, 14, 0, 0, null);
            y += 14;
            ++i;
        }
        if (y != y6) {
            g.setStroke(new BasicStroke(1.0f));
            g.drawLine(x3, y, x3, y6);
            g.drawLine(x4, y, x4, y6);
            g.drawLine(x5, y, x5, y6);
            g.drawLine(x5a, y, x5a, y6);
            g.drawLine(x6, y, x6, y6);
            g.drawLine(x7, y, x7, y6);
            g.drawLine(x8, y, x8, y6);
            int ly = y6;
            while (ly <= y) {
                g.drawLine(x0, ly, x2, ly);
                ly += 14;
            }
        }
        this.drawRect(g, x0, y5, x3, y6, HeidelbergPrinter.mm(0.8));
        this.drawRect(g, x3, y5, x5, y6, HeidelbergPrinter.mm(0.8));
        this.drawRect(g, x5, y5, x6, y6, HeidelbergPrinter.mm(0.8));
        this.drawRect(g, x6, y5, x2, y6, HeidelbergPrinter.mm(0.8));
    }

    private void drawRect(Graphics2D g, int ulx, int uly, int lrx, int lry, float width) {
        g.setColor(Color.black);
        g.setStroke(new BasicStroke(width));
        g.drawRect(ulx, uly, lrx - ulx, lry - uly);
    }

    private void fillRect(Graphics2D g, int ulx, int uly, int lrx, int lry, Color col) {
        g.setColor(col);
        g.fillRect(ulx, uly, lrx - ulx, lry - uly);
    }

    private void makeMotherBox(Mouse mother, Cage c, int y, Graphics2D g, Color back) {
        LabelMaker.make(g, DefaultManager.getFemale(), FontManagerUS.SSB14, HeidelbergPrinter.mm(43.0), HeidelbergPrinter.mm(y), HeidelbergPrinter.mm(7.0), HeidelbergPrinter.mm(7.0), 0, 0, null);
        StringBuffer msb = new StringBuffer();
        if (mother != null) {
            msb.append(mother.getCLLWStrainString()).append("/").append(mother.getCLLWLineString());
        }
        LabelMaker.make(g, msb.toString(), FontManagerUS.SSP10, HeidelbergPrinter.mm(50.0), HeidelbergPrinter.mm(y), HeidelbergPrinter.mm(50.0), HeidelbergPrinter.mm(4.0), 0, 2, null);
        int yn = (int)(((double)y + 5.0) * 2.834645669291339);
        int w1 = 42;
        int w2 = 53;
        int x1 = 178;
        int x2 = x1 + w1;
        int lh = 12;
        LabelMaker.make(g, "Date in", FontManagerUS.SSP10, x1, yn, w1, lh, 0, 2, null);
        LabelMaker.makeWithDate(g, this.getInDate(mother, c), FontManagerUS.SSB10, x2, yn, w2, lh, 0, 0, null);
        this.drawRect(g, x2, yn, x2 + w2, yn + lh, 1.0f);
        LabelMaker.make(g, "ID", FontManagerUS.SSP10, x1, yn += lh, w1, lh, 0, 2, null);
        LabelMaker.make(g, this.getEartag(mother), FontManagerUS.SSB10, x2, yn, w2, lh, 0, 0, back);
        this.drawRect(g, x2, yn, x2 + w2, yn + lh, 1.0f);
        LabelMaker.make(g, "Born", FontManagerUS.SSP10, x1, yn += lh, w1, lh, 0, 2, null);
        LabelMaker.makeWithDate(g, this.getBirthday(mother), FontManagerUS.SSB10, x2, yn, w2, lh, 0, 0, null);
        this.drawRect(g, x2, yn, x2 + w2, yn + lh, 1.0f);
        LabelMaker.make(g, "Plug", FontManagerUS.SSP10, x1, yn += lh, w1, lh, 0, 2, null);
        LabelMaker.makeWithDate(g, this.getPlugday(mother), FontManagerUS.SSB10, x2, yn, w2, lh, 0, 0, null);
        this.drawRect(g, x2, yn, x2 + w2, yn + lh, 1.0f);
        yn += lh;
    }

    private void printStockCage(Graphics2D g, Cage c) {
        String ownerName;
        int x0 = 19;
        int x2 = 280;
        int x3 = 59;
        int x4 = 113;
        int x5 = 212;
        int y0 = 19;
        int y1 = 59;
        int y3 = 204;
        int y4 = 243;
        int y5 = 260;
        int y6 = 408;
        this.drawRect(g, x0, y0, x2, y3, HeidelbergPrinter.mm(0.8));
        this.fillRect(g, x0, y0, x2, y1, Color.lightGray);
        this.drawRect(g, x0, y0, x2, y1, HeidelbergPrinter.mm(0.8));
        LabelMaker.make(g, c.getNumberString(), FontManagerUS.SSB16, HeidelbergPrinter.mm(9.0), y0 + HeidelbergPrinter.mm(2.0), HeidelbergPrinter.mm(23.0), HeidelbergPrinter.mm(10.0), HeidelbergPrinter.mm(0.8), 0, Color.white);
        String roomname = c.getRoomName();
        if (roomname != null && roomname.length() != 0) {
            LabelMaker.make(g, roomname, FontManagerUS.SSB12, HeidelbergPrinter.mm(35.0), HeidelbergPrinter.mm(9.0), HeidelbergPrinter.mm(55.0), HeidelbergPrinter.mm(4.0), 0, 0, null);
        }
        if ((ownerName = c.getLabelOwnerString(false)) != null) {
            LabelMaker.make(g, ownerName, FontManagerUS.SSB11, HeidelbergPrinter.mm(35.0), HeidelbergPrinter.mm(15.0), HeidelbergPrinter.mm(55.0), HeidelbergPrinter.mm(4.0), 0, 0, null);
        }
        LabelMaker.make(g, "Line", FontManagerUS.SSB14, HeidelbergPrinter.mm(10.0), HeidelbergPrinter.mm(24.0), HeidelbergPrinter.mm(14.0), 20, 0, 2, null);
        LabelMaker.make(g, c.getLabelLineString(false, ", "), FontManagerUS.SP14, HeidelbergPrinter.mm(25.0), HeidelbergPrinter.mm(24.0), HeidelbergPrinter.mm(72.0), 20, 1, 0, null);
        LabelMaker.make(g, c.getLabelLineString(false, ", "), FontManagerUS.SP11, HeidelbergPrinter.mm(34.0), HeidelbergPrinter.mm(75.0), HeidelbergPrinter.mm(63.0), 15, 1, 0, null);
        int y = HeidelbergPrinter.mm(48.0);
        Vector mice = c.getActualMice();
        int numf = 0;
        int numm = 0;
        int i = 0;
        while (i < mice.size()) {
            Mouse mausi = (Mouse)mice.elementAt(i);
            if (mausi.getSex() == 1) {
                ++numm;
            } else if (mausi.getSex() == 2) {
                ++numf;
            }
            ++i;
        }
        String insStr = "";
        if (numf != 0) {
            g.setFont(FontManagerUS.SSB28);
            g.drawString(String.valueOf(Integer.toString(numf)) + " " + DefaultManager.getFemale(), HeidelbergPrinter.mm(10.0), y);
            y += 28;
            insStr = String.valueOf(insStr) + numf + DefaultManager.getFemale() + "  ";
        }
        if (numm != 0) {
            g.setFont(FontManagerUS.SSB28);
            g.drawString(String.valueOf(Integer.toString(numm)) + " " + DefaultManager.getMale(), HeidelbergPrinter.mm(10.0), y);
            y += 28;
            insStr = String.valueOf(insStr) + numm + DefaultManager.getMale() + " ";
        }
        LabelMaker.make(g, insStr, FontManagerUS.SSB11, HeidelbergPrinter.mm(34.0), HeidelbergPrinter.mm(75.0) + 15, HeidelbergPrinter.mm(63.0), 15, 0, 2, null);
        this.drawRect(g, x0, y3, x2, y6, HeidelbergPrinter.mm(0.8));
        this.fillRect(g, x0, y3, x2, y4, Color.lightGray);
        this.drawRect(g, x0, y3, x2, y4, HeidelbergPrinter.mm(0.8));
        LabelMaker.make(g, c.getLabelLineString(false, ", "), FontManagerUS.SP11, HeidelbergPrinter.mm(34.0), HeidelbergPrinter.mm(75.0), HeidelbergPrinter.mm(63.0), 15, 1, 0, null);
        LabelMaker.make(g, insStr, FontManagerUS.SSB11, HeidelbergPrinter.mm(34.0), HeidelbergPrinter.mm(75.0) + 15, HeidelbergPrinter.mm(63.0), 15, 0, 2, null);
        LabelMaker.make(g, c.getNumberString(), FontManagerUS.SSB16, HeidelbergPrinter.mm(9.0), y3 + HeidelbergPrinter.mm(2.0), HeidelbergPrinter.mm(23.0), HeidelbergPrinter.mm(10.0), HeidelbergPrinter.mm(0.8), 0, Color.white);
        this.drawRect(g, x0, y4, x3, y5, HeidelbergPrinter.mm(0.8));
        this.drawRect(g, x3, y4, x4, y5, HeidelbergPrinter.mm(0.8));
        this.drawRect(g, x4, y4, x5, y5, HeidelbergPrinter.mm(0.8));
        this.drawRect(g, x5, y4, x2, y5, HeidelbergPrinter.mm(0.8));
        LabelMaker.make(g, "ID", FontManagerUS.SSB11, x0, y4, x3 - x0, y5 - y4, 0, 0, null);
        LabelMaker.make(g, "Born", FontManagerUS.SSB11, x3, y4, x4 - x3, y5 - y4, 0, 0, null);
        LabelMaker.make(g, "Genotype", FontManagerUS.SSB11, x4, y4, x5 - x4, y5 - y4, 0, 0, null);
        LabelMaker.make(g, "Comments", FontManagerUS.SSB11, x5, y4, x2 - x5, y5 - y4, 0, 0, null);
        int yd = y5;
        Vector v = c.getActualMice();
        int i2 = 0;
        while (i2 < v.size()) {
            Mouse mausi = (Mouse)v.elementAt(i2);
            String gts = mausi.getGenotype();
            gts = gts != null && !gts.equals("?") ? " " + gts + " " : "";
            String cms = "";
            if (mausi.get("MOS_COMMENT") != null) {
                cms = " " + mausi.getString("MOS_COMMENT") + " ";
            }
            String ets = mausi.getCLLWEartagString("?", true, true);
            Date bds = this.getBirthday(mausi);
            LabelMaker.make(g, ets, FontManagerUS.SSP10, x0, yd, x3 - x0, 14, 0, 0, null);
            LabelMaker.makeWithDate(g, bds, FontManagerUS.SSP10, x3, yd, x4 - x3, 14, 0, 0, null);
            LabelMaker.make(g, gts, FontManagerUS.SSP10, x4, yd, x5 - x4, 14, 0, 2, null);
            LabelMaker.make(g, cms, FontManagerUS.SSP10, x5, yd, x2 - x5, 14, 0, 2, null);
            g.setStroke(new BasicStroke(1.0f));
            g.drawLine(x0, yd += 14, x2, yd);
            ++i2;
        }
        if (yd != y4) {
            g.drawLine(x3, yd, x3, y4);
            g.drawLine(x4, yd, x4, y4);
            g.drawLine(x5, yd, x5, y4);
        }
    }

    private String getEartag(Mouse mausi) {
        if (mausi != null) {
            return mausi.getCLLWEartagString("", true, true);
        }
        return "";
    }

    private String getJustEartag(long mausid, String group) {
        int et;
        Mouse mausi;
        if (mausid != 0L && (mausi = MouseManager.getMouse(mausid, group)) != null && (et = mausi.getInt("MOS_EARTAG", -1)) > 0) {
            return Integer.toString(et);
        }
        return "";
    }

    private Date getBirthday(Mouse mausi) {
        if (mausi != null) {
            return mausi.getDate("MOS_BIRTHDAY");
        }
        return null;
    }

    private Date getPlugday(Mouse mausi) {
        if (mausi != null) {
            return mausi.getDate("MOS_PLUGDATE");
        }
        return null;
    }

    private Date getInDate(Mouse mausi, Cage cagi) {
        Visit vis;
        Visit[] varr;
        if (mausi != null && cagi != null && (varr = (Visit[])mausi.get("MOS_VISIT")) != null && (vis = Visit.findLatestUnfinishedVisit(varr, mausi.getID(), cagi.getID())) != null) {
            return vis.ivStartDate;
        }
        return null;
    }
}

