/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.labelprinters;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.XMLNode;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Vector;
import mausoleum.gui.MFLabel;
import mausoleum.printing.PrintElement;
import mausoleum.printing.labelprinters.LabelPrinter;

public class LabelColumn {
    public static final int ARRPOS_MARK = 0;
    public static final int ARRPOS_EARTAG = 1;
    public static final int ARRPOS_SEX = 2;
    public static final int ARRPOS_GENOTYPE = 3;
    public static final int ARRPOS_BIRTHDAY = 4;
    public static final int ARRPOS_ENTRYDAY = 5;
    public static final int ARRPOS_SYSTEMID = 6;
    public static final int ARRPOS_TAG = 7;
    public static final int ARRPOS_EARTAG_WITH_PREFIX = 8;
    public static final int ARRPOS_PLUGDAY = 9;
    public static final int ARRPOS_PARENTS = 10;
    public static final int ARRPOS_PARENTS_MIT_TAG = 11;
    public static final int ARRPOS_STRAINS = 12;
    public static final int ARRPOS_STRAINS_MIT_PROZ = 13;
    public static final int ARRPOS_SEXED_TAG = 14;
    public static final int ARRSIZE = 15;
    private static final String TAG_FONT = "font";
    public static final String TAG_TYP = "typ";
    public static final String TAG_SYSTEMID = "systemid";
    public static final String TAG_MARK = "mark";
    public static final String TAG_EARTAG = "eartag";
    public static final String TAG_TAG = "tag";
    public static final String TAG_SEXED_TAG = "SexedTag";
    public static final String TAG_SEX = "sex";
    public static final String TAG_GENOTYPE = "genotype";
    public static final String TAG_BIRTHDAY = "birthday";
    public static final String TAG_ENTRYDAY = "entryday";
    public static final String TAG_EARTAG_WITH_PREFIX = "eartagwp";
    public static final String TAG_PLUGDAY = "plugday";
    public static final String TAG_PARENTS = "parents";
    public static final String TAG_PARENTS_MIT_TAG = "parentsmittag";
    public static final String TAG_STRAINS = "strains";
    public static final String TAG_STRAINS_MIT_PROZ = "strainsproz";
    private static final String[] TYPE_STRINGS = new String[]{"mark", "eartag", "sex", "genotype", "birthday", "entryday", "systemid", "tag", "eartagwp", "plugday", "parents", "parentsmittag", "strains", "strainsproz", "SexedTag"};
    private static final int[] TYPE_INTS;
    public final int ivType;
    public final Font ivFont;

    static {
        int[] nArray = new int[15];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        TYPE_INTS = nArray;
    }

    public LabelColumn(XMLNode xn) {
        String type = "";
        Font f = LabelPrinter.getFont(0);
        Enumeration en = xn.attributes();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String val = xn.getAttributeValue(key, null);
            if (key.equals(TAG_TYP)) {
                type = val;
                continue;
            }
            if (!key.equals(TAG_FONT)) continue;
            f = LabelPrinter.getFont(Integer.parseInt(val));
        }
        this.ivType = StringHelper.getIntForString(type.toLowerCase().trim(), TYPE_INTS, TYPE_STRINGS, -1);
        this.ivFont = f;
    }

    public boolean isGenotypeColumn() {
        return this.ivType == 3;
    }

    public int getWidth(Object[] arr) {
        Object ooo = this.getObject(arr);
        if (ooo == null) {
            return 0;
        }
        if (ooo instanceof String) {
            return StringHelper.getStringWidth((String)ooo, this.ivFont, 10);
        }
        if (ooo instanceof MFLabel) {
            MFLabel mlfo = (MFLabel)ooo;
            return mlfo.getWidth();
        }
        if (ooo instanceof Vector) {
            Vector mlfov = (Vector)ooo;
            int sum = 0;
            int i = 0;
            while (i < mlfov.size()) {
                MFLabel mlfo = (MFLabel)mlfov.elementAt(i);
                sum += mlfo.getWidth();
                ++i;
            }
            return sum;
        }
        return 0;
    }

    public int generateOutput(Object[] arr, Vector page, int x, int y, int maxWidth) {
        return LabelColumn.handleLabelColumnObject(this.getObject(arr), page, x, y, maxWidth, this.ivFont);
    }

    public static int handleLabelColumnObject(Object ooo, Vector page, int x, int y, int maxWidth, Font font) {
        if (ooo == null) {
            return 0;
        }
        if (ooo instanceof String) {
            page.addElement(PrintElement.getTextElement(x, y, (String)ooo, font));
            return font.getSize();
        }
        if (ooo instanceof MFLabel) {
            MFLabel mlfo = (MFLabel)ooo;
            if (mlfo.ivBackground != null) {
                if (mlfo.ivString != null && mlfo.ivString.trim().length() != 0) {
                    page.addElement(PrintElement.getFilledTextBox(x, y, maxWidth, mlfo.ivFont.getSize(), mlfo.ivString, mlfo.ivFont, mlfo.ivBackground));
                }
            } else {
                page.addElement(PrintElement.getTextElement(x, y, mlfo.ivString, mlfo.ivFont));
            }
            return mlfo.ivFont.getSize();
        }
        if (ooo instanceof Vector) {
            int starty = y;
            Vector mlfov = (Vector)ooo;
            int maximalHoehe = 0;
            int xOffset = 0;
            int i = 0;
            while (i < mlfov.size()) {
                MFLabel mlfo = (MFLabel)mlfov.elementAt(i);
                int width = mlfo.getWidth();
                if (xOffset + width > maxWidth) {
                    y += maximalHoehe;
                    maximalHoehe = 0;
                    xOffset = 0;
                }
                page.addElement(PrintElement.getTextElement(x + xOffset, y, mlfo.ivString, mlfo.ivFont));
                xOffset += width;
                int th = mlfo.ivFont.getSize();
                if (th > maximalHoehe) {
                    maximalHoehe = th;
                }
                ++i;
            }
            return y - starty + maximalHoehe;
        }
        return 0;
    }

    private Object getObject(Object[] arr) {
        if (this.ivType >= 0 && this.ivType < arr.length) {
            return arr[this.ivType];
        }
        return null;
    }
}

