/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.labelprinters;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.XMLNode;
import java.awt.Color;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.gui.TextWrapComponent;
import mausoleum.gui.TextWrapElement;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.FontManager;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.printing.PrintElement;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.printing.util.Wurf;
import mausoleum.rack.Rack;
import mausoleum.rack.RackPos;

public class LabelLine {
    private static final String TAG_TYP = "typ";
    private static final String TAG_FONT = "font";
    private static final String TAG_ANZLINES = "anzLines";
    private static final String TAG_CONTENTS = "contents";
    public static final String TAG_ID = "ID";
    public static final String TAG_POLYGON = "Polygon";
    public static final String TAG_POLYGON_WOO = "PolygonOhneOwner";
    public static final String TAG_POLYGON_CECAD = "PolygonOhneCECAD";
    public static final String TAG_POLYGON_GROUP = "PolygonGroup";
    public static final String TAG_POLYGON_MIT_LINES = "PolygonMitLines";
    public static final String TAG_CAGENR_AND_MOUSE_COUNT = "CageNrAndMouseCount";
    public static final String TAG_MOUSECOUNT = "MouseCount";
    public static final String TAG_LINE = "Line";
    public static final String TAG_STRAIN = "Strain";
    public static final String TAG_OWNER = "Owner";
    public static final String TAG_OWNER_OS = "OwnerOnlySingle";
    public static final String TAG_LICENSE = "License";
    public static final String TAG_LICENSE_WO = "LicenseWithOwners";
    public static final String TAG_LICENSE_WO_NAME_PREFERRED = "LicenseWithOwnersNamePreferred";
    public static final String TAG_OWNER_W_LICENSE = "OwnerAndLicense";
    public static final String TAG_OWNER_W_LICENSE_OSLO = "OwnerAndLicenseOslo";
    public static final String TAG_OWNER_STANFORD = "OwnerStanford";
    public static final String TAG_COMMENT = "Comment";
    public static final String TAG_TEXT = "Text";
    public static final String TAG_MULTI_LINE_COMMENT = "MultiLineComment";
    public static final String TAG_RACK_POS = "RackPos";
    public static final String TAG_RACK_POS_GROUP = "RackPosGroup";
    public static final String TAG_RACK_POS_GROUP_RENDL = "RackPosGroupRendl";
    public static final String TAG_RACK_POS_GROUP_STANFORD = "RackPosGroupStanford";
    public static final String TAG_RACK_POS_GROUP_STANFORD_OHNE_RACKPOS = "RackPosGroupStanfordOhneRackPos";
    public static final String TAG_EMPTY = "Empty";
    private static final String TAG_OVERRIDECAGE_COLORMODE = "ovrCageColorMode";
    private static final Color RED_WEDDING = new Color(210, 0, 0);
    private String ivType = "";
    private Font ivFont = LabelPrinter.getFont(0);
    private int ivAnzLines = 1;
    private String ivContents = null;
    private int ivOverrideCageColorMode = -1;

    public LabelLine(XMLNode xn) {
        Enumeration en = xn.attributes();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String val = xn.getAttributeValue(key, null);
            this.checkKeyValue(key, val);
        }
    }

    public String getType() {
        return this.ivType;
    }

    public int generateOutput(Cage cage, Vector page, int x, int y, boolean weddingsred, String mouseCountString, LabelPrinter lp) {
        String s = null;
        if (this.ivType.equalsIgnoreCase(TAG_ID)) {
            s = cage.getLabelIDString();
        } else if (this.ivType.equalsIgnoreCase(TAG_MOUSECOUNT)) {
            s = cage.getLabelMouseNumberString();
        } else if (this.ivType.equalsIgnoreCase(TAG_LINE)) {
            s = cage.getLabelLineString(true, ", ");
        } else if (this.ivType.equalsIgnoreCase(TAG_STRAIN)) {
            s = cage.getLabelStrainString(true);
        } else if (this.ivType.equalsIgnoreCase(TAG_TEXT)) {
            if (this.ivContents != null) {
                PrintElement pe = PrintElement.getTextElement((int)(lp.ivWidth - lp.ivRight) / 2, y, this.ivContents, this.ivFont);
                pe.ivOrientation = 2;
                page.addElement(pe);
                return this.ivFont.getSize();
            }
        } else if (this.ivType.equalsIgnoreCase(TAG_OWNER)) {
            s = cage.getLabelOwnerString(true);
        } else if (this.ivType.equalsIgnoreCase(TAG_OWNER_OS)) {
            s = cage.getOwnerStringOnlySingleEmailPreferred();
        } else if (this.ivType.equalsIgnoreCase(TAG_LICENSE)) {
            s = cage.getLicenseString("permiss.: ");
        } else if (this.ivType.equalsIgnoreCase(TAG_CAGENR_AND_MOUSE_COUNT)) {
            StringBuffer msb = new StringBuffer();
            msb.append(cage.getLabelIDString());
            msb.append(LabelLine.getSexedContentString(cage, true));
            s = msb.toString();
        } else {
            if (this.ivType.equalsIgnoreCase(TAG_LICENSE_WO)) {
                page.addElement(PrintElement.getTextElement(x, y, cage.getLicenseString("permiss.: "), this.ivFont));
                PrintElement pe = PrintElement.getTextElement((int)(lp.ivWidth - lp.ivRight), y, cage.getOwnerStringOnlySingleEmailPreferred(), this.ivFont);
                pe.ivOrientation = 3;
                page.addElement(pe);
                return this.ivFont.getSize();
            }
            if (this.ivType.equalsIgnoreCase(TAG_LICENSE_WO_NAME_PREFERRED)) {
                String lic = cage.getPureCageObjectString(null, "[c] ", "CAG_LICENSEID");
                if (lic == null) {
                    lic = cage.getPureMouseObjectString(null, "[m] ", 16);
                }
                String grp = cage.getPureCageObjectString("", "[g] ", "IDO_GROUP");
                String permiss = "permiss.: ";
                int res = 0;
                page.addElement(PrintElement.getTextElement(x, y, String.valueOf(permiss) + grp, this.ivFont));
                PrintElement pe = PrintElement.getTextElement((int)(lp.ivWidth - lp.ivRight), y, cage.getOwnerStringOnlySingleNamePreferred(), this.ivFont);
                pe.ivOrientation = 3;
                page.addElement(pe);
                if (lic == null) {
                    res = this.ivFont.getSize();
                } else {
                    page.addElement(PrintElement.getTextElement(x + StringHelper.getStringWidth(permiss, this.ivFont, 0), y += this.ivFont.getSize() + 3, lic, this.ivFont));
                    res = 2 * this.ivFont.getSize() + 3;
                }
                return res;
            }
            if (this.ivType.equalsIgnoreCase(TAG_OWNER_W_LICENSE)) {
                page.addElement(PrintElement.getTextElement(x, y, cage.getOwnerStringOnlySingleEmailPreferred(), this.ivFont));
                PrintElement pe = PrintElement.getTextElement((int)(lp.ivWidth - lp.ivRight), y, cage.getLicenseString(null), this.ivFont);
                pe.ivOrientation = 3;
                page.addElement(pe);
                return this.ivFont.getSize();
            }
            if (this.ivType.equalsIgnoreCase(TAG_OWNER_W_LICENSE_OSLO)) {
                page.addElement(PrintElement.getTextElement(x, y, cage.getOwnerStringOslo(null, cage.getString("IDO_GROUP", "").toUpperCase()), this.ivFont));
                PrintElement pe = PrintElement.getTextElement((int)(lp.ivWidth - lp.ivRight), y, cage.getLicenseString(null), this.ivFont);
                pe.ivOrientation = 3;
                page.addElement(pe);
                return this.ivFont.getSize();
            }
            if (this.ivType.equalsIgnoreCase(TAG_OWNER_STANFORD)) {
                page.addElement(PrintElement.getTextElement(x, y, cage.getOwnerStringOslo("Person responsible: ", "Lab: " + cage.getString("IDO_GROUP", "").toUpperCase()), this.ivFont));
                return this.ivFont.getSize();
            }
            if (this.ivType.equalsIgnoreCase(TAG_RACK_POS)) {
                String rps = cage.getRackPosString("Position: ");
                if (rps != null) {
                    page.addElement(PrintElement.getTextElement(x, y, rps, this.ivFont));
                    return this.ivFont.getSize();
                }
                return 0;
            }
            if (this.ivType.equalsIgnoreCase(TAG_RACK_POS_GROUP)) {
                String rps = cage.getRackPosString("Position: ");
                if (rps != null) {
                    page.addElement(PrintElement.getTextElement(x, y, rps, this.ivFont));
                }
                PrintElement pe = PrintElement.getTextElement((int)(lp.ivWidth - lp.ivRight), y, cage.getString("IDO_GROUP", ""), this.ivFont);
                pe.ivOrientation = 3;
                page.addElement(pe);
                return this.ivFont.getSize();
            }
            if (this.ivType.equalsIgnoreCase(TAG_RACK_POS_GROUP_STANFORD)) {
                String rps = cage.getRackPosString("Position: ");
                if (rps != null) {
                    page.addElement(PrintElement.getTextElement(x, y, rps, this.ivFont));
                }
                PrintElement pe = PrintElement.getTextElement((int)(lp.ivWidth - lp.ivRight), y, "Lab: " + cage.getString("IDO_GROUP", ""), this.ivFont);
                pe.ivOrientation = 3;
                page.addElement(pe);
                return this.ivFont.getSize();
            }
            if (this.ivType.equalsIgnoreCase(TAG_RACK_POS_GROUP_STANFORD_OHNE_RACKPOS)) {
                PrintElement pe = PrintElement.getTextElement((int)(lp.ivWidth - lp.ivRight), y, "Lab: " + cage.getString("IDO_GROUP", ""), this.ivFont);
                pe.ivOrientation = 3;
                page.addElement(pe);
                return this.ivFont.getSize();
            }
            if (this.ivType.equalsIgnoreCase(TAG_RACK_POS_GROUP_RENDL)) {
                Rack r;
                String owner = "Owner: " + cage.getOwnerStringOslo(null, cage.getString("IDO_GROUP", "").toUpperCase());
                String rackpos = "";
                RackPos rp = (RackPos)cage.get("CAG_POS");
                if (rp != null && (r = (Rack)ObjectStore.getObjectDeadOrAlive(3, rp.ivRackID, cage.getGroup(), null, false)) != null) {
                    StringBuffer msb = new StringBuffer("#");
                    msb.append(r.getName());
                    if (rp.ivSide == 1) {
                        msb.append("/B");
                    }
                    msb.append("-");
                    msb.append(String.valueOf(rp.ivColumn + 1) + "." + (rp.ivRow + 1));
                    rackpos = msb.toString();
                }
                String group = "PI:" + cage.getGroup();
                page.addElement(PrintElement.getTextElement(x, y, owner, this.ivFont));
                PrintElement pe = PrintElement.getTextElement((int)((double)x + lp.ivWidth / 2.0), y, rackpos, this.ivFont);
                pe.ivOrientation = 2;
                page.addElement(pe);
                pe = PrintElement.getTextElement((int)(lp.ivWidth - lp.ivRight), y, group, this.ivFont);
                pe.ivOrientation = 3;
                page.addElement(pe);
                return this.ivFont.getSize();
            }
            if (this.ivType.equalsIgnoreCase(TAG_EMPTY)) {
                s = "";
            } else if (this.ivType.equalsIgnoreCase(TAG_COMMENT)) {
                s = cage.getString("CAG_COMMENT", null);
                if (s != null) {
                    s = (s = s.trim()).length() != 0 ? "\u2192 " + StringHelper.gSub(s, "\n", " ") : null;
                }
            } else {
                if (this.ivType.equalsIgnoreCase(TAG_MULTI_LINE_COMMENT)) {
                    int ys = y;
                    s = cage.getString("CAG_COMMENT");
                    if (s != null) {
                        TextWrapComponent twc = new TextWrapComponent("\u2192 " + s, this.ivFont);
                        twc.setSize((int)(lp.ivWidth - lp.ivRight), 100);
                        Enumeration en = twc.getElements();
                        int anzlines = 0;
                        while (en.hasMoreElements() && anzlines < this.ivAnzLines) {
                            TextWrapElement twe = (TextWrapElement)en.nextElement();
                            String rein = twe.ivText;
                            if (anzlines == this.ivAnzLines - 1) {
                                rein = String.valueOf(rein) + "...";
                            }
                            PrintElement pe = PrintElement.getTextElement(x, ys, rein, this.ivFont);
                            pe.ivOrientation = 1;
                            page.addElement(pe);
                            ++anzlines;
                            ys += this.ivFont.getSize();
                        }
                        ys += 4;
                    }
                    return ys - y;
                }
                if (this.ivType.equalsIgnoreCase(TAG_POLYGON) || this.ivType.equalsIgnoreCase(TAG_POLYGON_WOO) || this.ivType.equalsIgnoreCase(TAG_POLYGON_GROUP)) {
                    PrintElement polygon = PrintElement.getPolygonElement(x, y - 8, cage, false);
                    if (this.ivOverrideCageColorMode != -1) {
                        polygon.ivOverrideCageColorMode = this.ivOverrideCageColorMode;
                    }
                    page.addElement(polygon);
                    String cageDescription = lp.getCageLabelIDString(cage);
                    if (mouseCountString != null) {
                        cageDescription = String.valueOf(cageDescription) + " " + mouseCountString + " ";
                    } else {
                        int anzmice = cage.getNumberOfMice();
                        if (anzmice == 1) {
                            cageDescription = String.valueOf(cageDescription) + " (1 mouse) ";
                        } else if (anzmice > 1) {
                            cageDescription = String.valueOf(cageDescription) + " (" + anzmice + " mice) ";
                        }
                    }
                    if (this.ivType.equalsIgnoreCase(TAG_POLYGON)) {
                        cageDescription = String.valueOf(cageDescription) + cage.getOwnerStringOnlySingleEmailPreferred();
                    } else if (this.ivType.equalsIgnoreCase(TAG_POLYGON_GROUP)) {
                        cageDescription = String.valueOf(cageDescription.trim()) + " - " + cage.getGroup();
                    }
                    if (cage.isMatingCage() && weddingsred) {
                        page.addElement(PrintElement.getTextElement(x + 45, y, cageDescription, this.ivFont, RED_WEDDING));
                    } else {
                        page.addElement(PrintElement.getTextElement(x + 45, y, cageDescription, this.ivFont));
                    }
                    String titelExtra = lp.getCageTitelExtra(cage);
                    if (titelExtra != null && titelExtra.trim().length() != 0) {
                        int sw = FontManager.stringWidth(titelExtra, this.ivFont);
                        int extraX = (int)(lp.ivWidth - lp.ivRight) - sw - 1;
                        Color col = lp.getCageTitelExtraColor();
                        page.addElement(PrintElement.getTextElement(extraX, y, titelExtra, this.ivFont, col != null ? col : Color.black));
                    }
                    return 18;
                }
                if (this.ivType.equalsIgnoreCase(TAG_POLYGON_CECAD)) {
                    int height = 24;
                    PrintElement polygon = PrintElement.getPolygonElement(x, y - 8, cage, false);
                    if (this.ivOverrideCageColorMode != -1) {
                        polygon.ivOverrideCageColorMode = this.ivOverrideCageColorMode;
                    }
                    polygon.ivX2 = 2 * height;
                    polygon.ivY2 = height;
                    y += 4;
                    page.addElement(polygon);
                    int anzMale = 0;
                    int anzFemale = 0;
                    int anzUnknown = 0;
                    Vector mice = cage.getActualMice();
                    Iterator iterator = mice.iterator();
                    while (iterator.hasNext()) {
                        Mouse mouse = (Mouse)iterator.next();
                        int sex = mouse.getSex();
                        if (sex == 1) {
                            ++anzMale;
                            continue;
                        }
                        if (sex == 2) {
                            ++anzFemale;
                            continue;
                        }
                        ++anzUnknown;
                    }
                    StringBuilder ssb = new StringBuilder();
                    if (anzMale != 0) {
                        ssb.append(anzMale).append("\u2642").append(" ");
                    }
                    if (anzFemale != 0) {
                        ssb.append(anzFemale).append("\u2640").append(" ");
                    }
                    if (anzUnknown != 0) {
                        ssb.append(anzUnknown).append("? ");
                    }
                    ssb.append(cage.getRackName());
                    page.addElement(PrintElement.getTextElement(x + 55, y, ssb.toString(), this.ivFont, weddingsred && cage.isMatingCage() ? Color.red : Color.black));
                    String titelExtra = lp.getCageTitelExtra(cage);
                    if (titelExtra != null && titelExtra.trim().length() != 0) {
                        int sw = FontManager.stringWidth(titelExtra, this.ivFont);
                        int extraX = (int)(lp.ivWidth - lp.ivRight) - sw - 1;
                        Color col = lp.getCageTitelExtraColor();
                        page.addElement(PrintElement.getTextElement(extraX, y, titelExtra, this.ivFont, col != null ? col : Color.black));
                    }
                    return height;
                }
                if (this.ivType.equalsIgnoreCase(TAG_POLYGON_MIT_LINES)) {
                    page.addElement(PrintElement.getPolygonElement(x, y - 8, cage, false));
                    Color color = Color.black;
                    String css = null;
                    if (cage.isMatingCage() && weddingsred) {
                        Vector males = new Vector();
                        Vector females = new Vector();
                        Wurf.findSexActiveMice(cage, null, males, females, null);
                        String maleLines = AllgUtils.getTypeString(cage, males, 0, ",", true);
                        String femaleLines = AllgUtils.getTypeString(cage, females, 0, ",", true);
                        if (maleLines != null && femaleLines != null) {
                            css = String.valueOf(maleLines) + " \u2297 " + femaleLines;
                        } else if (maleLines == null && femaleLines != null) {
                            css = femaleLines;
                        } else if (maleLines != null && femaleLines == null) {
                            css = maleLines;
                        }
                        color = RED_WEDDING;
                    } else {
                        css = cage.getLabelLineString(false, ", ");
                    }
                    int sx = x + 45;
                    int sy = y - 8;
                    int rest = (int)(lp.ivWidth - lp.ivRight) - sx;
                    TextWrapComponent twc = new TextWrapComponent(css, this.ivFont, rest);
                    Enumeration en = twc.getElements();
                    while (en.hasMoreElements()) {
                        TextWrapElement twe = (TextWrapElement)en.nextElement();
                        page.addElement(PrintElement.getTextElement(sx, sy, twe.ivText, this.ivFont, color));
                        sy += this.ivFont.getSize();
                    }
                    int twAdvance = sy - (y - 8);
                    int minYAdvance = 18;
                    if (twAdvance > minYAdvance) {
                        return twAdvance;
                    }
                    return minYAdvance;
                }
            }
        }
        if (s != null) {
            page.addElement(PrintElement.getTextElement(x, y, s, this.ivFont));
            return this.ivFont.getSize();
        }
        return 0;
    }

    public static String getSexedContentString(Cage c, boolean mitKlammern) {
        StringBuffer msb = new StringBuffer();
        int anzGes = c.getNumberOfMice();
        int anzW = c.getNumberOfSexedMice(2);
        int anzM = c.getNumberOfSexedMice(1);
        if (anzGes != 0) {
            boolean appended = false;
            if (mitKlammern) {
                msb.append(" (");
            }
            if (anzW != 0) {
                msb.append(anzW).append(" ").append(DefaultManager.getFemale());
                appended = true;
            }
            if (anzM != 0) {
                if (appended) {
                    msb.append(", ");
                }
                msb.append(anzM).append(" ").append(DefaultManager.getMale());
                appended = true;
            }
            if (anzW + anzM != anzGes) {
                if (appended) {
                    msb.append(", ");
                }
                msb.append(anzGes - (anzW + anzM)).append(" ?");
            }
            if (mitKlammern) {
                msb.append(")");
            }
        }
        return msb.toString();
    }

    private void checkKeyValue(String key, String val) {
        if (key.equals(TAG_TYP)) {
            this.ivType = val;
        } else if (key.equals(TAG_FONT)) {
            this.ivFont = LabelPrinter.getFont(Integer.parseInt(val));
        } else if (key.equals(TAG_ANZLINES)) {
            try {
                this.ivAnzLines = Integer.parseInt(val);
            }
            catch (Exception exception) {}
        } else if (key.equals(TAG_OVERRIDECAGE_COLORMODE)) {
            try {
                this.ivOverrideCageColorMode = Integer.parseInt(val);
            }
            catch (Exception exception) {}
        } else if (key.equals(TAG_CONTENTS)) {
            this.ivContents = val;
        }
    }
}

