/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.labelprinters;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.XMLNode;
import de.hannse.netobjects.util.XMLParser;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.gui.TextWrapComponent;
import mausoleum.gui.TextWrapElement;
import mausoleum.helper.FontManagerUS;
import mausoleum.helper.LongPunkt;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.printing.MausoleumPrinter;
import mausoleum.printing.PageFormatGenerator;
import mausoleum.printing.PrintElement;
import mausoleum.printing.labelprinters.CECADMatingPrinter;
import mausoleum.printing.labelprinters.CECADStockPrinter;
import mausoleum.printing.labelprinters.CIBIRPrinter;
import mausoleum.printing.labelprinters.CesarMating2;
import mausoleum.printing.labelprinters.CesarPrinterFish;
import mausoleum.printing.labelprinters.DMBRA6Printer;
import mausoleum.printing.labelprinters.DMBRDymoPrinter;
import mausoleum.printing.labelprinters.DZNEMagdeburg;
import mausoleum.printing.labelprinters.DZNEMatingPrinter;
import mausoleum.printing.labelprinters.DZNEStockPrinter;
import mausoleum.printing.labelprinters.HeidelbergPrinter;
import mausoleum.printing.labelprinters.KoelnCECADPrinter;
import mausoleum.printing.labelprinters.KoelnPrinter;
import mausoleum.printing.labelprinters.KoelnSPFPrinter;
import mausoleum.printing.labelprinters.KoelnSPFPrinter2;
import mausoleum.printing.labelprinters.LIMESPrinter;
import mausoleum.printing.labelprinters.LabelColumn;
import mausoleum.printing.labelprinters.LabelLine;
import mausoleum.printing.labelprinters.LimesPrinterFish;
import mausoleum.printing.labelprinters.ManolisPrinter;
import mausoleum.printing.labelprinters.MountSinaiRendl;
import mausoleum.printing.labelprinters.OsloPrinter;
import mausoleum.printing.labelprinters.StanfordPrinter;
import mausoleum.printing.labelprinters.StanfordPrinter2;
import mausoleum.printing.labelprinters.UPennPrinter;
import mausoleum.printing.util.LabelMaker;
import mausoleum.requester.LabelPrintRequester;
import mausoleum.ui.UIDef;
import mausoleum.util.InstallationType;

public class LabelPrinter
extends MausoleumPrinter {
    private static final String DEFAULT_PRINTER = "<LabelPrinters>\n\t<LabelPrinter name=\"SingleCard_Landscape_Ext\" weddingsred=\"true\" rotated=\"1\" onecardperpage=\"1\" width=\"131\" height=\"75\" top=\"5\" left=\"5\">\n\t\t<lines>\n\t\t\t<line typ=\"Polygon\" font=\"5\" orientation=\"center\"></line>\n\t\t\t<line typ=\"Line\" font=\"4\"></line>\n\t\t\t<line typ=\"Strain\" font=\"4\"></line>\n\t\t\t<line typ=\"Comment\" font=\"3\"></line>\n\t\t</lines>\n\t\t<mice>\n\t\t\t<col typ=\"Mark\" font=\"3\"></col>\n\t\t\t<col typ=\"EarTag\" font=\"3\"></col>\n\t\t\t<col typ=\"Sex\" font=\"3\"></col>\n\t\t\t<col typ=\"Genotype\" font=\"3\"></col>\n\t\t\t<col typ=\"Birthday\" font=\"3\"></col>\n\t\t</mice>\n\t</LabelPrinter>\n\t<LabelPrinter name=\"SingleCard_Landscape\" rotated=\"1\" onecardperpage=\"1\" width=\"131\" height=\"75\" top=\"5\" left=\"5\">\n\t\t<lines>\n\t\t\t<line typ=\"Polygon\" font=\"5\" orientation=\"center\"></line>\n\t\t\t<line typ=\"Line\" font=\"4\"></line>\n\t\t\t<line typ=\"Strain\" font=\"4\"></line>\n\t\t</lines>\n\t\t<mice>\n\t\t\t<col typ=\"EarTag\" font=\"3\"></col>\n\t\t\t<col typ=\"Sex\" font=\"3\"></col>\n\t\t\t<col typ=\"Genotype\" font=\"3\"></col>\n\t\t\t<col typ=\"Birthday\" font=\"3\"></col>\n\t\t</mice>\n\t</LabelPrinter>\n\t<LabelPrinter name=\"SingleCard_Landscape_Group\" rotated=\"1\" onecardperpage=\"1\" width=\"131\" height=\"75\" top=\"5\" left=\"5\">\n\t\t<lines>\n\t\t\t<line typ=\"PolygonGroup\" font=\"5\" orientation=\"center\"></line>\n\t\t\t<line typ=\"Line\" font=\"4\"></line>\n\t\t\t<line typ=\"Strain\" font=\"4\"></line>\n\t\t</lines>\n\t\t<mice>\n\t\t\t<col typ=\"EarTag\" font=\"3\"></col>\n\t\t\t<col typ=\"Sex\" font=\"3\"></col>\n\t\t\t<col typ=\"Genotype\" font=\"3\"></col>\n\t\t\t<col typ=\"Birthday\" font=\"3\"></col>\n\t\t</mice>\n\t</LabelPrinter>\n</LabelPrinters>\n";
    public static final double MM = 2.834645669291339;
    public static final int CEN = 0;
    public static final int RIG = 4;
    public static final int LEF = 2;
    private static final int SPALTEN_BREITEN_EXTRA = 6;
    private static final Comparator STRING_COMP = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof String && arg1 instanceof String) {
                String s0 = (String)arg0;
                String s1 = (String)arg1;
                return s0.compareToIgnoreCase(s1);
            }
            return 0;
        }
    };
    private static final TreeMap PRINTER_HASH = new TreeMap(STRING_COMP);
    private static final TreeMap PRINTER_HASH_FOR_TOOLTIP = new TreeMap(STRING_COMP);
    private static final TreeMap MOUSE_PRINTER_HASH = new TreeMap(STRING_COMP);
    private static final Font[] FONTS = new Font[]{FontManagerUS.SSB10, FontManagerUS.SSB08, FontManagerUS.SSB09, FontManagerUS.SSB10, FontManagerUS.SSB12, FontManagerUS.SSB22, FontManagerUS.SSB24};
    public static final Color GVO_COLOR = new Color(190, 190, 255);
    private static String[] cvPrinterNames = null;
    private static String[] cvPrinterNamesWithSpace = null;
    private static String[] cvMousePrinterNames = null;
    private static String[] cvMousePrinterNamesWithSpace = null;
    public static final Graphics OPFER_GRAPHICS = new BufferedImage(2, 2, 1).getGraphics();
    public static final Stroke DICK_STROKE = new BasicStroke(1.0f);
    public static final Stroke DUENN_STROKE = new BasicStroke(0.2f);
    public String ivName;
    public double ivWidth = 0.0;
    public double ivHeight = 0.0;
    public double ivTop = 0.0;
    public double ivLeft = 0.0;
    public double ivBottom = 0.0;
    public double ivRight = 0.0;
    public boolean ivBackground = false;
    public boolean ivRotated = false;
    public boolean ivWeddingsRed = false;
    public String ivGVOWatermark = null;
    public Vector ivLines = new Vector();
    public Vector ivColumns = new Vector();
    public boolean[] ivWantedInfos = new boolean[15];
    public boolean ivUseVeryShortDate = false;
    public boolean ivGroupMiceByParents = false;
    public boolean ivGenotypePralineMode = false;
    public boolean ivGroupMiceByParentsNotIfTooBig = false;
    public int ivWatermarkExtraY = 0;
    protected boolean ivLatePageGeneration = false;
    static /* synthetic */ Class class$0;

    static {
        XMLNode xn = XMLParser.parseXMLString(DEFAULT_PRINTER);
        Vector lpn = new Vector();
        xn.findAllNodesWithTag("LabelPrinter", lpn);
        int i = 0;
        while (i < lpn.size()) {
            LabelPrinter slp = new LabelPrinter((XMLNode)lpn.elementAt(i));
            PRINTER_HASH.put(slp.ivName, slp);
            ++i;
        }
        LabelPrinter lp = null;
        if (InstallationType.isMouse()) {
            lp = new HeidelbergPrinter();
            PRINTER_HASH.put(lp.ivName, lp);
            lp = ManolisPrinter.createPrinter();
            PRINTER_HASH.put(lp.ivName, lp);
            lp = KoelnPrinter.createPrinter(false);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = KoelnPrinter.createPrinter(true);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new KoelnCECADPrinter(true);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new KoelnCECADPrinter(false);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new KoelnSPFPrinter();
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new KoelnSPFPrinter2();
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new DZNEMatingPrinter(false, false, false, false, false, false);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new DZNEMatingPrinter(false, false, false, false, false, true);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new DZNEMatingPrinter(false, true, false, false, false, false);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new DZNEMatingPrinter(false, false, true, false, false, false);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new DZNEMatingPrinter(false, false, false, true, false, false);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new DZNEMatingPrinter(false, false, false, false, true, false);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new DZNEMatingPrinter(true, false, false, false, false, false);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new DZNEMatingPrinter(true, true, false, false, false, false);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new DZNEMatingPrinter(true, false, true, false, false, false);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new DZNEMatingPrinter(true, false, false, true, false, false);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new DZNEMatingPrinter(true, false, false, false, true, false);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new DZNEMatingPrinter(true, false, true, false, false, false);
            lp.ivName = "caesar Mating";
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new CesarMating2();
            PRINTER_HASH.put(lp.ivName, lp);
            lp = OsloPrinter.createPrinter();
            PRINTER_HASH.put(lp.ivName, lp);
            lp = OsloPrinter.createMatingPrinter();
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new DMBRDymoPrinter();
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new DMBRA6Printer(1);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new DMBRA6Printer(2);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new DMBRA6Printer(3);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new DMBRA6Printer(4);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = StanfordPrinter.createPrinter(false);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = StanfordPrinter2.createPrinter();
            PRINTER_HASH.put(lp.ivName, lp);
            lp = StanfordPrinter.createPrinter(true);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = CIBIRPrinter.createPrinter(false);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = CIBIRPrinter.createPrinter(true);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = DZNEStockPrinter.createNormalPrinter(false);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = DZNEStockPrinter.createNormalPrinter(true);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = DZNEStockPrinter.createBackcrossPrinter();
            PRINTER_HASH.put(lp.ivName, lp);
            lp = MountSinaiRendl.createPrinter();
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new DZNEMagdeburg();
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new UPennPrinter(1);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new UPennPrinter(2);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = CECADStockPrinter.createNormalPrinter(false);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = CECADStockPrinter.createNormalPrinter(true);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new CECADMatingPrinter(false, true, false, false, false, false);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new CECADMatingPrinter(false, false, true, false, false, false);
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new LIMESPrinter();
            PRINTER_HASH.put(lp.ivName, lp);
            MOUSE_PRINTER_HASH.put(lp.ivName, lp);
        } else if (InstallationType.isFish()) {
            lp = new LimesPrinterFish();
            PRINTER_HASH.put(lp.ivName, lp);
            lp = new CesarPrinterFish();
            PRINTER_HASH.put(lp.ivName, lp);
        }
        LabelPrinter.makeCagePrinterNames();
        LabelPrinter.makeMousePrinterNames();
    }

    public static void makeCagePrinterNames() {
        Object[] arr = LabelPrinter.makePrinterNames(PRINTER_HASH, DefaultManager.cvExcludedPrinters);
        cvPrinterNames = (String[])arr[0];
        cvPrinterNamesWithSpace = (String[])arr[1];
    }

    public static void makeMousePrinterNames() {
        Object[] arr = LabelPrinter.makePrinterNames(MOUSE_PRINTER_HASH, null);
        cvMousePrinterNames = (String[])arr[0];
        cvMousePrinterNamesWithSpace = (String[])arr[1];
    }

    private static Object[] makePrinterNames(TreeMap allPrinters, HashSet excludeds) {
        int siz = excludeds == null ? allPrinters.size() : allPrinters.size() - excludeds.size();
        String[] ohne = new String[siz];
        String[] mit = new String[siz];
        if (siz != 0) {
            int pos = 0;
            Iterator iter = allPrinters.keySet().iterator();
            while (iter.hasNext()) {
                String rein = (String)iter.next();
                if (excludeds != null && excludeds.contains(rein)) continue;
                ohne[pos] = rein;
                mit[pos] = " " + rein + " ";
                ++pos;
            }
        }
        return new Object[]{ohne, mit};
    }

    public static boolean hasMousePrinters() {
        return !MOUSE_PRINTER_HASH.isEmpty();
    }

    public static String[] getNames(boolean cagePrinters) {
        return cagePrinters ? cvPrinterNames : cvMousePrinterNames;
    }

    public static String[] getNamesWithSpace(boolean cagePrinters) {
        return cagePrinters ? cvPrinterNamesWithSpace : cvMousePrinterNamesWithSpace;
    }

    public static void printIt(Vector cages, String key) {
        LabelPrinter lp = LabelPrinter.get(key, true);
        lp.distributeCageLabels(cages);
        lp.printIt();
    }

    public static void previewIt(Vector cages, String key) {
        LabelPrinter slp = LabelPrinter.get(key, true);
        if (slp != null) {
            slp.distributeCageLabels(cages);
            slp.previewIt();
        }
    }

    public static PrintElementFactSheet getCageCardAsPrintElementFactSheet(Cage c, int x, int y, int maxWidth) {
        try {
            LabelPrinter slp;
            if (c != null && (slp = LabelPrinter.get(LabelPrintRequester.getLastUsedLabelPrinter(), false)) != null) {
                Vector<Cage> cages = new Vector<Cage>();
                cages.add(c);
                slp.distributeCageLabels(cages);
                PageFormat pf = slp.getPageFormatForPreview();
                if (pf != null) {
                    int w = (int)pf.getWidth();
                    int h = (int)pf.getHeight();
                    if (slp.isRotated()) {
                        int t = w;
                        w = h;
                        h = t;
                    }
                    double fak = 1.0;
                    fak = (double)maxWidth / (double)w;
                    if (fak > 1.0) {
                        fak = 1.0;
                    }
                    int rw = (int)(fak * (double)w);
                    int rh = (int)(fak * (double)h);
                    if (slp.ivDocument != null && !slp.ivDocument.isEmpty() && slp.ivDocument.firstElement() instanceof Vector) {
                        return PrintElementFactSheet.getEncapsulatedElement(x, y, rw, rh, (Vector)slp.ivDocument.elementAt(0), fak, false, false);
                    }
                    if (slp.ivDocument != null && !slp.ivDocument.isEmpty() && slp.ivDocument.firstElement() instanceof Cage) {
                        Vector<Object> v = new Vector<Object>();
                        v.add(slp);
                        v.add(c);
                        return PrintElementFactSheet.getEncapsulatedElement(x, y, rw, rh, v, fak, false, false);
                    }
                }
            }
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.printing.labelprinters.LabelPrinter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Problem bei Erezugung von Encapsulated PrintElement", e, clazz);
        }
        return null;
    }

    public static Dimension getImageDimensions(int untenExtra, double fak) {
        return LabelPrinter.getImageDimensions(LabelPrintRequester.getLastUsedLabelPrinter(), untenExtra, fak);
    }

    public static Dimension getImageDimensions(String printerName, int untenExtra, double fak) {
        LabelPrinter slp = LabelPrinter.get(printerName, false);
        if (slp != null) {
            PageFormat pf = slp.getPageFormatForPreview();
            if (pf == null) {
                PageFormatGenerator.createPageformatForLabelPrinter(slp);
                pf = slp.getPageFormatForPreview();
            }
            if (pf != null) {
                int w = (int)pf.getWidth();
                int h = (int)pf.getHeight();
                if (slp.isRotated()) {
                    int t = w;
                    w = h;
                    h = t;
                }
                int rw = w;
                int rh = h + untenExtra;
                rw = (int)((double)rw * fak);
                rh = (int)((double)rh * fak);
                return new Dimension(rw, rh);
            }
        }
        return null;
    }

    public static BufferedImage getTooltipImage(Cage c, int untenExtra, BufferedImage altesImage, double fak) {
        return LabelPrinter.getTooltipImage(c, untenExtra, altesImage, fak, LabelPrintRequester.getLastUsedLabelPrinter());
    }

    public static BufferedImage getTooltipImage(Cage c, int untenExtra, BufferedImage altesImage, double fak, String printerName) {
        Dimension id;
        LabelPrinter slp = LabelPrinter.get(printerName, false);
        if (slp != null && (id = LabelPrinter.getImageDimensions(printerName, untenExtra, fak)) != null) {
            Vector<Cage> cages = new Vector<Cage>();
            cages.add(c);
            slp.distributeCageLabels(cages);
            BufferedImage img = null;
            img = altesImage == null ? new BufferedImage(id.width, id.height, 1) : (altesImage.getWidth() == id.width && altesImage.getHeight() == id.height ? altesImage : new BufferedImage(id.width, id.height, 1));
            Graphics2D g = (Graphics2D)img.getGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, id.width, id.height);
            if (fak != 1.0) {
                g.scale(fak, fak);
            }
            if (slp.isRotated()) {
                slp.rotateBack(g);
            }
            PageFormat pf = slp.getPageFormatForPreview();
            slp.print(g, pf, 0);
            return img;
        }
        return null;
    }

    public static LabelPrinter get(String key, boolean realPrinting) {
        if (realPrinting) {
            LabelPrinter lp = (LabelPrinter)PRINTER_HASH.get(key);
            if (lp != null) {
                return lp.getClone();
            }
        } else {
            LabelPrinter lp = (LabelPrinter)PRINTER_HASH_FOR_TOOLTIP.get(key);
            if (lp != null) {
                return lp;
            }
            lp = (LabelPrinter)PRINTER_HASH.get(key);
            if (lp != null) {
                lp = lp.getClone();
                PRINTER_HASH_FOR_TOOLTIP.put(key, lp);
                return lp;
            }
        }
        return null;
    }

    public static int mm(double inmm) {
        return (int)(inmm * 2.834645669291339);
    }

    public static TextWrapComponent getWrapper(String s, Font font, int width, int orientation) {
        TextWrapComponent twc = new TextWrapComponent(s, font);
        twc.ivHardWrapPossible = true;
        twc.setOrientation(orientation);
        twc.setSize(width, 100);
        return twc;
    }

    public static int useWrapper(TextWrapComponent twc, Graphics2D g, int x, int w, int y, int h) {
        Enumeration en = twc.getElements();
        while (en.hasMoreElements()) {
            TextWrapElement twe = (TextWrapElement)en.nextElement();
            LabelMaker.make(g, twe.ivText, twc.getFont(), x, y, w, h, 0, twc.getOrientation(), null);
            y += h;
        }
        return y;
    }

    public static int getWrapHeight(TextWrapComponent twc, int lineHeight) {
        int anzel = twc.getAnzElements();
        return anzel > 1 ? anzel * lineHeight : lineHeight;
    }

    public static int makeFullWrap(String s, int y, Font font, int x, int volleBreite, int rand, int lineHeight, Graphics2D g) {
        return LabelPrinter.makeFullWrap(s, y, font, x, volleBreite, rand, lineHeight, g, 2);
    }

    public static int makeFullWrap(String s, int y, Font font, int x, int volleBreite, int rand, int lineHeight, Graphics2D g, int orientation) {
        TextWrapComponent twcGT = LabelPrinter.getWrapper(s, font, volleBreite - 2 * rand, orientation);
        int twcHeight = LabelPrinter.getWrapHeight(twcGT, lineHeight);
        LabelPrinter.useWrapper(twcGT, g, x + rand, volleBreite, y, lineHeight);
        return y + twcHeight;
    }

    public LabelPrinter() {
    }

    public LabelPrinter(String name, double width, double height) {
        this.ivName = name;
        this.ivWidth = width;
        this.ivHeight = height;
        this.ivLatePageGeneration = true;
    }

    public LabelPrinter(XMLNode xn) {
        this.ivLatePageGeneration = false;
        this.ivName = xn.getAttributeValue("name", null);
        this.ivWidth = 2.834645669291339 * this.getAttributeValue(xn, "width");
        this.ivHeight = 2.834645669291339 * this.getAttributeValue(xn, "height");
        this.ivTop = 2.834645669291339 * this.getAttributeValue(xn, "top");
        this.ivLeft = 2.834645669291339 * this.getAttributeValue(xn, "left");
        this.ivRight = 2.834645669291339 * this.getAttributeValue(xn, "right");
        String s = xn.getAttributeValue("background", null);
        if (s != null && s.equals("1")) {
            this.ivBackground = true;
        }
        if ((s = xn.getAttributeValue("rotated", null)) != null) {
            this.ivRotated = s.toLowerCase().trim().equals("1");
        }
        if ((s = xn.getAttributeValue("weddingsred", null)) != null) {
            this.ivWeddingsRed = s.toLowerCase().trim().equals("true");
        }
        XMLNode lineNode = xn.findFirstNodeWithTag("lines");
        Vector lines = new Vector();
        lineNode.findAllNodesWithTag("line", lines);
        int i = 0;
        while (i < lines.size()) {
            this.ivLines.addElement(new LabelLine((XMLNode)lines.elementAt(i)));
            ++i;
        }
        XMLNode miceNode = xn.findFirstNodeWithTag("mice");
        Vector cols = new Vector();
        miceNode.findAllNodesWithTag("col", cols);
        int i2 = 0;
        while (i2 < cols.size()) {
            LabelColumn lc = new LabelColumn((XMLNode)cols.elementAt(i2));
            this.ivWantedInfos[lc.ivType] = true;
            this.ivColumns.addElement(lc);
            ++i2;
        }
    }

    public static Font getFont(int nr) {
        if (nr >= 0 && nr < FONTS.length) {
            return FONTS[nr];
        }
        return FontManagerUS.SSB10;
    }

    public LabelPrinter getClone() {
        LabelPrinter clone = new LabelPrinter();
        this.copyValues(clone);
        return clone;
    }

    public void copyValues(LabelPrinter clone) {
        clone.ivName = this.ivName;
        clone.ivWidth = this.ivWidth;
        clone.ivHeight = this.ivHeight;
        clone.ivTop = this.ivTop;
        clone.ivLeft = this.ivLeft;
        clone.ivBottom = this.ivBottom;
        clone.ivRight = this.ivRight;
        clone.ivBackground = this.ivBackground;
        clone.ivLines = this.ivLines;
        clone.ivColumns = this.ivColumns;
        clone.ivRotated = this.ivRotated;
        clone.ivWeddingsRed = this.ivWeddingsRed;
        clone.ivUseVeryShortDate = this.ivUseVeryShortDate;
        clone.ivGroupMiceByParents = this.ivGroupMiceByParents;
        clone.ivGenotypePralineMode = this.ivGenotypePralineMode;
        clone.ivGVOWatermark = this.ivGVOWatermark;
        clone.ivWatermarkExtraY = this.ivWatermarkExtraY;
        clone.ivLatePageGeneration = this.ivLatePageGeneration;
        int i = 0;
        while (i < this.ivWantedInfos.length) {
            clone.ivWantedInfos[i] = this.ivWantedInfos[i];
            ++i;
        }
    }

    public boolean isRotated() {
        return this.ivRotated;
    }

    private double getAttributeValue(XMLNode xn, String name) {
        String s = xn.getAttributeValue(name, null);
        if (s == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            System.out.println("Could not parse: " + s);
            return 0.0;
        }
    }

    public void distributeCageLabels(Vector idObjects) {
        this.ivDocument.clear();
        if (this.ivLatePageGeneration) {
            this.ivDocument.addAll(idObjects);
        } else {
            PageFormatGenerator.createPageformatForLabelPrinter(this);
            Enumeration en = idObjects.elements();
            while (en.hasMoreElements()) {
                Vector<PrintElement> page = new Vector<PrintElement>();
                Vector card = this.handleCage((Cage)en.nextElement());
                page.addElement(PrintElement.getVectorElement(card, -1, -1, (int)this.ivWidth + 2, (int)this.ivHeight + 2));
                this.ivDocument.addElement(page);
            }
        }
    }

    public PageFormat getPageFormatForPreview() {
        return this.getPageFormat(0);
    }

    public Object getPage(int index) {
        if (index >= 0 && index < this.ivDocument.size()) {
            return this.ivDocument.elementAt(index);
        }
        return null;
    }

    public String getCageLabelIDString(Cage c) {
        return c.getLabelIDString();
    }

    public String getCageTitelExtra(Cage c) {
        return null;
    }

    public Color getCageTitelExtraColor() {
        return null;
    }

    public Color[] getCageColor(Cage cage) {
        return cage.getColor(0);
    }

    public Vector handleCage(Cage cage) {
        return this.handleCage(cage, null);
    }

    public Vector handleCage(Cage cage, String mouseCountString) {
        Color[] col;
        Vector<PrintElement> card = new Vector<PrintElement>();
        if (this.ivBackground && (col = this.getCageColor(cage)) != null && col.length == 1) {
            Color tc = col[0];
            Color nc = new Color(tc.getRed() + (255 - tc.getRed()) / 2, tc.getGreen() + (255 - tc.getGreen()) / 2, tc.getBlue() + (255 - tc.getBlue()) / 2);
            card.addElement(PrintElement.getFilledBoxElement(0, 0, (int)this.ivWidth, (int)this.ivHeight, nc));
        }
        if (this.ivGVOWatermark != null && cage.isGVOCage()) {
            Font f = FontManagerUS.SSB120;
            FontMetrics fm = OPFER_GRAPHICS.getFontMetrics(f);
            int ascent = fm.getAscent();
            int descent = fm.getDescent();
            int rfh = ascent + descent;
            PrintElement pe = PrintElement.getTextElement((int)this.ivWidth / 2, ((int)this.ivHeight - rfh) / 2 + ascent + this.ivWatermarkExtraY, this.ivGVOWatermark, f, GVO_COLOR);
            pe.ivOrientation = 2;
            card.addElement(pe);
        }
        int ax = (int)this.ivLeft;
        int ay = (int)this.ivTop;
        int i = 0;
        while (i < this.ivLines.size()) {
            LabelLine ll = (LabelLine)this.ivLines.elementAt(i);
            ay += ll.generateOutput(cage, card, ax, ay, this.ivWeddingsRed, mouseCountString, this);
            ++i;
        }
        if (this.ivColumns != null && !this.ivColumns.isEmpty()) {
            LabelColumn lc = (LabelColumn)this.ivColumns.firstElement();
            Vector mouseLabelElements = new Vector();
            HashMap labelElementsByParents = null;
            if (this.ivGroupMiceByParents) {
                labelElementsByParents = new HashMap();
            }
            cage.sammleLabels(lc.ivFont, this.ivUseVeryShortDate, mouseLabelElements, labelElementsByParents, this.ivWantedInfos, this.ivGenotypePralineMode);
            this.polishMouseLabels(mouseLabelElements);
            if (!mouseLabelElements.isEmpty()) {
                Vector neededWidths = this.getNeededWidths(mouseLabelElements);
                if (this.ivGroupMiceByParents) {
                    Vector cardSoFar = new Vector(card);
                    int ayVorher = ay;
                    if (labelElementsByParents != null) {
                        Iterator iter = labelElementsByParents.keySet().iterator();
                        while (iter.hasNext()) {
                            LongPunkt lp = (LongPunkt)iter.next();
                            Vector kids = (Vector)labelElementsByParents.get(lp);
                            String parentString = this.getParentString(cage, lp);
                            if (parentString != null && parentString.trim().length() != 0) {
                                int h = lc.ivFont.getSize();
                                int w = (int)(this.ivWidth - this.ivLeft - this.ivRight);
                                Vector parentLines = StringHelper.splitStringByAny(parentString, "\n");
                                Iterator iterator = parentLines.iterator();
                                while (iterator.hasNext()) {
                                    String parentLine = (String)iterator.next();
                                    card.addElement(PrintElement.getFilledTextBox(ax, ay, w, h + 2, parentLine, this.getParentFont(lc.ivFont), UIDef.GRAY_COLOR));
                                    ay += h + 2;
                                }
                                ay += 2;
                            }
                            ay = this.createMouseLines(kids, ax, ay, neededWidths, card);
                            ay += 6;
                        }
                    }
                    if ((double)ay > this.ivHeight && this.ivGroupMiceByParentsNotIfTooBig) {
                        card.clear();
                        card.addAll(cardSoFar);
                        ay = ayVorher;
                        ay = this.createMouseLines(mouseLabelElements, ax, ay, neededWidths, card);
                    }
                } else {
                    ay = this.createMouseLines(mouseLabelElements, ax, ay, neededWidths, card);
                }
            }
        }
        return card;
    }

    public void polishMouseLabels(Vector mouseLabelElements) {
    }

    public String getParentString(Cage cage, LongPunkt lp) {
        return null;
    }

    public Font getParentFont(Font model) {
        return model;
    }

    public int createMouseLines(Vector mouseLabelElements, int xMargin, int aktY, Vector neededWidths, Vector card) {
        if (mouseLabelElements != null && !mouseLabelElements.isEmpty()) {
            int i = 0;
            while (i < mouseLabelElements.size()) {
                Object[] sarr = (Object[])mouseLabelElements.elementAt(i);
                int maxYAddInThisLine = 0;
                int aktX = 0;
                int j = 0;
                while (j < this.ivColumns.size()) {
                    int spaltenBreite = (Integer)neededWidths.elementAt(j);
                    LabelColumn labelColumn = (LabelColumn)this.ivColumns.elementAt(j);
                    int ayw = labelColumn.generateOutput(sarr, card, xMargin + aktX, aktY, spaltenBreite);
                    if (ayw > maxYAddInThisLine) {
                        maxYAddInThisLine = ayw;
                    }
                    aktX += spaltenBreite;
                    ++j;
                }
                aktY += maxYAddInThisLine;
                ++i;
            }
        }
        return aktY;
    }

    public Vector getNeededWidths(Vector mouseLabelElements) {
        int gesamtbreite = 0;
        int genotypeCol = -1;
        Vector<Integer> neededWidths = new Vector<Integer>(this.ivColumns.size());
        int cx = 0;
        while (cx < this.ivColumns.size()) {
            int spaltenbreite = 0;
            LabelColumn labelColumn = (LabelColumn)this.ivColumns.elementAt(cx);
            if (labelColumn.isGenotypeColumn()) {
                genotypeCol = cx;
            }
            int cy = 0;
            while (cy < mouseLabelElements.size()) {
                Object[] sarr = (Object[])mouseLabelElements.elementAt(cy);
                int tbr = labelColumn.getWidth(sarr);
                if (tbr > 0) {
                    tbr += 6;
                }
                if (tbr > spaltenbreite) {
                    spaltenbreite = tbr;
                }
                ++cy;
            }
            neededWidths.addElement(new Integer(spaltenbreite));
            gesamtbreite += spaltenbreite;
            ++cx;
        }
        int maxw = (int)(this.ivWidth - this.ivLeft - this.ivRight);
        if (gesamtbreite > maxw && genotypeCol != -1) {
            int diff = gesamtbreite - maxw;
            Integer nwinti = (Integer)neededWidths.elementAt(genotypeCol);
            int res = nwinti - diff;
            if (res < 30) {
                res = 30;
            }
            neededWidths.setElementAt(new Integer(res), genotypeCol);
        }
        return neededWidths;
    }

    public void rotate(Graphics graphics) {
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(this.ivWidth, 0.0);
        g2d.rotate(1.5707963267948966);
        g2d.translate(0.0, this.ivWidth - this.ivHeight);
    }

    public void rotateBack(Graphics graphics) {
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(0.0, this.ivHeight - this.ivWidth);
        g2d.rotate(-1.5707963267948966);
        g2d.translate((int)(-this.ivWidth), 0);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex >= this.ivDocument.size()) {
            return 1;
        }
        Object ooo = this.ivDocument.elementAt(pageIndex);
        if (this.isRotated()) {
            this.rotate(graphics);
        }
        if (ooo instanceof Cage) {
            this.simplePrint((Cage)ooo, graphics);
        } else if (ooo instanceof Mouse) {
            this.simplePrint((Mouse)ooo, graphics);
        } else if (ooo instanceof Vector) {
            this.simplePrint((Vector)ooo, graphics);
        }
        if (this.isRotated()) {
            this.rotateBack(graphics);
        }
        return 0;
    }

    public void simplePrint(Vector page, Graphics graphics) {
        int i = 0;
        while (i < page.size()) {
            PrintElement tpe = (PrintElement)page.elementAt(i);
            tpe.print(graphics);
            ++i;
        }
    }

    public void simplePrint(Cage cage, Graphics graphics) {
    }

    public void simplePrint(Mouse mouse, Graphics graphics) {
    }
}

