/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.labelprinters;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.MyDate;
import de.hannse.netobjects.util.XMLNode;
import de.hannse.netobjects.util.XMLParser;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.gui.MFLabel;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.FontManagerUS;
import mausoleum.mouse.Mouse;
import mausoleum.printing.PrintElement;
import mausoleum.printing.labelprinters.LabelLine;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.printing.util.Wurf;

public class MountSinaiRendl
extends LabelPrinter {
    private static final String DEFAULT_PRINTER = "\t<LabelPrinter name=\"MSSM_Rendl\" weddingsred=\"true\" rotated=\"1\" onecardperpage=\"1\" width=\"127\" height=\"45\" top=\"2\" left=\"3\" right=\"3\">\n\t\t<lines>\n\t\t\t<line typ=\"RackPosGroupRendl\" font=\"3\"></line>\n\t\t\t<line typ=\"Empty\" font=\"4\"></line>\n\t\t\t<line typ=\"PolygonMitLines\" font=\"4\" orientation=\"center\"></line>\n\t\t</lines>\n\t\t<mice>\n\t\t\t<col typ=\"SexedTag\" font=\"3\"></col>\n\t\t\t<col typ=\"Birthday\" font=\"3\"></col>\n\t\t\t<col typ=\"Genotype\" font=\"3\"></col>\n\t\t\t<col typ=\"Entryday\" font=\"3\"></col>\n\t\t</mice>\n\t</LabelPrinter>\n";

    public static MountSinaiRendl createPrinter() {
        return new MountSinaiRendl(XMLParser.parseXMLString(DEFAULT_PRINTER));
    }

    private MountSinaiRendl(XMLNode xn) {
        super(xn);
        this.ivUseVeryShortDate = true;
    }

    private MountSinaiRendl() {
        this.ivUseVeryShortDate = true;
    }

    public LabelPrinter getClone() {
        MountSinaiRendl clone = new MountSinaiRendl();
        this.copyValues(clone);
        return clone;
    }

    public Vector handleCage(Cage c) {
        if (c.isMatingCage()) {
            return this.handleMatingCage(c);
        }
        return super.handleCage(c);
    }

    public void polishMouseLabels(Vector mouseLabelElements) {
        if (mouseLabelElements != null) {
            Iterator iter = mouseLabelElements.iterator();
            while (iter.hasNext()) {
                Object[] arr = (Object[])iter.next();
                if (arr[4] != null) {
                    MFLabel mfl = (MFLabel)arr[4];
                    if (mfl.ivString != null) {
                        mfl.ivString = "B" + mfl.ivString;
                    }
                }
                if (arr[3] == null) continue;
                Vector v = (Vector)arr[3];
                Iterator iterator = v.iterator();
                while (iterator.hasNext()) {
                    MFLabel mfl = (MFLabel)iterator.next();
                    if (mfl.ivString == null) continue;
                    mfl.ivString = StringHelper.gSub(mfl.ivString, "; ", ";");
                    mfl.ivString = StringHelper.gSub(mfl.ivString, " ;", ";");
                }
            }
        }
    }

    public Vector handleMatingCage(Cage c) {
        Vector page = new Vector(100);
        Vector males = new Vector();
        Vector females = new Vector();
        Vector wuerfe = Wurf.collectWuerfeForPrinters(c, males, females, false, 20, 20, null, false, false, false, false, true, false, true, false, false, false);
        if (wuerfe == null) {
            return super.handleCage(c);
        }
        int anzAdults = males.size() + females.size();
        String mouseCount = "(" + anzAdults + " adults)";
        if (anzAdults == 1) {
            mouseCount = "(" + anzAdults + " adult)";
        }
        int ax = (int)this.ivLeft;
        int ay = (int)this.ivTop;
        int i = 0;
        while (i < this.ivLines.size()) {
            LabelLine ll = (LabelLine)this.ivLines.elementAt(i);
            String ltyp = ll.getType();
            if (!(ltyp.equalsIgnoreCase("Line") || ltyp.equalsIgnoreCase("Strain") || ltyp.equalsIgnoreCase("Comment"))) {
                ay += ll.generateOutput(c, page, ax, ay, this.ivWeddingsRed, mouseCount, this);
            }
            ++i;
        }
        ay = this.showParentMice(c, males, females, ax, ay, page);
        ay += 5;
        ay = this.showWuerfe(wuerfe, ax, ay, page, males, females, IDObject.combineIDObjectCollections(new Vector[]{males, females}));
        return page;
    }

    private int showParentMice(Cage cage, Vector fathers, Vector mothers, int ax, int ay, Vector page) {
        if (this.ivColumns != null && !this.ivColumns.isEmpty()) {
            Vector<Object[]> mouseLabelElements = new Vector<Object[]>();
            Vector mice = new Vector();
            mice.addAll(fathers);
            mice.addAll(mothers);
            Iterator iter = mice.iterator();
            while (iter.hasNext()) {
                Mouse mausi = (Mouse)iter.next();
                if (mausi == null) continue;
                Object[] labels = mausi.fillLabelInformation(FontManagerUS.SSB10, true, cage.getID(-1L), this.ivWantedInfos, false);
                Color bg = null;
                int ind = fathers.indexOf(mausi);
                if (ind != -1) {
                    if (ind < Wurf.FATHER_COLORS.length) {
                        bg = Wurf.FATHER_COLORS[ind];
                    }
                } else {
                    ind = mothers.indexOf(mausi);
                    if (ind != -1 && ind < Wurf.MOTHER_COLORS.length) {
                        bg = Wurf.MOTHER_COLORS[ind];
                    }
                }
                if (bg != null && labels[14] != null && labels[14] instanceof MFLabel) {
                    MFLabel mflo = (MFLabel)labels[14];
                    mflo.ivBackground = bg;
                }
                mouseLabelElements.add(labels);
            }
            this.polishMouseLabels(mouseLabelElements);
            if (!mouseLabelElements.isEmpty()) {
                Vector neededWidths = this.getNeededWidths(mouseLabelElements);
                ay = this.createMouseLines(mouseLabelElements, ax, ay, neededWidths, page);
            }
        }
        return ay;
    }

    private int showWuerfe(Vector wuerfe, int ax, int ay, Vector page, Vector males, Vector females, HashMap parents) {
        int origay = ay;
        int w1 = 8;
        int w2 = 42;
        int w3 = 42;
        int w4 = 30;
        int w5 = 30;
        int tw = w1 + w2 + w3 + w4 + w5;
        int lineHeigth = 10;
        int maxh = (int)(this.ivHeight - 5.669291338582678);
        Font f = FontManagerUS.SSB09;
        int i = wuerfe.size() - 1;
        while (i >= 0) {
            Wurf w = (Wurf)wuerfe.elementAt(i);
            int tx = ax;
            if (w.areAllLeft()) {
                page.addElement(PrintElement.getFilledTextBox(tx, ay, 8, 12, "*", f, null));
            }
            page.addElement(PrintElement.getFilledTextBox(tx += w1, ay, 38, 12, "B" + DatumFormat.getVeryShortDateString(new MyDate(w.ivDay)), f, null));
            tx += w2;
            if (w.ivNumBornTotal > 0) {
                if (w.ivNumBornTotal == 1) {
                    page.addElement(PrintElement.getFilledTextBox(tx, ay, 40, 12, String.valueOf(w.ivNumBornTotal) + " pup", f, null));
                } else {
                    page.addElement(PrintElement.getFilledTextBox(tx, ay, 40, 12, String.valueOf(w.ivNumBornTotal) + " pups", f, null));
                }
            }
            tx += w3;
            Mouse father = (Mouse)parents.get(new Long(w.ivFatherID));
            if (father != null) {
                int pos = males.indexOf(father);
                PrintElement tpe = null;
                tpe = pos < Wurf.FATHER_COLORS.length && pos != -1 ? PrintElement.getFilledTextBox(tx, ay, 30, 12, father.getCLLWEartagString("?", true, true), f, Wurf.FATHER_COLORS[pos]) : PrintElement.getFilledTextBox(tx, ay, 30, 12, father.getCLLWEartagString("?", true, true), f, null);
                page.addElement(tpe);
                tpe.ivOrientation = 2;
            }
            tx += 30;
            Mouse mother = (Mouse)parents.get(new Long(w.ivMotherID));
            if (mother != null) {
                int pos = females.indexOf(mother);
                PrintElement tpe = null;
                tpe = pos < Wurf.MOTHER_COLORS.length && pos != -1 ? PrintElement.getFilledTextBox(tx, ay, 30, 12, mother.getCLLWEartagString("?", true, true), f, Wurf.MOTHER_COLORS[pos]) : PrintElement.getFilledTextBox(tx, ay, 30, 12, mother.getCLLWEartagString("?", true, true), f, null);
                page.addElement(tpe);
                tpe.ivOrientation = 2;
            }
            tx += 30;
            if ((ay += 10) + lineHeigth > maxh) {
                ay = origay;
                ax += tw + 5;
            }
            --i;
        }
        return ay;
    }
}

