/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.labelprinters;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.gui.MusterColor;
import mausoleum.gui.TextWrapComponent;
import mausoleum.gui.TextWrapElement;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.FontManagerUS;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.printing.PageFormatGenerator;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.printing.util.LabelMaker;
import mausoleum.rack.frame.CageDisplayManager;
import mausoleum.room.Room;

public class UPennPrinter
extends LabelPrinter {
    private static final int LINE_HEIGHT_STOCK_DZNE = 14;
    private static final int MIN_RAND = UPennPrinter.mm(2.0);
    private static final double RAND = 4.0;
    private final int ivVersion;
    private final int ivLinks;
    private final int ivRechts;
    private final int ivOben;
    private final int ivUnten;

    public UPennPrinter(int version) {
        super("UPenn" + (version == 2 ? " V2" : ""), 216.00000000000003, 360.00000000000006);
        PageFormatGenerator.createPageformatForLabelPrinter(this);
        this.ivLinks = 11;
        this.ivRechts = (int)(this.ivWidth - 11.338582677165356);
        this.ivOben = 11;
        this.ivUnten = (int)(this.ivHeight - 11.338582677165356);
        this.ivVersion = version;
    }

    public LabelPrinter getClone() {
        UPennPrinter clone = new UPennPrinter(this.ivVersion);
        this.copyValues(clone);
        return clone;
    }

    public void simplePrint(Cage cage, Graphics graphics) {
        this.printStockCage((Graphics2D)graphics, cage);
    }

    private static void fillRect(Graphics2D g, int ulx, int uly, int lrx, int lry, Color col) {
        g.setColor(col);
        if (col instanceof MusterColor) {
            MusterColor mc = (MusterColor)col;
            mc.fill(ulx, uly, lrx - ulx, lry - uly, g);
        } else {
            g.fillRect(ulx, uly, lrx - ulx, lry - uly);
        }
    }

    private void printStockCage(Graphics2D g, Cage c) {
        Room room;
        int rand = MIN_RAND;
        int orLineHeight = UPennPrinter.mm(4.0);
        int cfw = UPennPrinter.mm(25.0);
        int obenHeight = UPennPrinter.mm(50.8);
        UPennPrinter.makeFill(c, g, cfw, 0, UPennPrinter.mm(76.2), obenHeight);
        int orXStart = 0;
        int cfy = UPennPrinter.mm(18.0);
        LabelMaker.make(g, Babel.get("CAGE"), FontManagerUS.SSB16, 0, cfy, cfw, 20, 0, 0, null);
        LabelMaker.make(g, c.getNumberString(), FontManagerUS.SSB16, 0, cfy + 20, cfw, 20, 0, 0, null);
        int orBreite = UPennPrinter.mm(76.2) - cfw - 2 * rand;
        int ay = this.ivOben + rand;
        String ularID = "ULAR ID: " + c.getString("IDO_FKEY", "");
        LabelMaker.makeMitRandDrumrum(g, ularID, FontManagerUS.SSB12, orXStart += cfw + rand, ay - 1, orBreite, orLineHeight, 0, 0, null);
        ay += orLineHeight + UPennPrinter.mm(3.0);
        TextWrapComponent twc = null;
        String typs = AllgUtils.getTypeString(c, c.getActualMice(), 0, true);
        if (typs.trim().length() != 0) {
            twc = new TextWrapComponent(typs, FontManagerUS.SSB10, orBreite);
            twc.ivHardWrapPossible = true;
            twc.generateElements();
            Enumeration en = twc.getElements();
            while (en.hasMoreElements()) {
                TextWrapElement twe = (TextWrapElement)en.nextElement();
                LabelMaker.makeMitRandDrumrum(g, twe.ivText, FontManagerUS.SSB10, orXStart, ay - 1, orBreite, orLineHeight, 0, 0, null);
                ay += orLineHeight + UPennPrinter.mm(0.2);
            }
        }
        if ((room = c.getRoom()) != null) {
            ay = obenHeight - rand - orLineHeight - 2 * (UPennPrinter.mm(2.0) + orLineHeight);
            LabelMaker.makeMitRandDrumrum(g, room.getName(), FontManagerUS.SSB10, orXStart, ay + 1, orBreite, orLineHeight, 0, 0, null);
        }
        String rps = c.getRackPosString("");
        ay = obenHeight - rand - orLineHeight - UPennPrinter.mm(2.0) - orLineHeight;
        LabelMaker.makeMitRandDrumrum(g, rps, FontManagerUS.SSB10, orXStart, ay + 1, orBreite, orLineHeight, 0, 0, null);
        ay = obenHeight - rand - orLineHeight;
        LabelMaker.makeMitRandDrumrum(g, "Lab " + c.getGroup(), FontManagerUS.SSB10, orXStart, ay + 1, orBreite, orLineHeight, 0, 4, null);
        int akty = obenHeight;
        int hlh = UPennPrinter.mm(6.0);
        int totW = this.ivRechts - this.ivLinks;
        int sexW = this.ivVersion == 2 ? UPennPrinter.mm(4.0) : UPennPrinter.mm(4.5);
        int datW = UPennPrinter.mm(24.0);
        int tagW = this.ivVersion == 2 ? UPennPrinter.mm(12.0) : 0;
        int etW = totW - sexW - datW - tagW;
        int gtW = totW - rand;
        int tagX = this.ivVersion == 2 ? this.ivLinks : 0;
        int etX = this.ivVersion == 2 ? tagX + tagW : this.ivLinks;
        int sexX = etX + etW;
        int dateX = sexX + sexW;
        if (this.ivVersion == 2) {
            LabelMaker.make(g, "T", FontManagerUS.SSB11, tagX, akty, tagW, hlh, 0, 2, null);
        }
        LabelMaker.make(g, "ET", FontManagerUS.SSB11, etX, akty, etW, hlh, 0, 2, null);
        LabelMaker.make(g, "S", FontManagerUS.SSB11, sexX, akty, sexW, hlh, 0, 0, null);
        LabelMaker.make(g, "Born", FontManagerUS.SSB11, dateX, akty, datW, hlh, 0, 0, null);
        int lineHeight = 14;
        int yd = akty += hlh;
        Vector v = c.getActualMice();
        Collections.sort(v, AllgUtils.MOUSE_ET_SORTER);
        int i = 0;
        while (i < v.size() && yd < this.ivUnten) {
            String tag;
            Mouse mausi = (Mouse)v.elementAt(i);
            if (this.ivVersion == 2 && (tag = mausi.getString("MOS_ANTAG", null)) != null) {
                LabelMaker.make(g, tag, FontManagerUS.SSP10, tagX, yd, tagW, lineHeight, 0, 2, null);
            }
            String ets = mausi.getCLLWEartagString("?", true, true);
            LabelMaker.make(g, ets, FontManagerUS.SSP10, etX, yd, etW, lineHeight, 0, 2, null);
            int sex = mausi.getSex();
            if (sex == 1) {
                LabelMaker.make(g, DefaultManager.getMale(), FontManagerUS.SSP10, sexX, yd, sexW, lineHeight, 0, 0, null);
            } else if (sex == 2) {
                LabelMaker.make(g, DefaultManager.getFemale(), FontManagerUS.SSP10, sexX, yd, sexW, lineHeight, 0, 0, null);
            }
            Date bds = mausi.getDate("MOS_BIRTHDAY");
            LabelMaker.make(g, LabelMaker.getDateString(bds), FontManagerUS.SSP10, dateX, yd, datW, lineHeight, 0, 0, null);
            String gts = mausi.getGenotype();
            gts = gts != null && !gts.equals("?") ? " " + gts + " " : "";
            LabelMaker.make(g, gts, FontManagerUS.SSP9, etX + rand, yd += lineHeight - 2, gtW, lineHeight, 0, 2, null);
            yd += lineHeight;
            ++i;
        }
    }

    private static void makeFill(Cage c, Graphics2D g, int links, int oben, int rechts, int unten) {
        Color[] ccol = c.getColor(0);
        if (ccol != null && ccol.length != 0) {
            if (ccol.length == 1 && ccol[0] != CageColorManager.NULL_COLOR && !(ccol[0] instanceof MusterColor)) {
                UPennPrinter.fillRect(g, links, oben, rechts, unten, ccol[0]);
            } else {
                Graphics2D g2d = g;
                g2d.setPaint(CageDisplayManager.getTexture(links, 0, ccol, rechts - links, true));
                UPennPrinter.fillRect(g, links, oben, rechts, unten, null);
            }
        }
    }
}

