/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.util;

import de.hannse.netobjects.util.Babel;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import mausoleum.printing.util.Papierformat;

public class CPPageFormat
extends PageFormat
implements Serializable {
    private static final long serialVersionUID = 1234234L;
    private static final String FORM_PORTRAIT = "PORTRAIT";
    private static final String FORM_LANDSCAPE = "LANDSCAPE";
    public static final String[] PAGE_ORIENTATION_STRINGS = new String[]{"PORTRAIT", "LANDSCAPE"};
    public static final int[] PAGE_ORIENTATION_INTS;

    static {
        int[] nArray = new int[2];
        nArray[0] = 1;
        PAGE_ORIENTATION_INTS = nArray;
    }

    public static String[] getOrientations() {
        String[] erg = new String[PAGE_ORIENTATION_STRINGS.length];
        int i = 0;
        while (i < PAGE_ORIENTATION_STRINGS.length) {
            erg[i] = Babel.get(PAGE_ORIENTATION_STRINGS[i]);
            ++i;
        }
        return erg;
    }

    public CPPageFormat() {
    }

    public CPPageFormat(String pageformat, int orientation, double rand_links, double rand_oben, double rand_rechts, double rand_unten) {
        Paper pap = Papierformat.getPaper(pageformat);
        if (pap == null) {
            throw new IllegalArgumentException("Unknown page format");
        }
        this.setOrientation(orientation);
        double marg_l = rand_links;
        double marg_r = rand_rechts;
        double marg_o = rand_oben;
        double marg_u = rand_unten;
        if (marg_l + marg_r > pap.getWidth()) {
            throw new IllegalArgumentException("Margins are too big");
        }
        if (marg_o + marg_u > pap.getHeight()) {
            throw new IllegalArgumentException("Margins are too big");
        }
        pap.setImageableArea(marg_l, marg_o, pap.getWidth() - marg_l - marg_r, pap.getHeight() - marg_o - marg_u);
        this.setPaper(pap);
    }

    public String toTableString() {
        StringBuffer msb = new StringBuffer();
        msb.append(Double.toString(this.getWidth()).replace('.', ',')).append(";");
        msb.append(Double.toString(this.getHeight()).replace('.', ',')).append(";");
        msb.append(Double.toString(this.getImageableX()).replace('.', ',')).append(";");
        msb.append(Double.toString(this.getImageableY()).replace('.', ',')).append(";");
        msb.append(Double.toString(this.getImageableWidth()).replace('.', ',')).append(";");
        msb.append(Double.toString(this.getImageableHeight()).replace('.', ','));
        return msb.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Paper paper = this.getPaper();
        out.writeDouble(paper.getWidth());
        out.writeDouble(paper.getHeight());
        out.writeDouble(paper.getImageableX());
        out.writeDouble(paper.getImageableY());
        out.writeDouble(paper.getImageableWidth());
        out.writeDouble(paper.getImageableHeight());
        out.writeInt(this.getOrientation());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        double w = in.readDouble();
        double h = in.readDouble();
        double x = in.readDouble();
        double y = in.readDouble();
        double iw = in.readDouble();
        double ih = in.readDouble();
        int orientation = in.readInt();
        Paper pap = new Paper();
        pap.setSize(w, h);
        this.setOrientation(orientation);
        pap.setImageableArea(x, y, iw, ih);
        this.setPaper(pap);
    }
}

