/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.util;

import de.hannse.netobjects.util.Babel;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import mausoleum.alert.Alert;
import mausoleum.gui.KomfortTextField;
import mausoleum.gui.MGButton;
import mausoleum.gui.NULLLayoutManager;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.FontManager;
import mausoleum.helper.WindowUtils;
import mausoleum.printing.util.CPPageFormat;
import mausoleum.printing.util.Papierformat;
import mausoleum.ui.UIDef;

public class CPPageFormatDialog
extends JDialog {
    private static final long serialVersionUID = -1628146097620816181L;
    private static final int LABEL_WIDTH = UIDef.getScaled(120);
    private static final int LABEL_WIDTH_2 = UIDef.getScaled(60);
    private static final int DOUBLEFIELD_WIDTH = UIDef.getScaled(80);
    private static final int MM_WIDTH = UIDef.getScaled(30);
    private static final int FIELD_WIDTH = 2 * UIDef.INNER_RAND + LABEL_WIDTH_2 + DOUBLEFIELD_WIDTH + MM_WIDTH;
    private static final int FIELD_START = 2 * UIDef.RAND + LABEL_WIDTH;
    private static final int BREITE = 3 * UIDef.RAND + LABEL_WIDTH + FIELD_WIDTH;
    private static PageFormat cvLastSelectedPageFormat = null;
    private JComboBox ivPaperSizeCombo = new JComboBox<String>(Papierformat.NAMES);
    private JComboBox ivOrientationCombo = null;
    private KomfortTextField ivLeftMarginField = new KomfortTextField(10.0);
    private KomfortTextField ivRightMarginField = new KomfortTextField(10.0);
    private KomfortTextField ivTopMarginField = new KomfortTextField(10.0);
    private KomfortTextField ivBottomMarginField = new KomfortTextField(10.0);
    private CPPageFormat ivFormat = null;

    public static CPPageFormat getPageFormat(Frame senderFrame, JDialog senderDialog, String okLabel, Vector extraLineComps) {
        CPPageFormatDialog rpfd = null;
        rpfd = senderFrame != null ? new CPPageFormatDialog(senderFrame, okLabel, extraLineComps) : new CPPageFormatDialog(senderDialog, okLabel, extraLineComps);
        if (rpfd.ivFormat != null) {
            cvLastSelectedPageFormat = rpfd.ivFormat;
        }
        return rpfd.ivFormat;
    }

    private static String getNormalText(double wert) {
        StringBuffer msb = new StringBuffer();
        int iwert = (int)wert;
        double rest = wert - (double)iwert;
        if (rest > 0.999) {
            ++iwert;
            rest = 0.0;
        } else if (rest < 1.0E-4) {
            rest = 0.0;
        }
        msb.append(iwert);
        if (rest != 0.0) {
            msb.append(".");
            rest = (rest + 0.05) * 10.0;
            msb.append((int)rest);
        }
        return msb.toString();
    }

    private CPPageFormatDialog(Frame sender, String okLabel, Vector extraLineComps) {
        super(sender, true);
        this.init(okLabel, extraLineComps);
    }

    private CPPageFormatDialog(JDialog sender, String okLabel, Vector extraLineComps) {
        super((Dialog)sender, true);
        this.init(okLabel, extraLineComps);
    }

    private void init(String okLabel, Vector extraLineComps) {
        this.setTitle(Babel.get("PAGEFORMAT"));
        int y = UIDef.RAND;
        y += UIDef.INNER_RAND + UIDef.LINE_HEIGHT;
        y += UIDef.INNER_RAND + UIDef.LINE_HEIGHT;
        y += UIDef.INNER_RAND + UIDef.LINE_HEIGHT;
        y += UIDef.INNER_RAND + UIDef.LINE_HEIGHT;
        y += UIDef.INNER_RAND + UIDef.LINE_HEIGHT;
        y += UIDef.LINE_HEIGHT;
        this.setContentPane(new RequesterPane(new NULLLayoutManager(BREITE, y += UIDef.BUT_HEIGHT + UIDef.RAND)));
        y = UIDef.RAND;
        PageFormat pf = cvLastSelectedPageFormat;
        double links = 10.0;
        double oben = 10.0;
        double rechts = 10.0;
        double unten = 10.0;
        if (pf != null) {
            links = pf.getPaper().getImageableX() / 2.834645669291339;
            oben = pf.getPaper().getImageableY() / 2.834645669291339;
            rechts = (pf.getPaper().getWidth() - pf.getPaper().getImageableWidth() - pf.getPaper().getImageableX()) / 2.834645669291339;
            unten = (pf.getPaper().getHeight() - pf.getPaper().getImageableHeight() - pf.getPaper().getImageableY()) / 2.834645669291339;
        }
        JLabel lab = new JLabel(Babel.get("PAPERSIZE"));
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(UIDef.RAND, y, LABEL_WIDTH, UIDef.LINE_HEIGHT);
        this.getContentPane().add(lab);
        this.ivPaperSizeCombo.setBounds(2 * UIDef.RAND + LABEL_WIDTH, y, FIELD_WIDTH, UIDef.LINE_HEIGHT);
        this.getContentPane().add(this.ivPaperSizeCombo);
        lab = new JLabel(Babel.get("ORIENTATION"));
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(UIDef.RAND, y += UIDef.INNER_RAND + UIDef.LINE_HEIGHT, LABEL_WIDTH, UIDef.LINE_HEIGHT);
        this.getContentPane().add(lab);
        this.ivOrientationCombo = new JComboBox<String>(CPPageFormat.getOrientations());
        if (pf != null) {
            int ori = pf.getOrientation();
            int i = 0;
            while (i < CPPageFormat.PAGE_ORIENTATION_INTS.length) {
                if (CPPageFormat.PAGE_ORIENTATION_INTS[i] == ori) {
                    this.ivOrientationCombo.setSelectedIndex(i);
                }
                ++i;
            }
        }
        this.ivOrientationCombo.setBounds(FIELD_START, y, FIELD_WIDTH, UIDef.LINE_HEIGHT);
        this.getContentPane().add(this.ivOrientationCombo);
        lab = new JLabel(Babel.get("RAND"));
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(UIDef.RAND, y += UIDef.INNER_RAND + UIDef.LINE_HEIGHT, LABEL_WIDTH, UIDef.LINE_HEIGHT);
        this.getContentPane().add(lab);
        lab = new JLabel(Babel.get("OBEN"));
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(FIELD_START, y, LABEL_WIDTH_2, UIDef.LINE_HEIGHT);
        this.getContentPane().add(lab);
        this.ivTopMarginField.setText(CPPageFormatDialog.getNormalText(oben));
        this.ivTopMarginField.setBounds(FIELD_START + UIDef.INNER_RAND + LABEL_WIDTH_2, y, DOUBLEFIELD_WIDTH, UIDef.LINE_HEIGHT);
        this.getContentPane().add(this.ivTopMarginField);
        lab = new JLabel("mm");
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(FIELD_START + 2 * UIDef.INNER_RAND + LABEL_WIDTH_2 + DOUBLEFIELD_WIDTH, y, MM_WIDTH, UIDef.LINE_HEIGHT);
        this.getContentPane().add(lab);
        lab = new JLabel(Babel.get("LINKS"));
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(FIELD_START, y += UIDef.INNER_RAND + UIDef.LINE_HEIGHT, LABEL_WIDTH_2, UIDef.LINE_HEIGHT);
        this.getContentPane().add(lab);
        this.ivLeftMarginField.setText(CPPageFormatDialog.getNormalText(links));
        this.ivLeftMarginField.setBounds(FIELD_START + UIDef.INNER_RAND + LABEL_WIDTH_2, y, DOUBLEFIELD_WIDTH, UIDef.LINE_HEIGHT);
        this.getContentPane().add(this.ivLeftMarginField);
        lab = new JLabel("mm");
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(FIELD_START + 2 * UIDef.INNER_RAND + LABEL_WIDTH_2 + DOUBLEFIELD_WIDTH, y, MM_WIDTH, UIDef.LINE_HEIGHT);
        this.getContentPane().add(lab);
        lab = new JLabel(Babel.get("RECHTS"));
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(FIELD_START, y += UIDef.INNER_RAND + UIDef.LINE_HEIGHT, LABEL_WIDTH_2, UIDef.LINE_HEIGHT);
        this.getContentPane().add(lab);
        this.ivRightMarginField.setText(CPPageFormatDialog.getNormalText(rechts));
        this.ivRightMarginField.setBounds(FIELD_START + UIDef.INNER_RAND + LABEL_WIDTH_2, y, DOUBLEFIELD_WIDTH, UIDef.LINE_HEIGHT);
        this.getContentPane().add(this.ivRightMarginField);
        lab = new JLabel("mm");
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(FIELD_START + 2 * UIDef.INNER_RAND + LABEL_WIDTH_2 + DOUBLEFIELD_WIDTH, y, MM_WIDTH, UIDef.LINE_HEIGHT);
        this.getContentPane().add(lab);
        lab = new JLabel(Babel.get("UNTEN"));
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(FIELD_START, y += UIDef.INNER_RAND + UIDef.LINE_HEIGHT, LABEL_WIDTH_2, UIDef.LINE_HEIGHT);
        this.getContentPane().add(lab);
        this.ivBottomMarginField.setText(CPPageFormatDialog.getNormalText(unten));
        this.ivBottomMarginField.setBounds(FIELD_START + UIDef.INNER_RAND + LABEL_WIDTH_2, y, DOUBLEFIELD_WIDTH, UIDef.LINE_HEIGHT);
        this.getContentPane().add(this.ivBottomMarginField);
        lab = new JLabel("mm");
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setBounds(FIELD_START + 2 * UIDef.INNER_RAND + LABEL_WIDTH_2 + DOUBLEFIELD_WIDTH, y, MM_WIDTH, UIDef.LINE_HEIGHT);
        this.getContentPane().add(lab);
        y += UIDef.INNER_RAND + UIDef.LINE_HEIGHT;
        if (extraLineComps != null) {
            Iterator iter = extraLineComps.iterator();
            while (iter.hasNext()) {
                JComponent comp = (JComponent)iter.next();
                comp.setBounds(FIELD_START, y, FIELD_WIDTH, UIDef.LINE_HEIGHT);
                this.getContentPane().add(comp);
                y += UIDef.INNER_RAND + UIDef.LINE_HEIGHT;
            }
        }
        int obw = BREITE - 2 * UIDef.RAND;
        MGButton but = new MGButton(Babel.get(okLabel));
        but.setBounds(UIDef.RAND, y += UIDef.LINE_HEIGHT, obw, UIDef.BUT_HEIGHT);
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    CPPageFormatDialog.this.createFormat();
                    CPPageFormatDialog.this.dispose();
                }
                catch (Exception exx) {
                    Alert.showAlert(exx.getMessage(), true);
                    CPPageFormatDialog.this.ivFormat = null;
                }
            }
        });
        but.setFont(FontManager.getFont("SSB12"));
        this.getContentPane().add(but);
        WindowUtils.bringUpCenteredDialog(this, BREITE, y += UIDef.BUT_HEIGHT + UIDef.RAND, true);
    }

    private void createFormat() {
        this.ivFormat = new CPPageFormat(Papierformat.NAMES[this.ivPaperSizeCombo.getSelectedIndex()], CPPageFormat.PAGE_ORIENTATION_INTS[this.ivOrientationCombo.getSelectedIndex()], this.ivLeftMarginField.getDouble(0.0) * 2.834645669291339, this.ivTopMarginField.getDouble(0.0) * 2.834645669291339, this.ivRightMarginField.getDouble(0.0) * 2.834645669291339, this.ivBottomMarginField.getDouble(0.0) * 2.834645669291339);
    }
}

