/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.util;

import de.hannse.netobjects.util.MyDate;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.border.LineBorder;
import mausoleum.helper.DatumFormat;

public class LabelMaker {
    private static JLabel cvLabel = new JLabel();

    public static void makeWithDate(Graphics2D g, Date d, Font f, int x, int y, int w, int h, int borderwidth, int halign, Color bgColor) {
        LabelMaker.make(g, LabelMaker.getVeryShortDateString(d), f, x, y, w, h, borderwidth, halign, bgColor);
    }

    public static void makeWithDate(Graphics2D g, int datum, Font f, int x, int y, int w, int h, int borderwidth, int halign, Color bgColor) {
        LabelMaker.make(g, LabelMaker.getVeryShortDateString(datum), f, x, y, w, h, borderwidth, halign, bgColor);
    }

    public static void make(Graphics2D g, int num, Font f, int x, int y, int w, int h, int borderwidth, int halign, Color bgColor) {
        LabelMaker.make(g, Integer.toString(num), f, x, y, w, h, borderwidth, halign, bgColor);
    }

    public static void make(Graphics2D g, long num, Font f, int x, int y, int w, int h, int borderwidth, int halign, Color bgColor) {
        LabelMaker.make(g, Long.toString(num), f, x, y, w, h, borderwidth, halign, bgColor);
    }

    public static void make(Graphics2D g, String cont, Font f, int x, int y, int w, int h, int borderwidth, int halign, Color bgColor) {
        LabelMaker.make(g, cont, f, x, y, w, h, borderwidth, halign, bgColor, Color.black);
    }

    public static void make(Graphics2D g, String cont, Font f, int x, int y, int w, int h, int borderwidth, int halign, Color bgColor, Color fgColor) {
        cvLabel.setText(cont);
        cvLabel.setFont(f);
        cvLabel.setForeground(fgColor);
        cvLabel.setEnabled(true);
        cvLabel.setBounds(x, y, w, h);
        cvLabel.setHorizontalAlignment(halign);
        cvLabel.setVerticalAlignment(0);
        if (bgColor != null) {
            cvLabel.setBackground(bgColor);
            cvLabel.setOpaque(true);
        } else {
            cvLabel.setOpaque(false);
        }
        if (borderwidth != 0) {
            cvLabel.setBorder(new LineBorder(fgColor, borderwidth));
        } else {
            cvLabel.setBorder(null);
        }
        g.translate(x, y);
        cvLabel.paint(g);
        g.translate(-x, -y);
    }

    public static void makeMitRandDrumrum(Graphics2D g, String cont, Font f, int x, int y, int w, int h, int borderwidth, int halign, Color bgColor) {
        cvLabel.setText(cont);
        cvLabel.setFont(f);
        cvLabel.setForeground(Color.black);
        cvLabel.setEnabled(true);
        cvLabel.setBounds(x, y, w, h);
        cvLabel.setHorizontalAlignment(halign);
        cvLabel.setVerticalAlignment(0);
        if (bgColor != null) {
            cvLabel.setBackground(bgColor);
            cvLabel.setOpaque(true);
        } else {
            cvLabel.setOpaque(false);
        }
        if (borderwidth != 0) {
            cvLabel.setBorder(new LineBorder(Color.black, borderwidth));
        } else {
            cvLabel.setBorder(null);
        }
        LabelMaker.doLabel(g, x - 1, y - 1, Color.black);
        LabelMaker.doLabel(g, x + 0, y - 1, Color.black);
        LabelMaker.doLabel(g, x + 1, y - 1, Color.black);
        LabelMaker.doLabel(g, x - 1, y, Color.black);
        LabelMaker.doLabel(g, x + 1, y, Color.black);
        LabelMaker.doLabel(g, x - 1, y + 1, Color.black);
        LabelMaker.doLabel(g, x + 0, y + 1, Color.black);
        LabelMaker.doLabel(g, x + 1, y + 1, Color.black);
        LabelMaker.doLabel(g, x, y, Color.white);
    }

    private static void doLabel(Graphics2D g, int x, int y, Color foregreound) {
        g.translate(x, y);
        cvLabel.setForeground(foregreound);
        cvLabel.paint(g);
        g.translate(-x, -y);
    }

    public static String getDateString(Date d) {
        if (d != null) {
            return DatumFormat.getJustDateString(d);
        }
        return "";
    }

    public static String getDateString(int tage) {
        if (tage != Integer.MIN_VALUE) {
            return DatumFormat.getJustDateString(new MyDate(tage));
        }
        return "";
    }

    public static String getVeryShortDateString(Date d) {
        if (d != null) {
            return DatumFormat.getVeryShortDateString(d);
        }
        return "";
    }

    public static String getVeryShortDateString(int tage) {
        if (tage != Integer.MIN_VALUE) {
            return DatumFormat.getVeryShortDateString(new MyDate(tage));
        }
        return "";
    }
}

