/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.util;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.util.MyDate;
import java.awt.Color;
import java.awt.Point;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.factsheets.VisitReport;
import mausoleum.helper.LongPunkt;
import mausoleum.main.DefaultManager;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.visit.Visit;

public class Wurf {
    private static final int TAGE_TOLERANZ = 3;
    public static final Color[] FATHER_COLORS = new Color[]{new Color(210, 210, 255), new Color(255, 210, 255)};
    public static final Color[] MOTHER_COLORS = new Color[]{new Color(255, 210, 210), new Color(210, 255, 210), new Color(255, 255, 210), new Color(212, 220, 240), new Color(180, 240, 210), new Color(210, 255, 255)};
    private static final Comparator DATE_SORTER = new Comparator(){

        public int compare(Object o1, Object o2) {
            return Wurf.compareWuerfe((Wurf)o1, (Wurf)o2, -1);
        }
    };
    private static final Comparator INV_DATE_SORTER = new Comparator(){

        public int compare(Object o1, Object o2) {
            return Wurf.compareWuerfe((Wurf)o1, (Wurf)o2, 1);
        }
    };
    public static long FATHERID_FOR_FOSTER_WURF = -3L;
    public long ivMotherID = 0L;
    public long ivFatherID = 0L;
    public int ivDay = Integer.MIN_VALUE;
    public Vector ivKids = null;
    public int ivNumBornTotal = 0;
    public int ivNumMaleBorn = 0;
    public int ivNumFemaleBorn = 0;
    public int ivNumMaleLeft = 0;
    public int ivNumFemaleLeft = 0;
    public int ivNumLeft = 0;
    public int ivNumNotKilled = 0;
    public boolean ivNumbersDeadAliveOK = true;
    public final String ivGroup;

    public static Vector getWuerfeForFactsheet(Mouse mouse) {
        Vector kidsv;
        if (mouse != null && mouse.existed() && (kidsv = mouse.getKids()) != null) {
            Vector wuerfe = new Vector();
            Iterator iter = kidsv.iterator();
            while (iter.hasNext()) {
                Mouse kid = (Mouse)iter.next();
                int datum = Integer.MIN_VALUE;
                Date d = kid.getDate("MOS_BIRTHDAY");
                if (d != null) {
                    datum = MyDate.getTage(d);
                }
                Wurf.putInWurf(mouse.getGroup(), kid.getID(), kid.getLong("MOS_FATHER", 0L), kid.getLong("MOS_MOTHER", 0L), datum, wuerfe, null, kid.getSex(), kid, false);
            }
            return wuerfe;
        }
        return null;
    }

    public static int getWurfCount(Mouse mouse, int defVal) {
        int sum = defVal;
        if (mouse != null && mouse.existed() && mouse.getSex() == 2) {
            sum = 0;
            int[] kbds = (int[])mouse.get("MOS_KID_BD");
            if (kbds != null) {
                HashSet<Integer> hs = new HashSet<Integer>();
                int i = 0;
                while (i < kbds.length) {
                    boolean isDa = false;
                    int dd = -3;
                    while (dd <= 3 && !isDa) {
                        if (hs.contains(new Integer(kbds[i] + dd))) {
                            isDa = true;
                        }
                        ++dd;
                    }
                    if (!isDa) {
                        hs.add(new Integer(kbds[i]));
                    }
                    ++i;
                }
                sum = hs.size();
            }
        }
        return sum;
    }

    public static Vector getFosterWuerfeForFactsheet(Mouse mouse) {
        if (mouse != null && mouse.existed()) {
            long mainMouseID = mouse.getID();
            Vector<Mouse> fosterKids = new Vector<Mouse>();
            Visit[] visArr = (Visit[])mouse.get("MOS_VISIT");
            if (visArr != null) {
                int i = 0;
                while (i < visArr.length) {
                    Visit[] cageVisits;
                    long startMillis = visArr[i].getStart(Long.MIN_VALUE);
                    long endMillis = visArr[i].getEnd(Long.MAX_VALUE);
                    Cage c = (Cage)ObjectStore.getObjectDeadOrAlive(2, visArr[i].ivCageID, mouse.getGroup(), null, false);
                    if (c != null && (cageVisits = (Visit[])c.get("CAG_VISIT")) != null) {
                        int j = 0;
                        while (j < cageVisits.length) {
                            Mouse potFKID;
                            Point p;
                            if (cageVisits[j].ivMouseID != mainMouseID && (p = VisitReport.getOverlapInDays(cageVisits[j], startMillis, endMillis)) != null && (potFKID = (Mouse)ObjectStore.getObjectDeadOrAlive(1, cageVisits[j].ivMouseID, mouse.getGroup(), null, false)) != null && potFKID.getLong("MOS_FOSTID", 0L) == mainMouseID) {
                                fosterKids.add(potFKID);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            if (!fosterKids.isEmpty()) {
                Vector wuerfe = new Vector();
                Iterator iter = fosterKids.iterator();
                while (iter.hasNext()) {
                    Mouse kid = (Mouse)iter.next();
                    int datum = Integer.MIN_VALUE;
                    Date d = kid.getDate("MOS_BIRTHDAY");
                    if (d != null) {
                        datum = MyDate.getTage(d);
                    }
                    Wurf.putInWurf(mouse.getGroup(), kid.getID(), FATHERID_FOR_FOSTER_WURF, mouse.getID(), datum, wuerfe, null, kid.getSex(), kid, false);
                }
                return wuerfe;
            }
        }
        return null;
    }

    public static Vector collectWuerfeForPrinters(Cage cage, Vector males, Vector females, boolean extraMating, int maxMales, int maxFemales, HashMap sepDatesByMaleID, boolean neueOben, boolean enrichAlsoFemales, boolean macheKinderVereinigungBeiExtraMating, boolean macheKinderVereinigungBeiNormalMating, boolean kidHadToBeInside, boolean otherParentHadToBeInsde, boolean enrichParentHadToBeInCage, boolean didoModus, boolean enrichParentHasToHaveKidsInCage, boolean getKidAlways) {
        Vector wuerfe = new Vector();
        long cageID = cage.getID();
        Visit[] cageVArr = (Visit[])cage.get("CAG_VISIT");
        if (cageVArr == null || cageVArr.length == 0) {
            return null;
        }
        Vector unfinishedVisits = Visit.collectUnfinishedVisits(cageVArr);
        Vector mice = Wurf.findSexActiveMice(cage, null, males, females, null);
        if (males.size() > maxMales || females.size() > maxFemales) {
            return null;
        }
        HashMap maleKidIds = Wurf.collectKidIds(males, cageVArr, kidHadToBeInside, otherParentHadToBeInsde);
        HashMap femaleKidIds = Wurf.collectKidIds(females, cageVArr, kidHadToBeInside, otherParentHadToBeInsde);
        boolean kinderVereinigung = macheKinderVereinigungBeiNormalMating;
        if (extraMating && !cage.isMatingCage()) {
            Vector<Mouse> extraMales = null;
            if (!enrichAlsoFemales) {
                Mouse female;
                Visit[] visits;
                if (females.isEmpty()) {
                    return null;
                }
                if (didoModus && females.size() == 1 && males.isEmpty() && (visits = (Visit[])(female = (Mouse)females.firstElement()).get("MOS_VISIT")) != null && visits.length >= 2) {
                    Visit lastVisit = visits[visits.length - 1];
                    if (lastVisit.ivEndDate == null && lastVisit.ivStartMode == 7) {
                        Vector ovVisits;
                        Visit penultimatetVisit = visits[visits.length - 2];
                        Cage pvCage = (Cage)ObjectStore.getClientObject(2, penultimatetVisit.ivCageID, female.getGroup());
                        Visit[] pvCageVArr = (Visit[])pvCage.get("CAG_VISIT");
                        if (pvCageVArr != null && pvCageVArr.length != 0 && (ovVisits = Visit.getOverlapVisits(penultimatetVisit, pvCageVArr, 0)) != null && !ovVisits.isEmpty()) {
                            long checkZeit = penultimatetVisit.ivEndDate.getTime();
                            long femaleID = female.getID();
                            Vector<Mouse> vorPaarungsBoecke = new Vector<Mouse>();
                            Iterator iter = ovVisits.iterator();
                            while (iter.hasNext()) {
                                long vend;
                                long vstart;
                                Mouse tMouse;
                                Visit visit = (Visit)iter.next();
                                if (visit.ivMouseID == femaleID || (tMouse = (Mouse)ObjectStore.getClientObject(1, visit.ivMouseID, female.getGroup())) == null || tMouse.getSex() != 1) continue;
                                LongPunkt lp = tMouse.getSexualActiveDates();
                                if (visit.ivStartDate != null && (vstart = visit.ivStartDate.getTime()) > lp.ivX) {
                                    lp.ivX = vstart;
                                }
                                if (visit.ivEndDate != null && (vend = visit.ivEndDate.getTime()) < lp.ivY) {
                                    lp.ivY = vend;
                                }
                                if (lp.ivX > checkZeit || lp.ivY < checkZeit) continue;
                                vorPaarungsBoecke.add(tMouse);
                            }
                            if (vorPaarungsBoecke.size() == 1) {
                                maleKidIds = Wurf.collectKidIds(vorPaarungsBoecke, cageVArr, kidHadToBeInside, false);
                                femaleKidIds = Wurf.collectKidIds(females, cageVArr, kidHadToBeInside, false);
                                extraMales = vorPaarungsBoecke;
                            }
                        }
                    }
                }
            }
            if (extraMales == null) {
                extraMales = Wurf.enrichParents(cageID, cageVArr, females, femaleKidIds, maleKidIds, cage.getGroup(), sepDatesByMaleID, enrichParentHadToBeInCage);
                if (enrichParentHasToHaveKidsInCage) {
                    Wurf.removeParentsWithoutKidsInCage(extraMales, unfinishedVisits);
                }
            }
            if (enrichAlsoFemales) {
                Vector extraFemales = Wurf.enrichParents(cageID, cageVArr, males, maleKidIds, femaleKidIds, cage.getGroup(), sepDatesByMaleID, enrichParentHadToBeInCage);
                if (enrichParentHasToHaveKidsInCage) {
                    Wurf.removeParentsWithoutKidsInCage(extraFemales, unfinishedVisits);
                }
                females.addAll(extraFemales);
            }
            males.addAll(extraMales);
            if (males.size() > maxMales || females.size() > maxFemales) {
                return null;
            }
            kinderVereinigung = macheKinderVereinigungBeiExtraMating;
        }
        if (mice != null && !females.isEmpty()) {
            Mouse parent;
            Long kidID;
            Vector parents = new Vector();
            parents.addAll(males);
            parents.addAll(females);
            Iterator iter = maleKidIds.keySet().iterator();
            while (iter.hasNext()) {
                kidID = (Long)iter.next();
                long klv = kidID;
                Long dadID = (Long)maleKidIds.get(kidID);
                Long momID = (Long)femaleKidIds.get(kidID);
                parent = Wurf.getMouse(dadID, parents);
                if (parent == null) continue;
                if (momID != null) {
                    Wurf.putInWurf(parent.getGroup(), klv, dadID, momID, Wurf.getIntInfo(parent, klv, "MOS_KID_BD", Integer.MIN_VALUE), wuerfe, cageVArr, Wurf.getIntInfo(parent, klv, "MOS_KID_SX", 0), null, getKidAlways);
                    continue;
                }
                if (!kinderVereinigung) continue;
                Wurf.putInWurf(parent.getGroup(), klv, dadID, Wurf.getLongInfo(parent, klv, "MOS_KID_OP", -3L), Wurf.getIntInfo(parent, klv, "MOS_KID_BD", Integer.MIN_VALUE), wuerfe, cageVArr, Wurf.getIntInfo(parent, klv, "MOS_KID_SX", 0), null, getKidAlways);
            }
            iter = femaleKidIds.keySet().iterator();
            while (iter.hasNext()) {
                kidID = (Long)iter.next();
                long klv = kidID;
                Long momID = (Long)femaleKidIds.get(kidID);
                Long dadID = (Long)maleKidIds.get(kidID);
                if (dadID != null || !kinderVereinigung || (parent = Wurf.getMouse(momID, parents)) == null) continue;
                Wurf.putInWurf(parent.getGroup(), klv, Wurf.getLongInfo(parent, klv, "MOS_KID_OP", -3L), momID, Wurf.getIntInfo(parent, klv, "MOS_KID_BD", Integer.MIN_VALUE), wuerfe, cageVArr, Wurf.getIntInfo(parent, klv, "MOS_KID_SX", 0), null, getKidAlways);
            }
        }
        Wurf.sortWuerfe(wuerfe, neueOben);
        return wuerfe;
    }

    public static int compareWuerfe(Wurf w1, Wurf w2, int faktor) {
        if (w1.ivDay < w2.ivDay) {
            return faktor;
        }
        if (w1.ivDay > w2.ivDay) {
            return -faktor;
        }
        return 0;
    }

    public static void sortWuerfe(Vector wuerfe, boolean neueOben) {
        if (wuerfe != null && wuerfe.size() > 1) {
            Collections.sort(wuerfe, neueOben ? INV_DATE_SORTER : DATE_SORTER);
        }
    }

    public static int getLatestWurfDate(Cage cage) {
        return Wurf.getLatestWurfDate(cage, null);
    }

    public static int getLatestWurfDate(Cage cage, Vector mice) {
        Iterator iter;
        int res = Integer.MIN_VALUE;
        Vector lastVisitDateTarget = new Vector();
        Vector males = new Vector();
        Vector females = new Vector();
        Wurf.findSexActiveMice(cage, mice, males, females, lastVisitDateTarget);
        if (!males.isEmpty() && !females.isEmpty()) {
            HashSet<Long> maleKidIDs = new HashSet<Long>();
            Iterator iter2 = males.iterator();
            while (iter2.hasNext()) {
                Mouse father = (Mouse)iter2.next();
                long[] kidIds = (long[])father.get("MOS_KID");
                if (kidIds == null) continue;
                int i = 0;
                while (i < kidIds.length) {
                    maleKidIDs.add(new Long(kidIds[i]));
                    ++i;
                }
            }
            if (!maleKidIDs.isEmpty()) {
                int latestDate = Integer.MIN_VALUE;
                iter = females.iterator();
                while (iter.hasNext()) {
                    Mouse mother = (Mouse)iter.next();
                    long[] kidIds = (long[])mother.get("MOS_KID");
                    int[] kidBDs = (int[])mother.get("MOS_KID_BD");
                    if (kidIds == null || kidBDs == null || kidIds.length != kidBDs.length) continue;
                    int i = 0;
                    while (i < kidIds.length) {
                        if (maleKidIDs.contains(new Long(kidIds[i])) && kidBDs[i] != Integer.MIN_VALUE && kidBDs[i] > latestDate) {
                            latestDate = kidBDs[i];
                        }
                        ++i;
                    }
                }
                if (latestDate != Integer.MIN_VALUE) {
                    res = latestDate;
                }
            }
        }
        if (res == Integer.MIN_VALUE && !lastVisitDateTarget.isEmpty()) {
            long latestMillis = Long.MIN_VALUE;
            iter = lastVisitDateTarget.iterator();
            while (iter.hasNext()) {
                Date d = (Date)iter.next();
                long millis = d.getTime();
                if (millis <= latestMillis) continue;
                latestMillis = millis;
            }
            if (latestMillis != Long.MIN_VALUE) {
                res = MyDate.getTage(latestMillis);
            }
        }
        return res;
    }

    public static Vector findSexActiveMice(Cage c, Vector mice, Vector males, Vector females, Vector lastVisitStartDateTarget) {
        if (mice == null) {
            mice = c.getActualMice();
        }
        if (mice != null) {
            int i = 0;
            while (i < mice.size()) {
                Mouse mouse = (Mouse)mice.elementAt(i);
                if (mouse.isPossMatingPartner()) {
                    Visit lastVisit;
                    switch (mouse.getSex()) {
                        case 1: {
                            males.addElement(mouse);
                            break;
                        }
                        case 2: {
                            females.addElement(mouse);
                            break;
                        }
                    }
                    if (lastVisitStartDateTarget != null && (lastVisit = Visit.findLatestUnfinishedVisit((Visit[])mouse.get("MOS_VISIT"), mouse.getID(), c.getID())) != null && lastVisit.ivStartDate != null) {
                        lastVisitStartDateTarget.add(lastVisit.ivStartDate);
                    }
                }
                ++i;
            }
        }
        return mice;
    }

    private static void removeParentsWithoutKidsInCage(Vector parents, Vector unfinishedVisits) {
        if (parents != null) {
            Vector tmp = new Vector(parents);
            parents.clear();
            Iterator iterator = tmp.iterator();
            while (iterator.hasNext()) {
                Mouse mouse = (Mouse)iterator.next();
                boolean hat = false;
                long[] kidIDs = (long[])mouse.get("MOS_KID");
                if (kidIDs != null) {
                    int i = 0;
                    while (i < kidIDs.length && !hat) {
                        Iterator iterator2 = unfinishedVisits.iterator();
                        while (iterator2.hasNext() && !hat) {
                            Visit vis = (Visit)iterator2.next();
                            if (vis.ivMouseID != kidIDs[i]) continue;
                            hat = true;
                        }
                        ++i;
                    }
                }
                if (!hat) continue;
                parents.add(mouse);
            }
            tmp.clear();
            Object var2_2 = null;
        }
    }

    private static void putInWurf(String group, long kidID, long fid, long mid, int datum, Vector target, Visit[] cageVarr, int sex, Mouse kid, boolean getKidAlways) {
        Iterator iter = target.iterator();
        while (iter.hasNext()) {
            Wurf w = (Wurf)iter.next();
            if (w.ivFatherID != fid || w.ivMotherID != mid) continue;
            int diff = datum - w.ivDay;
            if (diff < 0) {
                diff = -diff;
            }
            if (diff >= 3) continue;
            w.addKidToWurf(kidID, cageVarr, sex, kid, getKidAlways);
            if (datum < w.ivDay) {
                w.ivDay = datum;
            }
            return;
        }
        new Wurf(fid, mid, datum, group, target).addKidToWurf(kidID, cageVarr, sex, kid, getKidAlways);
    }

    private static int getIntInfo(Mouse mom, long kidID, String key, int defVal) {
        long[] kids = (long[])mom.get("MOS_KID");
        int[] arr = (int[])mom.get(key);
        if (kids != null && arr != null && kids.length == arr.length) {
            int i = 0;
            while (i < kids.length) {
                if (kids[i] == kidID) {
                    return arr[i];
                }
                ++i;
            }
        }
        return defVal;
    }

    private static long getLongInfo(Mouse mom, long kidID, String key, long defVal) {
        long[] kids = (long[])mom.get("MOS_KID");
        long[] arr = (long[])mom.get(key);
        if (kids != null && arr != null && kids.length == arr.length) {
            int i = 0;
            while (i < kids.length) {
                if (kids[i] == kidID) {
                    return arr[i];
                }
                ++i;
            }
        }
        return defVal;
    }

    private static Mouse getMouse(Long id, Vector mice) {
        if (id != null && mice != null) {
            Iterator iter = mice.iterator();
            while (iter.hasNext()) {
                Mouse mouse = (Mouse)iter.next();
                if (!mouse.get("IDO_ID").equals(id)) continue;
                return mouse;
            }
        }
        return null;
    }

    private static HashMap collectKidIds(Vector adults, Visit[] cageVArr, boolean kidHadToBeInside, boolean otherParentHadToBeInsde) {
        HashMap<Long, Object> target = new HashMap<Long, Object>(100);
        if (adults != null && !adults.isEmpty()) {
            Iterator iter = adults.iterator();
            while (iter.hasNext()) {
                Mouse adult = (Mouse)iter.next();
                long[] kidIds = (long[])adult.get("MOS_KID");
                long[] otherParentIds = (long[])adult.get("MOS_KID_OP");
                if (kidIds == null) continue;
                int i = 0;
                while (i < kidIds.length) {
                    boolean takeit = true;
                    if (kidHadToBeInside && !Cage.wasMouseEverInside(kidIds[i], cageVArr)) {
                        takeit = false;
                    }
                    if (otherParentHadToBeInsde && !Cage.wasMouseEverInside(otherParentIds[i], cageVArr)) {
                        takeit = false;
                    }
                    if (takeit) {
                        target.put(new Long(kidIds[i]), adult.get("IDO_ID"));
                    }
                    ++i;
                }
            }
        }
        return target;
    }

    private static int getLastExitMode(long mouseID, Visit[] arr) {
        int i = arr.length - 1;
        while (i >= 0) {
            if (arr[i].ivMouseID == mouseID) {
                return arr[i].ivEndMode;
            }
            --i;
        }
        return -1;
    }

    private static Vector enrichParents(long cageID, Visit[] cageVArr, Vector aktParentSide, HashMap aktParentKidIds, HashMap opponentParentKidIds, String group, HashMap sepDatesByMaleID, boolean enrichParentHadToBeInCage) {
        Vector<Mouse> newParents = new Vector<Mouse>();
        HashSet<Long> newParentsID = new HashSet<Long>();
        Iterator iter = aktParentSide.iterator();
        while (iter.hasNext()) {
            Mouse parent = (Mouse)iter.next();
            long[] kids = (long[])parent.get("MOS_KID");
            long[] opar = (long[])parent.get("MOS_KID_OP");
            if (kids == null || opar == null || kids.length != opar.length) continue;
            int i = 0;
            while (i < opar.length) {
                Mouse gegner;
                Long kidID;
                Long opponentID;
                if (opar[i] != -3L && (opponentID = (Long)opponentParentKidIds.get(kidID = new Long(kids[i]))) == null && aktParentKidIds != null && aktParentKidIds.containsKey(kidID) && (!enrichParentHadToBeInCage || Cage.wasMouseEverInside(opar[i], cageVArr)) && (gegner = (Mouse)ObjectStore.getClientObject(1, opar[i], group)) != null) {
                    opponentID = (Long)gegner.get("IDO_ID");
                    if (!newParentsID.contains(opponentID)) {
                        newParentsID.add(opponentID);
                        newParents.add(gegner);
                        if (sepDatesByMaleID != null) {
                            Visit lastVisit = null;
                            Visit[] varr = (Visit[])gegner.get("MOS_VISIT");
                            if (varr != null) {
                                int j = 0;
                                while (j < varr.length) {
                                    if (varr[j].ivEndDate != null && varr[j].ivCageID == cageID) {
                                        lastVisit = varr[j];
                                    }
                                    ++j;
                                }
                            }
                            if (lastVisit != null) {
                                sepDatesByMaleID.put(gegner.get("IDO_ID"), lastVisit.ivEndDate);
                            }
                        }
                    }
                    opponentParentKidIds.put(kidID, opponentID);
                }
                ++i;
            }
        }
        return newParents;
    }

    private Wurf(long fatherID, long motherID, int datum, String group, Vector target) {
        this.ivFatherID = fatherID;
        this.ivMotherID = motherID;
        this.ivDay = datum;
        this.ivGroup = group;
        target.addElement(this);
    }

    public boolean areAllLeft() {
        return this.ivNumBornTotal == this.ivNumLeft;
    }

    public String getMaleNumberString() {
        return String.valueOf(DefaultManager.getMale()) + " " + this.ivNumMaleBorn;
    }

    public String getFemaleNumberString() {
        return String.valueOf(DefaultManager.getFemale()) + " " + this.ivNumFemaleBorn;
    }

    public void addMiceToSexTargets(Vector maleTarget, Vector femaleTarget, Vector unsexTarget, Vector totalTarget) {
        if (this.ivKids != null) {
            totalTarget.addAll(this.ivKids);
            Iterator iter = this.ivKids.iterator();
            while (iter.hasNext()) {
                Mouse kid = (Mouse)iter.next();
                switch (kid.getSex()) {
                    case 1: {
                        maleTarget.add(kid);
                        break;
                    }
                    case 2: {
                        femaleTarget.add(kid);
                        break;
                    }
                    default: {
                        unsexTarget.add(kid);
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuffer msb = new StringBuffer();
        msb.append(this.ivMotherID).append(";");
        msb.append(this.ivFatherID).append(";");
        msb.append(this.ivDay).append(";");
        msb.append(this.ivNumBornTotal).append(";");
        msb.append(this.ivNumMaleBorn).append(";");
        msb.append(this.ivNumFemaleBorn).append(";");
        msb.append(this.ivNumMaleLeft).append(";");
        msb.append(this.ivNumFemaleLeft).append(";");
        msb.append(this.ivNumLeft).append(";");
        msb.append(this.ivNumNotKilled).append(";");
        return msb.toString();
    }

    public Cage getCage() {
        if (ProcessDefinition.isClient() && this.ivKids != null) {
            Iterator iter = this.ivKids.iterator();
            while (iter.hasNext()) {
                Cage cage;
                Mouse mouse = (Mouse)iter.next();
                Visit[] visits = (Visit[])mouse.get("MOS_VISIT");
                if (visits == null || visits.length == 0 || (cage = (Cage)ObjectStore.getClientObject(2, visits[0].ivCageID, mouse.getGroup())) == null) continue;
                return cage;
            }
        }
        return null;
    }

    private void addKidToWurf(long kidID, Visit[] cageVarr, int sex, Mouse kid, boolean getKidAlways) {
        ++this.ivNumBornTotal;
        if (kid == null && getKidAlways) {
            kid = (Mouse)ObjectStore.getObjectDeadOrAlive(1, kidID, this.ivGroup, null, false);
        }
        if (kid != null) {
            if (this.ivKids == null) {
                this.ivKids = new Vector();
            }
            this.ivKids.add(kid);
        }
        boolean mouseInCage = false;
        if (cageVarr != null) {
            int lastEndMode = Wurf.getLastExitMode(kidID, cageVarr);
            boolean bl = mouseInCage = lastEndMode == 0;
            if (lastEndMode == -1) {
                this.ivNumbersDeadAliveOK = false;
            }
            if (mouseInCage) {
                ++this.ivNumLeft;
                ++this.ivNumNotKilled;
            } else if (lastEndMode != 4) {
                ++this.ivNumNotKilled;
            }
        }
        switch (sex) {
            case 1: {
                ++this.ivNumMaleBorn;
                if (!mouseInCage) break;
                ++this.ivNumMaleLeft;
                break;
            }
            case 2: {
                ++this.ivNumFemaleBorn;
                if (!mouseInCage) break;
                ++this.ivNumFemaleLeft;
                break;
            }
        }
    }
}

