/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack.frame;

import de.hannse.netobjects.user.Privileges;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Vector;
import mausoleum.cage.BlockingCage;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.gui.ColorManager;
import mausoleum.gui.MusterColor;
import mausoleum.gui.PralineColor;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.rack.frame.PolygonManager;
import mausoleum.rack.frame.RackField;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.ui.UIDef;

public abstract class CageDisplayManager {
    public static final String VERBOT_GRUPPE = "GRU";
    public static final String VERBOT_100 = "100";
    public static final String VERBOT_GOMORRHA = "GOM";
    public static final String VERBOT_EINBAHN = "EBS";
    public static final String GOMMORRAH_STRING = "\u2642\u2642";
    private static Color HEFTIGES_ROT = Color.red;
    private static Color MILDES_ROT = new Color(255, 0, 0, 180);
    private static Color HEFTIGES_WEISS = Color.white;
    private static Color MILDES_WEISS = new Color(255, 255, 255, 180);
    public static final Color MATT_BLACK_COL = new Color(150, 150, 150);
    public static final Color MATT_WHITE_COL = new Color(240, 240, 240);
    private static final Color[] NIX_COLORS = new Color[]{CageColorManager.NULL_COLOR};
    private static final Color[] BLOCKING_COLORS = new Color[]{new Color(150, 150, 150, 60)};
    private static final int STREIFEN_MASS = 8;
    private static final Stroke DICKERLE = new BasicStroke(2.2f);
    private static final HashMap STROKES_BY_WIDTH = new HashMap();
    public static final Color[] CLEAR_NUMBER_FOREGROUNDS = new Color[]{Color.white, Color.black};
    public static final Color[] MATT_NUMBER_FOREGRUNDS = Cage.mattiereFarben(new Color[]{UIDef.NOT_MINE_FOREGROUND, Color.white});

    public static void drawFramedCagePolygon(Graphics g, int x, int y, int breite, int hoehe) {
        CageDisplayManager.drawPolygons(g, x, y, breite, hoehe, Color.red, null, 4, 1);
    }

    public static void drawFramedLeftCagePolygon(Graphics g, int x, int y, int breite, int hoehe) {
        CageDisplayManager.drawPolygons(g, x, y, breite, hoehe, Color.red, null, 4, 2);
    }

    public static void drawFramedRightCagePolygon(Graphics g, int x, int y, int breite, int hoehe) {
        CageDisplayManager.drawPolygons(g, x, y, breite, hoehe, Color.red, null, 4, 3);
    }

    public static void drawFilledCagePolygon(Graphics g, int x, int y, int breite, int hoehe) {
        CageDisplayManager.drawPolygons(g, x, y, breite, hoehe, Color.black, Color.white, 2, 1);
    }

    public static void paintCage(Cage cage, Graphics g, int x, int y, int breite, int hoehe, Vector checkSelection, HashMap cageVerbote) {
        if (cage != null) {
            if (cage instanceof BlockingCage) {
                BlockingCage bc = (BlockingCage)cage;
                CageDisplayManager.fillCage(bc, g, x, y, breite, hoehe, null, -1);
                CageDisplayManager.drawNormalBorder(g, x, y, breite, hoehe, DefaultManager.getMaskCagesMode(), false);
            } else {
                String verbot;
                CageDisplayManager.fillCage(cage, g, x, y, breite, hoehe, checkSelection, -1);
                String string = verbot = cageVerbote != null ? (String)cageVerbote.get(cage.getIdentifierString()) : null;
                if (verbot != null) {
                    if (verbot == VERBOT_GRUPPE) {
                        Polygon poly = PolygonManager.getPolygon(breite, hoehe, 0, 1);
                        poly.translate(x, y);
                        g.setColor(RackField.UNZUGAENGLICH_COL);
                        g.fillPolygon(poly);
                        poly.translate(-x, -y);
                    }
                    Dimension dim = new Dimension(breite, hoehe);
                    CageDisplayManager.drawVerboten((Graphics2D)g, dim, x, y, verbot);
                } else if (!CageDisplayManager.isSelected(cage, checkSelection)) {
                    CageDisplayManager.drawNormalBorder(g, x, y, breite, hoehe, DefaultManager.getMaskCagesMode(), CageDisplayManager.isMine(cage));
                }
            }
        } else {
            CageDisplayManager.drawPolygon(g, PolygonManager.getPolygon(breite, hoehe, 0, 1), null, x, y, MATT_WHITE_COL, MATT_BLACK_COL);
        }
    }

    public static void checkVerbote(Cage cage, Vector mice, String commonGroup, HashMap cageVerboteByCIDString) {
        if (cage != null && !(cage instanceof BlockingCage)) {
            if (MausoleumClient.isServiceCaretaker() && (commonGroup == null || cage.getGroup() == null || !cage.getGroup().equals(commonGroup))) {
                cageVerboteByCIDString.put(cage.getIdentifierString(), VERBOT_GRUPPE);
            } else {
                int[] aborigineNumber = new int[1];
                Point gomorrhaPoint = PopeAlert.hasGommorrha(cage, mice, null, aborigineNumber);
                if (aborigineNumber[0] != 0) {
                    cageVerboteByCIDString.put(cage.getIdentifierString(), VERBOT_EINBAHN);
                } else if (gomorrhaPoint != null) {
                    cageVerboteByCIDString.put(cage.getIdentifierString(), VERBOT_GOMORRHA);
                } else if (PopeAlert.hasEartag100Collision(cage, mice)) {
                    cageVerboteByCIDString.put(cage.getIdentifierString(), VERBOT_100);
                }
            }
        }
    }

    private static void drawVerboten(Graphics2D g, Dimension dim, int x, int y, String verbot) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int radius = dim.height - 2;
        int x2 = x + (dim.width - radius) / 2;
        int y2 = y + (dim.height - radius) / 2;
        if (verbot == VERBOT_EINBAHN) {
            g.setColor(Color.red);
            g.fillArc(x2, y2, radius, radius, 0, 360);
            int mitte = dim.height / 2;
            Float strbr = new Float((float)radius / 6.0f);
            BasicStroke stroke = (BasicStroke)STROKES_BY_WIDTH.get(strbr);
            if (stroke == null) {
                stroke = new BasicStroke(strbr.floatValue(), 1, 1);
                STROKES_BY_WIDTH.put(strbr, stroke);
            }
            int rand = 4 + (int)(strbr.floatValue() / 2.0f);
            Stroke merk = g.getStroke();
            g.setStroke(stroke);
            g.setColor(Color.white);
            g.drawLine(x2 + rand, y + mitte, x2 + radius - rand, y + mitte);
            g.setStroke(merk);
        } else {
            boolean heftigesVerbot = verbot == VERBOT_GRUPPE;
            g.setColor(heftigesVerbot ? HEFTIGES_ROT : MILDES_ROT);
            g.fillArc(x2, y2, radius, radius, 0, 360);
            radius = (dim.height - 2) * 3 / 4;
            x2 = x + (dim.width - radius) / 2;
            y2 = y + (dim.height - radius) / 2;
            g.setColor(heftigesVerbot ? HEFTIGES_WEISS : MILDES_WEISS);
            g.fillArc(x2, y2, radius, radius, 0, 360);
            Font font = null;
            String pfui = null;
            if (verbot == VERBOT_100) {
                pfui = VERBOT_100;
                font = FontManager.getMatching100Font(radius);
            } else if (verbot == VERBOT_GOMORRHA) {
                pfui = GOMMORRAH_STRING;
                font = FontManager.getMatchingGommorrahFont(radius - 2);
            }
            if (pfui != null) {
                g.setFont(font);
                FontMetrics mfm = g.getFontMetrics();
                Rectangle2D rect = mfm.getStringBounds(pfui, g);
                int textHeight = (int)rect.getHeight();
                int textWidth = (int)rect.getWidth();
                int panelHeight = dim.height;
                int panelWidth = dim.width;
                int x3 = x + (panelWidth - textWidth) / 2;
                int y3 = y + (panelHeight - textHeight) / 2 + mfm.getAscent();
                g.setColor(Color.black);
                g.drawString(pfui, x3, y3 - 1);
                g.drawString(pfui, x3 - 1, y3 - 1);
            }
        }
    }

    public static void fillCage(Cage c, Graphics g, int dx, int dy, int breite, int hoehe, Vector checkSelection, int overrideCageColorMode) {
        if (c == null || CageDisplayManager.isSelected(c, checkSelection)) {
            CageDisplayManager.drawPolygon(g, PolygonManager.getPolygon(breite, hoehe, 0, 1), null, dx, dy, MATT_WHITE_COL, MATT_BLACK_COL);
        } else {
            CageDisplayManager.fillCage(c, g, dx, dy, breite, hoehe, DefaultManager.getMaskCagesMode(), checkSelection, overrideCageColorMode);
        }
    }

    public static void fillCage(Cage c, Graphics g, int dx, int dy, int breite, int hoehe, int maskMode, Vector checkSelection, int overrideCageColorMode) {
        int usedMode;
        int n = usedMode = overrideCageColorMode != -1 ? overrideCageColorMode : DefaultManager.getCageDisplayMode();
        if (c instanceof BlockingCage) {
            CageDisplayManager.paintNormalCage(g, dx, dy, BLOCKING_COLORS, breite, hoehe);
        } else if (c.hasSubCages()) {
            Cage cr;
            Cage cl = c.getLeftSubCage();
            if (cl != null && !CageDisplayManager.isSelected(cl, checkSelection)) {
                if (!cl.itsMine(null) && !Privileges.hasPrivilege("VIEW_OTHERS_OBJECTS")) {
                    CageDisplayManager.paintHalfCage(g, dx, dy, hoehe, PolygonManager.getPolygon(breite, hoehe, 0, 2), NIX_COLORS);
                } else {
                    CageDisplayManager.paintHalfCage(g, dx, dy, hoehe, PolygonManager.getPolygon(breite, hoehe, 0, 2), cl.getColor(overrideCageColorMode));
                    CageDisplayManager.drawTaskTriangel(cl, breite, hoehe, dx, dy, 2, g);
                    if (CageDisplayManager.isWedding(cl)) {
                        CageDisplayManager.drawWeddingSign(g, dx, dy, breite / 2, usedMode, cl.ivIsSterileWeddingCage);
                    }
                    if (CageDisplayManager.hasFlag(cl)) {
                        CageDisplayManager.drawFlagSign(g, dx, dy);
                    }
                }
            }
            if ((cr = c.getRightSubCage()) != null && !CageDisplayManager.isSelected(cr, checkSelection)) {
                if (!cr.itsMine(null) && !Privileges.hasPrivilege("VIEW_OTHERS_OBJECTS")) {
                    CageDisplayManager.paintHalfCage(g, dx, dy, hoehe, PolygonManager.getPolygon(breite, hoehe, 0, 3), NIX_COLORS);
                } else {
                    CageDisplayManager.paintHalfCage(g, dx, dy, hoehe, PolygonManager.getPolygon(breite, hoehe, 0, 3), cr.getColor(overrideCageColorMode));
                    CageDisplayManager.drawTaskTriangel(cr, breite, hoehe, dx, dy, 3, g);
                    if (CageDisplayManager.isWedding(cr)) {
                        CageDisplayManager.drawWeddingSign(g, dx + breite / 2, dy, breite / 2, usedMode, cr.ivIsSterileWeddingCage);
                    }
                    if (CageDisplayManager.hasFlag(cr)) {
                        CageDisplayManager.drawFlagSign(g, dx + breite / 2, dy);
                    }
                }
            }
            int mittx = dx + breite / 2 - 1;
            g.setColor(Color.white);
            g.drawLine(mittx, dy, mittx, dy + hoehe);
            g.setColor(Color.black);
            g.drawLine(mittx + 1, dy, mittx + 1, dy + hoehe);
            CageDisplayManager.drawNumber(g, dx, dy, CageDisplayManager.getNumberString(c), CageDisplayManager.isMine(c), maskMode, breite, hoehe);
        } else if (!c.itsMine(null) && !Privileges.hasPrivilege("VIEW_OTHERS_OBJECTS")) {
            CageDisplayManager.paintNormalCage(g, dx, dy, NIX_COLORS, breite, hoehe);
        } else {
            CageDisplayManager.fillNormalCage(g, dx, dy, breite, hoehe, DefaultManager.getMaskCagesMode(), c.getColor(overrideCageColorMode), CageDisplayManager.getNumberString(c), CageDisplayManager.hasFlag(c), CageDisplayManager.isWedding(c), CageDisplayManager.isMine(c) || overrideCageColorMode != -1, usedMode, c);
        }
    }

    public static void fillNormalCage(Graphics g, int dx, int dy, int breite, int hoehe, int maskMode, Color[] ccol, String number, boolean hasFlag, boolean isMating, boolean isMine, int usedMode, Cage cage) {
        CageDisplayManager.paintNormalCage(g, dx, dy, ccol, breite, hoehe);
        CageDisplayManager.drawTaskTriangel(cage, breite, hoehe, dx, dy, 1, g);
        if (hasFlag) {
            CageDisplayManager.drawFlagSign(g, dx, dy);
        }
        if (isMating) {
            CageDisplayManager.drawWeddingSign(g, dx, dy, breite, usedMode, cage.ivIsSterileWeddingCage);
        }
        CageDisplayManager.drawNumber(g, dx, dy, number, isMine, maskMode, breite, hoehe);
    }

    private static void drawTaskTriangel(Cage cage, int breite, int hoehe, int dx, int dy, int cageMode, Graphics g) {
        Color tc;
        if (DefaultManager.showTaskTriangleInRack() && cage != null && (tc = Mouse.getTaskColor(cage.getActualMice(), null)) != null) {
            Polygon poly2 = PolygonManager.getTriangel(breite, hoehe, cageMode);
            poly2.translate(dx, dy);
            g.setColor(tc);
            g.fillPolygon(poly2);
            Graphics2D g2d = (Graphics2D)g;
            Object rh = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(ColorManager.getForegroundColorForBackground(tc));
            Stroke pstroke = g2d.getStroke();
            g2d.setStroke(DICKERLE);
            g.drawLine(poly2.xpoints[1], poly2.ypoints[1], poly2.xpoints[2], poly2.ypoints[2]);
            g2d.setStroke(pstroke);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rh);
            poly2.translate(-dx, -dy);
        }
    }

    public static void drawNormalBorder(Graphics g, int dx, int dy, int breite, int hoehe, int mode, boolean isMine) {
        if (isMine || mode < 1) {
            CageDisplayManager.drawFilledCagePolygon(g, dx, dy, breite, hoehe);
        }
    }

    public static void fillGrayNormalCage(Graphics g, int dx, int dy, int breite, int hoehe) {
        CageDisplayManager.fillPolygonGray(g, dx, dy, PolygonManager.getPolygon(breite, hoehe, 0, 1));
    }

    public static String getNumberString(Cage c) {
        if (c != null) {
            return c.getSuperCageIfThere().getNumber();
        }
        return "";
    }

    private static boolean isMine(Cage c) {
        return c != null && c.itsMine(null);
    }

    private static boolean isSelected(Cage c, Vector checkSelection) {
        return checkSelection != null && c != null && checkSelection.contains(c);
    }

    private static boolean isWedding(Cage c) {
        if (c != null) {
            return c.isMatingCage();
        }
        return false;
    }

    private static boolean hasFlag(Cage c) {
        char tc;
        return c != null && (tc = c.getChar("CAG_FLAG")) != '\u0000';
    }

    public static void drawNumber(Graphics g, int dx, int dy, String number, boolean itsMine, int maskMode, int breite, int hoehe) {
        CageDisplayManager.drawNumber(g, dx, dy, number, itsMine, maskMode, breite, hoehe, FontManager.getMatchingCageFont(breite));
    }

    public static void drawNumber(Graphics g, int dx, int dy, String number, boolean itsMine, int maskMode, int breite, int hoehe, Font f) {
        if (f != null) {
            g.setFont(f);
            FontMetrics mfm = g.getFontMetrics();
            int br = mfm.stringWidth(number);
            int ho = f.getSize();
            int stx = dx + (breite - br) / 2;
            int sty = dy + (hoehe - ho) / 2 + ho - 1;
            CageDisplayManager.drawNumberAtPoint(g, stx, sty, number, itsMine, maskMode);
        }
    }

    public static void drawOrcusPoolString(String title, Dimension d, Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Object oldHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(FontManager.getFont("SSB20"));
        int px = (d.width - g.getFontMetrics().stringWidth(title)) / 2;
        int ph = g.getFontMetrics().getAscent();
        int py = (d.height - ph) / 2 + ph;
        g.setColor(Color.black);
        g.drawString(title, px - 1, py - 1);
        g.setColor(Color.white);
        g.drawString(title, px + 1, py + 1);
        g.setColor(Color.lightGray);
        g.drawString(title, px, py);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    public static void drawNumberAtPoint(Graphics g, int stx, int sty, String number, boolean itsMine, int maskMode) {
        Color[] fores = CLEAR_NUMBER_FOREGROUNDS;
        if (!itsMine && maskMode >= 2) {
            fores = MATT_NUMBER_FOREGRUNDS;
        }
        Graphics2D g2 = (Graphics2D)g;
        Object oldHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(fores[1]);
        g.drawString(number, stx + 1, sty + 1);
        g.drawString(number, stx, sty + 1);
        g.drawString(number, stx - 1, sty + 1);
        g.drawString(number, stx + 1, sty);
        g.drawString(number, stx - 1, sty);
        g.drawString(number, stx - 1, sty - 1);
        g.drawString(number, stx, sty - 1);
        g.drawString(number, stx + 1, sty - 1);
        g.setColor(fores[0]);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.drawString(number, stx, sty);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawString(number, stx, sty);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    private static void fillPolygonGray(Graphics g, int dx, int dy, Polygon polygon) {
        g.setColor(Color.lightGray);
        polygon.translate(dx, dy);
        g.fillPolygon(polygon);
        polygon.translate(-dx, -dy);
    }

    private static void drawFlagSign(Graphics g, int dx, int dy) {
        g.drawImage(ImageProvider.CAGE_MARK_IMAGE, dx + 4, dy + 2, null);
    }

    private static void drawWeddingSign(Graphics g, int dx, int dy, int breite, int usedCageColorMode, boolean sterile) {
        if (usedCageColorMode != 1) {
            g.drawImage(sterile ? ImageProvider.CAGE_STERILE_MATING_IMAGE : ImageProvider.CAGE_MATING_IMAGE, dx + breite - 6, dy + 2, null);
        }
    }

    private static void paintNormalCage(Graphics g, int dx, int dy, Color[] ccol, int breite, int hoehe) {
        Polygon poly = PolygonManager.getPolygon(breite, hoehe, 0, 1);
        if (ccol != null && ccol.length != 0) {
            if (ccol.length == 1 && ccol[0] != CageColorManager.NULL_COLOR && !(ccol[0] instanceof MusterColor)) {
                if (ccol[0] instanceof PralineColor) {
                    PralineColor pc = (PralineColor)ccol[0];
                    CageDisplayManager.fillPoly(g, pc.ivRahmenColor, poly, dx, dy, null);
                    Polygon poly2 = PolygonManager.getSmallerPoly(poly, poly.ypoints[3] / 4);
                    CageDisplayManager.fillPoly(g, pc, poly2, dx, dy, Color.black);
                } else {
                    CageDisplayManager.fillPoly(g, ccol[0], poly, dx, dy, null);
                }
            } else {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setPaint(CageDisplayManager.getTexture(dx, dy, ccol, breite, true));
                poly.translate(dx, dy);
                g.fillPolygon(poly);
                poly.translate(-dx, -dy);
            }
        }
    }

    private static void fillPoly(Graphics g, Color col, Polygon poly, int dx, int dy, Color rahmen) {
        poly.translate(dx, dy);
        if (col instanceof MusterColor) {
            MusterColor mc = (MusterColor)col;
            MusterColor.fill(mc, mc.ivSecondColor, mc.ivMuster, poly, g);
        } else if (col instanceof PralineColor) {
            PralineColor pc = (PralineColor)col;
            if (pc.ivFirstMuster != 0 && pc.ivFirstSecondColor != null) {
                MusterColor.fill(pc, pc.ivFirstSecondColor, pc.ivFirstMuster, poly, g);
            } else {
                g.setColor(col);
                g.fillPolygon(poly);
            }
        } else {
            g.setColor(col);
            g.fillPolygon(poly);
        }
        if (rahmen != null) {
            g.setColor(rahmen);
            g.drawPolygon(poly);
        }
        poly.translate(-dx, -dy);
    }

    private static void paintHalfCage(Graphics g, int dx, int dy, int hoehe, Polygon poly, Color[] ccol) {
        if (ccol != null && ccol.length != 0) {
            if (ccol.length == 1 && ccol[0] != CageColorManager.NULL_COLOR) {
                if (ccol[0] instanceof PralineColor) {
                    PralineColor pc = (PralineColor)ccol[0];
                    CageDisplayManager.fillPoly(g, pc.ivRahmenColor, poly, dx, dy, null);
                    Polygon poly2 = PolygonManager.getSmallerPoly(poly, poly.ypoints[3] / 4);
                    CageDisplayManager.fillPoly(g, pc, poly2, dx, dy, Color.black);
                } else {
                    CageDisplayManager.fillPoly(g, ccol[0], poly, dx, dy, null);
                }
            } else {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setPaint(CageDisplayManager.getTexture(dx, dy, ccol, hoehe, false));
                poly.translate(dx, dy);
                g.fillPolygon(poly);
                poly.translate(-dx, -dy);
            }
        }
    }

    public static TexturePaint getTexture(int dx, int dy, Color[] ccol, int ausdehnung, boolean senkrechteStreifen) {
        BufferedImage bi = null;
        bi = senkrechteStreifen ? new BufferedImage(ausdehnung, 8, 2) : new BufferedImage(8, ausdehnung, 2);
        ImageProvider.machEsDurchsichtig(bi);
        Graphics ig = bi.getGraphics();
        int mass = ausdehnung / ccol.length;
        int lMass = ausdehnung - mass * (ccol.length - 1);
        int pos = 0;
        int i = 0;
        while (i < ccol.length) {
            int streifenMass = mass;
            if (i == 0) {
                streifenMass = lMass;
            }
            if (ccol[i] != null) {
                if (ccol[i] == CageColorManager.NULL_COLOR) {
                    if (senkrechteStreifen) {
                        int xx = 0;
                        while (xx < streifenMass) {
                            ig.drawImage(ImageProvider.SCHRAFF_IMAGE, pos + xx, 0, null);
                            xx += 8;
                        }
                    } else {
                        int yy = 0;
                        while (yy < streifenMass) {
                            ig.drawImage(ImageProvider.SCHRAFF_IMAGE, 0, pos + yy, null);
                            yy += 8;
                        }
                    }
                } else if (ccol[i] instanceof MusterColor) {
                    MusterColor mc = (MusterColor)ccol[i];
                    Image image = mc.getMuster();
                    if (image == null) {
                        System.out.println("Fehlendes Musterbild Modus: " + mc.ivMuster);
                    } else {
                        int iw = image.getWidth(null);
                        int ih = image.getHeight(null);
                        if (senkrechteStreifen) {
                            int xx = 0;
                            while (xx < streifenMass) {
                                int y = 0;
                                while (y < 8) {
                                    ig.drawImage(image, pos + xx, y, null);
                                    y += ih;
                                }
                                xx += iw;
                            }
                        } else {
                            int yy = 0;
                            while (yy < streifenMass) {
                                int x = 0;
                                while (x < 8) {
                                    ig.drawImage(image, x, pos + yy, null);
                                    x += iw;
                                }
                                yy += ih;
                            }
                        }
                    }
                } else if (ccol[i] instanceof PralineColor) {
                    PralineColor pc = (PralineColor)ccol[i];
                    int r = streifenMass / 4;
                    if (senkrechteStreifen) {
                        if (pc.ivFirstMuster != 0 && pc.ivFirstSecondColor != null) {
                            MusterColor.fill(pc, pc.ivFirstSecondColor, pc.ivFirstMuster, pos, 0, streifenMass, 8, ig);
                        } else {
                            ig.setColor(ccol[i]);
                            ig.fillRect(pos, 0, streifenMass, 8);
                        }
                        if (pc.ivRahmenColor instanceof MusterColor) {
                            MusterColor mc = (MusterColor)pc.ivRahmenColor;
                            mc.fill(pos, 0, r, 8, ig);
                            mc.fill(pos + streifenMass - r, 0, r, 8, ig);
                        } else {
                            ig.setColor(pc.ivRahmenColor);
                            ig.fillRect(pos, 0, r, 8);
                            ig.fillRect(pos + streifenMass - r, 0, r, 8);
                        }
                        ig.setColor(Color.black);
                        ig.drawLine(pos + r, 0, pos + r, 8);
                        ig.drawLine(pos + streifenMass - r, 0, pos + streifenMass - r, 8);
                    } else {
                        if (pc.ivFirstMuster != 0 && pc.ivFirstSecondColor != null) {
                            MusterColor.fill(pc, pc.ivFirstSecondColor, pc.ivFirstMuster, 0, pos, 8, streifenMass, ig);
                        } else {
                            ig.setColor(ccol[i]);
                            ig.fillRect(0, pos, 8, streifenMass);
                        }
                        if (pc.ivRahmenColor instanceof MusterColor) {
                            MusterColor mc = (MusterColor)pc.ivRahmenColor;
                            mc.fill(0, pos, 8, r, ig);
                            mc.fill(0, pos + streifenMass - r, 8, streifenMass, ig);
                        } else {
                            ig.setColor(pc.ivRahmenColor);
                            ig.fillRect(0, pos, 8, r);
                            ig.fillRect(0, pos + streifenMass - r, 8, streifenMass);
                        }
                    }
                } else {
                    ig.setColor(ccol[i]);
                    if (senkrechteStreifen) {
                        ig.fillRect(pos, 0, streifenMass, 8);
                    } else {
                        ig.fillRect(0, pos, 8, streifenMass);
                    }
                }
            }
            pos += streifenMass;
            ++i;
        }
        Rectangle2D.Double tr = null;
        tr = senkrechteStreifen ? new Rectangle2D.Double(dx, dy, ausdehnung, 8.0) : new Rectangle2D.Double(dx, dy, 8.0, ausdehnung);
        return new TexturePaint(bi, tr);
    }

    public static void drawPolygons(Graphics g, int x, int y, int breite, int hoehe, Color c1, Color c2, int anz, int pmode) {
        Polygon[] arr = new Polygon[anz];
        int i = 0;
        while (i < anz) {
            arr[i] = PolygonManager.getPolygon(breite, hoehe, i, pmode);
            ++i;
        }
        CageDisplayManager.drawPolygon(g, null, arr, x, y, c1, c2);
    }

    public static void drawPolygon(Graphics g, Polygon p, Polygon[] parr, int dx, int dy, Color c1, Color c2) {
        Graphics2D g2 = (Graphics2D)g;
        Object oldHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (p != null) {
            g2.setColor(c1);
            g2.drawLine(p.xpoints[1] + dx, p.ypoints[1] + dy, p.xpoints[2] + dx, p.ypoints[2] + dy);
            g2.drawLine(p.xpoints[3] + dx, p.ypoints[3] + dy, p.xpoints[2] + dx, p.ypoints[2] + dy);
            if (c2 != null) {
                g2.setColor(c2);
            }
            g2.drawLine(p.xpoints[1] + dx, p.ypoints[1] + dy, p.xpoints[0] + dx, p.ypoints[0] + dy);
            g2.drawLine(p.xpoints[3] + dx, p.ypoints[3] + dy, p.xpoints[0] + dx, p.ypoints[0] + dy);
        } else if (parr != null) {
            int i = 0;
            while (i < parr.length) {
                g2.setColor(c1);
                g2.drawLine(parr[i].xpoints[1] + dx, parr[i].ypoints[1] + dy, parr[i].xpoints[2] + dx, parr[i].ypoints[2] + dy);
                g2.drawLine(parr[i].xpoints[3] + dx, parr[i].ypoints[3] + dy, parr[i].xpoints[2] + dx, parr[i].ypoints[2] + dy);
                if (c2 != null) {
                    g2.setColor(c2);
                }
                g2.drawLine(parr[i].xpoints[1] + dx, parr[i].ypoints[1] + dy, parr[i].xpoints[0] + dx, parr[i].ypoints[0] + dy);
                g2.drawLine(parr[i].xpoints[3] + dx, parr[i].ypoints[3] + dy, parr[i].xpoints[0] + dx, parr[i].ypoints[0] + dy);
                ++i;
            }
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }
}

