/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack.frame;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.HashMap;

public abstract class PolygonManager {
    public static final int CORNER = 3;
    public static final int MODE_GANZ = 1;
    public static final int MODE_LINKS = 2;
    public static final int MODE_RECHTS = 3;
    private static final HashMap POLYGONE = new HashMap(100);
    private static final HashMap SMALL_POLYGONE = new HashMap(100);
    private static final HashMap TRIANGELN = new HashMap(100);

    public static Polygon getPolygon(int breite, int hoehe, int weg, int mode) {
        Rectangle key = new Rectangle(breite, hoehe, weg, mode);
        Polygon res = (Polygon)POLYGONE.get(key);
        if (res == null) {
            res = new Polygon();
            switch (mode) {
                case 1: {
                    res.addPoint(-weg, -weg);
                    res.addPoint(breite + weg, -weg);
                    res.addPoint(breite - 3 + weg, hoehe + weg);
                    res.addPoint(3 - weg, hoehe + weg);
                    break;
                }
                case 2: {
                    res.addPoint(-weg, -weg);
                    res.addPoint(breite / 2 - weg, -weg);
                    res.addPoint(breite / 2 - weg, hoehe + weg);
                    res.addPoint(3 - weg, hoehe + weg);
                    break;
                }
                case 3: {
                    res.addPoint(breite / 2 + weg, -weg);
                    res.addPoint(breite + weg, -weg);
                    res.addPoint(breite - 3 + weg, hoehe + weg);
                    res.addPoint(breite / 2 + weg, hoehe + weg);
                    break;
                }
            }
            POLYGONE.put(key, res);
        }
        return res;
    }

    public static Polygon getTriangel(int breite, int hoehe, int mode) {
        Rectangle key = new Rectangle(breite, hoehe, 0, mode);
        Polygon res = (Polygon)TRIANGELN.get(key);
        if (res == null) {
            res = new Polygon();
            switch (mode) {
                case 1: 
                case 2: {
                    res.addPoint(0, 0);
                    res.addPoint(hoehe / 2, 0);
                    res.addPoint(1, hoehe / 2);
                    break;
                }
                case 3: {
                    res.addPoint(breite / 2, 0);
                    res.addPoint(breite / 2 + hoehe / 2, 0);
                    res.addPoint(breite / 2, hoehe / 2);
                }
            }
            TRIANGELN.put(key, res);
        }
        return res;
    }

    public static Polygon getSmallerPoly(Polygon poly, int diff) {
        Polygon res = null;
        if (poly != null) {
            Integer key;
            HashMap<Integer, Polygon> hm = (HashMap<Integer, Polygon>)SMALL_POLYGONE.get(poly);
            if (hm == null) {
                hm = new HashMap<Integer, Polygon>();
                SMALL_POLYGONE.put(poly, hm);
            }
            if ((res = (Polygon)hm.get(key = new Integer(diff))) == null) {
                res = new Polygon();
                hm.put(key, res);
                res.addPoint(poly.xpoints[0] + diff, poly.ypoints[0] + diff);
                res.addPoint(poly.xpoints[1] - diff, poly.ypoints[1] + diff);
                res.addPoint(poly.xpoints[2] - diff, poly.ypoints[2] - diff);
                res.addPoint(poly.xpoints[3] + diff, poly.ypoints[3] - diff);
            }
        }
        return res;
    }
}

