/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack.frame;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.objectstore.ObjectStoreClient;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserRoomRestriction;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import mausoleum.cage.Cage;
import mausoleum.cage.CageManager;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.gui.MGButton;
import mausoleum.helper.FontManager;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.inspector.DormantPanel;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanelRack;
import mausoleum.inspector.actions.room.RoomAction;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.rack.Rack;
import mausoleum.rack.RackMoveButton;
import mausoleum.rack.RackPos;
import mausoleum.rack.RackRemoveButton;
import mausoleum.rack.frame.MausoleumPool;
import mausoleum.rack.frame.RackComboBox;
import mausoleum.rack.frame.RackComboChangeListener;
import mausoleum.rack.frame.RackField;
import mausoleum.rack.frame.RackFrameMainPanel;
import mausoleum.rack.frame.RackFrameMouseManager;
import mausoleum.rack.frame.RackGraphicsManager;
import mausoleum.rack.frame.RackOrcusField;
import mausoleum.rack.frame.RackOverview;
import mausoleum.rack.frame.TriangleButton;
import mausoleum.rack.frame.cagecard.RackCageCardFrame;
import mausoleum.requester.MoveRackOrRoomRequester;
import mausoleum.requester.calendar.CalendarRequester;
import mausoleum.requester.rack.RackNameRequester;
import mausoleum.room.Room;
import mausoleum.room.RoomStatusListener;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.models.MTCageInRackDisplay;
import mausoleum.tables.models.MTCagesInOrcus;
import mausoleum.tables.models.MTCagesInRack;
import mausoleum.tables.models.MTMouseInRackDisplay;

public class RackFrame
extends JFrame
implements ActionListener,
ObjectConsumer,
RoomStatusListener,
RackComboChangeListener {
    private static final long serialVersionUID = 148683L;
    private static final String COM_NEW = "NEW";
    private static final String COM_REMOVE = "REMOVE";
    private static final String COM_MOVE = "MOVE";
    private static final String COM_NAME = "NAME";
    private static final String COM_OVERVIEW = "OVERVIEW";
    private static final String COM_CAGECARDVIEW = "CGAECARDVIEW";
    public static final int SELMODE_FROMTABLE = 1;
    public static final int SELMODE_FROMFIELD = 2;
    public static final int SEL_MODE_OTHER = 0;
    public static final int SELMODE_NEVER_SELECTED = -1;
    private static final int[] CONSUMERTYPES = new int[]{3, 10};
    private static RackFrame cvInstance = null;
    private Rack ivActualRack;
    private String ivLastAdaptedIdentifier = null;
    private RackComboBox ivRackComboBox = new RackComboBox(this);
    private MGButton ivNewButton = null;
    private RackRemoveButton ivRemoveButton = null;
    private RackMoveButton ivMoveButton = null;
    private MGButton ivNameButton = null;
    private MGButton ivOverviewButton = new MGButton(Babel.get("OVERVIEW"), "OVERVIEW");
    private MGButton ivCageCardViewButton = new MGButton(Babel.get("CAGE_CARD_VIEW"), "CGAECARDVIEW");
    public RackField ivFrontField = new RackField(true, this);
    public RackField ivBackField = new RackField(false, this);
    private JScrollBar ivOrcusScrollBar = new JScrollBar(0, 0, 1, 0, 512);
    public RackOrcusField ivOrcusField = new RackOrcusField(this.ivOrcusScrollBar);
    private MTCageInRackDisplay ivRackCageTableModel = new MTCagesInRack(null);
    private MausoleumTable ivRackCageTable = new MausoleumTable(this.ivRackCageTableModel, false);
    private MTCageInRackDisplay ivOrcusCageTableModel = new MTCagesInOrcus(this.ivOrcusField);
    private MausoleumTable ivOrcusCageTable = new MausoleumTable(this.ivOrcusCageTableModel, false);
    private MTMouseInRackDisplay ivMouseTableModel = new MTMouseInRackDisplay();
    private MausoleumTable ivMouseTable = new MausoleumTable(this.ivMouseTableModel, false);
    private HashMap ivComponents = new HashMap(20);
    private Insets ivInsets = null;
    private boolean ivBlocker = false;
    private boolean ivListenForDisplay = false;
    private final Vector ivLastSelectionVector = new Vector();
    private int ivLastSelectionMode = -1;

    public static RackFrame getInstance() {
        if (cvInstance == null) {
            RackFrame.createInstance();
        }
        return cvInstance;
    }

    public static RackFrame getInstanceIfPresent() {
        return cvInstance;
    }

    public static void destroyIt() {
        if (cvInstance != null) {
            ObjectStoreClient.removeConsumer((ObjectConsumer)cvInstance, CONSUMERTYPES);
            RoomAction.removeListener(cvInstance);
            cvInstance.dispose();
            cvInstance = null;
        }
    }

    public static void reinit() {
        RackFrame.destroyIt();
        RackFrame.createInstance();
    }

    public static void redisplay(boolean potentialResize) {
        RackFrame.getInstance().adaptToRack(RackFrame.getInstance().ivActualRack, true, potentialResize);
        RackFrame.getInstance().ivFrontField.somethingChanged();
        RackFrame.getInstance().ivBackField.somethingChanged();
        RackFrame.getInstance().repaint();
    }

    public static void showRackFrame() {
        WindowUtils.bringUpFrame(RackFrame.getInstance());
    }

    public static void showRack(Rack r) {
        if (r != null) {
            WindowUtils.bringUpFrame(RackFrame.getInstance());
            RackFrame.getInstance().ivRackComboBox.setSelectedRack(r);
            RackFrame.getInstance().selectCages(null, 0);
        }
    }

    public static void showCagePositionsForShowPosAction(Vector cages, Vector mice) {
        RackFrame.showCagePosition(cages);
        if (mice != null) {
            RackFrame.cvInstance.ivMouseTableModel.selectElements(mice);
            RackFrame.cvInstance.ivMouseTable.ensureSelectionIsVisible();
        }
    }

    public static void ensureSelVisInRackTable() {
        if (cvInstance != null && RackFrame.cvInstance.ivRackCageTable != null) {
            RackFrame.cvInstance.ivRackCageTable.ensureSelectionIsVisible();
        }
    }

    public static void showCagePosition(Vector v) {
        Cage c;
        if (v != null && !v.isEmpty() && (c = (Cage)v.firstElement()) != null) {
            RackPos rackPos = (RackPos)(c = c.getSuperCageIfThere()).get("CAG_POS");
            if (rackPos != null) {
                Rack r = (Rack)ObjectStore.getClientObject(3, rackPos.ivRackID, c.getGroup());
                if (r != null) {
                    WindowUtils.bringUpFrame(RackFrame.getInstance());
                    RackFrame.getInstance().ivRackComboBox.setSelectedRack(r);
                    RackFrame.getInstance().selectCages(v, 2);
                }
            } else {
                WindowUtils.bringUpFrame(RackFrame.getInstance());
                RackFrame.getInstance().selectCages(v, 1);
            }
        }
    }

    public static long getRackID() {
        if (RackFrame.getInstance() == null || RackFrame.getInstance().ivActualRack == null) {
            return -1L;
        }
        return RackFrame.getInstance().ivActualRack.getID(-1L);
    }

    public static Rack getRack() {
        if (RackFrame.getInstance() == null || RackFrame.getInstance().ivActualRack == null) {
            return null;
        }
        return RackFrame.getInstance().ivActualRack;
    }

    public static void cageColorModeChanged() {
        if (MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker()) {
            RackFrame.getInstance().ivListenForDisplay = false;
            CageColorManager.cvColormodeComboRackFrame.setSelectedIndex(CageColorManager.getIndexOfMainMode());
            RackFrame.getInstance().ivListenForDisplay = true;
            RackFrame.redisplay(false);
        }
    }

    public static MTMouseInRackDisplay getMouseTableModel() {
        return RackFrame.getInstance().ivMouseTableModel;
    }

    public static MTCageInRackDisplay getParallelCageTableModel(MTCageInRackDisplay origo) {
        if (origo == RackFrame.getInstance().ivOrcusCageTableModel) {
            return RackFrame.getInstance().ivRackCageTableModel;
        }
        return RackFrame.getInstance().ivOrcusCageTableModel;
    }

    public static void fillOldSelection(Vector v) {
        int i;
        if (RackFrame.getInstance().ivFrontField.ivSelCages != null) {
            i = 0;
            while (i < RackFrame.getInstance().ivFrontField.ivSelCages.size()) {
                v.addElement(RackFrame.getInstance().ivFrontField.ivSelCages.elementAt(i));
                ++i;
            }
        }
        if (RackFrame.getInstance().ivBackField.ivSelCages != null) {
            i = 0;
            while (i < RackFrame.getInstance().ivBackField.ivSelCages.size()) {
                v.addElement(RackFrame.getInstance().ivBackField.ivSelCages.elementAt(i));
                ++i;
            }
        }
        Enumeration en = RackFrame.getInstance().ivOrcusField.getSelectedCages();
        while (en.hasMoreElements()) {
            v.addElement(en.nextElement());
        }
    }

    public static RackFrameMainPanel getMainPanel() {
        return (RackFrameMainPanel)RackFrame.getInstance().getContentPane();
    }

    private static void createInstance() {
        cvInstance = new RackFrame();
        if (RackFrame.cvInstance.ivRackCageTableModel != null) {
            RackFrame.cvInstance.ivRackCageTableModel.setTable(CageManager.cvInstance.getActualObjectVectorAllGroups());
            RackFrame.cvInstance.ivRackCageTableModel.sortDefault();
        }
        if (RackFrame.cvInstance.ivOrcusCageTableModel != null) {
            RackFrame.cvInstance.ivOrcusCageTableModel.setTable(CageManager.cvInstance.getActualObjectVectorAllGroups());
            RackFrame.cvInstance.ivOrcusCageTableModel.sortDefault();
        }
    }

    private RackFrame() {
        this.setIconImage(MausoleumImageStore.getLogo());
        this.setWindowTitle();
        this.setContentPane(new RackFrameMainPanel(null));
        this.addComponent("COMBO", this.ivRackComboBox);
        if (Privileges.hasPrivilege("CREATE_RACK") && (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService())) {
            this.ivNewButton = new MGButton(Babel.get("IBNEW"), COM_NEW);
            this.ivNewButton.setEnabled(true);
            this.addComponent("BUTT1", this.ivNewButton);
        }
        if (Privileges.hasPrivilege("REMOVE_RACK")) {
            this.ivRemoveButton = new RackRemoveButton(Babel.get("IBREMOVE"), COM_REMOVE);
            this.ivRemoveButton.setEnabled(false);
            this.addComponent("BUTT2", this.ivRemoveButton);
        }
        if (Privileges.hasPrivilege("MOVE_RACK")) {
            this.ivMoveButton = new RackMoveButton(Babel.get("MOVERACKTOROOM"), COM_MOVE);
            this.addComponent("BUTT4", this.ivMoveButton);
        }
        if (Privileges.hasPrivilege("NAME_RACK")) {
            this.ivNameButton = new MGButton(Babel.get("NAMERACK"), COM_NAME);
            this.addComponent("BUTT5", this.ivNameButton);
            this.ivNameButton.setEnabled(false);
        }
        this.addComponent("TRIANGLE_RESTR", new TriangleButton());
        CageColorManager.cvColormodeComboRackFrame.setSelectedIndex(CageColorManager.getIndexOfMainMode());
        CageColorManager.cvColormodeComboRackFrame.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && RackFrame.this.ivListenForDisplay) {
                    RackFrame.this.ivListenForDisplay = false;
                    CageColorManager.modeSelected(true);
                    RackFrame.this.ivListenForDisplay = true;
                }
            }
        });
        this.addComponent("BUTT6", CageColorManager.cvColormodeComboRackFrame);
        this.addComponent("FRONTFIELD", this.ivFrontField);
        this.addComponent("BACKFIELD", this.ivBackField);
        this.addComponent("ORCUSFIELD", this.ivOrcusField);
        this.addComponent("SCROLLBAR", this.ivOrcusScrollBar);
        this.ivOrcusScrollBar.setOpaque(false);
        this.addComponent("MOUSE_POOL", MausoleumPool.POOL_COMPONENT);
        this.addComponent(COM_OVERVIEW, this.ivOverviewButton);
        this.addComponent("CAGECARD", this.ivCageCardViewButton);
        this.addComponent("RACKCTABLE", this.ivRackCageTable);
        this.ivRackCageTable.setHeader(Babel.get("CAGESCURRRACK"), FontManager.getFont("SSB12"));
        this.addComponent("ORCUSCTABLE", this.ivOrcusCageTable);
        this.ivOrcusCageTable.setHeader(Babel.get("CAGESTRANSFERAREA"), FontManager.getFont("SSB12"));
        this.addComponent("MOUSETABLE", this.ivMouseTable);
        this.ivRackComboBox.adjust();
        Dimension d = RackGraphicsManager.calcSizeForRack(this.ivActualRack, this.ivComponents, true, null);
        this.pack();
        this.ivInsets = this.getInsets();
        this.setSize(d.width + this.ivInsets.left + this.ivInsets.right, d.height + this.ivInsets.top + this.ivInsets.bottom);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                if (!RackFrame.this.ivBlocker) {
                    RackFrame.this.ivBlocker = true;
                    RackGraphicsManager.calcNewCageHeight(RackFrame.this.getSize(), RackFrame.this.ivInsets, RackFrame.this.ivActualRack);
                    RackFrame.redisplay(true);
                    RackFrame.getInstance().validate();
                    RackFrame.this.ivBlocker = false;
                }
            }
        });
        RackFrameMouseManager.installRackFrameMouseManager(this);
        ObjectStoreClient.addConsumer((ObjectConsumer)this, CONSUMERTYPES);
        RoomAction.addListener(this);
        this.ivListenForDisplay = true;
    }

    public void dispose() {
        this.setVisible(false);
        this.removeAll();
        this.getContentPane().removeAll();
        this.ivActualRack = null;
        this.ivLastAdaptedIdentifier = null;
        if (this.ivOrcusCageTable != null) {
            this.ivOrcusCageTable.mDispose();
            this.ivOrcusCageTable = null;
            this.ivOrcusCageTableModel = null;
        }
        if (this.ivMouseTable != null) {
            this.ivMouseTable.mDispose();
            this.ivMouseTable = null;
            this.ivMouseTableModel = null;
        }
        if (this.ivRackCageTable != null) {
            this.ivRackCageTable.mDispose();
            this.ivRackCageTable = null;
            this.ivRackCageTableModel = null;
        }
        if (this.ivRackComboBox != null) {
            this.ivRackComboBox.dispose();
            this.ivRackComboBox = null;
        }
        if (this.ivNewButton != null) {
            this.ivNewButton.dispose();
            this.ivNewButton = null;
        }
        if (this.ivRemoveButton != null) {
            this.ivRemoveButton.dispose();
            this.ivRemoveButton = null;
        }
        if (this.ivMoveButton != null) {
            this.ivMoveButton.dispose();
            this.ivMoveButton = null;
        }
        if (this.ivNameButton != null) {
            this.ivNameButton.dispose();
            this.ivNameButton = null;
        }
        if (this.ivOverviewButton != null) {
            this.ivOverviewButton.dispose();
            this.ivOverviewButton = null;
        }
        if (this.ivCageCardViewButton != null) {
            this.ivCageCardViewButton.dispose();
            this.ivCageCardViewButton = null;
        }
        if (this.ivFrontField != null) {
            this.ivFrontField.dispose();
            this.ivFrontField = null;
        }
        if (this.ivBackField != null) {
            this.ivBackField.dispose();
            this.ivBackField = null;
        }
        this.ivOrcusScrollBar = null;
        if (this.ivOrcusField != null) {
            this.ivOrcusField.dispose();
            this.ivOrcusField = null;
        }
        if (this.ivComponents != null) {
            this.ivComponents.clear();
            this.ivComponents = null;
        }
        this.ivInsets = null;
        this.ivLastSelectionVector.clear();
        super.dispose();
    }

    public void reselectCages() {
        if (this.ivLastSelectionMode != -1) {
            Vector<IDObject> cages = new Vector<IDObject>(this.ivLastSelectionVector.size());
            Iterator iterator = this.ivLastSelectionVector.iterator();
            while (iterator.hasNext()) {
                String idStr = (String)iterator.next();
                IDObject ooo = ObjectStore.getClientObject(new IDObject.IDObjectIdentifier(idStr));
                if (ooo == null) continue;
                cages.add(ooo);
            }
            this.selectCages(cages, this.ivLastSelectionMode);
        }
    }

    public void selectCages(Vector v, int mode) {
        this.ivLastSelectionVector.clear();
        this.ivLastSelectionMode = mode;
        Vector<Cage> orcus = new Vector<Cage>();
        Vector<Cage> front = new Vector<Cage>();
        Vector<Cage> back = new Vector<Cage>();
        Vector<Cage> rack = new Vector<Cage>();
        if (v != null) {
            int i = 0;
            while (i < v.size()) {
                Cage sc;
                Cage c = (Cage)v.elementAt(i);
                this.ivLastSelectionVector.add(c.getIdentifierString());
                RackPos rp = (RackPos)c.get("CAG_POS");
                if (c.get("CAG_SUPERCAGE") != null && (sc = c.getSuperCageIfThere()) != null) {
                    rp = (RackPos)sc.get("CAG_POS");
                }
                if (rp == null) {
                    orcus.addElement(c);
                } else if (this.ivActualRack != null) {
                    long rackID = rp.ivRackID;
                    if (MausoleumClient.isServiceCaretaker()) {
                        Rack srack = (Rack)ObjectStore.getClientObject(3, rackID, c.getGroup());
                        if (srack == null) {
                            rackID = 0L;
                        } else if (srack.isSharedWithOtherGroups()) {
                            rackID = srack.getLong("IDO_SERVID", 0L);
                        }
                    }
                    if (rackID == this.ivActualRack.getID()) {
                        rack.addElement(c);
                        if (rp.ivSide == 0) {
                            front.addElement(c);
                        } else {
                            back.addElement(c);
                        }
                    }
                }
                ++i;
            }
        }
        if (mode == 2) {
            this.ivOrcusCageTableModel.adjustSelection(orcus);
            this.ivRackCageTableModel.adjustSelection(rack);
            if (rack.size() == 0 && orcus.size() == 0) {
                this.ivMouseTableModel.setCages(ArrayHelper.LEER);
            } else if (rack.size() == 0) {
                Inspector.adjustToTable(this.ivOrcusCageTable);
                this.ivOrcusCageTable.ensureSelectionIsVisible();
                this.ivMouseTableModel.setCages(this.ivOrcusCageTable.getSelectedObjects());
                this.ivMouseTableModel.sortDefault();
            } else if (orcus.size() == 0) {
                Inspector.adjustToTable(this.ivRackCageTable);
                this.ivRackCageTable.ensureSelectionIsVisible();
                this.ivMouseTableModel.setCages(this.ivRackCageTableModel.getSelectedObjects());
                this.ivMouseTableModel.sortDefault();
            } else {
                this.ivOrcusCageTable.ensureSelectionIsVisible();
                this.ivRackCageTable.ensureSelectionIsVisible();
                Vector both = new Vector();
                Vector vm = this.ivRackCageTableModel.getSelectedObjects();
                if (vm != null) {
                    int i = 0;
                    while (i < vm.size()) {
                        both.addElement(vm.elementAt(i));
                        ++i;
                    }
                }
                if ((vm = this.ivOrcusCageTableModel.getSelectedObjects()) != null) {
                    int i = 0;
                    while (i < vm.size()) {
                        both.addElement(vm.elementAt(i));
                        ++i;
                    }
                }
                this.ivMouseTableModel.setCages(both);
                this.ivMouseTableModel.sortDefault();
            }
            if (DefaultManager.showCageTablesInRackDisplay()) {
                this.ivOrcusCageTable.ensureSelectionIsVisible();
                this.ivRackCageTable.ensureSelectionIsVisible();
                this.ivRackCageTable.repaint();
                this.ivOrcusCageTable.repaint();
            }
            this.ivOrcusField.setSelectedCages(orcus);
            this.ivFrontField.setSelectedVector(front);
            this.ivBackField.setSelectedVector(back);
        } else if (mode == 1) {
            this.ivOrcusField.setSelectedCages(orcus);
            this.ivFrontField.setSelectedVector(front);
            this.ivBackField.setSelectedVector(back);
        }
    }

    public void adaptToRack(Rack rack, boolean forceRepaint, boolean potentialResize) {
        boolean rackchanged;
        DormantPanel.actionDone();
        String newIdentifier = rack == null ? null : rack.getExtendedIdentifier();
        boolean bl = rackchanged = this.ivActualRack == null && rack != null || this.ivActualRack != null && rack == null || this.ivActualRack != rack || this.ivActualRack != null && rack != null && !newIdentifier.equals(this.ivLastAdaptedIdentifier);
        if (rackchanged || forceRepaint) {
            if (rackchanged) {
                int arw = this.ivActualRack != null ? this.ivActualRack.getInt("RCK_COLUMNS", 0) : 0;
                int arh = this.ivActualRack != null ? this.ivActualRack.getInt("RCK_ROWS", 0) : 0;
                int ars = this.ivActualRack != null ? this.ivActualRack.getInt("RCK_SIDES", 0) : 0;
                int nrw = rack != null ? rack.getInt("RCK_COLUMNS", 0) : 0;
                int nrh = rack != null ? rack.getInt("RCK_ROWS", 0) : 0;
                int nrs = rack != null ? rack.getInt("RCK_SIDES", 0) : 0;
                boolean rackDimChanged = arw != nrw || arh != nrh || ars != nrs;
                this.ivActualRack = rack;
                this.ivLastAdaptedIdentifier = newIdentifier;
                if (rackDimChanged) {
                    this.setMinimumSize(RackGraphicsManager.calcMinimumSize(rack, this.getInsets(), this.ivComponents));
                    Dimension d = RackGraphicsManager.calcSizeForRack(this.ivActualRack, this.ivComponents, true, null);
                    Dimension olddim = this.getSize();
                    Insets in = this.getInsets();
                    d.width += in.left + in.right;
                    d.height += in.top + in.bottom;
                    if (d.width != olddim.width || d.height != olddim.height) {
                        this.setSize(d);
                    }
                }
                this.ivRackCageTableModel.rackChanged();
                this.ivFrontField.setRack(this.ivActualRack);
                this.ivBackField.setRack(this.ivActualRack);
                if (this.ivMoveButton != null) {
                    this.ivMoveButton.adjust(this.ivActualRack);
                }
                if (this.ivRemoveButton != null) {
                    this.ivRemoveButton.adjust(this.ivActualRack);
                }
                if (this.ivNameButton != null) {
                    this.ivNameButton.setEnabled(this.ivActualRack != null && !this.ivActualRack.isSharedWithOtherGroups() && Privileges.hasPrivilege("NAME_RACK"));
                }
                this.setWindowTitle();
                this.ivCageCardViewButton.setEnabled(this.ivActualRack != null);
                Vector sel = new Vector();
                this.ivFrontField.setSelectedVector(sel);
                this.ivBackField.setSelectedVector(sel);
                this.selectCages(sel, 2);
            } else if (potentialResize) {
                Insets insets = this.getInsets();
                Dimension aussen = this.getSize();
                Dimension d = new Dimension(aussen.width - insets.left - insets.right, aussen.height - insets.top - insets.bottom);
                RackGraphicsManager.calcSizeForRack(this.ivActualRack, this.ivComponents, false, d);
            }
            this.repaint();
        }
    }

    public void setCageDisplayMode(int mode) {
        this.ivListenForDisplay = false;
        CageColorManager.cvColormodeComboRackFrame.setSelectedIndex(CageColorManager.getIndexOfMainMode());
        this.ivListenForDisplay = true;
    }

    private void addComponent(String key, Component c) {
        this.ivComponents.put(key, c);
        this.getContentPane().add(c);
        if (c instanceof MausoleumTable) {
            ((MausoleumTable)c).setIsSubdisplay();
        } else if (c instanceof MGButton) {
            ((MGButton)c).addActionListener(this);
            ((MGButton)c).setFont(FontManager.getFont("SSB12"));
        }
    }

    private void setWindowTitle() {
        StringBuffer msb = new StringBuffer(Babel.get("RACKINSP"));
        if (this.ivActualRack == null) {
            msb.append(" []");
        } else {
            Room raum;
            String raumName = null;
            if (MausoleumClient.isServiceCaretaker()) {
                raumName = MausoleumClient.cvServiceCTRoomName;
            } else if (this.ivActualRack != null && (raum = this.ivActualRack.getRoom()) != null) {
                raumName = raum.getName();
            }
            msb.append(" [Rack: ").append(this.ivActualRack.getName());
            if (raumName != null) {
                msb.append(" in Room: ").append(raumName);
            }
            msb.append("]");
        }
        if (MausoleumClient.isRegularOrTGService()) {
            msb.append(RoomAction.cvRoomStatus);
        }
        this.setTitle(msb.toString());
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals(COM_NEW)) {
            InspectorPanelRack.doNewST(true);
        } else if (actionCommand.equals(COM_OVERVIEW)) {
            RackOverview.showIt();
        } else if (actionCommand.equals(COM_CAGECARDVIEW)) {
            RackCageCardFrame.showCageCardFrame(this.ivActualRack);
        } else if (this.ivActualRack != null && !this.ivActualRack.isSharedWithOtherGroups()) {
            String newName;
            String databaseCommand = null;
            if (actionCommand.equals(COM_REMOVE) && this.ivActualRack.isEmpty()) {
                Date myDate = CalendarRequester.getDate(Inspector.getInspector());
                if (myDate != null) {
                    databaseCommand = "RKR " + this.ivActualRack.getID() + " " + myDate.getTime();
                }
            } else if (actionCommand.equals(COM_MOVE)) {
                long rid = MoveRackOrRoomRequester.getTargetID(this, this.ivActualRack.getLong("RCK_ROOM"), this.ivActualRack.getGroup(), true);
                if (rid != -1L) {
                    databaseCommand = "RKMOVE " + this.ivActualRack.getID() + " " + rid;
                }
            } else if (actionCommand.equals(COM_NAME) && (newName = RackNameRequester.getNewRackName(this.ivActualRack.getName(), this.ivActualRack.getGroup())) != null) {
                databaseCommand = "RKNAME " + this.ivActualRack.getID() + " " + Base64Manager.encodeBase64(newName);
            }
            if (databaseCommand != null) {
                RequestManager.sendCommandRequestAndGetAnswer(databaseCommand, this.ivActualRack.getGroup());
            }
        }
    }

    public void roomStatusChanged() {
        this.setWindowTitle();
        if (this.ivMoveButton != null) {
            this.ivMoveButton.adjust(this.ivActualRack);
        }
    }

    public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
    }

    public void handleNewObjects(Vector idObjects) {
        Iterator iterator = idObjects.iterator();
        while (iterator.hasNext()) {
            this.handleNewObject((IDObject)iterator.next());
        }
    }

    public void handleNewObject(IDObject obj) {
        if (!UserRoomRestriction.isObjectRestricted(obj)) {
            if (obj instanceof Room) {
                if (this.ivMoveButton != null) {
                    this.ivMoveButton.adjust(this.ivActualRack);
                }
                this.setWindowTitle();
            }
            if (obj instanceof Rack) {
                this.ivRackComboBox.checkArrivedRack((Rack)obj);
            }
        }
    }
}

