/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack.frame;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import mausoleum.cage.Cage;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.rack.ERPFiller;
import mausoleum.rack.ExtendedRackPos;
import mausoleum.rack.Rack;
import mausoleum.rack.RackPos;
import mausoleum.rack.frame.MausoleumPool;
import mausoleum.rack.frame.RackFrame;
import mausoleum.tables.TableFrameMouse;

public class RackFrameMouseManager
implements MouseListener,
MouseMotionListener {
    public static RackFrameMouseManager cvInstance = null;
    public static Component cvComponent = null;
    private static JPopupMenu cvCageGroupNameMenu = null;
    private static JMenuItem cvCageGroupItem = null;
    private ExtendedRackPos ivStartERP;
    private boolean ivStartChecked = false;
    private ERPFiller ivAktTarget = null;
    public Cursor ivDragCursor = null;
    private boolean ivCursorSet = false;

    public static void installRackFrameMouseManager(RackFrame rackFrame) {
        if (cvInstance == null) {
            cvInstance = new RackFrameMouseManager();
            cvComponent = rackFrame.getContentPane();
            cvComponent.addMouseListener(cvInstance);
            cvComponent.addMouseMotionListener(cvInstance);
        } else if (cvComponent != null) {
            try {
                cvComponent.removeMouseListener(cvInstance);
                cvComponent.removeMouseMotionListener(cvInstance);
            }
            catch (Exception e) {
                System.out.println("RackFrameMouseManager Problem beim Abmelden " + e);
            }
            cvComponent = rackFrame.getContentPane();
            cvComponent.addMouseListener(cvInstance);
            cvComponent.addMouseMotionListener(cvInstance);
        }
    }

    public static Point getComponentLocation() {
        if (cvComponent != null) {
            try {
                return cvComponent.getLocationOnScreen();
            }
            catch (Exception e) {
                System.out.println("RackFrameMouseManager Problem bei getComponentLocation -> " + e);
            }
        }
        return null;
    }

    public static void clearDragTargetInFields(boolean dragFinished) {
        RackFrameMouseManager.cvInstance.ivAktTarget = null;
        RackFrame.getInstance().ivFrontField.setDragTarget(null, null);
        RackFrame.getInstance().ivBackField.setDragTarget(null, null);
        if (dragFinished) {
            RackFrame.getInstance().ivFrontField.clearUnzugaenglichkeit();
            RackFrame.getInstance().ivBackField.clearUnzugaenglichkeit();
            RackFrame.getInstance().ivOrcusField.clearUnzugaenglichkeit();
        }
        RackFrame.getInstance().ivOrcusField.setDragTarget(null, null);
        MausoleumPool.POOL_COMPONENT.setDragTarget(null, null);
    }

    public static void clearCursor() {
        RackFrame.getInstance().setCursor(Cursor.getDefaultCursor());
        RackFrameMouseManager.cvInstance.ivCursorSet = false;
    }

    public void evaluateStartERP(ExtendedRackPos startERP, MouseEvent e, Point urPunkt, boolean mitStartCheck) {
        this.ivStartERP = startERP;
        switch (this.ivStartERP.ivFeldKennung) {
            case 4: 
            case 5: {
                if (this.ivStartERP.mouseCount() > 0) {
                    this.createMiceCursor(this.ivStartERP.getMice());
                    break;
                }
                if (this.ivStartERP.cageCount() <= 0) break;
                this.createCageCursor(this.ivStartERP.getCages());
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                Cage cageToHandle = this.ivStartERP.getRelevantCage();
                if (cageToHandle != null) {
                    String key;
                    if (e.isMetaDown() && (key = DefaultManager.getLabelPrinter()) != null) {
                        Vector<Cage> preview = new Vector<Cage>();
                        preview.addElement(cageToHandle);
                        LabelPrinter.previewIt(preview, key);
                        return;
                    }
                    Vector<Cage> v = new Vector<Cage>();
                    if (e.isControlDown()) {
                        RackFrame.fillOldSelection(v);
                        if (v.contains(cageToHandle)) {
                            v.remove(cageToHandle);
                        } else {
                            v.addElement(cageToHandle);
                        }
                    } else {
                        v.addElement(cageToHandle);
                    }
                    RackFrame.getInstance().selectCages(v, 2);
                    Vector<Cage> v2 = new Vector<Cage>(1);
                    v2.add(cageToHandle);
                    this.createCageCursor(v2);
                    break;
                }
                if (e.isMetaDown() && this.ivStartERP != null && this.ivStartERP.ivBlockingRackPos != null && MausoleumClient.isRegularOrTGService() && Privileges.hasPrivilege("CAG_VIEW_GROUP_OF_FOREIGN_CAGES")) {
                    String blockingGroup;
                    RackPos searchERP = this.ivStartERP.ivBlockingRackPos;
                    Rack rack = RackFrame.getRack();
                    if (rack != null && (blockingGroup = (String)RequestManager.createSendAndGetObjectIfFinished((byte)69, rack.get("IDO_SERVID") + "," + searchERP.ivSide + "," + searchERP.ivRow + "," + searchERP.ivColumn, UserManager.getFirstGroup())) != null) {
                        if (cvCageGroupNameMenu == null) {
                            cvCageGroupNameMenu = new JPopupMenu();
                            cvCageGroupItem = new JMenuItem();
                            cvCageGroupItem.setEnabled(false);
                            cvCageGroupItem.setFont(FontManager.getFont("SSP11"));
                            cvCageGroupItem.setForeground(Color.black);
                            cvCageGroupNameMenu.add(cvCageGroupItem);
                        }
                        String res = Babel.get("CAGE_BELONGS_TO_GROUP");
                        res = StringHelper.gSub(res, "_GROUP_", blockingGroup);
                        cvCageGroupItem.setText(res);
                        cvCageGroupNameMenu.show((JComponent)e.getSource(), e.getX(), e.getY());
                    }
                }
                Vector v = null;
                if (e.isControlDown()) {
                    v = new Vector();
                    RackFrame.fillOldSelection(v);
                }
                RackFrame.getInstance().selectCages(v, 2);
                this.ivStartERP = null;
                break;
            }
            default: {
                Vector vii = null;
                if (e.isControlDown()) {
                    vii = new Vector();
                    RackFrame.fillOldSelection(vii);
                }
                RackFrame.getInstance().selectCages(vii, 2);
            }
        }
        if (mitStartCheck) {
            RackFrame.getInstance().ivFrontField.manageZugaenglich(this.ivStartERP);
            RackFrame.getInstance().ivBackField.manageZugaenglich(this.ivStartERP);
            RackFrame.getInstance().ivOrcusField.manageZugaenglich(this.ivStartERP);
            this.ivStartChecked = true;
        } else {
            this.ivStartChecked = false;
        }
    }

    private void createCageCursor(Vector cages) {
        this.ivDragCursor = Toolkit.getDefaultToolkit().createCustomCursor(ImageProvider.getCageImage(cages), new Point(10, 10), "CAGES");
    }

    private void createMiceCursor(Vector mice) {
        this.ivDragCursor = Toolkit.getDefaultToolkit().createCustomCursor(ImageProvider.getMiceImage(mice), new Point(10, 10), "MICE");
    }

    private MouseEvent convertEvent(MouseEvent e) {
        Point p = e.getPoint();
        JComponent erpf = null;
        RackFrame rf = RackFrame.getInstance();
        if (rf.ivFrontField.getBounds().contains(p)) {
            erpf = rf.ivFrontField;
        } else if (rf.ivBackField.getBounds().contains(p)) {
            erpf = rf.ivBackField;
        } else if (rf.ivOrcusField.getBounds().contains(p)) {
            erpf = rf.ivOrcusField;
        } else if (MausoleumPool.POOL_COMPONENT.getBounds().contains(p)) {
            erpf = MausoleumPool.POOL_COMPONENT;
        }
        if (erpf == null) {
            return null;
        }
        p.x -= ((Component)erpf).getBounds().x;
        p.y -= ((Component)erpf).getBounds().y;
        return new MouseEvent(erpf, 3467, System.currentTimeMillis(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger());
    }

    public void mouseReleased(MouseEvent e) {
        if (Privileges.hasPrivilege("MOVE_MICE")) {
            if (this.ivAktTarget != null) {
                this.ivAktTarget.setDragTarget(null, null);
                this.ivAktTarget = null;
            }
            if (this.ivStartERP != null && this.ivStartERP.ivDraggingAllowed && (e = this.convertEvent(e)) != null && e.getSource() instanceof ERPFiller) {
                ERPFiller erpf = (ERPFiller)e.getSource();
                SwingUtilities.invokeLater(new Deliverer(erpf, this.ivStartERP, ExtendedRackPos.calcERP(e)));
            }
            RackFrame.getInstance().setCursor(Cursor.getDefaultCursor());
            this.ivCursorSet = false;
            this.ivStartERP = null;
            this.ivStartChecked = false;
            RackFrame.getInstance().ivFrontField.clearUnzugaenglichkeit();
            RackFrame.getInstance().ivBackField.clearUnzugaenglichkeit();
            RackFrame.getInstance().ivOrcusField.clearUnzugaenglichkeit();
        }
    }

    public void mousePressed(MouseEvent e) {
        Point urPunkt = e.getPoint();
        if ((e = this.convertEvent(e)) != null) {
            this.evaluateStartERP(ExtendedRackPos.calcERP(e), e, urPunkt, false);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if ((e = this.convertEvent(e)) != null) {
            Vector v;
            ExtendedRackPos erp;
            Cage cage;
            if (e.getSource() instanceof MausoleumPool) {
                MausoleumPool.reactOnClick(e);
            } else if (e.getClickCount() == 2 && (cage = (erp = ExtendedRackPos.calcERP(e)).getRelevantCage()) != null && (v = cage.getActualMice()) != null && !v.isEmpty()) {
                TableFrameMouse.displayMice(v, Babel.get("CAGESNAPSHOT"), Babel.get("CAGESNAPSHOT"));
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        if (DefaultManager.getWantsTooltips()) {
            RackFrame.getMainPanel().setCageForTooltip(null);
        }
        ((JComponent)RackFrame.getInstance().getContentPane()).setToolTipText(null);
    }

    public void mouseMoved(MouseEvent e) {
        if (DefaultManager.getWantsTooltips()) {
            ExtendedRackPos erp;
            Cage cage = null;
            if ((e = this.convertEvent(e)) != null && (erp = ExtendedRackPos.calcERP(e)) != null) {
                cage = erp.getRelevantCage();
            }
            RackFrame.getMainPanel().setCageForTooltip(cage);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.ivStartERP != null && !this.ivStartChecked) {
            RackFrame.getInstance().ivFrontField.manageZugaenglich(this.ivStartERP);
            RackFrame.getInstance().ivBackField.manageZugaenglich(this.ivStartERP);
            RackFrame.getInstance().ivOrcusField.manageZugaenglich(this.ivStartERP);
            this.ivStartChecked = true;
        }
        if (Privileges.hasPrivilege("MOVE_MICE") && this.ivStartERP != null && this.ivStartERP.ivDraggingAllowed && (e = this.convertEvent(e)) != null) {
            if (!this.ivCursorSet && this.ivDragCursor != null) {
                RackFrame.getInstance().setCursor(this.ivDragCursor);
                this.ivCursorSet = true;
            }
            if (e.getSource() instanceof ERPFiller) {
                ERPFiller erpf = (ERPFiller)e.getSource();
                ExtendedRackPos tz = ExtendedRackPos.calcERP(e);
                if (e.getSource() != this.ivAktTarget && this.ivAktTarget != null) {
                    this.ivAktTarget.setDragTarget(null, null);
                }
                this.ivAktTarget = null;
                if (erpf.setDragTarget(tz, this.ivStartERP)) {
                    this.ivAktTarget = erpf;
                }
            }
        }
    }

    public class Deliverer
    implements Runnable {
        ERPFiller ivFiller;
        ExtendedRackPos ivStart;
        ExtendedRackPos ivZiel;

        public Deliverer(ERPFiller filler, ExtendedRackPos start, ExtendedRackPos ziel) {
            this.ivFiller = filler;
            this.ivStart = start;
            this.ivZiel = ziel;
        }

        public void run() {
            if (this.ivFiller.setDragTarget(this.ivZiel, this.ivStart)) {
                this.ivFiller.deliver(this.ivStart, this.ivZiel);
            }
            this.ivFiller.setDragTarget(null, null);
        }
    }
}

