/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack.frame;

import de.hannse.netobjects.network.client.TimeMachine;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.user.UserRoomRestriction;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import mausoleum.alert.Alert;
import mausoleum.cage.Cage;
import mausoleum.cage.CageManager;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.inspector.Inspector;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.mouse.TaskExtended;
import mausoleum.objectstore.CommandManagerMouse;
import mausoleum.rack.ERPFiller;
import mausoleum.rack.ExtendedRackPos;
import mausoleum.rack.RackPos;
import mausoleum.rack.frame.BlinkConsumer;
import mausoleum.rack.frame.CageDisplayManager;
import mausoleum.rack.frame.RackBlinker;
import mausoleum.rack.frame.RackFrame;
import mausoleum.rack.frame.RackGraphicsManager;
import mausoleum.reports.TrafficReport;
import mausoleum.requester.calendar.CalendarRequester;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.room.Room;
import mausoleum.room.RoomManager;
import mausoleum.task.standards.StandardTask;
import mausoleum.visit.Visit;

public class RackOrcusField
extends JComponent
implements BlinkConsumer,
AdjustmentListener,
ERPFiller {
    private static final long serialVersionUID = 48646446L;
    private final Vector ivCages = new Vector();
    private final Vector ivImplicitCages = new Vector();
    private final Vector ivSelCages = new Vector();
    private JScrollBar ivScrollBar = null;
    private ExtendedRackPos ivERPTarget = null;
    private boolean ivDrawAll = true;
    public final HashMap ivCageVerboteByCIDString = new HashMap();

    public RackOrcusField(JScrollBar jsb) {
        this.ivScrollBar = jsb;
        this.ivScrollBar.addAdjustmentListener(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                RackOrcusField.this.recalcScrollbar();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCages(Vector v) {
        Vector<Cage> nc = new Vector<Cage>();
        Vector<Cage> ic = new Vector<Cage>();
        if (v != null) {
            int i = 0;
            while (i < v.size()) {
                Cage c = (Cage)v.elementAt(i);
                if (c != null) {
                    if (c.get("CAG_SUPERCAGE") == null) {
                        nc.addElement(c);
                    } else {
                        Cage sc = c.getSuperCageIfThere();
                        if (sc != null && !nc.contains(sc)) {
                            nc.addElement(sc);
                        }
                        ic.addElement(c);
                    }
                }
                ++i;
            }
        }
        Vector vector = this.ivCages;
        synchronized (vector) {
            this.ivCages.clear();
            this.ivCages.addAll(nc);
        }
        vector = this.ivImplicitCages;
        synchronized (vector) {
            this.ivImplicitCages.clear();
            this.ivImplicitCages.addAll(ic);
        }
        this.recalcScrollbar();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getCages() {
        Vector res = new Vector();
        Vector vector = this.ivCages;
        synchronized (vector) {
            res.addAll(this.ivCages);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getImplicitCages() {
        Vector res = new Vector();
        Vector vector = this.ivImplicitCages;
        synchronized (vector) {
            res.addAll(this.ivImplicitCages);
        }
        return res;
    }

    public void clearUnzugaenglichkeit() {
        this.ivCageVerboteByCIDString.clear();
        this.repaint();
    }

    public void manageZugaenglich(ExtendedRackPos source) {
        Vector mice;
        this.ivCageVerboteByCIDString.clear();
        if (source != null && source.mouseCount() > 0 && (MausoleumClient.isServiceCaretaker() || MausoleumClient.isRegularOrTGService()) && !(mice = source.getMice()).isEmpty()) {
            Iterator iter = this.getCages().iterator();
            while (iter.hasNext()) {
                CageDisplayManager.checkVerbote((Cage)iter.next(), mice, IDObject.commonGroup(mice), this.ivCageVerboteByCIDString);
            }
            this.repaint();
        }
    }

    public Enumeration getSelectedCages() {
        return this.ivSelCages.elements();
    }

    public void setSelectedCages(Vector v) {
        this.ivSelCages.clear();
        if (v != null) {
            int i = 0;
            while (i < v.size()) {
                Cage c = (Cage)v.elementAt(i);
                if (this.getCages().contains(c) || this.getImplicitCages().contains(c)) {
                    this.ivSelCages.addElement(c);
                }
                ++i;
            }
        }
        if (this.ivSelCages.isEmpty()) {
            RackBlinker.removeConsumer(this);
            this.paint(true);
        } else {
            RackBlinker.addConsumer(this);
        }
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        int randOben = (this.getHeight() - RackGraphicsManager.cvCageHeight) / 2;
        MausoleumImageStore.fillDimWithImage(g, "inspectorButton", d);
        String title = Babel.get("ORCUS");
        if (MausoleumClient.isServiceCaretaker() && MausoleumClient.cvServiceCTRoomName != null) {
            title = String.valueOf(title) + " (" + Babel.get("FS_ROOM") + ": " + MausoleumClient.cvServiceCTRoomName + ")";
        }
        CageDisplayManager.drawOrcusPoolString(title, d, g);
        Vector tmpCages = this.getCages();
        if (!tmpCages.isEmpty()) {
            int start = this.ivScrollBar.getValue();
            int startCage = start - RackGraphicsManager.SMALL_MARGIN;
            int startCagePos = RackGraphicsManager.BIG_MARGIN + (startCage /= this.getSpaceForCage()) * this.getSpaceForCage();
            int aktx = startCagePos - start;
            boolean cont = true;
            Vector checkSelection = null;
            if (!this.ivDrawAll) {
                checkSelection = this.ivSelCages;
            }
            Cage c = null;
            while (cont) {
                c = (Cage)tmpCages.elementAt(startCage);
                CageDisplayManager.paintCage(c, g, aktx, randOben, RackGraphicsManager.cvCageWidth, RackGraphicsManager.cvCageHeight, checkSelection, this.ivCageVerboteByCIDString);
                if (++startCage >= tmpCages.size()) {
                    cont = false;
                }
                if ((aktx += this.getSpaceForCage()) <= this.getSize().width) continue;
                cont = false;
            }
        }
        g.setColor(Color.white);
        g.drawLine(d.width - 1, d.height - 1, d.width - 1, 0);
        g.drawLine(d.width - 1, d.height - 1, 0, d.height - 1);
        if (this.ivERPTarget != null) {
            if (this.ivERPTarget.cageCount() == 0) {
                g.setColor(Color.red);
                g.drawRect(1, 1, d.width - 3, d.height - 3);
                g.drawRect(2, 2, d.width - 5, d.height - 5);
                g.drawRect(3, 3, d.width - 7, d.height - 7);
            } else if (this.ivERPTarget.ivRackPos != null) {
                int cx = this.ivERPTarget.ivRackPos.ivColumn;
                Cage cage = this.ivERPTarget.getSingleCage();
                if (cage != null) {
                    if (cage.hasSubCages()) {
                        if (this.ivERPTarget.dx < RackGraphicsManager.getCageWidth() / 2) {
                            Cage c = cage.getLeftSubCage();
                            if (c != null) {
                                CageDisplayManager.drawFramedLeftCagePolygon(g, RackGraphicsManager.BIG_MARGIN + cx * this.getSpaceForCage() - this.ivScrollBar.getValue(), randOben, RackGraphicsManager.cvCageWidth, RackGraphicsManager.cvCageHeight);
                            }
                        } else {
                            Cage c = cage.getRightSubCage();
                            if (c != null) {
                                CageDisplayManager.drawFramedRightCagePolygon(g, RackGraphicsManager.BIG_MARGIN + cx * this.getSpaceForCage() - this.ivScrollBar.getValue(), randOben, RackGraphicsManager.cvCageWidth, RackGraphicsManager.cvCageHeight);
                            }
                        }
                    } else {
                        CageDisplayManager.drawFramedCagePolygon(g, RackGraphicsManager.BIG_MARGIN + cx * this.getSpaceForCage() - this.ivScrollBar.getValue(), randOben, RackGraphicsManager.cvCageWidth, RackGraphicsManager.cvCageHeight);
                    }
                }
            }
        }
        g.setColor(Color.black);
        g.drawLine(0, 0, d.width, 0);
        g.drawLine(0, 0, 0, d.height);
    }

    public void dispose() {
        this.ivCages.clear();
        this.ivImplicitCages.clear();
        this.ivSelCages.clear();
        this.ivScrollBar = null;
        this.ivERPTarget = null;
        this.ivCageVerboteByCIDString.clear();
    }

    private void clearTarget() {
        if (this.ivERPTarget != null) {
            this.ivERPTarget = null;
            this.repaint();
        }
    }

    private void putMiceInOrcus(ExtendedRackPos erp, Vector mice) {
        String commonGroup = IDObject.commonGroup(mice);
        if (commonGroup != null) {
            Vector paarungsSammler;
            long cageID = 0L;
            Cage cage = erp.getSingleCage();
            if (cage != null) {
                if (!cage.getGroup().equals(commonGroup)) {
                    return;
                }
                cageID = cage.hasSubCages() ? (this.ivERPTarget.dx < RackGraphicsManager.getCageWidth() / 2 ? cage.getLong("CAG_SUBCAGEL", 0L) : cage.getLong("CAG_SUBCAGER", 0L)) : cage.getID();
            }
            Cage target = null;
            if (cageID != 0L) {
                target = (Cage)ObjectStore.getClientObject(2, cageID, commonGroup);
            }
            if (!PopeAlert.makeCompleteMatingCheck(target, mice, paarungsSammler = new Vector())) {
                return;
            }
            if (!PopeAlert.checkForCageGomorrha(cageID, mice, commonGroup)) {
                return;
            }
            if (!PopeAlert.checkForEartag100Collision(cageID, mice, commonGroup)) {
                return;
            }
            Date transferDate = CalendarRequester.getDate((Frame)Inspector.getInspector(), Visit.findLatestStartDate(Mouse.getLastVisits(mice)), new Date());
            if (transferDate == null) {
                return;
            }
            int actionDate = (int)(transferDate.getTime() / 86400000L);
            if (cageID == 0L && (cageID = Cage.getNewCageID(transferDate, commonGroup)) == 0L) {
                Alert.showAlert(Babel.get("COULDNOTCREATECAGE"), true);
                return;
            }
            StringBuffer msb = new StringBuffer();
            TaskExtended.addExactPoolingTaskFinish(mice, cageID, msb, actionDate);
            long dateMillis = transferDate.getTime();
            int i = 0;
            while (i < mice.size()) {
                Mouse mausi = (Mouse)mice.elementAt(i);
                TaskExtended.addTaskFinishsToComBuff(mausi, mausi.getTaskKey(), "TASK_AC_TRANSFER", 0L, msb, actionDate);
                CommandManagerMouse.appendTransferCommand(mausi, cageID, dateMillis, msb, true);
                ++i;
            }
            StandardTask.checkForToAndFromMating(mice, paarungsSammler, msb, actionDate);
            TrafficReport.appendTrafficInfoClientSide(mice, dateMillis, "TRD_MICE_DROPPED_IN_ORCUS", msb);
            RequestManager.sendCommandRequestAndGetAnswer(msb.toString(), commonGroup);
            if (!mice.isEmpty()) {
                Mouse mouse = (Mouse)mice.elementAt(0);
                if ((mouse = MouseManager.getMouse(mouse.getID(), commonGroup)) != null) {
                    UserRoomRestriction.addRestrictionOverrideObject(mouse);
                    Cage newCage = mouse.getActCage();
                    if (newCage != null) {
                        UserRoomRestriction.addRestrictionOverrideObject(newCage);
                        CageManager.cvInstance.notifyConsumers(newCage);
                        Vector<Cage> v = new Vector<Cage>();
                        v.addElement(newCage);
                        RackFrame.getInstance().selectCages(v, 2);
                    }
                }
            }
        }
    }

    private void recalcScrollbar() {
        Vector tmpCages = this.getCages();
        if (tmpCages.isEmpty()) {
            this.ivScrollBar.setValues(0, 0, 0, 0);
            this.ivScrollBar.setBlockIncrement(0);
        } else {
            int siz = tmpCages.size();
            int maximum = RackGraphicsManager.SMALL_MARGIN * 2 + RackGraphicsManager.getCageWidth() * siz + RackGraphicsManager.CAGESEP * (siz - 1);
            if (maximum <= this.getSize().width) {
                this.ivScrollBar.setValues(0, 0, 0, 0);
                this.ivScrollBar.setBlockIncrement(0);
            } else {
                this.ivScrollBar.setValues(this.ivScrollBar.getValue(), this.getSize().width, 0, maximum);
                this.ivScrollBar.setBlockIncrement(this.getSize().width);
            }
        }
    }

    public void fillERP(ExtendedRackPos erp, int x, int y) {
        int realx = x + this.ivScrollBar.getValue() - RackGraphicsManager.BIG_MARGIN;
        int cageind = realx / this.getSpaceForCage();
        erp.ivFeldKennung = 3;
        erp.setCages(null);
        erp.ivRackPos = new RackPos(0L, -1, 0, 0);
        int cageHeight = RackGraphicsManager.cvCageHeight;
        int oben = (this.getHeight() - cageHeight) / 2;
        int unten = oben + cageHeight;
        if (y >= oben && y <= unten) {
            Cage cage;
            Vector tmpCages = this.getCages();
            if (cageind >= 0 && cageind < tmpCages.size() && (cage = (Cage)tmpCages.elementAt(cageind)).isTouchable()) {
                erp.setCage(cage);
                erp.ivRackPos = new RackPos(0L, -1, 0, cageind);
                erp.dx = realx - cageind * this.getSpaceForCage();
            }
        }
    }

    public boolean setDragTarget(ExtendedRackPos target, ExtendedRackPos source) {
        boolean tolerable = false;
        if (target == null || source == null || target.ivFeldKennung == -1) {
            this.clearTarget();
            return false;
        }
        if (source.mouseCount() > 0) {
            String commonGroup = IDObject.commonGroup(source.getMice());
            if (commonGroup != null) {
                Cage c;
                int anz = target.cageCount();
                if (anz == 0) {
                    tolerable = true;
                } else if (anz == 1 && (c = target.getRelevantCage()) != null && c.isTouchable() && !c.areMiceInside(source.getMice()) && c.getGroup("").equals(commonGroup)) {
                    tolerable = true;
                }
            }
        } else if (source.cageCount() > 0 && source.ivFeldKennung != 3) {
            target.setCages(null);
            tolerable = true;
        }
        if (tolerable) {
            this.ivERPTarget = target;
            this.repaint();
        } else {
            this.clearTarget();
        }
        return tolerable;
    }

    public void deliver(ExtendedRackPos source, ExtendedRackPos target) {
        if (source.mouseCount() > 0) {
            this.putMiceInOrcus(target, source.getMice());
        } else if (source.cageCount() > 0) {
            RackOrcusField.sendCagesToOrcus(source.getCages());
        }
    }

    public static void sendCagesToOrcus(Vector cages) {
        if (cages != null && !cages.isEmpty()) {
            Vector<Cage> realCages = new Vector<Cage>();
            Iterator iter = cages.iterator();
            while (iter.hasNext()) {
                Cage cage = (Cage)iter.next();
                if (!cage.isTouchable() || cage.get("CAG_POS") == null || realCages.contains(cage = cage.getSuperCageIfThere())) continue;
                realCages.add(cage);
            }
            if (!realCages.isEmpty()) {
                HashMap obsByGroup = IDObject.sortByGroup(realCages);
                if (obsByGroup != null) {
                    Iterator iter2 = obsByGroup.keySet().iterator();
                    while (iter2.hasNext()) {
                        String group = (String)iter2.next();
                        Vector obs = (Vector)obsByGroup.get(group);
                        StringBuffer msb = new StringBuffer();
                        int i = 0;
                        while (i < obs.size()) {
                            Room room;
                            Cage cage = (Cage)obs.elementAt(i);
                            long cageID = cage.getID();
                            long groupRoomID = -1L;
                            UserRoomRestriction.addRestrictionOverrideObject(cage);
                            CageManager.cvInstance.notifyConsumers(cage);
                            msb.append("CSETR").append(" ").append(cageID).append(" 0\n");
                            if (MausoleumClient.isServiceCaretaker()) {
                                groupRoomID = RoomManager.getGROUPRoomIDForServiceRoom(group);
                            } else if (MausoleumClient.isRegularOrTGService() && (room = cage.getRoom()) != null) {
                                groupRoomID = room.getID();
                            }
                            if (groupRoomID != -1L) {
                                msb.append("CTRR");
                                msb.append(" ").append(cageID);
                                msb.append(" ").append(groupRoomID);
                                msb.append(" ").append(TimeMachine.getCurrentMillis());
                                msb.append("\n");
                            }
                            ++i;
                        }
                        TrafficReport.appendTrafficInfoClientSide(obs, -1L, "TRD_CAGE_DROPPED_IN_ORCUS", msb);
                        RequestManager.sendCommandRequestAndGetAnswer(msb.toString().trim(), group);
                    }
                }
                RackFrame.getInstance().selectCages(realCages, 2);
            }
        }
    }

    private int getSpaceForCage() {
        return RackGraphicsManager.getCageWidth() + RackGraphicsManager.CAGESEP;
    }

    public void paint(boolean drawAll) {
        this.ivDrawAll = drawAll;
        this.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.repaint();
    }
}

