/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack.frame;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.gui.MGButton;
import mausoleum.mouse.TaskExtended;
import mausoleum.rack.frame.RackFrame;
import mausoleum.rack.frame.TriangleRestrictor;
import mausoleum.requester.AllgPickRequester;
import mausoleum.tables.MausoleumTableFrame;
import mausoleum.task.DisplayTask;
import mausoleum.task.TaskTreeNode;
import mausoleum.ui.UIDef;

public class TriangleButton
extends MGButton {
    private static final long serialVersionUID = 123423L;
    private static final Vector TASK_COLLECTOR = new Vector();
    private static final Vector PICK_COLLECTOR = new Vector();
    private static final TreeSet ALLE_COLLECTOR = new TreeSet();
    private static final TreeSet RESTR_COLLECTOR = new TreeSet();
    private static final Vector FTOOLTIP_COLLECTOR = new Vector();
    private boolean ivRestrictionPresent = false;

    public TriangleButton() {
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TriangleButton.this.collect();
                if (!TASK_COLLECTOR.isEmpty()) {
                    PICK_COLLECTOR.clear();
                    PICK_COLLECTOR.addAll(ALLE_COLLECTOR);
                    Vector nachher = AllgPickRequester.pickFromList(RackFrame.getInstance(), PICK_COLLECTOR, "SELECT_TASKS_FOR_MOUSE_AND_CAGE_HIGHLIGHT", "TASKS", new int[]{1, 2}, new String[]{"APR_SELECT_ALL", "APR_SELECT_NONE"}, 2, RESTR_COLLECTOR, false);
                    if (nachher != null) {
                        TaskExtended.cvTaskRestrictors.clear();
                        if (nachher.size() != PICK_COLLECTOR.size()) {
                            TaskExtended.cvTaskRestrictors.addAll(nachher);
                        }
                        TriangleButton.this.makeTooltipEtc();
                        MausoleumTableFrame.repaintAllTables(false);
                        RackFrame.getInstance().ivFrontField.somethingChanged();
                        RackFrame.getInstance().ivBackField.somethingChanged();
                        RackFrame.getInstance().repaint();
                    }
                }
            }
        });
        this.collect();
        this.makeTooltipEtc();
        this.ivShowTooltipTriangle = false;
    }

    private synchronized void collect() {
        ALLE_COLLECTOR.clear();
        RESTR_COLLECTOR.clear();
        TASK_COLLECTOR.clear();
        TaskTreeNode.PENDING.collectTasks(TASK_COLLECTOR);
        if (!TASK_COLLECTOR.isEmpty()) {
            Iterator iterator = TASK_COLLECTOR.iterator();
            while (iterator.hasNext()) {
                DisplayTask dt = (DisplayTask)iterator.next();
                TaskExtended task = dt.ivTask;
                if (TriangleRestrictor.isPresent(task, ALLE_COLLECTOR)) continue;
                ALLE_COLLECTOR.add(new TriangleRestrictor(task));
            }
        }
        if (TaskExtended.cvTaskRestrictors.isEmpty()) {
            RESTR_COLLECTOR.addAll(ALLE_COLLECTOR);
        } else {
            RESTR_COLLECTOR.addAll(TaskExtended.cvTaskRestrictors);
        }
    }

    private synchronized void makeTooltipEtc() {
        String title = null;
        FTOOLTIP_COLLECTOR.clear();
        if (TaskExtended.cvTaskRestrictors.isEmpty()) {
            this.ivRestrictionPresent = false;
            title = Babel.get("ALL_TASK_ARE_USED_FOR_HIGHLIGHTING");
            FTOOLTIP_COLLECTOR.addAll(ALLE_COLLECTOR);
        } else {
            this.ivRestrictionPresent = true;
            title = Babel.get("THESE_TASKS_ARE_USED_FOR_HIGHLIGHTING");
            FTOOLTIP_COLLECTOR.addAll(TaskExtended.cvTaskRestrictors);
        }
        this.setToolTipText(TaskExtended.getToolTipStringForTriangleButton(title, FTOOLTIP_COLLECTOR));
    }

    public void drawExtra(Graphics g) {
        Dimension dim = this.getSize();
        int siz = dim.width - 6;
        g.setColor(this.ivRestrictionPresent ? UIDef.ALARM_COLOR : UIDef.SELECTED_BACKGROUND);
        g.fillPolygon(new int[]{3, siz, 3}, new int[]{3, 3, siz}, 3);
        g.setColor(Color.black);
        g.drawLine(3, siz, siz, 3);
        g.setColor(Color.white);
        g.drawLine(3, 3, siz, 3);
        g.drawLine(3, 3, 3, siz);
    }
}

