/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack.frame.cagecard;

import de.hannse.netobjects.util.Babel;
import java.awt.Dimension;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

public class CageCardPrinterScaler
implements Comparable,
Serializable {
    private static final long serialVersionUID = 15364562L;
    public static final NumberFormat M1NKS = new DecimalFormat("0.#%");
    public static final Double EINS = new Double(1.0);
    public final int ivHash;
    public final double ivScale;
    public final String ivScalePerc;
    public final String ivDesc;
    public final Dimension ivCardsPerPage;
    public final Dimension ivNeededPages;
    public final Dimension ivScaledCardDim;

    public static void main(String[] args) {
        Dimension cards = new Dimension(10, 8);
        Dimension cardDim = new Dimension(320, 200);
        Dimension pageDim = new Dimension(620, 940);
        CageCardPrinterScaler.getScalers(cardDim, pageDim, cards);
    }

    public static Vector getScalers(Dimension cardDim, Dimension pageDim, Dimension cards) {
        double vert1Page;
        Vector<CageCardPrinterScaler> v = new Vector<CageCardPrinterScaler>();
        TreeSet<Double> faktoren = new TreeSet<Double>();
        double hor1Page = (double)pageDim.width / (double)(cards.width * cardDim.width);
        if (hor1Page < 1.0) {
            faktoren.add(new Double(hor1Page));
        }
        if ((vert1Page = (double)pageDim.height / (double)(cards.height * cardDim.height)) < 1.0) {
            faktoren.add(new Double(vert1Page));
        }
        CageCardPrinterScaler.makeOneDim(cardDim.width, pageDim.width, cards.width, faktoren);
        CageCardPrinterScaler.makeOneDim(cardDim.height, pageDim.height, cards.height, faktoren);
        faktoren.add(EINS);
        HashSet<Dimension> neededPages = new HashSet<Dimension>();
        Iterator iter = faktoren.iterator();
        while (iter.hasNext()) {
            Double faktor = (Double)iter.next();
            CageCardPrinterScaler ccps = new CageCardPrinterScaler(faktor, cardDim, pageDim, cards);
            if (ccps.ivNeededPages == null) continue;
            v.add(ccps);
            neededPages.add(ccps.ivNeededPages);
        }
        Vector<CageCardPrinterScaler> w = new Vector<CageCardPrinterScaler>();
        Iterator iter2 = neededPages.iterator();
        while (iter2.hasNext()) {
            Dimension nnps = (Dimension)iter2.next();
            CageCardPrinterScaler ccps = CageCardPrinterScaler.findUsable(v, nnps);
            if (ccps == null) continue;
            w.add(ccps);
        }
        Collections.sort(w);
        return w;
    }

    private static CageCardPrinterScaler findUsable(Vector ur, Dimension neededPages) {
        double maxf = 0.0;
        CageCardPrinterScaler res = null;
        Iterator iter = ur.iterator();
        while (iter.hasNext()) {
            CageCardPrinterScaler ccps = (CageCardPrinterScaler)iter.next();
            if (!ccps.ivNeededPages.equals(neededPages) || !(ccps.ivScale > maxf)) continue;
            maxf = ccps.ivScale;
            res = ccps;
        }
        return res;
    }

    private static void makeOneDim(int cd, int pd, int ac, TreeSet target) {
        CageCardPrinterScaler.addValue(cd, pd, ac, target);
        CageCardPrinterScaler.addValue(cd, pd, CageCardPrinterScaler.mdiv(ac, 2), target);
        CageCardPrinterScaler.addValue(cd, pd, CageCardPrinterScaler.mdiv(ac, 3), target);
        CageCardPrinterScaler.addValue(cd, pd, CageCardPrinterScaler.mdiv(ac, 4), target);
        CageCardPrinterScaler.addValue(cd, pd, CageCardPrinterScaler.mdiv(ac, 5), target);
        CageCardPrinterScaler.addValue(cd, pd, CageCardPrinterScaler.mdiv(ac, 6), target);
    }

    private static void addValue(int cd, int pd, int ta, TreeSet target) {
        double gewbr = cd * ta;
        double d = (double)pd / gewbr;
        if (d < 1.0) {
            target.add(new Double(d));
        }
    }

    private static int mdiv(int zaehler, int nenner) {
        return (zaehler + nenner - 1) / nenner;
    }

    private CageCardPrinterScaler(Double d, Dimension cardDim, Dimension pageDim, Dimension cards) {
        this.ivHash = d.hashCode();
        this.ivScale = d;
        this.ivScalePerc = M1NKS.format(this.ivScale);
        int hcdim = (int)(this.ivScale * (double)cardDim.width);
        int rest = pageDim.width;
        int hanz = 0;
        while (rest >= hcdim) {
            ++hanz;
            rest -= hcdim;
        }
        int vcdim = (int)(this.ivScale * (double)cardDim.height);
        rest = pageDim.height;
        int vanz = 0;
        while (rest >= vcdim) {
            ++vanz;
            rest -= vcdim;
        }
        if (hanz != 0 && vanz != 0 && hcdim != 0 && vcdim != 0) {
            this.ivScaledCardDim = new Dimension(hcdim, vcdim);
            this.ivCardsPerPage = new Dimension(hanz, vanz);
            this.ivNeededPages = new Dimension(CageCardPrinterScaler.mdiv(cards.width, this.ivCardsPerPage.width), CageCardPrinterScaler.mdiv(cards.height, this.ivCardsPerPage.height));
            int anzPages = this.ivNeededPages.width * this.ivNeededPages.height;
            this.ivDesc = anzPages == 1 ? " " + this.ivScalePerc + " [1 " + Babel.get("CCV_PAGE") + "] " : " " + this.ivScalePerc + " [" + anzPages + " " + Babel.get("CCV_PAGES") + " " + "(" + this.ivNeededPages.width + " x " + this.ivNeededPages.height + ")] ";
        } else {
            this.ivScaledCardDim = null;
            this.ivCardsPerPage = null;
            this.ivNeededPages = null;
            this.ivDesc = null;
        }
    }

    public String toString() {
        return this.ivDesc;
    }

    public String toTableString() {
        StringBuffer msb = new StringBuffer();
        msb.append(Double.toString(this.ivScale).replace('.', ',')).append(";");
        msb.append(this.ivCardsPerPage.width).append(";").append(this.ivCardsPerPage.height).append(";");
        msb.append(this.ivNeededPages.width).append(";").append(this.ivNeededPages.height).append(";");
        msb.append(this.ivScaledCardDim.width).append(";").append(this.ivScaledCardDim.height);
        return msb.toString();
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof CageCardPrinterScaler) {
            CageCardPrinterScaler ccps = (CageCardPrinterScaler)arg0;
            if (this.ivScale < ccps.ivScale) {
                return -1;
            }
            if (this.ivScale > ccps.ivScale) {
                return 1;
            }
        }
        return 0;
    }

    public int hashCode() {
        return this.ivHash;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof CageCardPrinterScaler) {
            CageCardPrinterScaler ccps = (CageCardPrinterScaler)arg0;
            return ccps.ivScale == this.ivScale;
        }
        return false;
    }
}

