/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack.frame.cagecard;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import mausoleum.cage.BlockingCage;
import mausoleum.cage.Cage;
import mausoleum.factsheets.FactSheetFrame;
import mausoleum.helper.WindowUtils;
import mausoleum.main.MausoleumClient;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.rack.Rack;
import mausoleum.rack.frame.RackFrame;
import mausoleum.requester.LabelPrintRequester;
import mausoleum.requester.preferences.Preferences;
import mausoleum.tables.TableFrameMouse;
import mausoleum.tables.models.MTCage;
import mausoleum.ui.UIDef;

public class RackCageCardComponent
extends JComponent {
    private static final long serialVersionUID = 1234234L;
    private static final Color EMPTY_COLOR = new Color(230, 230, 230);
    private static final Color BLOCK_COLOR = new Color(130, 130, 130);
    private static final int INTER_CARD = 0;
    private Rack ivRack = null;
    private int ivColumns = 0;
    private int ivRows = 0;
    private int ivSide = 0;
    public double ivFaktor = 0.5;
    private Dimension ivPreferredSize = UIDef.MINI_DIM;
    private Dimension ivImageDimension = null;
    private String ivPrinterName = LabelPrintRequester.getLastUsedLabelPrinter();
    private final HashMap ivImages = new HashMap(100);
    private final HashMap ivCages = new HashMap(100);
    private final HashMap ivPages = new HashMap(100);
    private final HashSet ivSelectedCageIDs = new HashSet();
    private final JPopupMenu ivPopupMenu = new JPopupMenu();
    private String ivLastMousePressedCageID = null;

    public RackCageCardComponent(Rack rack) {
        this.adapt(rack, this.ivPrinterName, this.ivSide);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isMetaDown()) {
                    if (!RackCageCardComponent.this.ivSelectedCageIDs.isEmpty()) {
                        RackCageCardComponent.this.ivPopupMenu.show((JComponent)e.getSource(), e.getX(), e.getY());
                    }
                } else {
                    Cage cage = RackCageCardComponent.this.getCageAt(e);
                    RackCageCardComponent.this.ivLastMousePressedCageID = cage == null ? null : cage.getIdentifierString();
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (RackCageCardComponent.this.ivLastMousePressedCageID != null) {
                    Cage cage = RackCageCardComponent.this.getCageAt(e);
                    if (cage != null && cage.getIdentifierString().equals(RackCageCardComponent.this.ivLastMousePressedCageID)) {
                        if (e.isControlDown()) {
                            if (RackCageCardComponent.this.ivSelectedCageIDs.contains(RackCageCardComponent.this.ivLastMousePressedCageID)) {
                                RackCageCardComponent.this.ivSelectedCageIDs.remove(RackCageCardComponent.this.ivLastMousePressedCageID);
                            } else {
                                RackCageCardComponent.this.ivSelectedCageIDs.add(RackCageCardComponent.this.ivLastMousePressedCageID);
                            }
                        } else {
                            RackCageCardComponent.this.ivSelectedCageIDs.clear();
                            RackCageCardComponent.this.ivSelectedCageIDs.add(RackCageCardComponent.this.ivLastMousePressedCageID);
                        }
                        RackCageCardComponent.this.repaint();
                    }
                    RackCageCardComponent.this.ivLastMousePressedCageID = null;
                }
            }

            public void mouseClicked(MouseEvent e) {
                Cage cage;
                if (!e.isMetaDown() && RackCageCardComponent.this.ivImageDimension != null && e.getClickCount() == 2 && (cage = RackCageCardComponent.this.getCageAt(e)) != null) {
                    Vector<Cage> v = new Vector<Cage>();
                    v.add(cage);
                    MTCage.showSnapshot(v);
                }
            }
        });
        JMenuItem item = new JMenuItem(Babel.get("PRINTLABEL"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector preview = RackCageCardComponent.this.getSelectedCages();
                if (preview != null && !preview.isEmpty()) {
                    LabelPrinter.previewIt(preview, RackCageCardComponent.this.getPrinterName());
                }
            }
        });
        this.ivPopupMenu.add(item);
        item = new JMenuItem(Babel.get("FS_SHOW"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector objects = RackCageCardComponent.this.getSelectedCages();
                if (objects != null && !objects.isEmpty()) {
                    FactSheetFrame.showTab(objects, Babel.get("FS_HEADER"));
                }
            }
        });
        this.ivPopupMenu.add(item);
        item = new JMenuItem(Babel.get("SHOWPOS"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector objects = RackCageCardComponent.this.getSelectedCages();
                if (objects != null && !objects.isEmpty()) {
                    RackFrame.showCagePosition(objects);
                }
            }
        });
        this.ivPopupMenu.add(item);
        item = new JMenuItem(Babel.get("CAGESNAPSHOT"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector objects = RackCageCardComponent.this.getSelectedCages();
                if (objects != null && !objects.isEmpty()) {
                    TableFrameMouse.showCageContents(objects, false);
                }
            }
        });
        this.ivPopupMenu.add(item);
        item = new JMenuItem(Babel.get("SHOWALLMICE"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector objects = RackCageCardComponent.this.getSelectedCages();
                if (objects != null && !objects.isEmpty()) {
                    TableFrameMouse.showCageContents(objects, true);
                }
            }
        });
        this.ivPopupMenu.add(item);
    }

    public void dispose() {
        this.ivRack = null;
        this.ivPreferredSize = null;
        this.ivImageDimension = null;
        this.ivImages.clear();
        this.ivCages.clear();
        this.ivPages.clear();
        this.ivSelectedCageIDs.clear();
    }

    public Cage getCageAt(MouseEvent e) {
        int rx = (e.getPoint().x - UIDef.RAND) / (this.ivImageDimension.width + 0);
        int ry = (e.getPoint().y - UIDef.RAND) / (this.ivImageDimension.height + 0);
        return this.getCageAt(rx, ry);
    }

    public Cage getCageAt(int x, int y) {
        Cage cage = (Cage)this.ivCages.get(new Point(x, y));
        if (cage != null && cage.isAliveAndVisible() && !(cage instanceof BlockingCage)) {
            return cage;
        }
        return null;
    }

    public Vector getSelectedCages() {
        Vector<Cage> res = new Vector<Cage>();
        Iterator iterator = this.ivCages.values().iterator();
        while (iterator.hasNext()) {
            Cage c = (Cage)iterator.next();
            if (!this.ivSelectedCageIDs.contains(c.getIdentifierString())) continue;
            res.add(c);
        }
        return res;
    }

    public void setRack(Rack rack) {
        int side = this.ivSide;
        if (rack.getInt("RCK_SIDES", 0) == 1) {
            side = 0;
        }
        this.adapt(rack, this.ivPrinterName, side);
        this.ivSelectedCageIDs.clear();
        this.validate();
        this.repaint();
    }

    public void setPrinter(String printerName) {
        this.adapt(this.ivRack, printerName, this.ivSide);
        this.validate();
        this.repaint();
    }

    public void setSide(int side) {
        this.adapt(this.ivRack, this.ivPrinterName, side);
        this.ivSelectedCageIDs.clear();
        this.validate();
        this.repaint();
    }

    public String getZoomString() {
        int i = 0;
        while (i < Preferences.ZOOM_FACTORS.length) {
            if (this.ivFaktor == Preferences.ZOOM_FACTORS[i]) {
                return Preferences.ZOOM_STRINGS[i];
            }
            ++i;
        }
        return "";
    }

    public Dimension getRackDimension() {
        if (this.ivRows != 0 && this.ivColumns != 0) {
            return new Dimension(this.ivColumns, this.ivRows);
        }
        return null;
    }

    public String getPrinterName() {
        if (this.ivPrinterName != null) {
            return this.ivPrinterName.trim();
        }
        return null;
    }

    public Dimension getSingleCardDimension() {
        if (this.ivPrinterName != null) {
            this.ivImageDimension = LabelPrinter.getImageDimensions(this.ivPrinterName, 0, 1.0);
            return this.ivImageDimension;
        }
        return null;
    }

    public HashMap getCagesByRaster() {
        return this.ivCages;
    }

    public String getSideInfo() {
        if (this.ivSide == 0) {
            return Babel.get("FRONT");
        }
        return Babel.get("Back");
    }

    public String getRackInfo() {
        if (this.ivRack != null) {
            return this.ivRack.getName();
        }
        return "";
    }

    private void adapt(Rack rack, String printerName, int side) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.ivImageDimension = null;
            this.ivPrinterName = printerName.trim();
            this.ivSide = side;
            this.ivRack = rack;
            this.ivColumns = 0;
            this.ivRows = 0;
            this.ivImages.clear();
            this.ivCages.clear();
            if (this.ivRack != null) {
                this.ivColumns = this.ivRack.getInt("RCK_COLUMNS", 0);
                this.ivRows = this.ivRack.getInt("RCK_ROWS", 0);
                int row = 0;
                while (row < this.ivRows) {
                    int col = 0;
                    while (col < this.ivColumns) {
                        Cage cage = null;
                        if (this.ivRack.istPosBelegt(this.ivSide, row, col, true)) {
                            Cage sharedCage;
                            cage = BlockingCage.BLOCKER;
                            if (MausoleumClient.isServiceCaretaker() && (sharedCage = this.ivRack.getCageAlsoFromSharedRack(side, row, col)) != null) {
                                cage = sharedCage;
                            }
                        } else {
                            cage = this.ivRack.getCage(side, row, col);
                        }
                        if (cage != null) {
                            Point key = new Point(col, row);
                            this.ivCages.put(key, cage);
                            this.ivPages.clear();
                        }
                        ++col;
                    }
                    ++row;
                }
                this.setZoom(this.ivFaktor);
            }
        }
        catch (Exception e) {
            System.out.println("Problem while adapting in CageCardComponent " + e);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void setZoom(double zoom) {
        this.ivFaktor = zoom;
        this.ivImageDimension = LabelPrinter.getImageDimensions(this.ivPrinterName, 0, this.ivFaktor);
        if (this.ivImageDimension != null) {
            int fieldWidth = this.ivColumns * this.ivImageDimension.width + (this.ivColumns - 1) * 0;
            int fieldHeight = this.ivRows * this.ivImageDimension.height + (this.ivRows - 1) * 0;
            this.ivPreferredSize = new Dimension(2 * UIDef.RAND + fieldWidth, 2 * UIDef.RAND + fieldHeight);
            this.setPreferredSize(this.ivPreferredSize);
            this.setSize(this.ivPreferredSize);
        }
        this.validate();
        this.repaint();
    }

    public void paint(Graphics g) {
        Rectangle viewRect = WindowUtils.getJScrollPane(this).getViewport().getViewRect();
        Graphics2D g2d = (Graphics2D)g;
        Dimension d = this.getSize();
        g.setColor(Color.white);
        if (viewRect.width >= d.width && viewRect.height >= d.height) {
            g.fillRect(0, 0, d.width, d.height);
        } else {
            g.fillRect(viewRect.x, viewRect.y, viewRect.width, viewRect.height);
        }
        if (this.ivImageDimension != null) {
            LabelPrinter lp = LabelPrinter.get(this.ivPrinterName, true);
            Vector<Cage> cages = new Vector<Cage>();
            Rectangle cageRect = new Rectangle(0, 0, this.ivImageDimension.width, this.ivImageDimension.height);
            cageRect.y = UIDef.RAND;
            Point p = new Point();
            p.y = 0;
            while (p.y < this.ivRows) {
                cageRect.x = UIDef.RAND;
                p.x = 0;
                while (p.x < this.ivColumns) {
                    if (cageRect.intersects(viewRect)) {
                        Cage cage = (Cage)this.ivCages.get(p);
                        if (cage == null) {
                            g.setColor(EMPTY_COLOR);
                            g.fillRect(cageRect.x, cageRect.y, cageRect.width, cageRect.height);
                        } else if (cage instanceof BlockingCage) {
                            g.setColor(BLOCK_COLOR);
                            g.fillRect(cageRect.x, cageRect.y, cageRect.width, cageRect.height);
                        } else {
                            Object ooo;
                            if (this.ivSelectedCageIDs.contains(cage.getIdentifierString())) {
                                g.setColor(UIDef.SELECTED_BACKGROUND);
                                g.fillRect(cageRect.x, cageRect.y, cageRect.width, cageRect.height);
                            }
                            if ((ooo = this.ivPages.get(p)) == null) {
                                cages.clear();
                                cages.add(cage);
                                lp.distributeCageLabels(cages);
                                ooo = lp.getPage(0);
                                if (ooo != null) {
                                    this.ivPages.put(new Point(p), ooo);
                                }
                            }
                            if (ooo != null) {
                                g2d.translate(cageRect.x, cageRect.y);
                                if (this.ivFaktor != 1.0) {
                                    g2d.scale(this.ivFaktor, this.ivFaktor);
                                }
                                if (ooo instanceof Cage) {
                                    Cage cage2 = (Cage)ooo;
                                    lp.simplePrint(cage2, g);
                                } else if (ooo instanceof Vector) {
                                    Vector page = (Vector)ooo;
                                    lp.simplePrint(page, g);
                                }
                                if (this.ivFaktor != 1.0) {
                                    g2d.scale(1.0 / this.ivFaktor, 1.0 / this.ivFaktor);
                                }
                                g2d.translate(-cageRect.x, -cageRect.y);
                            }
                        }
                        g.setColor(Color.black);
                        g.drawRect(cageRect.x, cageRect.y, cageRect.width, cageRect.height);
                    }
                    cageRect.x += this.ivImageDimension.width + 0;
                    ++p.x;
                }
                cageRect.y += this.ivImageDimension.height + 0;
                ++p.y;
            }
        }
    }
}

