/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack.frame.cagecard;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectStoreClient;
import de.hannse.netobjects.util.Babel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.gui.WindowMinimalSizer;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.rack.Rack;
import mausoleum.rack.frame.RackComboBox;
import mausoleum.rack.frame.RackComboChangeListener;
import mausoleum.rack.frame.cagecard.CCVPageFormatDialog;
import mausoleum.rack.frame.cagecard.RackCageCardComponent;
import mausoleum.requester.LabelPrintRequester;
import mausoleum.requester.preferences.Preferences;
import mausoleum.ui.UIDef;

public class RackCageCardFrame
extends JFrame
implements RackComboChangeListener,
ObjectConsumer {
    private static final long serialVersionUID = 1234234234L;
    private static final int BREITE = UIDef.getScaled(800);
    private static final int HOEHE = UIDef.getScaled(600);
    private static final int COMBO_HOEHE = UIDef.getScaled(24);
    private static final int BUT_WIDTH = UIDef.getScaled(80);
    private static final int MIN_BREITE = UIDef.getScaled(600);
    private static final int MIN_HOEHE = UIDef.getScaled(450);
    private static final int[] CONSUMERTYPES = new int[]{3};
    private static RackCageCardFrame cvInstance = null;
    private RackCageCardComponent ivCageCardComponent = new RackCageCardComponent(null);
    private JScrollPane ivCardPane = new JScrollPane(this.ivCageCardComponent);
    private RackComboBox ivRackComboBox = null;
    private JComboBox ivSideComboBox = new JComboBox<String>(new String[]{" " + Babel.get("FRONT") + " ", " " + Babel.get("BACK") + " "});
    private JComboBox ivPrinterComboBox = new JComboBox<String>(LabelPrinter.getNamesWithSpace(true));
    private JComboBox ivZoomComboBox = new JComboBox<String>(Preferences.ZOOM_STRINGS);
    private JLabel ivRackLabel = new JLabel(" " + Babel.get("CCV_RACK") + ": ");
    private JLabel ivSideLabel = new JLabel(" " + Babel.get("CCV_SIDE") + ": ");
    private JLabel ivPrinterLabel = new JLabel(" " + Babel.get("CCV_PRINTER") + ": ");
    private JLabel ivZoomLabel = new JLabel(" " + Babel.get("CCV_ZOOM") + ": ");
    private MGButton ivPrintButton = new MGButton(Babel.get("PRINT"));
    private Point ivPressedPoint = null;

    public static void showCageCardFrame(Rack rack) {
        if (cvInstance == null) {
            cvInstance = new RackCageCardFrame();
        }
        RackCageCardFrame.cvInstance.ivCageCardComponent.setRack(rack);
        WindowUtils.bringUpFrame(cvInstance);
    }

    public static void hideCageCardFrame() {
        if (cvInstance != null) {
            cvInstance.setVisible(false);
        }
    }

    public static void destroyIt() {
        if (cvInstance != null) {
            cvInstance.setVisible(false);
            cvInstance.getContentPane().removeAll();
            RackCageCardFrame.cvInstance.ivCageCardComponent.dispose();
            ObjectStoreClient.removeConsumer((ObjectConsumer)cvInstance, CONSUMERTYPES);
            cvInstance.dispose();
            cvInstance = null;
        }
    }

    private static void dragScroller(JScrollBar bar, int diff) {
        if (bar.isVisible()) {
            int aval = bar.getValue();
            int nval = aval + diff;
            if (nval <= bar.getMinimum()) {
                nval = bar.getMinimum();
            } else if (nval + bar.getVisibleAmount() >= bar.getMaximum()) {
                nval = bar.getMaximum() - bar.getVisibleAmount();
            }
            if (nval != aval) {
                bar.setValue(nval);
            }
        }
    }

    private RackCageCardFrame() {
        this.setTitle(Babel.get("RACK_CAGE_CARDS"));
        this.setIconImage(MausoleumImageStore.getLogo());
        this.setContentPane(new RequesterPane(new SimpleLayoutManager(){

            public void layoutContainer(Container arg0) {
                Dimension d = arg0.getSize();
                int rand = UIDef.RAND;
                int iw = d.width - 2 * rand;
                int ih = d.height - 2 * rand;
                int uh = ih - COMBO_HOEHE - UIDef.INNER_RAND;
                int x = rand;
                int y = rand;
                int anzCombos = 4;
                int anzTrenner = anzCombos - 1;
                int wsum = 0;
                wsum += ((RackCageCardFrame)RackCageCardFrame.this).ivRackComboBox.getPreferredSize().width;
                wsum += ((RackCageCardFrame)RackCageCardFrame.this).ivSideComboBox.getPreferredSize().width;
                wsum += ((RackCageCardFrame)RackCageCardFrame.this).ivPrinterComboBox.getPreferredSize().width;
                wsum += ((RackCageCardFrame)RackCageCardFrame.this).ivZoomComboBox.getPreferredSize().width;
                wsum += ((RackCageCardFrame)RackCageCardFrame.this).ivRackLabel.getPreferredSize().width;
                wsum += ((RackCageCardFrame)RackCageCardFrame.this).ivSideLabel.getPreferredSize().width;
                wsum += ((RackCageCardFrame)RackCageCardFrame.this).ivPrinterLabel.getPreferredSize().width;
                int comboBreite = iw - UIDef.INNER_RAND - BUT_WIDTH;
                int rest = comboBreite - (wsum += ((RackCageCardFrame)RackCageCardFrame.this).ivZoomLabel.getPreferredSize().width);
                int comborest = 0;
                int comboresti = 0;
                int comborestl = 0;
                if (rest < 0) {
                    rest = anzTrenner * UIDef.INNER_RAND;
                } else {
                    comborest = rest * 2 / 3;
                    comboresti = comborest / anzCombos;
                    comborestl = comborest - (anzCombos - 1) * comboresti;
                    rest -= comborest;
                }
                int nrest = rest / anzTrenner;
                int lrest = rest - (anzTrenner - 1) * nrest;
                int w = ((RackCageCardFrame)RackCageCardFrame.this).ivRackLabel.getPreferredSize().width;
                RackCageCardFrame.this.ivRackLabel.setBounds(x, y, w, COMBO_HOEHE);
                x += w;
                w = ((RackCageCardFrame)RackCageCardFrame.this).ivRackComboBox.getPreferredSize().width + comboresti;
                RackCageCardFrame.this.ivRackComboBox.setBounds(x, y, w, COMBO_HOEHE);
                x += w + nrest;
                w = ((RackCageCardFrame)RackCageCardFrame.this).ivSideLabel.getPreferredSize().width;
                RackCageCardFrame.this.ivSideLabel.setBounds(x, y, w, COMBO_HOEHE);
                x += w;
                w = ((RackCageCardFrame)RackCageCardFrame.this).ivSideComboBox.getPreferredSize().width + comboresti;
                RackCageCardFrame.this.ivSideComboBox.setBounds(x, y, w, COMBO_HOEHE);
                x += w + nrest;
                w = ((RackCageCardFrame)RackCageCardFrame.this).ivPrinterLabel.getPreferredSize().width;
                RackCageCardFrame.this.ivPrinterLabel.setBounds(x, y, w, COMBO_HOEHE);
                x += w;
                w = ((RackCageCardFrame)RackCageCardFrame.this).ivPrinterComboBox.getPreferredSize().width + comboresti;
                RackCageCardFrame.this.ivPrinterComboBox.setBounds(x, y, w, COMBO_HOEHE);
                x += w + lrest;
                w = ((RackCageCardFrame)RackCageCardFrame.this).ivZoomLabel.getPreferredSize().width;
                RackCageCardFrame.this.ivZoomLabel.setBounds(x, y, w, COMBO_HOEHE);
                x += w;
                w = ((RackCageCardFrame)RackCageCardFrame.this).ivZoomComboBox.getPreferredSize().width + comborestl;
                RackCageCardFrame.this.ivZoomComboBox.setBounds(x, y, w, COMBO_HOEHE);
                RackCageCardFrame.this.ivPrintButton.setBounds(x += w + UIDef.INNER_RAND, y, BUT_WIDTH, COMBO_HOEHE);
                x = rand;
                RackCageCardFrame.this.ivCardPane.setBounds(x, y += COMBO_HOEHE + UIDef.INNER_RAND, iw, uh);
            }
        }));
        this.getContentPane().add(this.ivCardPane);
        this.getContentPane().add(this.ivRackLabel);
        this.getContentPane().add(this.ivSideLabel);
        this.getContentPane().add(this.ivPrinterLabel);
        this.getContentPane().add(this.ivZoomLabel);
        this.ivRackComboBox = new RackComboBox(this);
        this.ivRackComboBox.adjust();
        this.getContentPane().add(this.ivRackComboBox);
        this.ivSideComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RackCageCardFrame.this.ivCageCardComponent.setSide(RackCageCardFrame.this.ivSideComboBox.getSelectedIndex());
            }
        });
        this.getContentPane().add(this.ivSideComboBox);
        this.ivPrinterComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RackCageCardFrame.this.ivCageCardComponent.setPrinter((String)RackCageCardFrame.this.ivPrinterComboBox.getSelectedItem());
            }
        });
        String printerToUse = LabelPrintRequester.getLastUsedLabelPrinter();
        if (printerToUse == null || printerToUse.trim().length() == 0) {
            printerToUse = (String)this.ivPrinterComboBox.getSelectedItem();
        }
        this.ivPrinterComboBox.setSelectedItem(printerToUse);
        this.getContentPane().add(this.ivPrinterComboBox);
        this.ivZoomComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RackCageCardFrame.this.ivCageCardComponent.setZoom(Preferences.ZOOM_FACTORS[RackCageCardFrame.this.ivZoomComboBox.getSelectedIndex()]);
            }
        });
        this.ivZoomComboBox.setSelectedItem(this.ivCageCardComponent.getZoomString());
        this.getContentPane().add(this.ivZoomComboBox);
        this.ivCageCardComponent.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (!e.isMetaDown()) {
                    RackCageCardFrame.this.ivPressedPoint = e.getPoint();
                }
            }

            public void mouseReleased(MouseEvent e) {
                RackCageCardFrame.this.ivPressedPoint = null;
            }
        });
        this.ivCardPane.getViewport().setOpaque(false);
        this.ivCageCardComponent.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if (RackCageCardFrame.this.ivPressedPoint != null) {
                    Point np = e.getPoint();
                    RackCageCardFrame.dragScroller(RackCageCardFrame.this.ivCardPane.getHorizontalScrollBar(), ((RackCageCardFrame)RackCageCardFrame.this).ivPressedPoint.x - np.x);
                    RackCageCardFrame.dragScroller(RackCageCardFrame.this.ivCardPane.getVerticalScrollBar(), ((RackCageCardFrame)RackCageCardFrame.this).ivPressedPoint.y - np.y);
                }
            }
        });
        this.ivCageCardComponent.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if ((e.getModifiers() & 2) != 0 || (e.getModifiers() & 1) != 0) {
                    int notches = e.getWheelRotation();
                    int asel = RackCageCardFrame.this.ivZoomComboBox.getSelectedIndex();
                    int nsel = asel + notches;
                    if (nsel < 0) {
                        nsel = 0;
                    } else if (nsel >= RackCageCardFrame.this.ivZoomComboBox.getItemCount()) {
                        nsel = RackCageCardFrame.this.ivZoomComboBox.getItemCount() - 1;
                    }
                    if (asel != nsel) {
                        double nzoom;
                        int dh;
                        int nhval = -1;
                        int nvval = -1;
                        JScrollBar bar = RackCageCardFrame.this.ivCardPane.getHorizontalScrollBar();
                        if (bar.isVisible()) {
                            dh = RackCageCardFrame.this.ivCardPane.getViewport().getWidth() / 2;
                            int rx = (int)((double)(bar.getValue() + dh) / ((RackCageCardFrame)RackCageCardFrame.this).ivCageCardComponent.ivFaktor);
                            nzoom = Preferences.ZOOM_FACTORS[nsel];
                            nhval = (int)((double)rx * nzoom - (double)dh);
                        }
                        if ((bar = RackCageCardFrame.this.ivCardPane.getVerticalScrollBar()).isVisible()) {
                            dh = RackCageCardFrame.this.ivCardPane.getViewport().getHeight() / 2;
                            int ry = (int)((double)(bar.getValue() + dh) / ((RackCageCardFrame)RackCageCardFrame.this).ivCageCardComponent.ivFaktor);
                            nzoom = Preferences.ZOOM_FACTORS[nsel];
                            nvval = (int)((double)ry * nzoom - (double)dh);
                        }
                        RackCageCardFrame.this.ivZoomComboBox.setSelectedIndex(nsel);
                        if (nhval != -1 && (bar = RackCageCardFrame.this.ivCardPane.getHorizontalScrollBar()).isVisible()) {
                            bar.setValue(nhval);
                        }
                        if (nvval != -1 && (bar = RackCageCardFrame.this.ivCardPane.getVerticalScrollBar()).isVisible()) {
                            bar.setValue(nvval);
                        }
                    }
                } else {
                    e.getComponent().getParent().dispatchEvent(e);
                }
            }
        });
        this.adjustCCVComponent();
        this.ivPrintButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RackCageCardFrame.this.printIt();
            }
        });
        this.getContentPane().add(this.ivPrintButton);
        WindowUtils.setRememberedBounds(this, new Rectangle(UIDef.getScaled(20), UIDef.getScaled(20), BREITE, HOEHE));
        new WindowMinimalSizer(this, MIN_BREITE, MIN_HOEHE, true);
        ObjectStoreClient.addConsumer((ObjectConsumer)this, CONSUMERTYPES);
    }

    private void adjustCCVComponent() {
        this.ivCageCardComponent.setSide(this.ivSideComboBox.getSelectedIndex());
        this.ivCageCardComponent.setPrinter((String)this.ivPrinterComboBox.getSelectedItem());
        this.ivCageCardComponent.setZoom(Preferences.ZOOM_FACTORS[this.ivZoomComboBox.getSelectedIndex()]);
    }

    private void printIt() {
        new CCVPageFormatDialog((Frame)this, this.ivCageCardComponent);
        this.adjustCCVComponent();
        this.repaint();
    }

    public void adaptToRack(Rack rack, boolean forceRepaint, boolean potentialResize) {
        if (rack != null) {
            if (rack.getInt("RCK_SIDES", 0) < 2) {
                this.ivSideComboBox.setEnabled(false);
                this.ivSideComboBox.setSelectedIndex(0);
            } else {
                this.ivSideComboBox.setEnabled(true);
            }
            this.ivCageCardComponent.setRack(rack);
        }
    }

    public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
    }

    public void handleNewObjects(Vector idObjects) {
        Iterator iterator = idObjects.iterator();
        while (iterator.hasNext()) {
            this.handleNewObject((IDObject)iterator.next());
        }
    }

    public void handleNewObject(IDObject obj) {
        if (obj instanceof Rack) {
            this.ivRackComboBox.checkArrivedRack((Rack)obj);
        }
    }
}

