/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.reports;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.dfa.IntermediaerHelfer;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import mausoleum.cage.colors.MixColorMode;
import mausoleum.helper.Zeile;
import mausoleum.helper.ZeileAbstr;
import mausoleum.license.License;
import mausoleum.main.ProcessDefinition;

public class LineLicenseUsageReport {
    public static final String CLIENT_HOL_TAG = "#";
    public static final String SUM_OTHER_TAG = "##++SO++##";
    public static final String SUM_TAG = "##++SUM++##";
    public final String ivUrGroup;
    public final long ivUrID;
    public final TreeMap ivBinsByGroup = new TreeMap();

    public static String getLineLicenseUsageReport(String group, long[] ids, boolean isLine) {
        if (ProcessDefinition.isServer()) {
            HashSet groupsToCheck = new HashSet();
            Vector<LineLicenseUsageReport> reports = new Vector<LineLicenseUsageReport>(ids.length);
            int i = 0;
            while (i < ids.length) {
                reports.add(new LineLicenseUsageReport(group, ids[i], groupsToCheck, isLine));
                ++i;
            }
            Vector interesteds = new Vector();
            Iterator iterator = groupsToCheck.iterator();
            while (iterator.hasNext()) {
                String lgroup = (String)iterator.next();
                interesteds.clear();
                Iterator iterator2 = reports.iterator();
                while (iterator2.hasNext()) {
                    LineLicenseUsageReport lrp = (LineLicenseUsageReport)iterator2.next();
                    lrp.addInterestedBin(lgroup, interesteds);
                }
                boolean useOnlyActiveObjects = isLine;
                Vector allMouseIDs = useOnlyActiveObjects ? DataLayer.cvDataLayer.getSortedActualIDs(lgroup, 1) : DataLayer.cvDataLayer.getSortedIDs(lgroup, 1);
                int indexCol = isLine ? IntermediaerHelfer.getLineCol() : IntermediaerHelfer.getLicenseCol();
                Iterator iterator22 = allMouseIDs.iterator();
                while (iterator22.hasNext()) {
                    String sind;
                    Number inti = (Number)iterator22.next();
                    Long idL = inti instanceof Long ? (Long)inti : new Long(inti.longValue());
                    String index = IntermediaerHelfer.getIndex(lgroup, idL);
                    if (index == null || index.length() == 0 || (sind = ZeileAbstr.getStringNONEmpty(index, IntermediaerHelfer.getIndexSeparator(), indexCol, null)) == null) continue;
                    Iterator iterator3 = interesteds.iterator();
                    while (iterator3.hasNext()) {
                        LicRepBin lrp = (LicRepBin)iterator3.next();
                        lrp.check(sind);
                    }
                }
                allMouseIDs.clear();
                allMouseIDs = null;
            }
            StringBuilder msb = new StringBuilder();
            Iterator iterator2 = reports.iterator();
            while (iterator2.hasNext()) {
                LineLicenseUsageReport lr = (LineLicenseUsageReport)iterator2.next();
                lr.appendTransport(msb);
            }
            return msb.toString();
        }
        return null;
    }

    public LineLicenseUsageReport(String transport, boolean isLine) {
        Zeile z = new Zeile(transport, '|');
        this.ivUrID = z.getLong(0, 0L);
        this.ivUrGroup = z.getStringB64(1, "?");
        SimpleLicenseUsageLine sumLUL = null;
        Vector<SimpleLicenseUsageLine> zeilen = new Vector<SimpleLicenseUsageLine>();
        int i = 2;
        while (i < z.size()) {
            SimpleLicenseUsageLine slul = new SimpleLicenseUsageLine(z.getStringNONEmpty(i, null));
            if (slul.ivGroup != null) {
                zeilen.add(slul);
                if (slul.ivIsSum) {
                    sumLUL = slul;
                }
            }
            ++i;
        }
        if (!isLine) {
            int sumMice = sumLUL == null ? 0 : sumLUL.ivCount;
            int allowedMice = 0;
            License license = (License)ObjectStore.getClientObject(16, this.ivUrID, this.ivUrGroup);
            if (license != null) {
                allowedMice = license.getInt("LIC_MMC", 0);
            }
            int gelbGrenze = allowedMice * 8 / 10;
            Color bg = null;
            bg = sumMice < gelbGrenze ? MixColorMode.getMixColor(Color.green, Color.yellow, 0, gelbGrenze, sumMice) : MixColorMode.getMixColor(Color.yellow, Color.red, gelbGrenze, allowedMice, sumMice);
            sumLUL.ivBackGround = bg;
            SimpleLicenseUsageLine actLUL = new SimpleLicenseUsageLine(Babel.get("GRANTED_NUMBER"), allowedMice, true);
            actLUL.ivBackGround = bg;
            SimpleLicenseUsageLine remLUL = new SimpleLicenseUsageLine(Babel.get("REMAINING_NUMBER"), allowedMice - sumMice, true);
            remLUL.ivBackGround = bg;
            zeilen.add(actLUL);
            zeilen.add(remLUL);
        }
        this.ivBinsByGroup.put(CLIENT_HOL_TAG, zeilen);
    }

    private LineLicenseUsageReport(String group, long objectID, HashSet groupsToCheck, boolean isLine) {
        this.ivUrGroup = group;
        this.ivUrID = objectID;
        IDObject urObject = ObjectStore.getObjectDeadOrAlive(isLine ? 7 : 16, objectID, group, null, false);
        if (urObject != null) {
            if (urObject.isSharedWithOtherGroups() || urObject.getGroup().equals("service")) {
                HashMap hm;
                IDObject serviceObject;
                IDObject iDObject = serviceObject = urObject.isSharedWithOtherGroups() ? urObject.getServiceGroupObject(null) : urObject;
                if (serviceObject != null && (hm = serviceObject.getSubObjectsByGroupOnServer(null)) != null && !hm.isEmpty()) {
                    Iterator iter = hm.keySet().iterator();
                    while (iter.hasNext()) {
                        String sgroup = (String)iter.next();
                        IDObject object = (IDObject)hm.get(sgroup);
                        this.ivBinsByGroup.put(sgroup, new LicRepBin(sgroup, isLine ? 7 : 16, object.getID()));
                    }
                }
            } else {
                this.ivBinsByGroup.put(this.ivUrGroup, new LicRepBin(this.ivUrGroup, isLine ? 7 : 16, this.ivUrID));
            }
        }
        groupsToCheck.addAll(this.ivBinsByGroup.keySet());
    }

    public void addInterestedBin(String group, Vector target) {
        LicRepBin lrp = (LicRepBin)this.ivBinsByGroup.get(group);
        if (lrp != null) {
            target.add(lrp);
        }
    }

    public void appendTransport(StringBuilder msb) {
        msb.append(this.ivUrID).append("|").append(Base64Manager.encodeBase64(this.ivUrGroup));
        int sum = 0;
        if ("service".equals(this.ivUrGroup)) {
            Iterator iterator = this.ivBinsByGroup.keySet().iterator();
            while (iterator.hasNext()) {
                String group = (String)iterator.next();
                LicRepBin lrb = (LicRepBin)this.ivBinsByGroup.get(group);
                sum += lrb.ivCount;
                msb.append("|").append(Base64Manager.encodeBase64(group)).append(";").append(lrb.ivCount);
            }
        } else {
            int sumOther = 0;
            Iterator iterator = this.ivBinsByGroup.keySet().iterator();
            while (iterator.hasNext()) {
                String group = (String)iterator.next();
                LicRepBin lrb = (LicRepBin)this.ivBinsByGroup.get(group);
                sum += lrb.ivCount;
                if (group.equalsIgnoreCase(this.ivUrGroup)) {
                    msb.append("|").append(Base64Manager.encodeBase64(group)).append(";").append(lrb.ivCount);
                    continue;
                }
                sumOther += lrb.ivCount;
            }
            if (sumOther != 0) {
                msb.append("|").append(SUM_OTHER_TAG).append(";").append(sumOther);
            }
        }
        msb.append("|").append(SUM_TAG).append(";").append(sum).append("\n");
    }

    public static class LicRepBin {
        public final String ivGroup;
        public final int ivObjectType;
        public final long ivID;
        public final String ivIdentifierString;
        private final String ivLicenseString;
        private final String ivLicenseVString;
        private final String ivLicenseMString;
        private final String ivLicenseHString;
        public int ivCount = 0;

        public LicRepBin(String group, int objectType, long objectID) {
            this.ivGroup = group;
            this.ivObjectType = objectType;
            this.ivID = objectID;
            this.ivLicenseString = String.valueOf(objectID);
            this.ivLicenseVString = String.valueOf(objectID) + "|";
            this.ivLicenseMString = "|" + objectID + "|";
            this.ivLicenseHString = "|" + objectID;
            this.ivIdentifierString = IDObject.getIdentifierString(group, objectType, objectID);
        }

        public boolean equals(Object obj) {
            if (obj instanceof LicRepBin) {
                LicRepBin lrp = (LicRepBin)obj;
                return this.ivIdentifierString.equals(lrp.ivIdentifierString);
            }
            return false;
        }

        public int hashCode() {
            return this.ivIdentifierString.hashCode();
        }

        public void check(String subIndex) {
            if (subIndex.equals(this.ivLicenseString) || subIndex.startsWith(this.ivLicenseVString) || subIndex.endsWith(this.ivLicenseHString) || subIndex.contains(this.ivLicenseMString)) {
                ++this.ivCount;
            }
        }
    }

    public static class LineLicenseUsageReportSammler {
        public final boolean ivIsLine;
        public final Vector ivReports = new Vector();

        public LineLicenseUsageReportSammler(boolean isLine) {
            this.ivIsLine = isLine;
        }
    }

    public static class SimpleLicenseUsageLine {
        public final String ivGroup;
        public final int ivCount;
        public boolean ivBold = false;
        public boolean ivIsSum = false;
        public Color ivBackGround = null;

        public SimpleLicenseUsageLine(String group, int count, boolean bold) {
            this.ivGroup = group;
            this.ivCount = count;
            this.ivBold = bold;
        }

        public SimpleLicenseUsageLine(String s) {
            int ind;
            String group = null;
            int anz = 0;
            if (s != null && (ind = s.indexOf(";")) != -1) {
                group = s.substring(0, ind);
                if (LineLicenseUsageReport.SUM_OTHER_TAG.equals(group)) {
                    group = Babel.get("OTHER_GROUPS");
                } else if (LineLicenseUsageReport.SUM_TAG.equals(group)) {
                    group = Babel.get("USED_NUMBER");
                    this.ivBold = true;
                    this.ivIsSum = true;
                } else {
                    group = Base64Manager.getDecodedString(group);
                }
                anz = Integer.parseInt(s.substring(ind + 1, s.length()));
            }
            this.ivGroup = group;
            this.ivCount = anz;
        }
    }
}

