/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.reports;

import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import de.hannse.netobjects.util.MyDate;
import java.io.File;
import java.util.GregorianCalendar;
import java.util.Vector;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.OpenStandardFiles;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.visit.Visit;

public class PlaisantReport {
    private static final int COL_NR = 0;
    private static final int COL_IMPORT = 1;
    private static final int COL_ID = 2;
    private static final int COL_CAGE = 3;
    private static final int COL_RACK = 4;
    private static final int COL_EXIT_DATE = 5;
    private static final int COL_EXIT_MODE = 6;
    private static final int COL_SEX = 7;
    private static final int COL_GENOTYPE = 8;
    private static final int COL_ORIGIN = 9;
    private static final int COL_SHIPMENTID = 10;
    private static final int COL_DESTINATION = 11;
    private static final int COL_COMMENT = 12;
    static /* synthetic */ Class class$0;

    public static void makeReport(Vector idObjects) {
        String repDir = "temp";
        FileManager.prepareDirs(repDir);
        String filePath = String.valueOf(repDir) + "/LegalReport_" + new MyDate(new GregorianCalendar()).getDateTimeForFileName() + "_" + MilliSpender.getMillis() + ".xls";
        try {
            WritableWorkbook workbook = Workbook.createWorkbook(new File(filePath));
            WritableSheet sheet = workbook.createSheet(Babel.get("REPORT"), 0);
            int row = 0;
            sheet.addCell(new Label(0, row, "\u2116"));
            sheet.addCell(new Label(1, row, "Arrivo-Nascita"));
            sheet.addCell(new Label(2, row, "Codice Id"));
            sheet.addCell(new Label(3, row, "Gabbia"));
            sheet.addCell(new Label(4, row, "Stanza - Rack"));
            sheet.addCell(new Label(5, row, "Data della morte"));
            sheet.addCell(new Label(6, row, "Causa della morte"));
            sheet.addCell(new Label(7, row, "Sesso"));
            sheet.addCell(new Label(8, row, "Genotipo"));
            sheet.addCell(new Label(9, row, "Provenienza"));
            sheet.addCell(new Label(10, row, "DDT"));
            sheet.addCell(new Label(11, row, "Destinazione"));
            sheet.addCell(new Label(12, row, "NOTE"));
            int i = 0;
            while (i < idObjects.size()) {
                Mouse mouse = (Mouse)idObjects.elementAt(i);
                sheet.addCell(new Number(0, ++row, (double)(i + 1)));
                sheet.addCell(new Label(1, row, DatumFormat.getJustDateString(mouse.getDate("IDO_START_DATE"))));
                sheet.addCell(new Label(9, row, mouse.getHerkunftOderZiel(true, false)));
                sheet.addCell(new Label(10, row, mouse.getString("MOS_SHIPID", "")));
                sheet.addCell(new Label(12, row, mouse.getString("MOS_COMMENT", "")));
                sheet.addCell(new Label(7, row, DefaultManager.getSexString(mouse.getSex(), mouse.getSexVariant(0), true, false)));
                sheet.addCell(new Label(8, row, mouse.getGenotype()));
                if (mouse.isAlive()) {
                    sheet.addCell(new Label(2, row, "" + mouse.getID()));
                    sheet.addCell(new Label(3, row, mouse.getCageString()));
                    sheet.addCell(new Label(4, row, mouse.getRackName()));
                } else {
                    sheet.addCell(new Label(2, row, "\u2020 " + mouse.getID()));
                    sheet.addCell(new Label(5, row, DatumFormat.getJustDateString(mouse.getDate("IDO_END_DATE"))));
                    sheet.addCell(new Label(6, row, Visit.translateMode(mouse.getInt("MOS_ENDMODE", 0))));
                    sheet.addCell(new Label(11, row, mouse.getHerkunftOderZiel(false, false)));
                }
                ++i;
            }
            workbook.write();
            workbook.close();
            OpenStandardFiles.openStandardFile(filePath);
            return;
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.reports.PlaisantReport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Problem writing PLAISANT-report", e, clazz);
            return;
        }
    }
}

