/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.reports;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Component;
import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JFrame;
import mausoleum.cage.Cage;
import mausoleum.factsheets.FactSheetFrame;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.LongPunkt;
import mausoleum.helper.WindowUtils;
import mausoleum.helper.Zeile;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.rack.Rack;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.requester.calendar.CalendarRequester;
import mausoleum.room.Room;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.models.MTTrafficReport;

public class TrafficReport {
    public static final String TRD_TRANSFER_VIA_ORCUS = "TRD_TRANSFER_VIA_ORCUS";
    public static final String TRD_REMOVE = "TRD_REMOVE";
    public static final String TRD_CAGE_GROUP_TRANSFER = "TRD_CAGE_GROUP_TRANSFER";
    public static final String TRD_CAGE_ROOM_TRANSFER = "TRD_CAGE_ROOM_TRANSFER";
    public static final String TRD_EXPORT = "TRD_EXPORT";
    public static final String TRD_MOUSE_GROUP_TRANSFER = "TRD_MOUSE_GROUP_TRANSFER";
    public static final String TRD_IMPORT = "TRD_IMPORT";
    public static final String TRD_LITTER = "TRD_LITTER";
    public static final String TRD_TRANSFER = "TRD_TRANSFER";
    public static final String TRD_BYDEATH = "TRD_BYDEATH";
    public static final String TRD_BYSACRIFICE = "TRD_BYSACRIFICE";
    public static final String TRD_BYEXPORT = "TRD_BYEXPORT";
    public static final String TRD_BYREMOVAL = "TRD_BYREMOVAL";
    public static final String TRD_DIGITAL_NIRVANA = "TRD_DIGITAL_NIRVANA";
    public static final String TRD_CAGE_DROPPED_IN_RACK = "TRD_CAGE_DROPPED_IN_RACK";
    public static final String TRD_MICE_DROPPED_IN_RACK = "TRD_MICE_DROPPED_IN_RACK";
    public static final String TRD_MICE_DROPPED_IN_ORCUS = "TRD_MICE_DROPPED_IN_ORCUS";
    public static final String TRD_CAGE_DROPPED_IN_ORCUS = "TRD_CAGE_DROPPED_IN_ORCUS";
    private static String[] NON_EXTENDS = new String[]{"TRD_REMOVE", "TRD_CAGE_GROUP_TRANSFER", "TRD_EXPORT", "TRD_MOUSE_GROUP_TRANSFER", "TRD_LITTER", "TRD_BYDEATH", "TRD_BYSACRIFICE", "TRD_BYEXPORT", "TRD_BYREMOVAL", "TRD_DIGITAL_NIRVANA"};
    private static final int POS_MILLIS = 0;
    private static final int POS_MOUSE_ID = 1;
    private static final int POS_DATE_MILLIS = 2;
    private static final int POS_ROOM_ID_V = 3;
    private static final int POS_RACK_ID_V = 4;
    private static final int POS_ROOM_ID_N = 5;
    private static final int POS_RACK_ID_N = 6;
    private static final int POS_DESCR = 7;
    private static String[] REP_CHOICES = new String[]{Babel.get("TRD_AS_REPORT"), Babel.get("TRD_AS_TABLE")};
    public final IDObject ivServiceObject;
    public final TreeMap ivLinesCollector;
    public final Vector ivDictSammler;
    public final int[] ivDates;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void getTrafficReportClientSide(Vector v, Component senderComp, boolean extended) {
        if (v != null && v.size() == 1) {
            IDObject serviceRoom = null;
            IDObject serviceRack = null;
            IDObject ido = (IDObject)v.firstElement();
            if (ido instanceof Rack) {
                serviceRack = ido;
            } else if (ido instanceof Room) {
                serviceRoom = ido;
            }
            if (serviceRack != null || serviceRoom != null) {
                Date end;
                MyDate jetzt = MyDate.getMyDate(System.currentTimeMillis());
                JFrame sender = WindowUtils.getJFrame(senderComp);
                Date start = CalendarRequester.getDate(sender, new MyDate(MyDate.getTage(1, 6, 2012)), jetzt, Babel.get("SELECT_START_DATE"));
                if (start != null && (end = CalendarRequester.getDate(sender, new MyDate((int)(start.getTime() / 86400000L)), jetzt, Babel.get("SELECT_END_DATE"))) != null) {
                    int[] dates = new int[]{(int)(start.getTime() / 86400000L), (int)(end.getTime() / 86400000L + 1L)};
                    int ind = AllgChoiceRequester.getIndexAnswer((Frame)sender, Babel.get("TRD_SELECT_MODE"), REP_CHOICES);
                    if (ind != -1) {
                        TrafficReportRequest trr = new TrafficReportRequest();
                        trr.ivGroup = MausoleumClient.isHeadOfService() ? "service" : UserManager.getFirstGroup();
                        trr.ivRoomID = serviceRoom != null ? serviceRoom.getID() : -1L;
                        trr.ivRackID = serviceRack != null ? serviceRack.getID() : -1L;
                        trr.ivStartDate = dates[0];
                        trr.ivEndDate = dates[1];
                        trr.ivExtended = extended;
                        ObjectRequest or = RequestManager.createSendAndGetAnswer((byte)78, trr, "service", null);
                        if (or != null && or.isFinished()) {
                            TrafficReport tr = new TrafficReport(or, serviceRack != null ? serviceRack : serviceRoom, dates);
                            if (ind == 1) {
                                MTTrafficReport mtm = MTTrafficReport.getModel(tr);
                                MausoleumTable mt = new MausoleumTable(mtm, false);
                                mt.setHeader(tr.getMainTitle());
                                FactSheetFrame.showTableTab(mt, Babel.get("MOUSE_TRAFFIC_REPORT"));
                            } else {
                                Vector<TrafficReport> vv = new Vector<TrafficReport>();
                                vv.add(tr);
                                FactSheetFrame.showTab(vv, Babel.get("MOUSE_TRAFFIC_REPORT"));
                            }
                        }
                    }
                }
            }
        }
    }

    public static void appendTrafficInfoClientSide(Object ooo, long dateMillis, String descBabel, StringBuffer msb) {
        if (ProcessDefinition.isClient()) {
            Vector v;
            if (msb.length() != 0 && msb.charAt(msb.length() - 1) != '\n') {
                msb.append("\n");
            }
            if (descBabel != null) {
                msb.append("##TDESC|").append(descBabel).append("\n");
            }
            if (dateMillis != -1L) {
                msb.append("##TD|").append(dateMillis).append("\n");
            }
            if (ooo == null) {
                msb.append("##TC|").append("\n");
            } else if (ooo instanceof Mouse) {
                TrafficReport.appendMouse((Mouse)ooo, msb);
            } else if (ooo instanceof Cage) {
                TrafficReport.appendCage((Cage)ooo, msb);
            } else if (ooo instanceof Vector && !(v = (Vector)ooo).isEmpty()) {
                Iterator iterator = v.iterator();
                while (iterator.hasNext()) {
                    TrafficReport.appendTrafficInfoClientSide(iterator.next(), -1L, null, msb);
                }
            }
        }
    }

    public static boolean getMouseTrafficReport(ObjectRequest ivRequest) {
        TrafficReportRequest trr = (TrafficReportRequest)ivRequest.ivObject;
        boolean isRoom = trr.ivRoomID != -1L;
        String[] groups = null;
        long[] ids = null;
        if (trr.ivGroup.equals("service")) {
            IDObject serviceObject;
            IDObject iDObject = serviceObject = isRoom ? ObjectStore.getObjectDeadOrAlive(10, trr.ivRoomID, "service", null, false) : ObjectStore.getObjectDeadOrAlive(3, trr.ivRackID, "service", null, false);
            if (serviceObject != null) {
                groups = (String[])serviceObject.get("IDO_UGROUPS");
                ids = (long[])serviceObject.get("IDO_UGROUPIDS");
            }
        } else {
            groups = new String[]{trr.ivGroup};
            ids = new long[]{isRoom ? trr.ivRoomID : trr.ivRackID};
        }
        if (groups != null && ids != null && groups.length == ids.length) {
            Vector presentFiles = new Vector();
            HashMap protFilenamesByYear = new HashMap();
            HashSet toDeleteKeySammler = new HashSet();
            Hashtable objectBag = new Hashtable();
            Vector tmpTarget = new Vector();
            int extStartDate = trr.ivStartDate - 30;
            MyDate origDate = new MyDate(extStartDate);
            MyDate md = new MyDate(trr.ivEndDate);
            int startMonth = origDate.ivMonat;
            int startYear = origDate.ivJahr;
            int endMonth = md.ivMonat;
            int endYear = md.ivJahr;
            long start = (long)trr.ivStartDate * 86400000L;
            long end = (long)trr.ivEndDate * 86400000L;
            TreeMap linesCollector = new TreeMap();
            Vector dictSammler = new Vector();
            int i = 0;
            while (i < groups.length) {
                long roomID = isRoom ? ids[i] : -1L;
                long rackID = isRoom ? -1L : ids[i];
                TrafficReport.determineFiles(groups[i], startMonth, startYear, endMonth, endYear, protFilenamesByYear, presentFiles, md);
                TrafficReport.readFiles(groups[i], presentFiles, protFilenamesByYear, start, end, linesCollector, roomID, rackID, trr.ivExtended);
                TrafficReport.unifyStrings(linesCollector, groups[i], roomID, rackID, toDeleteKeySammler, objectBag, dictSammler, tmpTarget, trr.ivExtended);
                ++i;
            }
            tmpTarget.clear();
            Iterator<Object> iterator = linesCollector.keySet().iterator();
            while (iterator.hasNext()) {
                Object ooo = iterator.next();
                TreeMap tagesMap = (TreeMap)linesCollector.get(ooo);
                if (!tagesMap.isEmpty()) continue;
                tmpTarget.add(ooo);
            }
            iterator = tmpTarget.iterator();
            while (iterator.hasNext()) {
                linesCollector.remove(iterator.next());
            }
            ivRequest.ivObject = linesCollector;
            ivRequest.ivExtraObject = dictSammler;
            return true;
        }
        return false;
    }

    private static void readFiles(String group, Vector presentFiles, HashMap protFilenamesByYear, long startMillis, long endMillis, TreeMap linesCollector, long roomID, long rackID, boolean extended) {
        String protDir;
        File f;
        int[] wiederverwert = null;
        if (!presentFiles.isEmpty()) {
            Iterator iterator = presentFiles.iterator();
            while (iterator.hasNext()) {
                String path = (String)iterator.next();
                try {
                    LineNumberReader lnr = new LineNumberReader(new FileReader(path));
                    boolean cont = true;
                    String line = lnr.readLine();
                    while (line != null && cont) {
                        int[] arr = TrafficReport.collectLines(group, line, startMillis, endMillis, linesCollector, wiederverwert, roomID, rackID, extended);
                        if (arr == null) {
                            cont = false;
                            continue;
                        }
                        wiederverwert = arr;
                        line = lnr.readLine();
                    }
                    lnr.close();
                }
                catch (Exception e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("de.hannse.netobjects.objectstore.requesthandler.OBRHS_WorkerThread");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error("Problem parsing file", e, clazz);
                }
            }
        }
        if (!protFilenamesByYear.isEmpty() && (f = new File(protDir = GroupFileManager.getProtocolsPath(group))).exists() && f.isDirectory()) {
            String[] files = f.list();
            int i = 0;
            while (i < files.length) {
                String year;
                Vector prots;
                int ind;
                if (files[i].endsWith(".zip") && (ind = files[i].indexOf("_")) != -1 && (prots = (Vector)protFilenamesByYear.get(year = files[i].substring(0, ind))) != null) {
                    TrafficReport.checkZip(group, String.valueOf(protDir) + "/" + files[i], prots, startMillis, endMillis, linesCollector, roomID, rackID, wiederverwert, extended);
                }
                ++i;
            }
        }
    }

    private static void checkZip(String group, String zipPath, Vector prots, long startMillis, long endMillis, TreeMap linesCollector, long roomID, long rackID, int[] wiederverwert, boolean extended) {
        block9: {
            try {
                ZipInputStream zin;
                File f = new File(zipPath);
                if (!f.exists() || (zin = new ZipInputStream(new FileInputStream(f))) == null) break block9;
                try {
                    ZipEntry entry = zin.getNextEntry();
                    while (entry != null) {
                        String name = entry.getName();
                        if (prots.contains(name)) {
                            int readbyte;
                            System.out.println("Check : " + name);
                            System.out.println("---------------------------------");
                            ByteArrayOutputStream myOut = new ByteArrayOutputStream();
                            byte[] mybuf = new byte[1024];
                            while ((readbyte = zin.read(mybuf)) > 0) {
                                myOut.write(mybuf, 0, readbyte);
                            }
                            String res = new String(myOut.toByteArray());
                            myOut.close();
                            boolean cont = true;
                            Vector lines = StringHelper.splitStringByAny(res, "\n");
                            Iterator iterator = lines.iterator();
                            while (iterator.hasNext() && cont) {
                                String line = (String)iterator.next();
                                int[] arr = TrafficReport.collectLines(group, line, startMillis, endMillis, linesCollector, wiederverwert, roomID, rackID, extended);
                                if (arr == null) {
                                    cont = false;
                                    continue;
                                }
                                wiederverwert = arr;
                            }
                            lines.clear();
                            lines = null;
                        }
                        entry = zin.getNextEntry();
                    }
                }
                catch (Exception e) {
                    System.out.println("Problem beim Ueberpruefen der Datei innen im Zip " + zipPath);
                }
                zin.close();
            }
            catch (Exception e) {
                System.out.println("Problem beim Ueberpruefen der Datei im Zip " + zipPath);
            }
        }
    }

    private static void determineFiles(String group, int startMonth, int startYear, int endMonth, int endYear, HashMap protFilenamesByYear, Vector presentFiles, MyDate md) {
        protFilenamesByYear.clear();
        presentFiles.clear();
        md.ivTag = 1;
        md.ivMonat = startMonth;
        md.ivJahr = startYear;
        boolean cont = true;
        while (cont) {
            String protocolPath = GroupFileManager.getTypeProtocolPath(group, "traffic", md);
            if (new File(protocolPath).exists()) {
                presentFiles.add(protocolPath);
            } else {
                String yearKey = Integer.toString(md.ivJahr);
                Vector<String> filenames = (Vector<String>)protFilenamesByYear.get(yearKey);
                if (filenames == null) {
                    filenames = new Vector<String>();
                    protFilenamesByYear.put(yearKey, filenames);
                }
                filenames.add(GroupFileManager.getTypeProtocolFilename("traffic", md));
            }
            md.nextMonth();
            if (md.ivJahr > endYear) {
                cont = false;
                continue;
            }
            if (md.ivJahr != endYear) continue;
            boolean bl = cont = md.ivMonat <= endMonth;
        }
    }

    public static void checkTraffic(HashMap trafficProtsByGroup, HashMap trafficChecks, LongPunkt trafficTarget, long trafficDateMillis, String trafficDescrBabel, Vector newObjectsTarget, Hashtable objectBag) {
        long millis = System.currentTimeMillis();
        Iterator<Object> iterator = trafficProtsByGroup.values().iterator();
        while (iterator.hasNext()) {
            StringBuilder msb = (StringBuilder)iterator.next();
            msb.setLength(0);
        }
        iterator = trafficChecks.keySet().iterator();
        while (iterator.hasNext()) {
            String objIdent = (String)iterator.next();
            Mouse mouse = (Mouse)objectBag.get(objIdent);
            if (mouse == null) {
                Zeile z = new Zeile(objIdent, '|');
                String group = z.getString(0, "");
                long mouseID = z.getLong(2, 0L);
                mouse = (Mouse)ObjectStoreServer.getObjectDeadOrAlive(1, mouseID, group, objectBag, false, false);
            }
            TrafficReport.manageMouseTraffic((Mouse)objectBag.get(objIdent), (LongPunkt)trafficChecks.get(objIdent), trafficTarget, millis, trafficDateMillis, trafficDescrBabel, trafficProtsByGroup, trafficChecks, objectBag);
        }
        iterator = newObjectsTarget.iterator();
        while (iterator.hasNext()) {
            IDObject ido = (IDObject)iterator.next();
            if (!(ido instanceof Mouse)) continue;
            TrafficReport.manageMouseTraffic((Mouse)ido, null, trafficTarget, millis, trafficDateMillis, trafficDescrBabel, trafficProtsByGroup, trafficChecks, objectBag);
        }
        iterator = trafficProtsByGroup.keySet().iterator();
        while (iterator.hasNext()) {
            MyDate md = new MyDate(new GregorianCalendar());
            String group = (String)iterator.next();
            StringBuilder msb = (StringBuilder)trafficProtsByGroup.get(group);
            if (msb.length() == 0) continue;
            String path = GroupFileManager.getTypeProtocolPath(group, "traffic", md);
            FileManager.pureAppend(path, msb.toString());
        }
    }

    public static int[] collectLines(String gruppe, String line, long startMillis, long endMillis, TreeMap collection, int[] wiederverwert, long roomID, long rackID, boolean extended) {
        int[] arr = Zeile.getTrenner(line, '|', '\u0000', wiederverwert);
        long millis = Zeile.getLong(line, arr, '\u0000', 0, -1L);
        if (millis > endMillis) {
            return null;
        }
        if (millis >= startMillis) {
            int vpos = roomID != -1L ? 3 : 4;
            int npos = roomID != -1L ? 5 : 6;
            long vgl = roomID != -1L ? roomID : rackID;
            long vid = Zeile.getLong(line, arr, '\u0000', vpos, -1L);
            long nid = Zeile.getLong(line, arr, '\u0000', npos, -1L);
            if (vid == -1L || vid == vgl || nid == -1L || nid == vgl) {
                TrafficReport.addLineFromProtocol(gruppe, line, arr, millis, collection, extended);
            }
        }
        return arr;
    }

    private static void manageMouseTraffic(Mouse mouse, LongPunkt posVorher, LongPunkt trafficTarget, long millis, long trafficDateMillis, String trafficDescrBabel, HashMap trafficProtsByGroup, HashMap trafficChecks, Hashtable objectBag) {
        if (mouse != null) {
            String group = mouse.getGroup();
            TrafficReport.getTrafficdata(mouse, group, trafficTarget, objectBag);
            if (posVorher == null || posVorher.ivX != trafficTarget.ivX || posVorher.ivY != trafficTarget.ivY) {
                StringBuilder msb = (StringBuilder)trafficProtsByGroup.get(group);
                if (msb == null) {
                    msb = new StringBuilder();
                    trafficProtsByGroup.put(group, msb);
                }
                TrafficReport.append(millis, trafficDateMillis, mouse.getID(), posVorher == null ? -1L : posVorher.ivX, posVorher == null ? -1L : posVorher.ivY, trafficTarget.ivX, trafficTarget.ivY, trafficDescrBabel, msb);
            }
        } else {
            String string = "Problem checking mouse traffic " + trafficChecks;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("mausoleum.reports.TrafficReport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, null, clazz);
        }
    }

    private static void getTrafficdata(Mouse mouse, String group, LongPunkt trafficTarget, Hashtable objectBag) {
        trafficTarget.ivX = -1L;
        trafficTarget.ivY = -1L;
        long actCageID = mouse.getActCageID(-1L);
        if (actCageID != -1L) {
            Cage cage = (Cage)ObjectStoreServer.getObjectDeadOrAlive(2, actCageID, group, objectBag, false, false);
            if (cage != null) {
                Rack rack;
                trafficTarget.ivY = cage.getRackID(-1L);
                if (trafficTarget.ivY != -1L && (rack = (Rack)ObjectStoreServer.getObjectDeadOrAlive(3, trafficTarget.ivY, group, objectBag, false, false)) != null) {
                    trafficTarget.ivX = rack.getRoomID(-1L);
                }
                if (trafficTarget.ivX == -1L) {
                    trafficTarget.ivX = cage.getLong("CAG_ROOM", -1L);
                }
            }
        } else {
            trafficTarget.ivX = mouse.getLong("MOS_ROOM", -1L);
        }
    }

    private static void appendMouse(Mouse mouse, StringBuffer msb) {
        Rack rack = mouse.getRack();
        Room room = mouse.getRoom();
        long rackID = rack != null ? rack.getID() : -1L;
        long roomID = room != null ? room.getID() : -1L;
        msb.append("##TC|").append(Base64Manager.encodeBase64(mouse.getIdentifierString())).append("|").append(roomID).append("|").append(rackID).append("\n");
    }

    private static void appendCage(Cage cage, StringBuffer msb) {
        Vector v = cage.getActualMice();
        if (v != null && !v.isEmpty()) {
            Rack rack = cage.getRack();
            Room room = cage.getRoom();
            long rackID = rack != null ? rack.getID() : -1L;
            long roomID = room != null ? room.getID() : -1L;
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                Mouse mouse = (Mouse)iterator.next();
                msb.append("##TC|").append(Base64Manager.encodeBase64(mouse.getIdentifierString())).append("|").append(roomID).append("|").append(rackID).append("\n");
            }
        }
    }

    private static void append(long millis, long dateMillis, long mouseID, long roomIDV, long rackIDV, long roomIDN, long rackIDN, String desc, StringBuilder msb) {
        if (ProcessDefinition.isServer()) {
            msb.append(millis).append("|");
            msb.append(mouseID).append("|");
            msb.append(dateMillis != -1L ? Long.toString(dateMillis) : "").append("|");
            msb.append(roomIDV != -1L ? Long.toString(roomIDV) : "").append("|");
            msb.append(rackIDV != -1L ? Long.toString(rackIDV) : "").append("|");
            msb.append(roomIDN != -1L ? Long.toString(roomIDN) : "").append("|");
            msb.append(rackIDN != -1L ? Long.toString(rackIDN) : "").append("|");
            msb.append(desc != null ? desc : "");
            msb.append("\n");
        }
    }

    public static void unifyStrings(TreeMap linesCollector, String group, long roomID, long rackID, HashSet toDeleteKeySammler, Hashtable objectBag, Vector dictSammler, Vector tmpTarget, boolean extended) {
        objectBag.clear();
        GregorianCalendar greg = new GregorianCalendar();
        int[] wiederverwert = null;
        StringBuilder msb = new StringBuilder();
        Iterator iterator = linesCollector.values().iterator();
        while (iterator.hasNext()) {
            String[] arr;
            Long mID;
            TreeMap tagesMap = (TreeMap)iterator.next();
            HashMap gruppenMap = (HashMap)tagesMap.get(group);
            if (gruppenMap == null) continue;
            Iterator iterator3 = gruppenMap.keySet().iterator();
            while (iterator3.hasNext()) {
                int i;
                mID = (Long)iterator3.next();
                arr = (String[])gruppenMap.get(mID);
                if (arr.length != 1) {
                    i = 0;
                    while (i < arr.length - 1) {
                        if (arr[i] != null) {
                            wiederverwert = TrafficReport.checkForOrcus(arr, i, wiederverwert, msb);
                        }
                        ++i;
                    }
                }
                i = 0;
                while (i < arr.length) {
                    TrafficReport.checkForRelevance2(arr, i, wiederverwert, roomID, rackID, extended);
                    ++i;
                }
            }
            toDeleteKeySammler.clear();
            tmpTarget.clear();
            iterator3 = gruppenMap.keySet().iterator();
            while (iterator3.hasNext()) {
                mID = (Long)iterator3.next();
                arr = (String[])gruppenMap.get(mID);
                String[] narr = ArrayHelper.withoutNULLs(arr, tmpTarget);
                if (narr == null) {
                    toDeleteKeySammler.add(mID);
                    continue;
                }
                gruppenMap.put(mID, narr);
            }
            Iterator iterator2 = toDeleteKeySammler.iterator();
            while (iterator2.hasNext()) {
                gruppenMap.remove(iterator2.next());
            }
            msb.setLength(0);
            if (!gruppenMap.isEmpty()) {
                iterator3 = gruppenMap.keySet().iterator();
                while (iterator3.hasNext()) {
                    Mouse mouse;
                    if (msb.length() != 0) {
                        msb.append("#");
                    }
                    String mIDS = (mouse = (Mouse)ObjectStore.getObjectDeadOrAlive(1, mID = (Long)iterator3.next(), group, objectBag, false)) == null ? "?" : mouse.getIDStringForReports(false);
                    msb.append(mIDS);
                    String[] arr2 = (String[])gruppenMap.get(mID);
                    int i = 0;
                    while (i < arr2.length) {
                        Rack rack;
                        Room room;
                        msb.append("@");
                        String s = arr2[i];
                        wiederverwert = Zeile.getTrenner(s, '|', '\u0000', wiederverwert);
                        long millis = Zeile.getLong(s, wiederverwert, '\u0000', 0, 0L);
                        if (millis != 0L) {
                            greg.setTimeInMillis(millis);
                            int stunde = greg.get(11);
                            int minute = greg.get(12);
                            int sekunde = greg.get(13);
                            msb.append(stunde).append(":").append(minute).append(":").append(sekunde);
                        }
                        msb.append("|");
                        long millisC = Zeile.getLong(s, wiederverwert, '\u0000', 2, 0L);
                        if (millisC != 0L) {
                            greg.setTimeInMillis(millisC);
                            int jahr = greg.get(1);
                            int monat = greg.get(2) + 1;
                            int tag = greg.get(5);
                            msb.append(tag).append(":").append(monat).append(":").append(jahr);
                        }
                        msb.append("|");
                        long id = Zeile.getLong(s, wiederverwert, '\u0000', 3, -1L);
                        Room room2 = room = id == -1L ? null : (Room)ObjectStore.getObjectDeadOrAlive(10, id, group, objectBag, false);
                        if (room != null) {
                            msb.append(TrafficReport.getDictVal(room.getBrowseName(), dictSammler));
                        }
                        msb.append("|");
                        id = Zeile.getLong(s, wiederverwert, '\u0000', 4, -1L);
                        Rack rack2 = rack = id == -1L ? null : (Rack)ObjectStore.getObjectDeadOrAlive(3, id, group, objectBag, false);
                        if (rack != null) {
                            msb.append(TrafficReport.getDictVal(rack.getBrowseName(), dictSammler));
                        }
                        msb.append("|");
                        id = Zeile.getLong(s, wiederverwert, '\u0000', 5, -1L);
                        Room room3 = room = id == -1L ? null : (Room)ObjectStore.getObjectDeadOrAlive(10, id, group, objectBag, false);
                        if (room != null) {
                            msb.append(TrafficReport.getDictVal(room.getBrowseName(), dictSammler));
                        }
                        msb.append("|");
                        id = Zeile.getLong(s, wiederverwert, '\u0000', 6, -1L);
                        Rack rack3 = rack = id == -1L ? null : (Rack)ObjectStore.getObjectDeadOrAlive(3, id, group, objectBag, false);
                        if (rack != null) {
                            msb.append(TrafficReport.getDictVal(rack.getBrowseName(), dictSammler));
                        }
                        msb.append("|");
                        String desc = Zeile.getString(s, 7, "", wiederverwert, '\u0000');
                        msb.append(TrafficReport.getDictVal(desc, dictSammler));
                        if ((TRD_IMPORT.equals(desc) || TRD_CAGE_GROUP_TRANSFER.equals(desc) || TRD_MOUSE_GROUP_TRANSFER.equals(desc)) && mouse != null) {
                            String herk = mouse.getHerkunftOderZiel(true, false);
                            String ziel = mouse.getHerkunftOderZiel(false, false);
                            if (herk != null || ziel != null) {
                                msb.append(":");
                                if (herk != null) {
                                    msb.append(TrafficReport.getDictVal(herk, dictSammler));
                                }
                                msb.append(":");
                                if (ziel != null) {
                                    msb.append(TrafficReport.getDictVal(ziel, dictSammler));
                                }
                            }
                        }
                        msb.append("|");
                        msb.append(millis);
                        ++i;
                    }
                }
            }
            if (msb.length() != 0) {
                tagesMap.put(group, msb.toString());
                continue;
            }
            tagesMap.remove(group);
        }
    }

    private static int getDictVal(String s, Vector dictSammler) {
        int ind = dictSammler.indexOf(s);
        if (ind == -1) {
            ind = dictSammler.size();
            dictSammler.add(s);
        }
        return ind;
    }

    private static void checkForRelevance2(String[] arr, int pos, int[] wiederverwert, long roomID, long rackID, boolean extended) {
        if (arr[pos] != null) {
            String desc;
            String line = arr[pos];
            wiederverwert = Zeile.getTrenner(line, '|', '\u0000');
            int vpos = roomID != -1L ? 3 : 4;
            int npos = roomID != -1L ? 5 : 6;
            long vgl = roomID != -1L ? roomID : rackID;
            long vid = Zeile.getLong(line, wiederverwert, '\u0000', vpos, -1L);
            long nid = Zeile.getLong(line, wiederverwert, '\u0000', npos, -1L);
            if (vid != vgl && nid != vgl) {
                arr[pos] = null;
            }
            if (arr[pos] != null && !extended && (desc = Zeile.getString(line, 7, null, wiederverwert, '\u0000')) != null && ArrayHelper.contained(desc, NON_EXTENDS)) {
                arr[pos] = null;
            }
        }
    }

    private static int[] checkForOrcus(String[] arr, int pos, int[] wiederverwert, StringBuilder msb) {
        String s1 = arr[pos];
        String s2 = arr[pos + 1];
        if (Zeile.getLong(s1, wiederverwert = Zeile.getTrenner(s1, '|', '\u0000', wiederverwert), '\u0000', 6, -1L) == -1L) {
            long roomIDV = Zeile.getLong(s1, wiederverwert, '\u0000', 3, -1L);
            long rackIDV = Zeile.getLong(s1, wiederverwert, '\u0000', 4, -1L);
            String ds1 = Zeile.getString(s1, 2, "", wiederverwert, '\u0000');
            if (Zeile.getLong(s2, wiederverwert = Zeile.getTrenner(s2, '|', '\u0000', wiederverwert), '\u0000', 4, -1L) == -1L) {
                msb.setLength(0);
                msb.append(Zeile.getString(s2, 0, "", wiederverwert, '\u0000')).append("|");
                msb.append(Zeile.getString(s2, 1, "", wiederverwert, '\u0000')).append("|");
                String ds2 = Zeile.getString(s2, 2, "", wiederverwert, '\u0000');
                if (ds1.length() != 0 && ds2.length() == 0) {
                    msb.append(ds1);
                } else if (ds1.length() == 0 && ds2.length() != 0) {
                    msb.append(ds2);
                } else if (ds1.length() != 0 && ds2.length() != 0) {
                    msb.append(ds1);
                }
                msb.append("|");
                msb.append(roomIDV).append("|");
                msb.append(rackIDV).append("|");
                msb.append(Zeile.getString(s2, 5, "", wiederverwert, '\u0000')).append("|");
                msb.append(Zeile.getString(s2, 6, "", wiederverwert, '\u0000')).append("|");
                msb.append(TRD_TRANSFER_VIA_ORCUS);
                arr[pos] = msb.toString();
                arr[pos + 1] = null;
                msb.setLength(0);
            }
        }
        return wiederverwert;
    }

    private static void addLineFromProtocol(String gruppe, String line, int[] arr, long millis, TreeMap collection, boolean extended) {
        long mausID;
        boolean useIt = true;
        if (!extended && ArrayHelper.contained(Zeile.getString(line, 7, "", arr, '\u0000'), NON_EXTENDS)) {
            useIt = false;
        }
        if (useIt && (mausID = Zeile.getLong(line, arr, '\u0000', 1, -1L)) != -1L) {
            Long mouseKey;
            String[] lines;
            HashMap<Long, String[]> gruppenMap;
            Integer tagesKey = new Integer((int)(millis / 86400000L));
            TreeMap tagesMap = (TreeMap)collection.get(tagesKey);
            if (tagesMap == null) {
                tagesMap = new TreeMap();
                collection.put(tagesKey, tagesMap);
            }
            if ((gruppenMap = (HashMap<Long, String[]>)tagesMap.get(gruppe)) == null) {
                gruppenMap = new HashMap<Long, String[]>();
                tagesMap.put(gruppe, gruppenMap);
            }
            if ((lines = (String[])gruppenMap.get(mouseKey = new Long(mausID))) == null) {
                gruppenMap.put(mouseKey, new String[]{line});
            } else {
                gruppenMap.put(mouseKey, ArrayHelper.enlargeStringArray(lines, line));
            }
        }
    }

    private TrafficReport(ObjectRequest or, IDObject serviceObject, int[] dates) {
        this.ivLinesCollector = (TreeMap)or.ivObject;
        this.ivDictSammler = (Vector)or.ivExtraObject;
        this.ivServiceObject = serviceObject;
        this.ivDates = dates;
    }

    public String getMainTitle() {
        String mainTitel = String.valueOf(Babel.get("MOUSE_TRAFFIC_REPORT")) + " ";
        if (this.ivServiceObject instanceof Rack) {
            Rack rack = (Rack)this.ivServiceObject;
            mainTitel = String.valueOf(mainTitel) + Babel.get("RACK") + ": " + rack.getBrowseName() + " ";
        } else if (this.ivServiceObject instanceof Room) {
            Room room = (Room)this.ivServiceObject;
            mainTitel = String.valueOf(mainTitel) + Babel.get("ROOM") + ": " + room.getBrowseName() + " ";
        }
        mainTitel = String.valueOf(mainTitel) + "(" + DatumFormat.getJustDateString(this.ivDates[0]) + " - ";
        mainTitel = String.valueOf(mainTitel) + DatumFormat.getJustDateString(this.ivDates[1]) + ")";
        return mainTitel;
    }

    public static class TrafficReportRequest
    implements Serializable {
        private static final long serialVersionUID = 12342134L;
        public String ivGroup;
        public long ivRoomID;
        public long ivRackID;
        public int ivStartDate;
        public int ivEndDate;
        public boolean ivExtended;
    }
}

