/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester;

import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.MGButton;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.requester.BasicRequester;
import mausoleum.ui.UIDef;

public class AllgPickRequester
extends BasicRequester
implements ListCellRenderer {
    private static final long serialVersionUID = -8725572587601097790L;
    public static final int SM_ALL = 1;
    public static final int SM_NONE = 2;
    public static final int SM_FIRST = 3;
    public static final int SM_LAST = 4;
    private static final int BREITE = UIDef.getScaled(500);
    private static final int HOEHE = UIDef.getScaled(600);
    private static final int INNER_BREITE = BREITE - 2 * UIDef.RAND;
    private JLabel ivListLabel = new JLabel();
    private final Vector ivSelectedValues = new Vector();
    private final Vector ivAllValues;
    private final boolean ivEmptyAllowed;

    public static Vector pickFromList(Frame sender, Vector origs, String titleBabel, String objectsBabel, int[] butSelmodes, String[] butBabels, int selmode) {
        return AllgPickRequester.pickFromList(sender, origs, titleBabel, objectsBabel, butSelmodes, butBabels, selmode, null, false);
    }

    public static Vector pickFromList(Frame sender, Vector origs, String titleBabel, String objectsBabel, int[] butSelmodes, String[] butBabels, int selmode, TreeSet prevSel, boolean emptyAllowed) {
        if (origs != null && !origs.isEmpty()) {
            AllgPickRequester apr = new AllgPickRequester(sender, origs, titleBabel, objectsBabel, butSelmodes, butBabels, selmode, prevSel, emptyAllowed);
            if (apr.ivWarOK && (!apr.ivSelectedValues.isEmpty() || emptyAllowed)) {
                return apr.ivSelectedValues;
            }
        }
        return null;
    }

    private AllgPickRequester(Frame sender, Vector origs, String titleBabel, String objectsBabel, int[] butSelmodes, String[] butBabels, int defaultSelectionMode, TreeSet prevSel, boolean emptyAllowed) {
        super(sender, BREITE, HOEHE);
        int gesamtHoehe;
        int diff2Max;
        this.ivAllValues = origs;
        this.ivListLabel.setFont(FontManager.getFont("SSB12"));
        this.ivListLabel.setHorizontalTextPosition(4);
        this.ivEmptyAllowed = emptyAllowed;
        this.setTitle(Babel.get(titleBabel));
        JList list = new JList(this.ivAllValues);
        list.setCellRenderer(this);
        list.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JList list = (JList)e.getSource();
                int selind = list.locationToIndex(e.getPoint());
                if (selind != -1) {
                    Object obj = list.getModel().getElementAt(selind);
                    if (AllgPickRequester.this.ivSelectedValues.contains(obj)) {
                        AllgPickRequester.this.ivSelectedValues.remove(obj);
                    } else {
                        AllgPickRequester.this.ivSelectedValues.addElement(obj);
                    }
                    AllgPickRequester.this.selectionChanged();
                }
            }
        });
        JPanel mp = new JPanel(new BorderLayout());
        mp.setOpaque(false);
        mp.add("Center", new JScrollPane(list));
        BorderPanel mbp = new BorderPanel(mp, Babel.get(objectsBabel));
        int listHeight = mp.getPreferredSize().height + UIDef.getScaled(10);
        int extraPanelsHeightMitRand = 0;
        JPanel extraButtonsPanel = this.makeExtraButPane(butSelmodes, butBabels);
        if (extraButtonsPanel != null) {
            extraPanelsHeightMitRand = UIDef.INNER_RAND + extraButtonsPanel.getPreferredSize().height;
        }
        if ((diff2Max = HOEHE - (gesamtHoehe = 2 * UIDef.RAND + UIDef.INNER_RAND + extraPanelsHeightMitRand + listHeight + UIDef.BUT_HEIGHT)) < 0) {
            listHeight -= diff2Max;
            gesamtHoehe = HOEHE;
        }
        int y = UIDef.RAND;
        this.addAndApplyBounds(mbp, UIDef.RAND, y, INNER_BREITE, listHeight);
        y += listHeight + UIDef.INNER_RAND;
        if (extraButtonsPanel != null) {
            this.addAndApplyBounds(extraButtonsPanel, UIDef.RAND, y, INNER_BREITE, extraPanelsHeightMitRand - UIDef.INNER_RAND);
            y += extraPanelsHeightMitRand;
        }
        this.ivOkButton.setFont(FontManager.getFont("SSB16"));
        this.ivOkButton.setEnabled(false);
        this.applyBounds(this.ivOkButton, UIDef.RAND, y, INNER_BREITE, UIDef.BUT_HEIGHT);
        y += UIDef.BUT_HEIGHT + UIDef.RAND;
        if (prevSel != null) {
            this.ivSelectedValues.addAll(prevSel);
            this.selectionChanged();
        } else {
            this.select(defaultSelectionMode);
        }
        this.setInnerSize(BREITE, gesamtHoehe);
        this.setVisible(true);
    }

    public void selectAll() {
        this.ivSelectedValues.clear();
        if (this.ivAllValues != null && !this.ivAllValues.isEmpty()) {
            this.ivSelectedValues.addAll(this.ivAllValues);
        }
        this.selectionChanged();
    }

    public void selectNone() {
        this.ivSelectedValues.clear();
        this.selectionChanged();
    }

    public void selectOneSpecificElement(Object element) {
        this.ivSelectedValues.clear();
        this.ivSelectedValues.add(element);
        this.selectionChanged();
    }

    public void selectFirstElement() {
        if (this.ivAllValues != null && !this.ivAllValues.isEmpty()) {
            this.selectOneSpecificElement(this.ivAllValues.firstElement());
        }
    }

    public void selectLastElement() {
        if (this.ivAllValues != null && !this.ivAllValues.isEmpty()) {
            this.selectOneSpecificElement(this.ivAllValues.lastElement());
        }
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    private void selectionChanged() {
        this.checkButton();
        this.repaint();
    }

    private void checkButton() {
        this.ivOkButton.setEnabled(this.ivEmptyAllowed || !this.ivSelectedValues.isEmpty());
    }

    private JPanel makeExtraButPane(int[] selmodes, String[] butBabels) {
        JPanel pan = null;
        if (selmodes != null && selmodes.length != 0) {
            pan = new JPanel(new GridLayout(1, selmodes.length, UIDef.INNER_RAND, UIDef.INNER_RAND));
            pan.setOpaque(false);
            pan.setPreferredSize(new Dimension(UIDef.getScaled(100), UIDef.BUT_HEIGHT));
            int i = 0;
            while (i < selmodes.length) {
                MGButton but = new MGButton(Babel.get(butBabels[i]));
                but.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        AllgPickRequester.this.select(Integer.parseInt(arg0.getActionCommand()));
                    }
                });
                but.setActionCommand(Integer.toString(selmodes[i]));
                pan.add(but);
                ++i;
            }
        }
        return pan;
    }

    private void select(int selmode) {
        switch (selmode) {
            case 1: {
                this.selectAll();
                break;
            }
            case 3: {
                this.selectFirstElement();
                break;
            }
            case 4: {
                this.selectLastElement();
                break;
            }
            default: {
                this.selectNone();
            }
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String text = value.toString();
        this.ivListLabel.setText(" " + text + " ");
        if (this.ivSelectedValues.contains(value)) {
            this.ivListLabel.setOpaque(true);
            this.ivListLabel.setBackground(UIDef.SELECTED_BACKGROUND);
            this.ivListLabel.setIcon(ImageProvider.HAKEN_ICON);
        } else {
            this.ivListLabel.setOpaque(false);
            this.ivListLabel.setBackground(null);
            this.ivListLabel.setIcon(ImageProvider.EMPTY_HAKEN_ICON);
        }
        return this.ivListLabel;
    }
}

