/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester;

import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import mausoleum.gui.ColorManager;
import mausoleum.gui.MGButton;
import mausoleum.helper.ClipboardObject;
import mausoleum.helper.HTMLEncoder;
import mausoleum.requester.BasicRequester;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.ui.UIDef;

public class CopyRequester
extends BasicRequester {
    private static final long serialVersionUID = 1L;
    private static final int BUT_WIDTH = UIDef.getScaled(150);
    private static final int LP_WIDTH = UIDef.getScaled(180);
    private static final int BUT_X_START = 2 * UIDef.RAND + LP_WIDTH;
    private static final int BREITE = 3 * UIDef.RAND + LP_WIDTH + BUT_WIDTH;
    private static final int HOEHE = 3 * UIDef.BUT_HEIGHT + 2 * UIDef.INNER_RAND + 2 * UIDef.RAND;
    private static final String HTML_PRE = "<html>\r\n<body>\r\n<table border=\"1\">\r\n";
    private static final String HTML_POST = "</table>\r\n</body>\r\n</html>\r\n";
    private static final String HTML_ROW_START = "\t<tr>\r\n";
    private static final String HTML_ROW_END = "\t</tr>\r\n";
    private static final String HTML_CELL_START_OPEN = "\t\t<td";
    private static final String HTML_CLOSER = ">";
    private static final String HTML_CELL_START = "\t\t<td>";
    private static final String HTML_CELL_END = "</td>\r\n";
    private static final String HTML_EMPTY_CELL = "\t\t<td></td>\r\n";
    private static final String COL_SEP = "\t";
    private static final String LIN_SEP = "\n";
    private TableModel ivTableModel = null;
    private TableCellRenderer ivRenderer = null;
    private int[] ivSelectedRows = null;
    private JRadioButton ivAllButton = new JRadioButton(Babel.get("COPY_DISPLAYED"), true);
    private JRadioButton ivSelButton = new JRadioButton(Babel.get("COPY_SELECTED"), false);
    private JCheckBox ivFormatBox = new JCheckBox(Babel.get("COPY_WITH_FORMAT"), false);

    public CopyRequester(Frame sender, TableModel tableModel, TableCellRenderer cellRenderer, int[] selectedRows) {
        super(sender, BREITE, HOEHE);
        this.ivTableModel = tableModel;
        this.ivRenderer = cellRenderer;
        this.ivSelectedRows = selectedRows;
        MGButton but = MGButton.getRequesterButton("Copy");
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                CopyRequester.this.copy();
            }
        });
        this.addAndApplyBounds(but, BUT_X_START, UIDef.RAND, BUT_WIDTH, UIDef.BUT_HEIGHT);
        but = MGButton.getRequesterButton(Babel.get("NO"));
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                CopyRequester.this.dispose();
            }
        });
        this.addAndApplyBounds(but, BUT_X_START, UIDef.RAND + UIDef.BUT_HEIGHT + UIDef.INNER_RAND, BUT_WIDTH, UIDef.BUT_HEIGHT);
        this.ivAllButton.setOpaque(false);
        this.ivAllButton.setFocusPainted(false);
        this.addAndApplyBounds(this.ivAllButton, UIDef.RAND, UIDef.RAND, LP_WIDTH, UIDef.getScaled(20));
        this.ivSelButton.setOpaque(false);
        this.ivSelButton.setFocusPainted(false);
        if (this.ivSelectedRows == null || this.ivSelectedRows.length == 0) {
            this.ivSelButton.setEnabled(false);
        }
        this.addAndApplyBounds(this.ivSelButton, UIDef.RAND, UIDef.RAND + UIDef.getScaled(24), LP_WIDTH, UIDef.getScaled(20));
        this.ivFormatBox.setOpaque(false);
        this.ivFormatBox.setFocusPainted(false);
        this.addAndApplyBounds(this.ivFormatBox, UIDef.RAND, UIDef.RAND + UIDef.getScaled(50), LP_WIDTH, UIDef.getScaled(20));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.ivAllButton);
        bg.add(this.ivSelButton);
    }

    public void dispose() {
        this.ivTableModel = null;
        this.ivRenderer = null;
        this.ivSelectedRows = null;
        super.dispose();
    }

    public boolean okAndNoWanted() {
        return false;
    }

    private void copy() {
        int i;
        boolean onlySelecteds = this.ivSelButton.isSelected();
        boolean withFormat = this.ivFormatBox.isSelected();
        StringBuilder msb = withFormat ? new StringBuilder(3000) : null;
        StringBuilder xsb = new StringBuilder(3000);
        if (withFormat) {
            msb.append(HTML_PRE);
        }
        int columnCount = this.ivTableModel.getColumnCount();
        if (withFormat) {
            msb.append(HTML_ROW_START);
            i = 0;
            while (i < columnCount) {
                msb.append(HTML_CELL_START).append(this.ivTableModel.getColumnName(i)).append(HTML_CELL_END);
                ++i;
            }
            msb.append(HTML_ROW_END);
        }
        i = 0;
        while (i < columnCount) {
            xsb.append(this.ivTableModel.getColumnName(i)).append(COL_SEP);
            ++i;
        }
        xsb.append(LIN_SEP);
        Vector altSel = null;
        if (this.ivTableModel instanceof MausoleumTableModel) {
            MausoleumTableModel mtm = (MausoleumTableModel)this.ivTableModel;
            altSel = new Vector(mtm.ivSelectedRows);
            mtm.ivSelectedRows.clear();
        }
        try {
            int rc = this.ivTableModel.getRowCount();
            int y = 0;
            while (y < rc) {
                if (!onlySelecteds || this.ivSelectedRows == null || ArrayHelper.findIndexInArray(y, this.ivSelectedRows) != -1) {
                    if (withFormat) {
                        msb.append(HTML_ROW_START);
                    }
                    int x = 0;
                    while (x < columnCount) {
                        Component comp = this.ivRenderer.getTableCellRendererComponent(null, this.ivTableModel.getValueAt(y, x), false, false, y, x);
                        boolean didit = false;
                        if (comp != null) {
                            if (comp instanceof JLabel) {
                                JLabel lab = (JLabel)comp;
                                if (withFormat) {
                                    msb.append(HTML_CELL_START_OPEN);
                                    msb.append(CopyRequester.getStyle(lab.getBackground(), lab.getForeground(), lab.getFont(), lab.getHorizontalAlignment(), false));
                                    msb.append(HTML_CLOSER);
                                    if (lab.getIcon() != null) {
                                        msb.append("x");
                                    } else if (lab.getText() != null) {
                                        msb.append(this.purifyString(lab.getText(), true));
                                    }
                                    msb.append(HTML_CELL_END);
                                }
                                if (lab.getIcon() != null) {
                                    xsb.append("x");
                                } else if (lab.getText() != null && lab.getText().length() != 0) {
                                    xsb.append(this.purifyString(lab.getText(), false));
                                }
                                xsb.append(COL_SEP);
                                didit = true;
                            } else if (comp instanceof JPanel) {
                                if (withFormat) {
                                    msb.append(HTML_CELL_START);
                                }
                                JPanel jp = (JPanel)comp;
                                Component[] arr = jp.getComponents();
                                boolean formatDa = false;
                                int i2 = 0;
                                while (i2 < arr.length) {
                                    JLabel lab;
                                    if (arr[i2] instanceof JLabel && (lab = (JLabel)arr[i2]).getText() != null) {
                                        if (withFormat) {
                                            if (!formatDa) {
                                                msb.append(CopyRequester.getStyle(lab.getBackground(), lab.getForeground(), lab.getFont(), lab.getHorizontalAlignment(), false));
                                                formatDa = true;
                                            }
                                            msb.append(this.purifyString(lab.getText(), true)).append(" ");
                                        }
                                        xsb.append(this.purifyString(lab.getText(), false)).append(" ");
                                    }
                                    ++i2;
                                }
                                xsb.append(COL_SEP);
                                if (withFormat) {
                                    msb.append(HTML_CELL_END);
                                }
                                didit = true;
                            }
                        }
                        if (!didit) {
                            if (withFormat) {
                                msb.append(HTML_EMPTY_CELL);
                            }
                            xsb.append(COL_SEP);
                        }
                        ++x;
                    }
                    if (withFormat) {
                        msb.append(HTML_ROW_END);
                    }
                    xsb.append(LIN_SEP);
                }
                ++y;
            }
            if (withFormat) {
                msb.append(HTML_POST);
            }
        }
        catch (Exception rc) {
            // empty catch block
        }
        if (altSel != null && this.ivTableModel instanceof MausoleumTableModel) {
            MausoleumTableModel mtm = (MausoleumTableModel)this.ivTableModel;
            mtm.ivSelectedRows.addAll(altSel);
        }
        if (withFormat) {
            ClipboardObject.manageCopy(msb.toString(), xsb.toString());
        } else {
            ClipboardObject.manageCopy(null, xsb.toString());
        }
        this.dispose();
    }

    private static String getStyle(Color back, Color fore, Font f, int orientation, boolean nowrap) {
        StringBuilder msb = new StringBuilder();
        if (back != null) {
            msb.append("background-color:#").append(ColorManager.getColorString(back)).append(";");
        }
        if (fore != null && !Color.black.equals(fore)) {
            msb.append("color:#").append(ColorManager.getColorString(fore)).append(";");
        }
        if (f.isBold()) {
            msb.append("font-weight:bold;");
        }
        if (f.isItalic()) {
            msb.append("font-style:italic;");
        }
        switch (orientation) {
            case 0: {
                msb.append("text-align:center;");
                break;
            }
            case 4: {
                msb.append("text-align:right;");
                break;
            }
        }
        if (nowrap) {
            msb.append("white-space:nowrap;");
        }
        return msb.length() != 0 ? " style=\"" + msb.toString() + "\"" : "";
    }

    private String purifyString(String s, boolean forHTML) {
        if (s != null && s.trim().length() != 0) {
            if (forHTML) {
                return HTMLEncoder.convertToHTML(s);
            }
            s = s.replaceAll("\u2642", "\u2642").replaceAll("\u2640", "\u2640");
            s = s.replaceAll("\"", "'");
            return "\"" + s + "\"";
        }
        return s;
    }
}

