/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester;

import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import mausoleum.gui.MGButton;
import mausoleum.inspector.Inspector;
import mausoleum.main.ProcessDefinition;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.InfoPanel;
import mausoleum.ui.UIDef;
import mausoleum.util.HelloMessage;
import mausoleum.util.InstallationType;

public class InfoDialog
extends BasicRequester {
    private static final long serialVersionUID = 1L;
    private static final String FILENAME = "data/changes.html";
    private static final int VERSION_HEIGHT = UIDef.getScaled(300);
    private static String cvUserString = null;
    private static InfoDialog cvInstance = null;

    public static void showDialog() {
        if (ProcessDefinition.isClient()) {
            String usersString = UserManager.getUser().getIdentifierString();
            if (cvInstance == null || !usersString.equals(cvUserString)) {
                cvInstance = new InfoDialog();
                cvUserString = usersString;
            }
            cvInstance.toFront();
            cvInstance.setVisible(true);
        }
    }

    private InfoDialog() {
        super((Frame)Inspector.getInspector(), 300, 200);
        int x = UIDef.RAND;
        int y = UIDef.RAND;
        InfoPanel infoPanel = new InfoPanel();
        infoPanel.ivString = Babel.get("INFORMATION");
        infoPanel.setText(null, 0.0, 0.0);
        this.addAndApplyBounds(infoPanel, x, y, infoPanel.BREITE, infoPanel.HOEHE);
        y += infoPanel.HOEHE + UIDef.INNER_RAND;
        JTabbedPane tp = new JTabbedPane();
        tp.setOpaque(false);
        String s = FileManager.getStringFromFile(FILENAME, false);
        if (s == null) {
            s = "";
        }
        JTextPane textArea = new JTextPane();
        textArea.setContentType("text/html");
        textArea.setText(s);
        textArea.setEditable(false);
        textArea.setDisabledTextColor(Color.black);
        textArea.setMargin(new Insets(UIDef.getScaled(4), UIDef.getScaled(4), UIDef.getScaled(4), UIDef.getScaled(4)));
        textArea.setCaretPosition(0);
        JScrollPane jsp = new JScrollPane(textArea);
        tp.add(Babel.get("VERSION_INFO"), jsp);
        s = HelloMessage.getSystemMessage(2, null);
        if (s != null && s.length() != 0) {
            textArea = new JTextPane();
            textArea.setText(s);
            textArea.setEditable(false);
            textArea.setDisabledTextColor(Color.black);
            textArea.setMargin(new Insets(UIDef.getScaled(4), UIDef.getScaled(4), UIDef.getScaled(4), UIDef.getScaled(4)));
            textArea.setCaretPosition(0);
            jsp = new JScrollPane(textArea);
            tp.add(Babel.get("INST_INFO"), jsp);
        }
        if ((s = HelloMessage.getSystemMessage(3, UserManager.getFirstGroup())) != null && s.length() != 0) {
            textArea = new JTextPane();
            textArea.setText(s);
            textArea.setEditable(false);
            textArea.setDisabledTextColor(Color.black);
            textArea.setMargin(new Insets(UIDef.getScaled(4), UIDef.getScaled(4), UIDef.getScaled(4), UIDef.getScaled(4)));
            textArea.setCaretPosition(0);
            jsp = new JScrollPane(textArea);
            tp.add(Babel.get("GROUP_INFO"), jsp);
        }
        this.addAndApplyBounds(tp, x, y, infoPanel.BREITE, VERSION_HEIGHT);
        if (Privileges.hasPrivilege("EDIT_INSTITUTE_INFO") && Privileges.hasPrivilege("EDIT_GROUP_INFO")) {
            int lw = (infoPanel.BREITE - UIDef.INNER_RAND) / 2;
            int rw = infoPanel.BREITE - UIDef.INNER_RAND - lw;
            x = UIDef.RAND;
            this.addBut(x, y += VERSION_HEIGHT + UIDef.INNER_RAND, lw, "EDIT_INST_INFO_MESSAGE", 2);
            this.addBut(x += lw + UIDef.INNER_RAND, y, rw, "EDIT_GROUP_INFO_MESSAGE", 3);
            y += UIDef.BUT_HEIGHT + UIDef.RAND;
        } else if (Privileges.hasPrivilege("EDIT_INSTITUTE_INFO")) {
            this.addBut(UIDef.RAND, y += VERSION_HEIGHT + UIDef.INNER_RAND, infoPanel.BREITE, "EDIT_INST_INFO_MESSAGE", 2);
            y += UIDef.BUT_HEIGHT + UIDef.RAND;
        } else if (Privileges.hasPrivilege("EDIT_GROUP_INFO")) {
            this.addBut(UIDef.RAND, y += VERSION_HEIGHT + UIDef.INNER_RAND, infoPanel.BREITE, "EDIT_GROUP_INFO_MESSAGE", 3);
            y += UIDef.BUT_HEIGHT + UIDef.RAND;
        } else {
            y += VERSION_HEIGHT + UIDef.RAND;
        }
        String tit = Babel.get("MAUSOLEUM_INFO");
        this.setTitle(StringHelper.gSub(tit, "Mausoleum", InstallationType.getNormalProgramName()));
        this.setInnerSize(infoPanel.BREITE + 2 * UIDef.RAND, y);
    }

    private void addBut(int x, int y, int w, String babel, int typ) {
        this.addAndApplyBounds(MGButton.getInspectorActionButton(Babel.get(babel), Integer.toString(typ), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MGButton but = (MGButton)e.getSource();
                InfoDialog.this.setVisible(false);
                boolean reload = HelloMessage.editSystemMessage(null, Integer.parseInt(e.getActionCommand()), but.getText(), UserManager.getFirstGroup());
                if (reload) {
                    Rectangle bounds = InfoDialog.this.getBounds();
                    InfoDialog.this.dispose();
                    cvInstance = new InfoDialog(null);
                    cvInstance.setBounds(bounds);
                    cvInstance.setVisible(true);
                } else {
                    InfoDialog.this.setVisible(true);
                }
            }
        }), x, y, w, UIDef.BUT_HEIGHT);
    }

    /* synthetic */ InfoDialog(InfoDialog infoDialog) {
        this();
    }
}

