/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.building.Building;
import mausoleum.building.BuildingManager;
import mausoleum.objectstore.QuotableIDObject;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.room.Room;
import mausoleum.room.RoomManager;

public abstract class MoveRackOrRoomRequester {
    public static long getTargetID(Frame sender, long crid, String group, boolean isRackToRoom) {
        int itemcount;
        Vector<String> targetNames = new Vector<String>();
        HashMap<Integer, QuotableIDObject> targetsByIndex = new HashMap<Integer, QuotableIDObject>();
        String title = "";
        if (isRackToRoom) {
            Vector rooms = RoomManager.getActualObjects(group);
            if (rooms != null) {
                Collections.sort(rooms, IDObject.SORTER_BY_NAME);
                itemcount = 0;
                int i = 0;
                while (i < rooms.size()) {
                    Room room = (Room)rooms.elementAt(i);
                    if (!room.isSharedWithOtherGroups() && room.getID() != crid) {
                        targetNames.add(room.getName());
                        targetsByIndex.put(new Integer(itemcount), room);
                        ++itemcount;
                    }
                    ++i;
                }
            }
            title = Babel.get("MOVERACKTOROOM");
        } else {
            Vector buildings = BuildingManager.getActualObjects(group);
            if (buildings != null) {
                Collections.sort(buildings, IDObject.SORTER_BY_NAME);
                targetNames.add(Babel.get("NO_BUILDING"));
                itemcount = 1;
                Iterator iter = buildings.iterator();
                while (iter.hasNext()) {
                    Building building = (Building)iter.next();
                    targetNames.add(building.getName());
                    targetsByIndex.put(new Integer(itemcount), building);
                    ++itemcount;
                }
            }
            title = Babel.get("SET_BUILDING");
        }
        if (!targetNames.isEmpty()) {
            int ind = AllgChoiceRequester.getIndexAnswer(sender, title, targetNames);
            if (ind != -1) {
                if (isRackToRoom) {
                    Room room = (Room)targetsByIndex.get(new Integer(ind));
                    if (room != null) {
                        return room.getID();
                    }
                } else {
                    if (ind == 0) {
                        return -1L;
                    }
                    Building building = (Building)targetsByIndex.get(new Integer(ind));
                    if (building != null) {
                        return building.getID();
                    }
                }
            }
        } else {
            Alert.showAlert(Babel.get("NO_MORE_POSSIBLE_ROOMS"), true);
        }
        return -2L;
    }
}

