/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Font;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import mausoleum.alert.Alert;
import mausoleum.gui.TextWrapComponent;
import mausoleum.helper.FontManager;
import mausoleum.requester.BasicRequester;
import mausoleum.ui.UIDef;

public class NewExperimentChoiceRequester
extends BasicRequester {
    private static final long serialVersionUID = 1L;
    private static final int BREITE = UIDef.getScaled(350);
    private static final int TEXT_WIDTH = BREITE - 2 * UIDef.RAND;
    private static String cvMeldung = Babel.get("SETPOSSIBLEVALUES");
    private static Font cvFont = FontManager.getFont("SSB14");
    private static int cvMeldungsHoehe = TextWrapComponent.getNecessaryHeight(cvMeldung, TEXT_WIDTH, cvFont);
    private static final int FIELD_X = UIDef.RAND;
    private static int FIELD_Y = cvMeldungsHoehe + 2 * UIDef.RAND;
    private static final int FIELD_HEIGHT = UIDef.getScaled(150);
    private static final int FIELD_WIDTH = BREITE - 2 * UIDef.RAND;
    private static int OKBUT_Y = FIELD_Y + FIELD_HEIGHT + UIDef.INNER_RAND;
    private static final int OKBUT_HEIGHT = UIDef.getScaled(40);
    private static final int OKBUT_WIDTH = BREITE - 2 * UIDef.RAND;
    private static final int OKBUT_X = UIDef.RAND;
    private static int HOEHE = OKBUT_Y + OKBUT_HEIGHT + UIDef.RAND;
    private JTextArea ivValueArea = new JTextArea();
    private String[] ivValues = null;

    public static String[] getValues(Frame sender, String[] oldvals) {
        NewExperimentChoiceRequester nmr = new NewExperimentChoiceRequester(sender, oldvals);
        nmr.setVisible(true);
        if (!nmr.ivWarOK) {
            return null;
        }
        return nmr.ivValues;
    }

    private NewExperimentChoiceRequester(Frame sender, String[] oldvals) {
        super(sender, BREITE, HOEHE);
        this.setTitle(cvMeldung);
        TextWrapComponent twc = new TextWrapComponent(cvMeldung, FontManager.getFont("SSB14"));
        twc.setOrientation(1112);
        this.addAndApplyBounds(twc, UIDef.RAND, UIDef.RAND, TEXT_WIDTH, cvMeldungsHoehe);
        this.ivValueArea.setFont(FontManager.getFont("SSB16"));
        if (oldvals == null) {
            this.ivValueArea.setText("");
        } else {
            StringBuffer msb = new StringBuffer();
            int i = 0;
            while (i < oldvals.length) {
                msb.append(oldvals[i]).append("\n");
                ++i;
            }
            this.ivValueArea.setText(msb.toString());
        }
        this.addAndApplyBounds(new JScrollPane(this.ivValueArea), FIELD_X, FIELD_Y, FIELD_WIDTH, FIELD_HEIGHT);
        this.applyBounds(this.ivOkButton, OKBUT_X, OKBUT_Y, OKBUT_WIDTH, OKBUT_HEIGHT);
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    public void OKPressed() {
        this.ivValues = null;
        String s = this.ivValueArea.getText();
        Vector v = StringHelper.splitStringByAny(s, "\n");
        if (v.size() == 0) {
            Alert.showAlert("You have to specify at least one value!", true);
            return;
        }
        this.ivValues = new String[v.size()];
        Vector<String> v2 = new Vector<String>();
        int i = 0;
        while (i < v.size()) {
            String vi = ((String)v.elementAt(i)).trim();
            if (vi.length() != 0) {
                v2.addElement(vi);
            }
            ++i;
        }
        if (v2.size() == 0) {
            Alert.showAlert("You have to specify at least one non empty value!", true);
            return;
        }
        this.ivValues = new String[v2.size()];
        i = 0;
        while (i < v2.size()) {
            this.ivValues[i] = (String)v2.elementAt(i);
            ++i;
        }
        this.ivWarOK = true;
        super.dispose();
    }
}

