/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mausoleum.experiment.Experiment;
import mausoleum.gui.MGButton;
import mausoleum.helper.FontManager;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.NewExperimentChoiceRequester;
import mausoleum.requester.NewExperimentLimitRequester;
import mausoleum.ui.MausoleumTextAreaUI;
import mausoleum.ui.UIDef;

public class NewExperimentRequester
extends BasicRequester
implements ItemListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private static final int BREITE = UIDef.getScaled(400);
    private static final int FIELD_HEIGHT = UIDef.getScaled(30);
    private static final int FIELD_WIDTH = UIDef.getScaled(260);
    private static final int NAMEFIELD_Y = UIDef.RAND;
    private static final int TYPEFIELD_Y = NAMEFIELD_Y + FIELD_HEIGHT + UIDef.INNER_RAND;
    private static final int LIMITBUT_Y = TYPEFIELD_Y + FIELD_HEIGHT + UIDef.INNER_RAND;
    private static final int VALUEBUT_Y = LIMITBUT_Y + FIELD_HEIGHT + UIDef.INNER_RAND;
    private static final int OKBUT_Y = VALUEBUT_Y + FIELD_HEIGHT + UIDef.INNER_RAND;
    private static final int OKBUT_HEIGHT = UIDef.getScaled(80);
    private static final int OKBUT_WIDTH = UIDef.getScaled(100);
    private static final int OKBUT_X = BREITE - OKBUT_WIDTH - UIDef.RAND;
    private static final int HOEHE = OKBUT_Y + OKBUT_HEIGHT + UIDef.RAND;
    private JTextField ivNameField = new JTextField();
    private JComboBox ivTypeCombo = new JComboBox<String>(Experiment.TYPE_STRINGS);
    private MGButton ivLimitButton = MGButton.getRequesterButton(Babel.get("SPECIFYLIMITS"));
    private MGButton ivValueButton = MGButton.getRequesterButton(Babel.get("SPECIFYVALUES"));
    private JTextArea ivInfoArea;
    private Object[] ivObjects = null;
    private String ivUnit = null;
    private String ivLastSelected = null;
    private Frame ivSender = null;

    public NewExperimentRequester(Frame sender) {
        super(sender, BREITE, HOEHE);
        this.ivSender = sender;
        this.setTitle(Babel.get("NEWEXPERIMENT"));
        this.ivNameField.setFont(FontManager.getFont("SSB16"));
        this.addPermanentLabel(Babel.get("NAME"), UIDef.RAND, NAMEFIELD_Y, FIELD_HEIGHT);
        this.addAndApplyBounds(this.ivNameField, BREITE - UIDef.RAND - FIELD_WIDTH, NAMEFIELD_Y, FIELD_WIDTH, FIELD_HEIGHT);
        this.addPermanentLabel(Babel.get("TYPE"), UIDef.RAND, TYPEFIELD_Y, FIELD_HEIGHT);
        this.addAndApplyBounds(this.ivTypeCombo, BREITE - UIDef.RAND - FIELD_WIDTH, TYPEFIELD_Y, FIELD_WIDTH, FIELD_HEIGHT);
        this.addAndApplyBounds(this.ivLimitButton, UIDef.RAND, LIMITBUT_Y, BREITE - 2 * UIDef.RAND, FIELD_HEIGHT);
        this.addAndApplyBounds(this.ivValueButton, UIDef.RAND, VALUEBUT_Y, BREITE - 2 * UIDef.RAND, FIELD_HEIGHT);
        this.applyBounds(this.ivOkButton, OKBUT_X, OKBUT_Y, OKBUT_WIDTH, OKBUT_HEIGHT);
        this.ivLimitButton.setEnabled(false);
        this.ivLimitButton.setActionCommand("LIMIT");
        this.ivLimitButton.addActionListener(this);
        this.ivValueButton.setEnabled(false);
        this.ivValueButton.setActionCommand("VALUE");
        this.ivValueButton.addActionListener(this);
        this.ivOkButton.setEnabled(false);
        this.ivTypeCombo.addItemListener(this);
        this.ivLastSelected = (String)this.ivTypeCombo.getSelectedItem();
        this.ivNameField.getDocument().addDocumentListener(this);
        this.ivInfoArea = new JTextArea();
        this.ivInfoArea.setEnabled(false);
        this.ivInfoArea.setEditable(false);
        this.ivInfoArea.setFont(FontManager.getFont("SSB12"));
        this.ivInfoArea.setDisabledTextColor(Color.black);
        int im = UIDef.getScaled(4);
        this.ivInfoArea.setMargin(new Insets(im, im, im, im));
        if (this.ivInfoArea.getUI() instanceof MausoleumTextAreaUI) {
            ((MausoleumTextAreaUI)this.ivInfoArea.getUI()).setImageKey("inspectorBack");
        }
        JScrollPane jsp = new JScrollPane(this.ivInfoArea);
        this.addAndApplyBounds(jsp, UIDef.RAND, OKBUT_Y, BREITE - OKBUT_WIDTH - 2 * UIDef.RAND - UIDef.INNER_RAND, OKBUT_HEIGHT);
        this.setVisible(true);
    }

    public void dispose() {
        this.ivSender = null;
        super.dispose();
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        String[] vals;
        super.actionPerformed(e);
        String comm = e.getActionCommand();
        if (comm.equals("LIMIT")) {
            NewExperimentLimitRequester nelr = new NewExperimentLimitRequester(this.ivSender, this.ivLastSelected.equals(Experiment.TYPES_INTEGER));
            nelr.setVisible(true);
            if (nelr.ivWarOK) {
                this.ivUnit = nelr.ivUnit;
                this.ivObjects = new Object[2];
                this.ivObjects[0] = nelr.ivLowerLimit;
                this.ivObjects[1] = nelr.ivUpperLimit;
                this.setOKState();
                this.setInfoArea();
            }
        } else if (comm.equals("VALUE") && (vals = NewExperimentChoiceRequester.getValues(this.ivSender, (String[])this.ivObjects)) != null) {
            this.ivUnit = null;
            this.ivObjects = vals;
            this.setOKState();
            this.setInfoArea();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        String newsel = (String)this.ivTypeCombo.getSelectedItem();
        if (this.ivLastSelected == null || !newsel.equals(this.ivLastSelected)) {
            this.ivObjects = null;
            this.ivUnit = null;
            this.ivLastSelected = newsel;
            if (newsel.equals(Experiment.TYPES_BOOLEAN)) {
                this.ivLimitButton.setEnabled(false);
                this.ivValueButton.setEnabled(false);
            }
            if (newsel.equals(Experiment.TYPES_IMAGE)) {
                this.ivLimitButton.setEnabled(false);
                this.ivValueButton.setEnabled(false);
            } else if (newsel.equals(Experiment.TYPES_INTEGER)) {
                this.ivLimitButton.setEnabled(true);
                this.ivValueButton.setEnabled(false);
            } else if (newsel.equals(Experiment.TYPES_DOUBLE)) {
                this.ivLimitButton.setEnabled(true);
                this.ivValueButton.setEnabled(false);
            } else if (newsel.equals(Experiment.TYPES_CHOICE)) {
                this.ivLimitButton.setEnabled(false);
                this.ivValueButton.setEnabled(true);
            } else if (newsel.equals(Experiment.TYPES_FREE)) {
                this.ivLimitButton.setEnabled(false);
                this.ivValueButton.setEnabled(false);
            } else if (newsel.equals(Experiment.TYPES_GPS)) {
                this.ivLimitButton.setEnabled(false);
                this.ivValueButton.setEnabled(false);
            } else if (newsel.equals(Experiment.TYPES_EMPTY)) {
                this.ivLimitButton.setEnabled(false);
                this.ivValueButton.setEnabled(false);
            }
        }
        this.setOKState();
        this.setInfoArea();
    }

    private void setInfoArea() {
        StringBuffer msb = new StringBuffer();
        if (!this.ivLastSelected.equals(Experiment.TYPES_BOOLEAN)) {
            if (this.ivLastSelected.equals(Experiment.TYPES_INTEGER)) {
                if (this.ivObjects == null) {
                    msb.append("No Limits specified");
                } else if (this.ivObjects.length == 2) {
                    String un = this.ivUnit.trim();
                    msb.append("Lower Limit:\t").append(this.ivObjects[0]).append(" ").append(un).append("\n");
                    msb.append("Upper Limit:\t").append(this.ivObjects[1]).append(" ").append(un).append("\n");
                } else {
                    msb.append("No Limits specified");
                }
            } else if (this.ivLastSelected.equals(Experiment.TYPES_DOUBLE)) {
                if (this.ivObjects == null) {
                    msb.append("No Limits specified");
                } else if (this.ivObjects.length == 2) {
                    String un = this.ivUnit.trim();
                    msb.append("Lower Limit:\t").append(this.ivObjects[0]).append(" ").append(un).append("\n");
                    msb.append("Upper Limit:\t").append(this.ivObjects[1]).append(" ").append(un).append("\n");
                } else {
                    msb.append("No Limits specified");
                }
            } else if (this.ivLastSelected.equals(Experiment.TYPES_CHOICE)) {
                if (this.ivObjects == null) {
                    msb.append("No values specified");
                } else if (this.ivObjects.length != 0) {
                    int i = 0;
                    while (i < this.ivObjects.length) {
                        msb.append("Value ").append(i + 1).append(":\t").append(this.ivObjects[i]).append("\n");
                        ++i;
                    }
                } else {
                    msb.append("No values specified");
                }
            } else if (!(this.ivLastSelected.equals(Experiment.TYPES_FREE) || this.ivLastSelected.equals(Experiment.TYPES_IMAGE) || this.ivLastSelected.equals(Experiment.TYPES_GPS))) {
                this.ivLastSelected.equals(Experiment.TYPES_EMPTY);
            }
        }
        this.ivInfoArea.setText(msb.toString());
    }

    private void setOKState() {
        boolean en = false;
        if (this.ivNameField.getText().trim().length() != 0) {
            if (this.ivLastSelected.equals(Experiment.TYPES_BOOLEAN)) {
                if (this.ivObjects == null) {
                    en = true;
                }
            } else if (this.ivLastSelected.equals(Experiment.TYPES_EMPTY)) {
                if (this.ivObjects == null) {
                    en = true;
                }
            } else if (this.ivLastSelected.equals(Experiment.TYPES_INTEGER)) {
                if (this.ivObjects != null && this.ivObjects.length == 2) {
                    en = true;
                }
            } else if (this.ivLastSelected.equals(Experiment.TYPES_DOUBLE)) {
                if (this.ivObjects != null && this.ivObjects.length == 2) {
                    en = true;
                }
            } else if (this.ivLastSelected.equals(Experiment.TYPES_CHOICE)) {
                if (this.ivObjects != null && this.ivObjects.length != 0) {
                    en = true;
                }
            } else if (this.ivLastSelected.equals(Experiment.TYPES_FREE)) {
                if (this.ivObjects == null) {
                    en = true;
                }
            } else if (this.ivLastSelected.equals(Experiment.TYPES_IMAGE)) {
                if (this.ivObjects == null) {
                    en = true;
                }
            } else if (this.ivLastSelected.equals(Experiment.TYPES_GPS) && this.ivObjects == null) {
                en = true;
            }
        }
        this.ivOkButton.setEnabled(en);
    }

    public void insertUpdate(DocumentEvent e) {
        this.setOKState();
    }

    public void removeUpdate(DocumentEvent e) {
        this.setOKState();
    }

    public void changedUpdate(DocumentEvent e) {
        this.setOKState();
    }

    public void OKPressed() {
        StringBuffer msb = new StringBuffer("EXPNEW");
        msb.append(" ");
        msb.append(Base64Manager.encodeBase64(this.ivNameField.getText().trim()));
        msb.append(" ");
        int exptype = Experiment.getExperimentTypeForString((String)this.ivTypeCombo.getSelectedItem());
        msb.append(exptype);
        msb.append(" ");
        if (exptype == 4 || exptype == 2 || exptype == 3) {
            if (this.ivObjects == null) {
                msb.append("0");
            } else if (this.ivObjects.length == 0) {
                msb.append("0");
            } else {
                msb.append(this.ivObjects.length);
                int i = 0;
                while (i < this.ivObjects.length) {
                    msb.append("@_@");
                    switch (exptype) {
                        case 2: 
                        case 3: {
                            msb.append(this.ivObjects[i]);
                            break;
                        }
                        case 4: {
                            msb.append(Base64Manager.encodeBase64((String)this.ivObjects[i]));
                            break;
                        }
                    }
                    ++i;
                }
            }
        } else {
            msb.append("0");
        }
        msb.append(" ");
        msb.append(UserManager.getIDOFUser());
        msb.append(" ");
        if (this.ivUnit == null) {
            msb.append("#####");
        } else {
            msb.append(Base64Manager.encodeBase64(this.ivUnit));
        }
        InspectorCommandSender.executeCommand(msb.toString(), UserManager.getFirstGroup());
        super.OKPressed();
    }
}

