/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester;

import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import mausoleum.gui.MGButton;
import mausoleum.printing.TablePrinter;
import mausoleum.printing.util.CPPageFormat;
import mausoleum.printing.util.CPPageFormatDialog;
import mausoleum.requester.BasicRequester;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.ui.UIDef;

public class PrintRequester
extends BasicRequester {
    private static final long serialVersionUID = 1L;
    private static final int BUT_WIDTH = UIDef.getScaled(150);
    private static final int BUT_HEIGHT = UIDef.getScaled(30);
    private static final int BUT_SPACE = UIDef.getScaled(4);
    private static final int LP_WIDTH = UIDef.getScaled(180);
    private static final int BUT_X_START = 2 * UIDef.RAND + LP_WIDTH;
    private static final int BREITE = 3 * UIDef.RAND + LP_WIDTH + BUT_WIDTH;
    private static final int HOEHE = 3 * BUT_HEIGHT + 2 * BUT_SPACE + 2 * UIDef.RAND;
    private MausoleumTableModel ivModel;
    private JRadioButton ivAllButton = new JRadioButton("Displayed Objects", true);
    private JRadioButton ivSelButton = new JRadioButton("Selected Objects", false);

    public PrintRequester(Frame sender, MausoleumTableModel model) {
        super(sender, BREITE, HOEHE);
        this.ivModel = model;
        MGButton but = MGButton.getRequesterButton(Babel.get("PREVIEW"));
        but.setActionCommand("PREV");
        but.addActionListener(this);
        this.addAndApplyBounds(but, BUT_X_START, UIDef.RAND, BUT_WIDTH, BUT_HEIGHT);
        but = MGButton.getRequesterButton(Babel.get("PRINT"));
        but.setActionCommand("PRINT");
        but.addActionListener(this);
        this.addAndApplyBounds(but, BUT_X_START, UIDef.RAND + BUT_HEIGHT + BUT_SPACE, BUT_WIDTH, BUT_HEIGHT);
        but = MGButton.getRequesterButton(Babel.get("NO"));
        but.setActionCommand("CANCEL");
        but.addActionListener(this);
        this.addAndApplyBounds(but, BUT_X_START, UIDef.RAND + 2 * (BUT_HEIGHT + BUT_SPACE), BUT_WIDTH, BUT_HEIGHT);
        this.ivAllButton.setOpaque(false);
        this.ivAllButton.setFocusPainted(false);
        this.addAndApplyBounds(this.ivAllButton, UIDef.RAND, UIDef.RAND, LP_WIDTH, UIDef.getScaled(20));
        this.ivSelButton.setOpaque(false);
        this.ivSelButton.setFocusPainted(false);
        if (model != null && model.getSelectedObjects().isEmpty()) {
            this.ivSelButton.setEnabled(false);
        }
        this.addAndApplyBounds(this.ivSelButton, UIDef.RAND, UIDef.RAND + UIDef.getScaled(24), LP_WIDTH, UIDef.getScaled(20));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.ivAllButton);
        bg.add(this.ivSelButton);
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        String comm = e.getActionCommand();
        if (comm.equals("PREV")) {
            this.ivWarOK = true;
            CPPageFormat cpf = CPPageFormatDialog.getPageFormat(null, this, Babel.get("PRINT"), null);
            if (cpf != null) {
                TablePrinter tp = new TablePrinter(this.ivModel, this.ivSelButton.isSelected(), cpf);
                tp.previewIt();
            }
            this.dispose();
        } else if (comm.equals("PRINT")) {
            this.ivWarOK = true;
            CPPageFormat cpf = CPPageFormatDialog.getPageFormat(null, this, Babel.get("PREVIEW"), null);
            if (cpf != null) {
                TablePrinter tp = new TablePrinter(this.ivModel, this.ivSelButton.isSelected(), cpf);
                tp.printIt();
            }
            this.dispose();
        } else if (comm.equals("CANCEL")) {
            this.ivWarOK = false;
            this.dispose();
        }
    }
}

