/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester;

import java.awt.Frame;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import mausoleum.gui.KomfortTextField;
import mausoleum.gui.PermanentLabel;
import mausoleum.gui.documents.PureIntegerDocument;
import mausoleum.helper.FontManager;
import mausoleum.requester.BasicRequester;
import mausoleum.ui.UIDef;

public class Requester
extends BasicRequester {
    private static final long serialVersionUID = 1L;
    private KomfortTextField ivTextField = null;

    public static String getString(Frame sender, String meldung) {
        return Requester.getString(sender, meldung, null);
    }

    public static String getString(Frame sender, String meldung, String stringval) {
        Requester mmr = new Requester(sender, meldung, false, null);
        if (stringval != null) {
            mmr.ivTextField.setText(stringval);
        }
        mmr.setVisible(true);
        if (mmr.ivWarOK) {
            return mmr.ivTextField.getText();
        }
        return null;
    }

    public static String getString(JDialog sender, String meldung, String stringval) {
        Requester mmr = new Requester(sender, meldung, false);
        if (stringval != null) {
            mmr.ivTextField.setText(stringval);
        }
        mmr.setVisible(true);
        if (mmr.ivWarOK) {
            return mmr.ivTextField.getText();
        }
        return null;
    }

    public static String getString(JDialog sender, JFrame senderFrame, String meldung, String stringval, KomfortTextField textfield) {
        Requester mmr = null;
        mmr = sender != null ? new Requester(sender, meldung, textfield) : new Requester(senderFrame, meldung, textfield);
        if (stringval != null) {
            mmr.ivTextField.setText(stringval);
        }
        mmr.setVisible(true);
        if (mmr.ivWarOK) {
            return mmr.ivTextField.getText();
        }
        return null;
    }

    public static int getInt(Frame sender, String meldung, int intVal, boolean useInput, int nullVal, boolean istLeer0, JComponent extraComponent) {
        Requester mmr = new Requester(sender, meldung, true, extraComponent);
        if (useInput) {
            mmr.ivTextField.setText(Integer.toString(intVal));
        }
        mmr.setVisible(true);
        if (mmr.ivWarOK) {
            String res = mmr.ivTextField.getText().trim();
            if (res.length() == 0) {
                if (istLeer0) {
                    return 0;
                }
            } else {
                try {
                    return Integer.parseInt(res);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return nullVal;
    }

    public static long getLong(Frame sender, String meldung, long intVal, boolean useInput, long nullVal, boolean istLeer0) {
        Requester mmr = new Requester(sender, meldung, true, null);
        if (useInput) {
            mmr.ivTextField.setText(Long.toString(intVal));
        }
        mmr.setVisible(true);
        if (mmr.ivWarOK) {
            String res = mmr.ivTextField.getText().trim();
            if (res.length() == 0) {
                if (istLeer0) {
                    return 0L;
                }
            } else {
                try {
                    return Long.parseLong(res);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return nullVal;
    }

    private Requester(Frame sender, String labelText, boolean nurZahlen, JComponent extraComponent) {
        super(sender, -1, -1);
        this.init(labelText, nurZahlen, null, extraComponent);
    }

    private Requester(JDialog sender, String labelText, boolean nurZahlen) {
        super(sender, -1, -1);
        this.init(labelText, nurZahlen, null, null);
    }

    private Requester(JDialog sender, String labelText, KomfortTextField tf) {
        super(sender, -1, -1);
        this.init(labelText, false, tf, null);
    }

    private Requester(JFrame sender, String labelText, KomfortTextField tf) {
        super((Frame)sender, -1, -1);
        this.init(labelText, false, tf, null);
    }

    private void init(String labelText, boolean nurZahlen, KomfortTextField tf, JComponent extraComponent) {
        if (tf != null) {
            this.ivTextField = tf;
        } else if (nurZahlen) {
            this.ivTextField = new KomfortTextField();
            this.ivTextField.setDocument(new PureIntegerDocument(this.ivTextField));
        } else {
            this.ivTextField = new KomfortTextField();
        }
        this.ivTextField.setFont(FontManager.getFont("SSB13"));
        this.ivTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Requester.this.ivTextField.selectAll();
            }
        });
        this.addReturnEqualsOKKeyListener(this.ivTextField);
        int y = UIDef.RAND;
        int fieldWidth = UIDef.getScaled(110);
        PermanentLabel pl = this.addPermanentLabel(labelText, UIDef.RAND, y, UIDef.LINE_HEIGHT);
        int labw = pl.preferredWidth();
        int innerwidth = labw + UIDef.INNER_RAND + fieldWidth;
        int gesWidth = UIDef.RAND + innerwidth + UIDef.RAND;
        this.addAndApplyBounds(this.ivTextField, labw + 2 * UIDef.RAND, y, fieldWidth, UIDef.LINE_HEIGHT);
        y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND;
        if (extraComponent != null) {
            this.addAndApplyBounds(extraComponent, UIDef.RAND, y, innerwidth, UIDef.LINE_HEIGHT);
            y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND;
        }
        int lbw = (innerwidth - UIDef.RAND) / 2;
        int rbw = innerwidth - UIDef.RAND - lbw;
        this.applyBounds(this.ivOkButton, UIDef.RAND, y, lbw, UIDef.BUT_HEIGHT);
        this.applyBounds(this.ivNoButton, UIDef.RAND + lbw + UIDef.RAND, y, rbw, UIDef.BUT_HEIGHT);
        this.setInnerSize(gesWidth, y += UIDef.BUT_HEIGHT + UIDef.RAND);
    }
}

