/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.calendar;

import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import mausoleum.gui.FlexGridLayout;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.mouse.TaskExtended;
import mausoleum.requester.calendar.CalendarPanel;
import mausoleum.requester.calendar.WeekdayPanel;
import mausoleum.search.profisearch.display.SDDateSelector;
import mausoleum.ui.UIDef;

public class TRPeriodPanel
extends RequesterPane {
    private static final long serialVersionUID = 123434523L;
    private boolean ivReact = true;
    private SDDateSelector ivStartSelector = new SDDateSelector(false, true);
    private SDDateSelector ivEndSelector = new SDDateSelector(false, true);
    private JComboBox ivFrequencyCombo = new JComboBox<String>(Babel.get(TaskExtended.FREQ_STRINGS, true));
    private MGButton ivButtonToEnable = null;
    private WeekdayPanel ivWeekdayPanel = new WeekdayPanel(new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (TRPeriodPanel.this.ivButtonToEnable != null && TRPeriodPanel.this.ivWeekdayPanel != null) {
                TRPeriodPanel.this.check();
            }
        }
    }, true);
    private Runnable ivExchanger = new Runnable(){

        public void run() {
            int sd = TRPeriodPanel.this.ivStartSelector.getDatum();
            int ed = TRPeriodPanel.this.ivEndSelector.getDatum();
            TRPeriodPanel.this.ivReact = false;
            TRPeriodPanel.this.ivStartSelector.setDatum(ed);
            TRPeriodPanel.this.ivEndSelector.setDatum(sd);
            TRPeriodPanel.this.ivReact = true;
        }
    };

    public TRPeriodPanel() {
        super(new SimpleLayoutManager(){

            public void layoutContainer(Container arg0) {
                Dimension d = arg0.getSize();
                Component c = arg0.getComponent(0);
                if (c != null) {
                    Dimension ps = c.getPreferredSize();
                    int x = (d.width - ps.width) / 2;
                    int y = (d.height - ps.height) / 2;
                    c.setBounds(x, y, ps.width, ps.height);
                }
            }
        });
        JPanel innerPanel = new JPanel(new FlexGridLayout(4, 2, UIDef.INNER_RAND, UIDef.INNER_RAND, true, false)){
            private static final long serialVersionUID = 22342342341L;

            public Dimension getPreferredSize() {
                return this.getLayout().preferredLayoutSize(this);
            }
        };
        innerPanel.add(new JLabel(Babel.get("START")));
        innerPanel.add(this.ivStartSelector);
        innerPanel.add(new JLabel(Babel.get("END")));
        innerPanel.add(this.ivEndSelector);
        innerPanel.add(new JLabel(Babel.get("FREQUENCY")));
        innerPanel.add(this.ivFrequencyCombo);
        innerPanel.add(new JLabel(" "));
        innerPanel.add(this.ivWeekdayPanel);
        innerPanel.setPreferredSize(innerPanel.getLayout().preferredLayoutSize(innerPanel));
        this.ivWeekdayPanel.setVisible(false);
        this.ivFrequencyCombo.setPreferredSize(new Dimension(100, UIDef.LINE_HEIGHT));
        this.ivFrequencyCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (TRPeriodPanel.this.ivWeekdayPanel != null) {
                    boolean vidNach;
                    boolean vidVor = TRPeriodPanel.this.ivWeekdayPanel.isVisible();
                    boolean bl = vidNach = TaskExtended.FREQ_INTS[TRPeriodPanel.this.ivFrequencyCombo.getSelectedIndex()] == 128;
                    if (vidVor != vidNach) {
                        TRPeriodPanel.this.ivWeekdayPanel.setVisible(vidNach);
                        TRPeriodPanel.this.repaint();
                    }
                }
                TRPeriodPanel.this.check();
            }
        });
        innerPanel.setOpaque(false);
        innerPanel.setPreferredSize(new Dimension(CalendarPanel.BREITE - 120, 3 * UIDef.LINE_HEIGHT + 2 * UIDef.INNER_RAND));
        CaretListener cl = new CaretListener(){

            public void caretUpdate(CaretEvent arg0) {
                TRPeriodPanel.this.check();
            }
        };
        this.ivStartSelector.getTextField().addCaretListener(cl);
        this.ivEndSelector.getTextField().addCaretListener(cl);
        this.add(innerPanel);
    }

    public void selectFrequency(int freqType) {
        int ind = ArrayHelper.findIndexInArray(freqType, TaskExtended.FREQ_INTS);
        this.ivFrequencyCombo.setSelectedIndex(ind == -1 ? 0 : ind);
    }

    public void setEndDate(int date) {
        this.ivEndSelector.setDatum(date);
    }

    public void check() {
        if (this.ivReact) {
            boolean beide;
            int sd = this.ivStartSelector.getDatum();
            int ed = this.ivEndSelector.getDatum();
            boolean bl = beide = this.ivStartSelector.getDatum() != Integer.MIN_VALUE && this.ivEndSelector.getDatum() != Integer.MIN_VALUE;
            if (beide) {
                if (sd > ed) {
                    SwingUtilities.invokeLater(this.ivExchanger);
                } else if (sd == ed) {
                    beide = false;
                }
            }
            if (beide && this.ivFrequencyCombo.getSelectedIndex() == 0) {
                beide = false;
            }
            if (this.ivButtonToEnable != null) {
                boolean enableBut = beide;
                if (this.ivWeekdayPanel.isVisible()) {
                    enableBut &= this.ivWeekdayPanel.getAnzPressedWeekdays() > 1;
                }
                this.ivButtonToEnable.setEnabled(enableBut);
            }
        }
    }

    public void setButtonToEnable(MGButton but) {
        this.ivButtonToEnable = but;
    }

    public void setStart(int date) {
        this.ivStartSelector.setDatum(date);
    }

    public void setEnd(int date) {
        this.ivEndSelector.setDatum(date);
    }

    public void setFrequenz(int frequenz) {
        int ind = 0;
        if (frequenz >= 0) {
            int weekDayRef = TaskExtended.getWeekDayPatternIfRelevant(frequenz);
            if (weekDayRef != -1) {
                if (this.ivWeekdayPanel != null) {
                    this.ivWeekdayPanel.setPressedWeekdaysForSubFreq(weekDayRef);
                    this.ivWeekdayPanel.setVisible(true);
                }
                frequenz = 128;
            }
            ind = ArrayHelper.findIndexInArray(frequenz, TaskExtended.FREQ_INTS);
        }
        this.ivFrequencyCombo.setSelectedIndex(ind);
    }

    public int getStart() {
        return this.ivStartSelector.getDatum();
    }

    public int getEnd() {
        return this.ivEndSelector.getDatum();
    }

    public int getFrequenz() {
        int freq = TaskExtended.FREQ_INTS[this.ivFrequencyCombo.getSelectedIndex()];
        if (freq == 128) {
            freq += this.ivWeekdayPanel.getPressedWeekdaysForSubFreq();
        }
        return freq;
    }
}

