/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.calendar;

import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import mausoleum.gui.FlexGridLayout;
import mausoleum.gui.IntegerField;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.mouse.TaskExtended;
import mausoleum.requester.calendar.CalendarPanel;
import mausoleum.ui.UIDef;

public class TRPeriodPanelWorkFlow
extends RequesterPane {
    private static final long serialVersionUID = 123434523L;
    private IntegerField ivStartSelector = new IntegerField();
    private IntegerField ivEndSelector = new IntegerField();
    private JComboBox ivFrequencyCombo = new JComboBox<String>(Babel.get(TaskExtended.FREQ_STRINGS, true));
    private MGButton ivButtonToEnable = null;

    public TRPeriodPanelWorkFlow() {
        super(new SimpleLayoutManager(){

            public void layoutContainer(Container arg0) {
                Dimension d = arg0.getSize();
                Component c = arg0.getComponent(0);
                if (c != null) {
                    Dimension ps = c.getPreferredSize();
                    int x = (d.width - ps.width) / 2;
                    int y = (d.height - ps.height) / 2;
                    c.setBounds(x, y, ps.width, ps.height);
                }
            }
        });
        JPanel innerPanel = new JPanel(new FlexGridLayout(3, 2, UIDef.INNER_RAND, UIDef.INNER_RAND, true, false));
        innerPanel.add(new JLabel(Babel.get("START_RELATIVE")));
        innerPanel.add(this.ivStartSelector);
        innerPanel.add(new JLabel(Babel.get("END_RELATIVE")));
        innerPanel.add(this.ivEndSelector);
        innerPanel.add(new JLabel(Babel.get("FREQUENCY")));
        innerPanel.add(this.ivFrequencyCombo);
        this.ivFrequencyCombo.setPreferredSize(new Dimension(100, UIDef.LINE_HEIGHT));
        this.ivFrequencyCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TRPeriodPanelWorkFlow.this.check();
            }
        });
        innerPanel.setOpaque(false);
        innerPanel.setPreferredSize(new Dimension(CalendarPanel.BREITE - 120, 3 * UIDef.LINE_HEIGHT + 2 * UIDef.INNER_RAND));
        CaretListener cl = new CaretListener(){

            public void caretUpdate(CaretEvent arg0) {
                TRPeriodPanelWorkFlow.this.check();
            }
        };
        this.ivStartSelector.addCaretListener(cl);
        this.ivEndSelector.addCaretListener(cl);
        this.add(innerPanel);
    }

    public void check() {
        if (this.ivButtonToEnable != null) {
            int sd = this.ivStartSelector.getInt(Integer.MIN_VALUE);
            int ed = this.ivEndSelector.getInt(Integer.MIN_VALUE);
            boolean enabled = sd != Integer.MIN_VALUE && ed != Integer.MIN_VALUE && this.ivFrequencyCombo.getSelectedIndex() != 0;
            this.ivButtonToEnable.setEnabled(enabled);
        }
    }

    public void setButtonToEnable(MGButton but) {
        this.ivButtonToEnable = but;
    }

    public void setStart(int date) {
        this.ivStartSelector.setInt(date);
    }

    public void setEnd(int date) {
        this.ivEndSelector.setInt(date);
    }

    public void setFrequenz(int frequenz) {
        this.ivFrequencyCombo.setSelectedIndex(ArrayHelper.findIndexInArray(frequenz, TaskExtended.FREQ_INTS));
    }

    public int getStart() {
        return this.ivStartSelector.getInt(Integer.MIN_VALUE);
    }

    public int getEnd() {
        return this.ivEndSelector.getInt(Integer.MIN_VALUE);
    }

    public int getFrequenz() {
        return TaskExtended.FREQ_INTS[this.ivFrequencyCombo.getSelectedIndex()];
    }
}

