/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.calendar;

import java.awt.GridLayout;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import mausoleum.gui.MToggleButton;
import mausoleum.helper.DatumFormat;
import mausoleum.util.calendar.InstituteHolidays;

public class WeekdayPanel
extends JPanel {
    private static final long serialVersionUID = 112325345615235L;
    public static final int[] SUB_FREQS = new int[]{2, 4, 8, 16, 32, 64, 1};
    public static final int[] SUB_FREQ_DAYS;
    private MToggleButton[] ivWeekdayButtons = new MToggleButton[7];

    static {
        int[] nArray = new int[7];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        SUB_FREQ_DAYS = nArray;
    }

    public WeekdayPanel(ActionListener weekDayListener, boolean showWeekEnd) {
        super(new GridLayout(1, 7, 0, 0));
        this.setOpaque(false);
        int wochentag = 0;
        while (wochentag < this.ivWeekdayButtons.length) {
            MToggleButton but = new MToggleButton(DatumFormat.weekday(wochentag));
            if (weekDayListener != null) {
                but.addActionListener(weekDayListener);
            }
            if (showWeekEnd && InstituteHolidays.isWeeklyDayOff(wochentag)) {
                but.setImageKey("yellowButton");
            }
            this.ivWeekdayButtons[wochentag] = but;
            this.add(but);
            ++wochentag;
        }
    }

    public int getAnzPressedWeekdays() {
        int anz = 0;
        int i = 0;
        while (i < this.ivWeekdayButtons.length) {
            if (this.ivWeekdayButtons[i].isPressed()) {
                ++anz;
            }
            ++i;
        }
        return anz;
    }

    public int[] getPressedWeekdays() {
        int[] res = null;
        int anz = this.getAnzPressedWeekdays();
        if (anz != 0) {
            res = new int[anz];
            int col = 0;
            int i = 0;
            while (i < this.ivWeekdayButtons.length) {
                if (this.ivWeekdayButtons[i].isPressed()) {
                    res[col++] = i;
                }
                ++i;
            }
        }
        return res;
    }

    public void setPressedWeekdays(int[] arr) {
        int i = 0;
        while (i < this.ivWeekdayButtons.length) {
            this.ivWeekdayButtons[i].setPressed(false);
            ++i;
        }
        if (arr != null) {
            i = 0;
            while (i < arr.length) {
                if (arr[i] >= 0 && arr[i] < this.ivWeekdayButtons.length) {
                    this.ivWeekdayButtons[arr[i]].setPressed(true);
                }
                ++i;
            }
        }
    }

    public void setPressedWeekdaysForSubFreq(int weekDayDef) {
        int i = 0;
        while (i < this.ivWeekdayButtons.length) {
            this.ivWeekdayButtons[i].setPressed(false);
            ++i;
        }
        if (weekDayDef != 0) {
            i = 0;
            while (i < this.ivWeekdayButtons.length) {
                if ((weekDayDef & SUB_FREQS[i]) != 0) {
                    this.ivWeekdayButtons[i].setPressed(true);
                }
                ++i;
            }
        }
    }

    public int getPressedWeekdaysForSubFreq() {
        int sum = 0;
        int i = 0;
        while (i < this.ivWeekdayButtons.length) {
            if (this.ivWeekdayButtons[i].isPressed()) {
                sum += SUB_FREQS[i];
            }
            ++i;
        }
        return sum;
    }
}

