/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.color;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.ListCellRenderer;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import mausoleum.gui.MGButton;
import mausoleum.gui.MusterColor;
import mausoleum.helper.FontManager;
import mausoleum.helper.MusterHelper;
import mausoleum.inspector.Inspector;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.color.ColorTestLabel;
import mausoleum.ui.UIDef;

public class ColorRequester
extends BasicRequester
implements AdjustmentListener {
    private static final long serialVersionUID = 1L;
    private static final int SLIDER_WIDTH = UIDef.getScaled(260);
    private static final int SLIDER_HEIGHT = UIDef.getScaled(22);
    private static final int INTER_SLIDER_MARGIN = UIDef.getScaled(4);
    private static final int SLIDER_LABEL_WIDTH = UIDef.getScaled(14);
    private static final int CLABEL_X = UIDef.RAND;
    private static final int CLABEL_WIDTH = UIDef.getScaled(70);
    private static final int CLABEL_HEIGHT = 4 * SLIDER_HEIGHT + 3 * INTER_SLIDER_MARGIN;
    private static final int BUTTON_X = CLABEL_X + CLABEL_WIDTH + UIDef.INNER_RAND;
    private static final int SLIDER_X = BUTTON_X + SLIDER_LABEL_WIDTH;
    private static final int COMBO_HEIGHT = UIDef.getScaled(24);
    private static final int IBREITE = CLABEL_WIDTH + UIDef.INNER_RAND + SLIDER_WIDTH;
    private static final int BREITE = UIDef.RAND + IBREITE + UIDef.RAND;
    private static final int LBUT_WITDH = (IBREITE - UIDef.INNER_RAND) / 2;
    private static final int RBUT_WITDH = IBREITE - UIDef.INNER_RAND - LBUT_WITDH;
    private static final int IHOEHE_OHNE = CLABEL_HEIGHT + UIDef.INNER_RAND + COMBO_HEIGHT + UIDef.INNER_RAND + CLABEL_HEIGHT + UIDef.INNER_RAND + UIDef.INNER_RAND + UIDef.BUT_HEIGHT;
    private static final int HOEHE_OHNE = UIDef.RAND + IHOEHE_OHNE + UIDef.RAND;
    private static final int IHOEHE_SIMPLE_OHNE = CLABEL_HEIGHT + UIDef.INNER_RAND + UIDef.INNER_RAND + UIDef.BUT_HEIGHT;
    private static final int HOEHE_SIMPLE_OHNE = UIDef.RAND + IHOEHE_SIMPLE_OHNE + UIDef.RAND;
    private static final int COMBO_MUSTER_DIM = UIDef.getScaled(16);
    private static final int CMD_WIDTH = COMBO_MUSTER_DIM * 3;
    private static final int CMD_HEIGHT = COMBO_MUSTER_DIM;
    private static final HashMap ICONS = new HashMap();
    private JLabel ivColorLabel = new JLabel();
    private JScrollBar ivRedSlider = new JScrollBar(0, 0, 1, 0, 256);
    private JScrollBar ivGreenSlider = new JScrollBar(0, 0, 1, 0, 256);
    private JScrollBar ivBlueSlider = new JScrollBar(0, 0, 1, 0, 256);
    private MGButton ivReqBut = new MGButton(Babel.get("BIG_COLOR_REQUESTER"));
    private ColorTestLabel ivTestLabel = new ColorTestLabel();
    private JLabel ivMusterLabel = null;
    private JComboBox ivMusterCombo = null;
    private JLabel ivComboLabel = null;
    private JLabel ivColorLabel2 = null;
    private JScrollBar ivRedSlider2 = null;
    private JScrollBar ivGreenSlider2 = null;
    private JScrollBar ivBlueSlider2 = null;
    private MGButton ivReqBut2 = null;
    private MusterColor ivColor;
    private boolean ivReact = true;

    public static Color getNewColor(Color orig, boolean musterModus) {
        ColorRequester cr = new ColorRequester(orig, Inspector.getInspector(), musterModus);
        cr.setVisible(true);
        if (cr.ivWarOK) {
            if (musterModus) {
                if (cr.ivColor.ivMuster == 0) {
                    return new Color(cr.ivColor.getRGB());
                }
                return cr.ivColor;
            }
            return new Color(cr.ivColor.getRGB());
        }
        return null;
    }

    private ColorRequester(Color orig, Frame sender, boolean musterModus) {
        super(sender, BREITE, (musterModus ? HOEHE_OHNE : HOEHE_SIMPLE_OHNE) + FontManager.getTableFont(true, false, 1.0).getSize() + 8);
        int testLHeight = FontManager.getTableFont(true, false, 1.0).getSize() + 8;
        this.setTitle(Babel.get("SELECTCOLOR"));
        this.ivColor = musterModus ? (orig == null ? new MusterColor(Color.white, Color.white, 0) : (orig instanceof MusterColor ? (MusterColor)orig : new MusterColor(orig, Color.white, 0))) : new MusterColor(orig, Color.white, 0);
        this.ivColorLabel.setOpaque(true);
        this.ivColorLabel.setBackground(this.ivColor);
        this.ivColorLabel.setBorder(new BevelBorder(1, Color.white, Color.lightGray, Color.black, Color.darkGray));
        this.ivRedSlider.addAdjustmentListener(this);
        this.ivRedSlider.setValue(this.ivColor.getRed());
        this.ivGreenSlider.addAdjustmentListener(this);
        this.ivGreenSlider.setValue(this.ivColor.getGreen());
        this.ivBlueSlider.addAdjustmentListener(this);
        this.ivBlueSlider.setValue(this.ivColor.getBlue());
        int y = UIDef.RAND;
        this.addAndApplyBounds(this.ivColorLabel, CLABEL_X, y, CLABEL_WIDTH, CLABEL_HEIGHT);
        this.addPermanentLabel("R", BUTTON_X, y, SLIDER_HEIGHT);
        this.addAndApplyBounds(this.ivRedSlider, SLIDER_X, y, SLIDER_WIDTH - SLIDER_LABEL_WIDTH, SLIDER_HEIGHT);
        this.addPermanentLabel("G", BUTTON_X, y += SLIDER_HEIGHT + INTER_SLIDER_MARGIN, SLIDER_HEIGHT);
        this.addAndApplyBounds(this.ivGreenSlider, SLIDER_X, y, SLIDER_WIDTH - SLIDER_LABEL_WIDTH, SLIDER_HEIGHT);
        this.addPermanentLabel("B", BUTTON_X, y += SLIDER_HEIGHT + INTER_SLIDER_MARGIN, SLIDER_HEIGHT);
        this.addAndApplyBounds(this.ivBlueSlider, SLIDER_X, y, SLIDER_WIDTH - SLIDER_LABEL_WIDTH, SLIDER_HEIGHT);
        this.ivReqBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Color col = JColorChooser.showDialog(ColorRequester.this.ivReqBut, Babel.get("SELECTCOLOR"), ColorRequester.this.ivColor);
                if (col != null) {
                    ColorRequester.this.ivReact = false;
                    ColorRequester.this.ivRedSlider.setValue(col.getRed());
                    ColorRequester.this.ivGreenSlider.setValue(col.getGreen());
                    ColorRequester.this.ivBlueSlider.setValue(col.getBlue());
                    ColorRequester.this.ivReact = true;
                    ColorRequester.this.changeColor(col.getRed(), col.getGreen(), col.getBlue(), true);
                }
            }
        });
        this.addAndApplyBounds(this.ivReqBut, BUTTON_X, y += SLIDER_HEIGHT + INTER_SLIDER_MARGIN, SLIDER_WIDTH, SLIDER_HEIGHT);
        y += SLIDER_HEIGHT;
        y += UIDef.INNER_RAND;
        if (musterModus) {
            this.ivMusterLabel = new JLabel(Babel.get("PATTERN"));
            this.ivMusterCombo = new JComboBox<Integer>(MusterHelper.MUSTER_INTS);
            this.ivComboLabel = new JLabel();
            this.ivMusterLabel.setFont(FontManager.getFont("SSB12"));
            this.addAndApplyBounds(this.ivMusterLabel, CLABEL_X, y, CLABEL_WIDTH, COMBO_HEIGHT);
            this.ivMusterCombo.setSelectedItem(new Integer(this.ivColor.ivMuster));
            this.manageMusterSelection();
            this.ivMusterCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Integer inti = (Integer)ColorRequester.this.ivMusterCombo.getSelectedItem();
                    ColorRequester.this.ivColor = new MusterColor(ColorRequester.this.ivColor, ((ColorRequester)ColorRequester.this).ivColor.ivSecondColor, (int)inti);
                    ColorRequester.this.manageMusterSelection();
                }
            });
            this.ivComboLabel.setHorizontalAlignment(0);
            this.ivComboLabel.setBorder(new EmptyBorder(UIDef.getScaled(3), 0, UIDef.getScaled(3), 0));
            this.ivMusterCombo.setRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Integer musterKey = (Integer)value;
                    ImageIcon icon = (ImageIcon)ICONS.get(musterKey);
                    if (icon == null) {
                        BufferedImage img = new BufferedImage(CMD_WIDTH, CMD_HEIGHT, 1);
                        Graphics g = img.getGraphics();
                        int muster = musterKey;
                        if (muster == 0) {
                            g.setColor(Color.gray);
                            g.fillRect(0, 0, CMD_WIDTH, CMD_HEIGHT);
                        } else {
                            MusterColor mcol = new MusterColor(Color.gray, Color.white, muster);
                            mcol.fill(new Dimension(CMD_WIDTH, CMD_HEIGHT), g);
                        }
                        g.setColor(Color.black);
                        g.drawRect(0, 0, CMD_WIDTH - 1, CMD_HEIGHT - 1);
                        icon = new ImageIcon(img);
                        ICONS.put(musterKey, icon);
                    }
                    ColorRequester.this.ivComboLabel.setIcon(icon);
                    return ColorRequester.this.ivComboLabel;
                }
            });
            this.addAndApplyBounds(this.ivMusterCombo, BUTTON_X, y, SLIDER_WIDTH, COMBO_HEIGHT);
            y += COMBO_HEIGHT + UIDef.INNER_RAND;
            this.ivColorLabel2 = new JLabel();
            this.ivRedSlider2 = new JScrollBar(0, 0, 1, 0, 256);
            this.ivGreenSlider2 = new JScrollBar(0, 0, 1, 0, 256);
            this.ivBlueSlider2 = new JScrollBar(0, 0, 1, 0, 256);
            this.ivReqBut2 = new MGButton(Babel.get("BIG_COLOR_REQUESTER"));
            this.ivColorLabel2.setOpaque(true);
            this.ivColorLabel2.setBackground(this.ivColor.ivSecondColor);
            this.ivColorLabel2.setBorder(new BevelBorder(1, Color.white, Color.lightGray, Color.black, Color.darkGray));
            this.ivRedSlider2.addAdjustmentListener(this);
            this.ivRedSlider2.setValue(this.ivColor.ivSecondColor.getRed());
            this.ivGreenSlider2.addAdjustmentListener(this);
            this.ivGreenSlider2.setValue(this.ivColor.ivSecondColor.getGreen());
            this.ivBlueSlider2.addAdjustmentListener(this);
            this.ivBlueSlider2.setValue(this.ivColor.ivSecondColor.getBlue());
            this.addAndApplyBounds(this.ivColorLabel2, CLABEL_X, y, CLABEL_WIDTH, CLABEL_HEIGHT);
            this.addPermanentLabel("R", BUTTON_X, y, SLIDER_HEIGHT);
            this.addAndApplyBounds(this.ivRedSlider2, SLIDER_X, y, SLIDER_WIDTH - SLIDER_LABEL_WIDTH, SLIDER_HEIGHT);
            this.addPermanentLabel("G", BUTTON_X, y += SLIDER_HEIGHT + INTER_SLIDER_MARGIN, SLIDER_HEIGHT);
            this.addAndApplyBounds(this.ivGreenSlider2, SLIDER_X, y, SLIDER_WIDTH - SLIDER_LABEL_WIDTH, SLIDER_HEIGHT);
            this.addPermanentLabel("B", BUTTON_X, y += SLIDER_HEIGHT + INTER_SLIDER_MARGIN, SLIDER_HEIGHT);
            this.addAndApplyBounds(this.ivBlueSlider2, SLIDER_X, y, SLIDER_WIDTH - SLIDER_LABEL_WIDTH, SLIDER_HEIGHT);
            this.ivReqBut2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    Color col = JColorChooser.showDialog(ColorRequester.this.ivReqBut2, Babel.get("SELECTCOLOR"), ColorRequester.this.ivColor);
                    if (col != null) {
                        ColorRequester.this.ivReact = false;
                        ColorRequester.this.ivRedSlider2.setValue(col.getRed());
                        ColorRequester.this.ivGreenSlider2.setValue(col.getGreen());
                        ColorRequester.this.ivBlueSlider2.setValue(col.getBlue());
                        ColorRequester.this.ivReact = true;
                        ColorRequester.this.changeColor(col.getRed(), col.getGreen(), col.getBlue(), false);
                    }
                }
            });
            this.addAndApplyBounds(this.ivReqBut2, BUTTON_X, y += SLIDER_HEIGHT + INTER_SLIDER_MARGIN, SLIDER_WIDTH, SLIDER_HEIGHT);
            y += SLIDER_HEIGHT;
            y += UIDef.INNER_RAND;
        }
        this.addAndApplyBounds(this.ivTestLabel, UIDef.RAND, y, IBREITE, testLHeight);
        this.applyBounds(this.ivOkButton, UIDef.RAND, y += testLHeight + UIDef.INNER_RAND, LBUT_WITDH, UIDef.BUT_HEIGHT);
        this.applyBounds(this.ivNoButton, UIDef.RAND + LBUT_WITDH + UIDef.INNER_RAND, y, RBUT_WITDH, UIDef.BUT_HEIGHT);
    }

    private void manageMusterSelection() {
        if (this.ivColor.ivMuster == 0) {
            if (this.ivRedSlider2 != null) {
                this.ivRedSlider2.setEnabled(false);
                this.ivGreenSlider2.setEnabled(false);
                this.ivBlueSlider2.setEnabled(false);
                this.ivReqBut2.setEnabled(false);
                this.ivColorLabel2.setOpaque(false);
            }
        } else if (this.ivRedSlider2 != null) {
            this.ivRedSlider2.setEnabled(true);
            this.ivGreenSlider2.setEnabled(true);
            this.ivBlueSlider2.setEnabled(true);
            this.ivReqBut2.setEnabled(true);
            this.ivColorLabel2.setOpaque(true);
        }
        this.ivTestLabel.setBackground(this.ivColor);
        this.ivTestLabel.repaint();
        if (this.ivColorLabel2 != null) {
            this.ivColorLabel2.repaint();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (this.ivReact) {
            if (e.getSource() == this.ivRedSlider) {
                this.changeColor(e.getValue(), this.ivColor.getGreen(), this.ivColor.getBlue(), true);
            } else if (e.getSource() == this.ivGreenSlider) {
                this.changeColor(this.ivColor.getRed(), e.getValue(), this.ivColor.getBlue(), true);
            } else if (e.getSource() == this.ivBlueSlider) {
                this.changeColor(this.ivColor.getRed(), this.ivColor.getGreen(), e.getValue(), true);
            } else if (e.getSource() == this.ivRedSlider2) {
                this.changeColor(e.getValue(), this.ivColor.ivSecondColor.getGreen(), this.ivColor.ivSecondColor.getBlue(), false);
            } else if (e.getSource() == this.ivGreenSlider2) {
                this.changeColor(this.ivColor.ivSecondColor.getRed(), e.getValue(), this.ivColor.ivSecondColor.getBlue(), false);
            } else if (e.getSource() == this.ivBlueSlider2) {
                this.changeColor(this.ivColor.ivSecondColor.getRed(), this.ivColor.ivSecondColor.getGreen(), e.getValue(), false);
            }
        }
    }

    private void changeColor(int r, int g, int b, boolean first) {
        if (first) {
            this.ivColor = new MusterColor(r, g, b, this.ivColor.ivSecondColor, this.ivColor.ivMuster);
            this.ivColorLabel.setBackground(this.ivColor);
        } else {
            this.ivColor = new MusterColor(this.ivColor, new Color(r, g, b), this.ivColor.ivMuster);
            this.ivColorLabel2.setBackground(this.ivColor.ivSecondColor);
        }
        this.ivTestLabel.setBackground(this.ivColor);
        this.ivTestLabel.repaint();
    }
}

