/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.color;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JLabel;
import javax.swing.border.LineBorder;
import mausoleum.gui.ColorManager;
import mausoleum.gui.MusterColor;
import mausoleum.helper.FontManager;
import mausoleum.main.DefaultManager;
import mausoleum.rack.frame.CageDisplayManager;

public class ColorTestLabel
extends JLabel {
    private static final long serialVersionUID = 14546L;
    private static final String NORM_TEXT = "Test ";
    private static final String CAGE_TEXT = "1234";
    private int ivX1 = 0;
    private int ivX2 = 0;
    private int ivY = 0;

    public ColorTestLabel() {
        this.setFont(FontManager.getTableFont(true, false, 1.0));
        this.setText("Test 1234");
        this.setHorizontalAlignment(0);
        this.setBorder(new LineBorder(Color.black));
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        Color bg = this.getBackground();
        if (bg instanceof MusterColor) {
            MusterColor mc = (MusterColor)bg;
            mc.fill(d, g);
        } else {
            g.setColor(bg);
            g.fillRect(0, 0, d.width, d.height);
        }
        g.setColor(ColorManager.getForegroundColorForBackground(bg));
        g.setFont(this.getFont());
        if (this.ivX1 == 0) {
            FontMetrics fm = g.getFontMetrics();
            int w1 = fm.stringWidth(NORM_TEXT);
            int w2 = fm.stringWidth(CAGE_TEXT);
            int wg = w1 + w2;
            int rw = d.width - wg;
            this.ivX1 = rw / 2;
            this.ivX2 = this.ivX1 + w1;
            int ma = fm.getMaxAscent();
            int md = fm.getMaxDescent();
            int rest = (d.height - ma - md) / 2;
            this.ivY = rest + ma;
        }
        g.drawString(NORM_TEXT, this.ivX1, this.ivY);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        CageDisplayManager.drawNumberAtPoint(g, this.ivX2, this.ivY, CAGE_TEXT, true, DefaultManager.getMaskCagesMode());
        super.paintBorder(g);
    }
}

