/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.columns;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.MGButton;
import mausoleum.gui.dnd.DNDHandler;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.inspector.Inspector;
import mausoleum.requester.BasicRequester;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.ui.UIDef;

public class ArrangeColumnRequester
extends BasicRequester
implements ListCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Color SPECIFIC_COLOR = Color.black;
    private static final Color GENERAL_COLOR = UIDef.NOT_MINE_FOREGROUND;
    public static final int BREITE = UIDef.getScaled(800);
    private static final int HOEHE = UIDef.getScaled(650);
    private static final int INNER_BREITE = BREITE - 2 * UIDef.RAND;
    private JList ivUsedColumnsList = null;
    private JList ivNotUsedColumnsList = null;
    private JLabel ivObjectLabel = new JLabel();
    private MGButton ivMoveObjectUpButton = MGButton.getRequesterButton(Babel.get("MOVEUPOBJECT"));
    private MGButton ivMoveObjectDownButton = MGButton.getRequesterButton(Babel.get("MOVEDOWNOBJECT"));
    private MGButton ivUseColumnButton = MGButton.getRequesterButton(Babel.get("USECOLUMN"));
    private MGButton ivDontUseColumnButton = MGButton.getRequesterButton(Babel.get("DONTUSECOLUMN"));
    private final Vector ivUsed = new Vector();
    private final Vector ivNotUsed;
    private final HashSet ivColored = new HashSet();
    private final HashSet ivColoredOriginal = new HashSet();
    private final String[] ivColorableColumns;
    private final String[] ivToolTipDict;
    private MausoleumTableModel ivDemoModel;
    private MausoleumTable ivDemoTable;
    private final Vector ivSelectedColumnKennungen = new Vector();
    private boolean ivReact = true;

    public static void arrange(MausoleumTableModel mtm) {
        ArrangeColumnRequester acr = new ArrangeColumnRequester((Frame)Inspector.getInspector(), mtm, mtm.getDisplayName(), Babel.get("ARRANGECOLS"));
        acr.setVisible(true);
        if (acr.ivWarOK) {
            mtm.setDefinedColumnNames(acr.ivUsed, acr.ivColored);
        }
    }

    private ArrangeColumnRequester(Frame sender, MausoleumTableModel mausoleumTableModel, String topLabel, String title) {
        this(sender, mausoleumTableModel, topLabel, title, mausoleumTableModel.ivColouredColumns, mausoleumTableModel.getColorableColumns(), mausoleumTableModel.getAllTooltipDict(), mausoleumTableModel.getAllPossibleColumns(), mausoleumTableModel.getDefinedColumnNames());
    }

    private ArrangeColumnRequester(Frame sender, MausoleumTableModel mausoleumTableModel, String topLabel, String title, HashSet coloredOriginal, String[] colorableColumns, String[] tooltipDict, String[] allPossibleColumns, Vector usedColumns) {
        super(sender, BREITE, HOEHE);
        super.setTitle(title);
        if (coloredOriginal != null) {
            this.ivColoredOriginal.addAll(coloredOriginal);
        }
        this.ivColorableColumns = colorableColumns;
        this.ivToolTipDict = tooltipDict;
        this.ivNotUsed = new Vector(allPossibleColumns.length);
        int i = 0;
        while (i < allPossibleColumns.length) {
            this.ivNotUsed.addElement(allPossibleColumns[i]);
            ++i;
        }
        this.ivUsed.addAll(usedColumns);
        Iterator iter = this.ivUsed.iterator();
        while (iter.hasNext()) {
            this.ivNotUsed.removeElement(iter.next());
        }
        Comparator sorter = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 instanceof String && arg1 instanceof String) {
                    String s0 = (String)arg0;
                    String s1 = (String)arg1;
                    return ArrangeColumnRequester.this.getDisplayValue(s0).compareToIgnoreCase(ArrangeColumnRequester.this.getDisplayValue(s1));
                }
                return 0;
            }
        };
        Collections.sort(this.ivNotUsed, sorter);
        this.ivColored.addAll(this.ivColoredOriginal);
        this.ivObjectLabel.setFont(FontManager.getFont("SSB12"));
        this.ivObjectLabel.setHorizontalTextPosition(4);
        int y = UIDef.RAND;
        this.addPermanentLabel(topLabel, UIDef.RAND, y, UIDef.LINE_HEIGHT);
        y += UIDef.LINE_HEIGHT + UIDef.RAND;
        this.ivUsedColumnsList = new JList(this.ivUsed);
        this.ivUsedColumnsList.setSelectionMode(0);
        this.ivUsedColumnsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (ArrangeColumnRequester.this.ivReact) {
                    ArrangeColumnRequester.this.ivUseColumnButton.setEnabled(false);
                    int ind = ArrangeColumnRequester.this.ivUsedColumnsList.getSelectedIndex();
                    ArrangeColumnRequester.this.ivDontUseColumnButton.setEnabled(ind != -1 && ArrangeColumnRequester.this.ivUsed.size() > 1);
                    ArrangeColumnRequester.this.ivMoveObjectUpButton.setEnabled(ind > 0);
                    ArrangeColumnRequester.this.ivMoveObjectDownButton.setEnabled(ind != -1 && ind < ArrangeColumnRequester.this.ivUsedColumnsList.getModel().getSize() - 1);
                    ArrangeColumnRequester.this.ivReact = false;
                    ArrangeColumnRequester.this.ivNotUsedColumnsList.clearSelection();
                    ArrangeColumnRequester.this.ivReact = true;
                    ArrangeColumnRequester.this.manageColumnListClick();
                }
            }
        });
        this.ivUsedColumnsList.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent arg0) {
                String val;
                Point p = arg0.getPoint();
                int row = ArrangeColumnRequester.this.ivUsedColumnsList.locationToIndex(p);
                if (row != -1 && p.x < ImageProvider.CHECK_EMPTY_ICON.getIconWidth() && ArrangeColumnRequester.this.potentiallyColored(val = (String)ArrangeColumnRequester.this.ivUsed.elementAt(row))) {
                    if (ArrangeColumnRequester.this.ivColored.contains(val)) {
                        ArrangeColumnRequester.this.ivColored.remove(val);
                    } else {
                        ArrangeColumnRequester.this.ivColored.add(val);
                    }
                    ArrangeColumnRequester.this.ivUsedColumnsList.repaint();
                    ArrangeColumnRequester.this.manageColumnListClick();
                }
            }
        });
        this.ivUsedColumnsList.setCellRenderer(this);
        this.ivNotUsedColumnsList = new JList(this.ivNotUsed);
        this.ivNotUsedColumnsList.setSelectionMode(0);
        this.ivNotUsedColumnsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (ArrangeColumnRequester.this.ivReact) {
                    ArrangeColumnRequester.this.ivMoveObjectUpButton.setEnabled(false);
                    ArrangeColumnRequester.this.ivMoveObjectDownButton.setEnabled(false);
                    ArrangeColumnRequester.this.ivDontUseColumnButton.setEnabled(false);
                    int ind = ArrangeColumnRequester.this.ivNotUsedColumnsList.getSelectedIndex();
                    ArrangeColumnRequester.this.ivUseColumnButton.setEnabled(ind != -1);
                    ArrangeColumnRequester.this.ivReact = false;
                    ArrangeColumnRequester.this.ivUsedColumnsList.clearSelection();
                    ArrangeColumnRequester.this.ivReact = true;
                    ArrangeColumnRequester.this.manageColumnListClick();
                }
            }
        });
        this.ivNotUsedColumnsList.setCellRenderer(this);
        int listh = HOEHE - 5 * UIDef.RAND - UIDef.LINE_HEIGHT - 2 * UIDef.BUT_HEIGHT;
        int listw = (BREITE - 3 * UIDef.RAND) / 2;
        int lx = UIDef.RAND;
        int rx = 2 * UIDef.RAND + listw;
        JPanel lpan = new JPanel(new GridLayout(1, 2, UIDef.RAND, UIDef.RAND));
        lpan.setOpaque(false);
        JScrollPane jsp = new JScrollPane(this.ivNotUsedColumnsList);
        BorderPanel bp = new BorderPanel(jsp, Babel.get("UNUSEDCOLUMNS"), FontManager.getFont("SSB14"));
        lpan.add(bp);
        jsp = new JScrollPane(this.ivUsedColumnsList);
        bp = new BorderPanel(jsp, Babel.get("USEDCOLUMNS"), FontManager.getFont("SSB14"));
        lpan.add(bp);
        if (mausoleumTableModel != null && mausoleumTableModel.displaysIDObjects()) {
            this.ivDemoModel = mausoleumTableModel.getDefaultModel();
            this.ivDemoModel.ivObjects.addAll(mausoleumTableModel.ivObjects);
            this.ivDemoModel.setDefinedColumnNames(this.ivSelectedColumnKennungen, this.ivColored, false);
            this.ivDemoTable = new MausoleumTable(this.ivDemoModel, false, false);
            this.ivDemoTable.setEnabled(false);
            this.ivDemoTable.ivJTable.removeMouseListener(this.ivDemoModel);
            this.ivDemoTable.ivJTable.removeMouseMotionListener(this.ivDemoModel);
            this.ivDemoTable.ivJTable.removeKeyListener(this.ivDemoModel);
            this.ivDemoModel.selectElements(mausoleumTableModel.getSelectedObjects());
            JPanel pan = new JPanel(new BorderLayout());
            pan.add("Center", this.ivDemoTable.ivScrollPane);
            pan.setOpaque(false);
            pan.setBorder(UIDef.getTitleBorder("PREVIEW"));
            JSplitPane split = new JSplitPane(0);
            split.add(lpan);
            split.add(pan);
            split.setResizeWeight(0.7);
            split.setBorder(null);
            split.setOpaque(false);
            this.addAndApplyBounds(split, lx, y, INNER_BREITE, listh);
        } else {
            this.addAndApplyBounds(lpan, lx, y, INNER_BREITE, listh);
        }
        y += listh + UIDef.RAND;
        int lbw = (listw - UIDef.RAND) / 2;
        int rbw = listw - UIDef.RAND - lbw;
        this.ivUseColumnButton.setFont(FontManager.getFont("SSB14"));
        this.ivUseColumnButton.setActionCommand("UC");
        this.ivUseColumnButton.addActionListener(this);
        this.ivUseColumnButton.setEnabled(false);
        this.ivDontUseColumnButton.setFont(FontManager.getFont("SSB14"));
        this.ivDontUseColumnButton.setActionCommand("DUC");
        this.ivDontUseColumnButton.addActionListener(this);
        this.ivDontUseColumnButton.setEnabled(false);
        this.addAndApplyBounds(this.ivUseColumnButton, lx, y, lbw, UIDef.BUT_HEIGHT);
        this.addAndApplyBounds(this.ivDontUseColumnButton, lx + UIDef.RAND + lbw, y, rbw, UIDef.BUT_HEIGHT);
        this.ivMoveObjectUpButton.setFont(FontManager.getFont("SSB14"));
        this.ivMoveObjectUpButton.setActionCommand("UP");
        this.ivMoveObjectUpButton.addActionListener(this);
        this.ivMoveObjectUpButton.setEnabled(false);
        this.ivMoveObjectDownButton.setFont(FontManager.getFont("SSB14"));
        this.ivMoveObjectDownButton.setActionCommand("DOWN");
        this.ivMoveObjectDownButton.addActionListener(this);
        this.ivMoveObjectDownButton.setEnabled(false);
        this.addAndApplyBounds(this.ivMoveObjectUpButton, rx, y, lbw, UIDef.BUT_HEIGHT);
        this.addAndApplyBounds(this.ivMoveObjectDownButton, rx + UIDef.RAND + lbw, y, rbw, UIDef.BUT_HEIGHT);
        this.applyBounds(this.ivOkButton, UIDef.RAND, y += UIDef.BUT_HEIGHT + UIDef.RAND, INNER_BREITE, UIDef.BUT_HEIGHT);
        new DNDHandler(this.ivNotUsedColumnsList, new JList[]{this.ivUsedColumnsList}, this, sorter);
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    private String getDisplayValue(String value) {
        String displayValue = value;
        String tt = MausoleumTableModel.getColumnTooltip(displayValue, this.ivToolTipDict);
        displayValue = tt != null ? String.valueOf(Babel.get(displayValue)) + " [" + Babel.get(tt) + "]" : Babel.get(displayValue);
        return displayValue;
    }

    public void dispose() {
        if (this.ivDemoTable != null) {
            this.ivDemoTable.mDispose();
        }
        super.dispose();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.ivObjectLabel.setText(" " + this.getDisplayValue((String)value) + " ");
        if (MausoleumTableModel.isGeneralColDef((String)value)) {
            this.ivObjectLabel.setForeground(GENERAL_COLOR);
        } else {
            this.ivObjectLabel.setForeground(SPECIFIC_COLOR);
        }
        if (list == this.ivUsedColumnsList && this.ivColorableColumns != null && this.ivColorableColumns.length != 0) {
            if (StringHelper.isIn((String)value, this.ivColorableColumns, true)) {
                if (this.ivColored.contains(value)) {
                    this.ivObjectLabel.setIcon(ImageProvider.CHECK_SEL_ICON);
                } else {
                    this.ivObjectLabel.setIcon(ImageProvider.CHECK_UNSEL_ICON);
                }
            } else {
                this.ivObjectLabel.setIcon(ImageProvider.CHECK_EMPTY_ICON);
            }
        } else {
            this.ivObjectLabel.setIcon(null);
        }
        if (isSelected) {
            this.ivObjectLabel.setOpaque(true);
            this.ivObjectLabel.setBackground(UIDef.SELECTED_BACKGROUND);
        } else {
            this.ivObjectLabel.setOpaque(false);
            this.ivObjectLabel.setBackground(null);
        }
        return this.ivObjectLabel;
    }

    private boolean potentiallyColored(String value) {
        return StringHelper.isIn(value, this.ivColorableColumns, true);
    }

    private void checkButton() {
        this.ivOkButton.setEnabled(this.ivUsedColumnsList.getModel().getSize() >= 1);
    }

    public void actionPerformed(ActionEvent e) {
        String comm = e.getActionCommand();
        if (comm.equals("UP")) {
            int ind = this.ivUsedColumnsList.getSelectedIndex();
            if (ind > 0) {
                Object drueber = this.ivUsed.elementAt(ind - 1);
                this.ivUsed.setElementAt(this.ivUsed.elementAt(ind), ind - 1);
                this.ivUsed.setElementAt(drueber, ind);
                this.ivUsedColumnsList.setSelectedIndex(ind - 1);
                this.ivUsedColumnsList.repaint();
            }
        } else if (comm.equals("DOWN")) {
            int ind = this.ivUsedColumnsList.getSelectedIndex();
            if (ind < this.ivUsed.size() - 1) {
                Object drunter = this.ivUsed.elementAt(ind + 1);
                this.ivUsed.setElementAt(this.ivUsed.elementAt(ind), ind + 1);
                this.ivUsed.setElementAt(drunter, ind);
                this.ivUsedColumnsList.setSelectedIndex(ind + 1);
                this.ivUsedColumnsList.repaint();
            }
        } else if (comm.equals("UC")) {
            int ind = this.ivNotUsedColumnsList.getSelectedIndex();
            if (ind != -1) {
                this.ivUsed.addElement(this.ivNotUsed.elementAt(ind));
                this.ivNotUsed.removeElementAt(ind);
                this.ivUsedColumnsList.setListData(this.ivUsed);
                this.ivNotUsedColumnsList.setListData(this.ivNotUsed);
                this.ivNotUsedColumnsList.clearSelection();
                this.ivUsedColumnsList.setSelectedIndex(this.ivUsed.size() - 1);
                this.ivUsedColumnsList.repaint();
                this.ivNotUsedColumnsList.repaint();
            }
        } else if (comm.equals("DUC")) {
            int ind = this.ivUsedColumnsList.getSelectedIndex();
            if (ind != -1 && this.ivUsed.size() > 1) {
                this.ivNotUsed.addElement(this.ivUsed.elementAt(ind));
                this.ivUsed.removeElementAt(ind);
                this.ivUsedColumnsList.setListData(this.ivUsed);
                this.ivNotUsedColumnsList.setListData(this.ivNotUsed);
                this.ivUsedColumnsList.clearSelection();
                this.ivNotUsedColumnsList.setSelectedIndex(this.ivNotUsed.size() - 1);
                this.ivUsedColumnsList.repaint();
                this.ivNotUsedColumnsList.repaint();
            }
        } else if (comm.equals("DND")) {
            this.reinitVecFromList(this.ivNotUsedColumnsList, this.ivNotUsed);
            this.reinitVecFromList(this.ivUsedColumnsList, this.ivUsed);
            this.checkButton();
        } else {
            super.actionPerformed(e);
        }
        this.manageColumnListClick();
    }

    private void reinitVecFromList(JList list, Vector target) {
        int size = list.getModel().getSize();
        Vector sammel = new Vector();
        int i = 0;
        while (i < size) {
            sammel.add(list.getModel().getElementAt(i));
            ++i;
        }
        target.clear();
        target.addAll(sammel);
    }

    private void manageColumnListClick() {
        String selColKenn = (String)this.ivNotUsedColumnsList.getSelectedValue();
        if (selColKenn == null) {
            selColKenn = (String)this.ivUsedColumnsList.getSelectedValue();
        }
        this.ivSelectedColumnKennungen.clear();
        if (selColKenn != null) {
            this.ivSelectedColumnKennungen.add(selColKenn);
        }
        if (this.ivDemoModel != null) {
            this.ivDemoModel.setDefinedColumnNames(this.ivSelectedColumnKennungen, this.ivColored, false);
            this.ivDemoTable.ivScrollPane.repaint();
        }
    }
}

