/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.mouse;

import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.Frame;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;
import javax.swing.JComboBox;
import mausoleum.cage.Cage;
import mausoleum.cage.CageManager;
import mausoleum.inspector.actions.room.RoomAction;
import mausoleum.main.DefaultManager;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.calendar.CalendarPanel;
import mausoleum.ui.UIDef;

public class MouseTransferRequester
extends BasicRequester
implements Comparator {
    private static final long serialVersionUID = 1L;
    private static final int BREITE = CalendarPanel.BREITE + 2 * UIDef.RAND;
    private static final int COMBO_HEIGHT = UIDef.getScaled(24);
    private static final int COMBO_WIDTH = UIDef.getScaled(150);
    private static final int PANELSTART = COMBO_HEIGHT + 2 * UIDef.RAND;
    private static final int BUTWIDTH = (BREITE - 3 * UIDef.RAND) / 2;
    private static final int BUTSTART = PANELSTART + CalendarPanel.HOEHE + UIDef.RAND;
    private static final int HOEHE = BUTSTART + UIDef.BUT_HEIGHT + UIDef.RAND;
    private JComboBox ivComboBox;
    private CalendarPanel ivCalendarPanel;
    private Vector ivCageNumbers = new Vector();

    public MouseTransferRequester(Frame sender, MyDate minimum, MyDate maximum, String group) {
        super(sender, BREITE, HOEHE);
        int i;
        Vector<String> cagePseudoIDs = new Vector<String>();
        Vector cs = CageManager.cvInstance.getActualObjectVector(group);
        if (cs != null) {
            Collections.sort(cs, this);
            Cage cage = null;
            i = 0;
            while (i < cs.size()) {
                cage = (Cage)cs.elementAt(i);
                if (!cage.isRoomAccesibilityRestricted() && (cage.get("CAG_SUBCAGEL") == null || cage.get("CAG_SUBCAGER") == null) && cage.itsMine(null)) {
                    String pseudoid = cage.getNumber();
                    int stype = cage.getInt("CAG_SIDE");
                    if (stype == 1) {
                        pseudoid = String.valueOf(pseudoid) + "-L";
                    } else if (stype == 2) {
                        pseudoid = String.valueOf(pseudoid) + "-R";
                    }
                    if (RoomAction.cvRoomID == 0L) {
                        this.ivCageNumbers.addElement(new Long(cage.getID()));
                        cagePseudoIDs.addElement(pseudoid);
                    } else if (cage.isCageInRoomOrTransfer(RoomAction.cvRoomID)) {
                        this.ivCageNumbers.addElement(new Long(cage.getID()));
                        cagePseudoIDs.addElement(pseudoid);
                    }
                }
                ++i;
            }
        }
        String[] array = new String[this.ivCageNumbers.size() + 1];
        array[0] = Babel.get("NEWCAGE");
        i = 0;
        while (i < this.ivCageNumbers.size()) {
            array[i + 1] = String.valueOf(Babel.get("CAGE")) + " " + (String)cagePseudoIDs.elementAt(i);
            ++i;
        }
        this.ivCalendarPanel = new CalendarPanel(minimum, maximum);
        this.addAndApplyBounds(this.ivCalendarPanel, UIDef.RAND, PANELSTART, CalendarPanel.BREITE, CalendarPanel.HOEHE);
        this.ivComboBox = new JComboBox<String>(array);
        this.addAndApplyBounds(this.ivComboBox, COMBO_WIDTH, UIDef.RAND, BREITE - COMBO_WIDTH - UIDef.RAND, COMBO_HEIGHT);
        this.applyBounds(this.ivOkButton, UIDef.RAND, BUTSTART, BUTWIDTH, UIDef.BUT_HEIGHT);
        this.applyBounds(this.ivNoButton, 2 * UIDef.RAND + BUTWIDTH, BUTSTART, BUTWIDTH, UIDef.BUT_HEIGHT);
        this.addPermanentLabel(Babel.get("TRANSFERTO"), UIDef.RAND, UIDef.RAND, UIDef.getScaled(14));
    }

    public Date getDate() {
        return this.ivCalendarPanel.getSelectedDate();
    }

    public long getTransferCageID() {
        if (!this.ivWarOK) {
            return -1L;
        }
        int sel = this.ivComboBox.getSelectedIndex();
        if (sel == 0) {
            return 0L;
        }
        if (sel == -1) {
            return -1L;
        }
        Long longi = (Long)this.ivCageNumbers.elementAt(sel - 1);
        return longi;
    }

    public int compare(Object Object1, Object Object2) {
        Cage u1 = (Cage)Object1;
        Cage u2 = (Cage)Object2;
        if (DefaultManager.useCagePseudoIDs()) {
            if (u1.getInt("CAG_PSEUDOID") < u2.getInt("CAG_PSEUDOID")) {
                return -1;
            }
            if (u1.getInt("CAG_PSEUDOID") > u2.getInt("CAG_PSEUDOID")) {
                return 1;
            }
        } else {
            if (u1.getID() < u2.getID()) {
                return -1;
            }
            if (u1.getID() > u2.getID()) {
                return 1;
            }
        }
        return 0;
    }
}

