/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.requester.mouse;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import mausoleum.definitionlists.ListDefinition;
import mausoleum.main.MausoleumClient;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.calendar.CalendarPanel;
import mausoleum.ui.UIDef;

public class NewMiceRequester
extends BasicRequester {
    private static final long serialVersionUID = 415135135L;
    private static final int BREITE = CalendarPanel.BREITE + 2 * UIDef.RAND;
    private static final int ANZ_WIDTH = UIDef.getScaled(120);
    private static final int OWNER_WIDTH = CalendarPanel.BREITE - ANZ_WIDTH - UIDef.RAND;
    private static final int START_Y = UIDef.RAND;
    private static final int COMBO_HEIGHT = UIDef.getScaled(24);
    private static final int PANELSTART = START_Y + COMBO_HEIGHT + UIDef.RAND;
    private static final int BUTWIDTH = (BREITE - 3 * UIDef.RAND) / 2;
    private static final int BUTSTART = PANELSTART + CalendarPanel.HOEHE + UIDef.RAND;
    private static final int HOEHE = BUTSTART + UIDef.BUT_HEIGHT + UIDef.RAND;
    private static final int HOEHE_MIT_ADRESSEN = HOEHE + UIDef.RAND + COMBO_HEIGHT + UIDef.RAND + UIDef.LINE_HEIGHT;
    private static final int HOEHE_MIT_GRUPPEN_UND_ADRESSEN = HOEHE + UIDef.RAND + COMBO_HEIGHT + UIDef.RAND + COMBO_HEIGHT + UIDef.RAND + UIDef.LINE_HEIGHT;
    public static final int OTHER_NUMBER = 666;
    public static final int MODUS_NIX_TEILEN = 1;
    public static final int MODUS_MIT_ALLEN_TEILEN = 2;
    public static final int MODUS_NIMM_VATER_OWNER = 3;
    public static final int MODUS_NIMM_MUTTER_OWNER = 4;
    public static final int MODUS_NIMM_ELTERN_OWNER = 5;
    private static final int[] NEW_MICE_OWNER_INTS = new int[]{1, 2};
    private static final int[] NEW_MICE_OWNER_INTS_CARETAKER = new int[]{2};
    private static final int[] LITTER_MICE_OWNER_INTS = new int[]{1, 2, 4, 3, 5};
    private static final int[] LITTER_MICE_OWNER_INTS_CARETAKER = new int[]{5};
    private static String[] cvNewMiceOwnerChoices = new String[]{Babel.get("SHARE_WITH_NOBODY"), Babel.get("SHARE_WITH_ALL")};
    private static String[] cvNewMiceOwnerChoicesCareTaker = new String[]{Babel.get("SHARE_WITH_ALL")};
    private static String[] cvLitterMiceOwnerChoices = new String[]{Babel.get("SHARE_WITH_NOBODY"), Babel.get("SHARE_WITH_ALL"), Babel.get("TAKE_MOTHERS_OWNERS"), Babel.get("TAKE_FATHERS_OWNERS"), Babel.get("TAKE_PARENTS_OWNERS")};
    private static String[] cvLitterMiceOwnerChoicesCareTaker = new String[]{Babel.get("TAKE_PARENTS_OWNERS")};
    private static String cvMouse = Babel.get("MOUSE");
    private static String cvMice = Babel.get("MICE");
    private static final int[] COUNTS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 20, 25, 30, 666};
    private static String[] cvAnzChoices = new String[]{"1 " + cvMouse, "2 " + cvMice, "3 " + cvMice, "4 " + cvMice, "5 " + cvMice, "6 " + cvMice, "7 " + cvMice, "8 " + cvMice, "9 " + cvMice, "10 " + cvMice, "11 " + cvMice, "12 " + cvMice, "15 " + cvMice, "20 " + cvMice, "25 " + cvMice, "30 " + cvMice, Babel.get("OTHER_NUM")};
    private static int cvLastLitterOwnerSelection = 0;
    private static int cvLastNewMiceOwnerSelection = 0;
    private JComboBox ivMouseCountCombo = new JComboBox<String>(cvAnzChoices);
    private JComboBox ivOwnerCombo = null;
    private CalendarPanel ivCalendarPanel = null;
    private JComboBox ivGruppenCombo = null;
    private JComboBox ivAdressenCombo = null;
    private JTextField ivLieferscheinField = null;
    private boolean ivIsLitterMode = false;

    private static int getHoehe(boolean isLitterMode) {
        if (isLitterMode) {
            return HOEHE;
        }
        if (MausoleumClient.isServiceCaretaker()) {
            return HOEHE_MIT_GRUPPEN_UND_ADRESSEN;
        }
        return HOEHE_MIT_ADRESSEN;
    }

    public NewMiceRequester(Frame sender, MyDate minimum, MyDate maximum, boolean isLitterMode) {
        super(sender, BREITE, NewMiceRequester.getHoehe(isLitterMode));
        this.ivIsLitterMode = isLitterMode;
        this.ivCalendarPanel = new CalendarPanel(minimum, maximum);
        int y = UIDef.RAND;
        if (this.ivIsLitterMode) {
            if (UserManager.cvIsCareTaker || MausoleumClient.isTGService()) {
                this.ivOwnerCombo = new JComboBox<String>(cvLitterMiceOwnerChoicesCareTaker);
                this.ivOwnerCombo.setSelectedIndex(cvLastLitterOwnerSelection);
            } else {
                this.ivOwnerCombo = new JComboBox<String>(cvLitterMiceOwnerChoices);
                this.ivOwnerCombo.setSelectedIndex(cvLastLitterOwnerSelection);
            }
        } else {
            this.ivAdressenCombo = new JComboBox();
            this.adaptAdressenCombo(UserManager.getFirstGroup());
            if (MausoleumClient.isServiceCaretaker()) {
                this.ivGruppenCombo = new JComboBox(UserManager.getGroupNamesWithoutServiceInServiceRoom(null, null));
                this.ivGruppenCombo.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        NewMiceRequester.this.adaptAdressenCombo((String)NewMiceRequester.this.ivGruppenCombo.getSelectedItem());
                    }
                });
                this.addAndApplyBounds(new JLabel(Babel.get("GROUP")), UIDef.RAND, y, ANZ_WIDTH, COMBO_HEIGHT);
                this.addAndApplyBounds(this.ivGruppenCombo, ANZ_WIDTH + 2 * UIDef.RAND, y, OWNER_WIDTH, COMBO_HEIGHT);
                y += COMBO_HEIGHT + UIDef.RAND;
            }
            this.addAndApplyBounds(new JLabel(Babel.get("ORIGIN")), UIDef.RAND, y, ANZ_WIDTH, COMBO_HEIGHT);
            this.addAndApplyBounds(this.ivAdressenCombo, ANZ_WIDTH + 2 * UIDef.RAND, y, OWNER_WIDTH, COMBO_HEIGHT);
            this.ivLieferscheinField = new JTextField();
            this.addAndApplyBounds(new JLabel(Babel.get("LIEFERSCHEIN")), UIDef.RAND, y += COMBO_HEIGHT + UIDef.RAND, ANZ_WIDTH, COMBO_HEIGHT);
            this.addAndApplyBounds(this.ivLieferscheinField, ANZ_WIDTH + 2 * UIDef.RAND, y, OWNER_WIDTH, COMBO_HEIGHT);
            y += UIDef.LINE_HEIGHT + UIDef.RAND;
            if (UserManager.cvIsCareTaker || MausoleumClient.isTGService()) {
                this.ivOwnerCombo = new JComboBox<String>(cvNewMiceOwnerChoicesCareTaker);
                this.ivOwnerCombo.setSelectedIndex(cvLastNewMiceOwnerSelection);
            } else {
                this.ivOwnerCombo = new JComboBox<String>(cvNewMiceOwnerChoices);
                this.ivOwnerCombo.setSelectedIndex(cvLastNewMiceOwnerSelection);
            }
        }
        this.addAndApplyBounds(this.ivOwnerCombo, ANZ_WIDTH + 2 * UIDef.RAND, y, OWNER_WIDTH, COMBO_HEIGHT);
        this.addAndApplyBounds(this.ivMouseCountCombo, UIDef.RAND, y, ANZ_WIDTH, COMBO_HEIGHT);
        this.addAndApplyBounds(this.ivCalendarPanel, UIDef.RAND, y += COMBO_HEIGHT + UIDef.RAND, CalendarPanel.BREITE, CalendarPanel.HOEHE);
        this.applyBounds(this.ivOkButton, UIDef.RAND, y += CalendarPanel.HOEHE + UIDef.RAND, BUTWIDTH, UIDef.BUT_HEIGHT);
        this.applyBounds(this.ivNoButton, 2 * UIDef.RAND + BUTWIDTH, y, BUTWIDTH, UIDef.BUT_HEIGHT);
    }

    public int getNumber() {
        return COUNTS[this.ivMouseCountCombo.getSelectedIndex()];
    }

    public String getGroup() {
        if (this.ivGruppenCombo != null) {
            return (String)this.ivGruppenCombo.getSelectedItem();
        }
        return null;
    }

    public String getHerkunft() {
        ListDefinition ld;
        if (this.ivAdressenCombo != null && (ld = (ListDefinition)this.ivAdressenCombo.getSelectedItem()) != null && ld.ivID > 0) {
            if (ld.ivTyp == 7) {
                return Base64Manager.encodeBase64("MGN:" + ld.ivName);
            }
            return Base64Manager.encodeBase64("EA:" + ld.ivID);
        }
        return "";
    }

    public String getLieferschein() {
        String s;
        if (this.ivLieferscheinField != null && (s = this.ivLieferscheinField.getText().trim()).length() != 0) {
            return Base64Manager.encodeBase64(s);
        }
        return "";
    }

    public int getOwnerMode() {
        if (this.ivIsLitterMode) {
            cvLastLitterOwnerSelection = this.ivOwnerCombo.getSelectedIndex();
            if (UserManager.cvIsCareTaker || MausoleumClient.isTGService()) {
                return LITTER_MICE_OWNER_INTS_CARETAKER[cvLastLitterOwnerSelection];
            }
            return LITTER_MICE_OWNER_INTS[cvLastLitterOwnerSelection];
        }
        cvLastNewMiceOwnerSelection = this.ivOwnerCombo.getSelectedIndex();
        if (UserManager.cvIsCareTaker || MausoleumClient.isTGService()) {
            return NEW_MICE_OWNER_INTS_CARETAKER[cvLastNewMiceOwnerSelection];
        }
        return NEW_MICE_OWNER_INTS[cvLastNewMiceOwnerSelection];
    }

    public Date getDate() {
        return this.ivCalendarPanel.getSelectedDate();
    }

    private void adaptAdressenCombo(String group) {
        if (this.ivAdressenCombo != null) {
            if (group == null) {
                group = UserManager.getFirstGroup();
            }
            Vector adressen = ListDefinition.getItems(UserManager.getGroupAndService(group), 6, true, true, true);
            this.ivAdressenCombo.setModel(new DefaultComboBoxModel(adressen));
            this.ivAdressenCombo.setEnabled(!adressen.isEmpty());
        }
    }
}

